/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2023-03-18 08:24:07 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=391 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=26477 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=377 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_automatic_amazon_links` (
  `link_url` varchar(500) NOT NULL,
  `link_title` varchar(500) NOT NULL,
  `link_keyword` varchar(300) NOT NULL,
  `link_status` varchar(20) NOT NULL,
  `link_id` int(11) NOT NULL AUTO_INCREMENT,
  `link_desc` mediumtext NOT NULL,
  `link_price` mediumtext NOT NULL,
  `link_img` varchar(750) NOT NULL,
  `link_review` text NOT NULL,
  PRIMARY KEY (`link_id`),
  KEY `link_keyword` (`link_keyword`(250))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_automatic_articles_keys` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `camp_id` bigint(20) NOT NULL,
  `keyword` varchar(200) NOT NULL,
  `page_num` int(11) NOT NULL DEFAULT 0,
  `status` int(11) NOT NULL DEFAULT 0,
  `last_page` int(11) NOT NULL DEFAULT 999,
  `articlesbase_lastadd` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_keywordID` (`camp_id`,`keyword`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_automatic_articles_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `link` varchar(300) NOT NULL,
  `keyword` varchar(300) NOT NULL,
  `page_num` int(11) NOT NULL,
  `status` int(2) NOT NULL DEFAULT 0,
  `title` mediumtext NOT NULL,
  `bing_cache` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `keyword` (`keyword`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_automatic_cached` (
  `img_id` int(11) NOT NULL AUTO_INCREMENT,
  `img_external` text NOT NULL,
  `img_internal` text NOT NULL,
  `img_path` text NOT NULL,
  `img_hash` varchar(50) NOT NULL,
  `img_data_hash` varchar(50) NOT NULL,
  PRIMARY KEY (`img_id`)
) ENGINE=MyISAM AUTO_INCREMENT=204 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_automatic_camps` (
  `camp_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'Campaign ID',
  `camp_name` varchar(100) NOT NULL,
  `camp_keywords` longtext NOT NULL,
  `camp_post_title` mediumtext NOT NULL,
  `camp_post_content` longtext NOT NULL,
  `camp_cb_category` varchar(300) NOT NULL,
  `camp_replace_link` varchar(100) NOT NULL,
  `camp_post_status` varchar(20) NOT NULL,
  `camp_post_every` int(11) NOT NULL,
  `camp_add_star` varchar(20) NOT NULL,
  `camp_post_category` varchar(200) NOT NULL,
  `camp_options` longtext NOT NULL,
  `feeds` longtext NOT NULL,
  `camp_type` varchar(20) NOT NULL DEFAULT 'Articles',
  `camp_search_order` varchar(100) NOT NULL,
  `camp_amazon_cat` varchar(100) NOT NULL,
  `camp_youtube_cat` varchar(100) NOT NULL,
  `camp_youtube_order` varchar(100) NOT NULL,
  `camp_amazon_region` varchar(50) DEFAULT NULL,
  `camp_post_author` int(11) NOT NULL,
  `camp_post_custom_k` mediumtext NOT NULL,
  `camp_post_custom_v` mediumtext NOT NULL,
  `camp_post_exact` mediumtext NOT NULL,
  `camp_general` mediumtext NOT NULL,
  `camp_post_execlude` mediumtext NOT NULL,
  `camp_yt_user` varchar(59) NOT NULL,
  `camp_translate_to` varchar(59) NOT NULL,
  `camp_translate_from` varchar(59) NOT NULL,
  `camp_translate_to_2` varchar(59) NOT NULL,
  `camp_post_type` varchar(59) NOT NULL DEFAULT 'post',
  PRIMARY KEY (`camp_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1951 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_automatic_categories` (
  `cat_id` int(11) NOT NULL,
  `cat_parent` int(11) NOT NULL DEFAULT 0,
  `cat_name` varchar(150) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_automatic_clickbank_links` (
  `link_url` varchar(500) NOT NULL,
  `link_title` varchar(500) NOT NULL,
  `link_keyword` varchar(300) NOT NULL,
  `link_status` varchar(20) NOT NULL,
  `link_id` int(11) NOT NULL AUTO_INCREMENT,
  `link_desc` mediumtext NOT NULL,
  PRIMARY KEY (`link_id`),
  KEY `link_keyword` (`link_keyword`)
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_automatic_general` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` varchar(50) NOT NULL,
  `item_type` varchar(250) NOT NULL,
  `item_status` varchar(50) NOT NULL,
  `item_data` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `item_type` (`item_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_automatic_keywords` (
  `keyword_id` int(11) NOT NULL AUTO_INCREMENT,
  `keyword_name` varchar(250) NOT NULL,
  `keyword_camp` bigint(20) NOT NULL,
  `keyword_start` int(11) NOT NULL DEFAULT 0,
  `clickbank_start` int(11) NOT NULL DEFAULT 1,
  `amazon_start` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`keyword_id`),
  UNIQUE KEY `keyword_name` (`keyword_name`,`keyword_camp`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_automatic_links` (
  `link_url` varchar(500) NOT NULL,
  `link_title` varchar(500) NOT NULL,
  `link_keyword` varchar(300) NOT NULL,
  `link_status` varchar(20) NOT NULL,
  `link_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`link_id`)
) ENGINE=MyISAM AUTO_INCREMENT=63 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_automatic_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(50) NOT NULL,
  `data` mediumtext NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `camp` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6414 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_automatic_youtube_links` (
  `link_url` varchar(500) NOT NULL,
  `link_title` varchar(500) NOT NULL,
  `link_keyword` varchar(300) NOT NULL,
  `link_status` varchar(20) NOT NULL,
  `link_id` int(11) NOT NULL AUTO_INCREMENT,
  `link_desc` longtext NOT NULL,
  `link_player` longtext NOT NULL,
  `link_img` varchar(500) NOT NULL,
  `link_rating` longtext NOT NULL,
  `link_views` varchar(20) NOT NULL,
  `link_time` varchar(10) NOT NULL,
  `link_author` varchar(40) NOT NULL,
  `link_duration` varchar(40) NOT NULL DEFAULT '00:00',
  `link_general` mediumtext NOT NULL,
  PRIMARY KEY (`link_id`),
  KEY `link_keyword` (`link_keyword`(250))
) ENGINE=MyISAM AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=68 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_index_now_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `level` enum('emergency','alert','critical','error','warning','notice','info','debug') NOT NULL DEFAULT 'debug',
  `search_engine` enum('index-now','yandex-index-now','yandex-webmaster','bing-index-now','bing-webmaster','site','google-webmaster') NOT NULL DEFAULT 'site',
  `direction` enum('incoming','outgoing','internal') NOT NULL DEFAULT 'incoming',
  `status_code` int(11) unsigned NOT NULL,
  `message` text NOT NULL,
  PRIMARY KEY (`log_id`)
) ENGINE=InnoDB AUTO_INCREMENT=94 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_litespeed_url` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url` varchar(500) NOT NULL,
  `cache_tags` varchar(1000) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`(191)),
  KEY `cache_tags` (`cache_tags`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_litespeed_url_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url_id` bigint(20) NOT NULL,
  `vary` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of final vary',
  `filename` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of file content',
  `type` tinyint(4) NOT NULL COMMENT 'css=1,js=2,ccss=3,ucss=4',
  `mobile` tinyint(4) NOT NULL COMMENT 'mobile=1',
  `webp` tinyint(4) NOT NULL COMMENT 'webp=1',
  `expired` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `type` (`type`),
  KEY `url_id_2` (`url_id`,`vary`,`type`),
  KEY `filename_2` (`filename`,`expired`),
  KEY `url_id` (`url_id`,`expired`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=77337 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_pmxe_exports` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) NOT NULL DEFAULT 0,
  `attch_id` bigint(20) NOT NULL DEFAULT 0,
  `options` longtext DEFAULT NULL,
  `scheduled` varchar(64) NOT NULL DEFAULT '',
  `registered_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `friendly_name` text NOT NULL DEFAULT '',
  `exported` bigint(20) NOT NULL DEFAULT 0,
  `canceled` tinyint(1) NOT NULL DEFAULT 0,
  `canceled_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `settings_update_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_activity` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `processing` tinyint(1) NOT NULL DEFAULT 0,
  `executing` tinyint(1) NOT NULL DEFAULT 0,
  `triggered` tinyint(1) NOT NULL DEFAULT 0,
  `iteration` bigint(20) NOT NULL DEFAULT 0,
  `export_post_type` text NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_pmxe_google_cats` (
  `id` int(11) NOT NULL,
  `name` varchar(200) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `parent_name` varchar(200) NOT NULL,
  `level` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_pmxe_posts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL,
  `export_id` bigint(20) unsigned NOT NULL,
  `iteration` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_pmxe_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `options` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_pmxi_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `import_id` bigint(20) unsigned NOT NULL,
  `name` text DEFAULT NULL,
  `path` text DEFAULT NULL,
  `registered_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_pmxi_hash` (
  `hash` binary(16) NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `import_id` smallint(5) unsigned NOT NULL,
  `post_type` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_pmxi_history` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `import_id` bigint(20) unsigned NOT NULL,
  `type` enum('manual','processing','trigger','continue','cli','') NOT NULL DEFAULT '',
  `time_run` text DEFAULT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `summary` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_pmxi_images` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attachment_id` bigint(20) unsigned NOT NULL,
  `image_url` varchar(900) NOT NULL DEFAULT '',
  `image_filename` varchar(900) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_pmxi_imports` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_import_id` bigint(20) NOT NULL DEFAULT 0,
  `name` text DEFAULT NULL,
  `friendly_name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(32) NOT NULL DEFAULT '',
  `feed_type` enum('xml','csv','zip','gz','') NOT NULL DEFAULT '',
  `path` text DEFAULT NULL,
  `xpath` text DEFAULT NULL,
  `options` longtext DEFAULT NULL,
  `registered_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `root_element` varchar(255) DEFAULT '',
  `processing` tinyint(1) NOT NULL DEFAULT 0,
  `executing` tinyint(1) NOT NULL DEFAULT 0,
  `triggered` tinyint(1) NOT NULL DEFAULT 0,
  `queue_chunk_number` bigint(20) NOT NULL DEFAULT 0,
  `first_import` timestamp NOT NULL DEFAULT current_timestamp(),
  `count` bigint(20) NOT NULL DEFAULT 0,
  `imported` bigint(20) NOT NULL DEFAULT 0,
  `created` bigint(20) NOT NULL DEFAULT 0,
  `updated` bigint(20) NOT NULL DEFAULT 0,
  `skipped` bigint(20) NOT NULL DEFAULT 0,
  `deleted` bigint(20) NOT NULL DEFAULT 0,
  `canceled` tinyint(1) NOT NULL DEFAULT 0,
  `canceled_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `failed` tinyint(1) NOT NULL DEFAULT 0,
  `failed_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `settings_update_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_activity` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `iteration` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_pmxi_posts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL,
  `import_id` bigint(20) unsigned NOT NULL,
  `unique_key` text DEFAULT NULL,
  `product_key` text DEFAULT NULL,
  `iteration` bigint(20) NOT NULL DEFAULT 0,
  `specified` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_pmxi_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `options` longtext DEFAULT NULL,
  `scheduled` varchar(64) NOT NULL DEFAULT '',
  `name` varchar(200) NOT NULL DEFAULT '',
  `title` text DEFAULT NULL,
  `content` longtext DEFAULT NULL,
  `is_keep_linebreaks` tinyint(1) NOT NULL DEFAULT 0,
  `is_leave_html` tinyint(1) NOT NULL DEFAULT 0,
  `fix_characters` tinyint(1) NOT NULL DEFAULT 0,
  `meta` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=135443 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=3162 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_rank_math_404_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uri` varchar(255) NOT NULL,
  `accessed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `times_accessed` bigint(20) unsigned NOT NULL DEFAULT 1,
  `referer` varchar(255) NOT NULL DEFAULT '',
  `user_agent` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `uri` (`uri`(191))
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_rank_math_analytics_gsc` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `query` varchar(1000) NOT NULL,
  `page` varchar(500) NOT NULL,
  `clicks` mediumint(6) NOT NULL,
  `impressions` mediumint(6) NOT NULL,
  `position` double NOT NULL,
  `ctr` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `analytics_query` (`query`(190)),
  KEY `analytics_page` (`page`(190)),
  KEY `clicks` (`clicks`),
  KEY `rank_position` (`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rank_math_analytics_inspections` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `page` varchar(500) NOT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `index_verdict` varchar(64) NOT NULL,
  `indexing_state` varchar(64) NOT NULL,
  `coverage_state` text NOT NULL,
  `page_fetch_state` varchar(64) NOT NULL,
  `robots_txt_state` varchar(64) NOT NULL,
  `mobile_usability_verdict` varchar(64) NOT NULL,
  `mobile_usability_issues` longtext NOT NULL,
  `rich_results_verdict` varchar(64) NOT NULL,
  `rich_results_items` longtext NOT NULL,
  `last_crawl_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `crawled_as` varchar(64) NOT NULL,
  `google_canonical` text NOT NULL,
  `user_canonical` text NOT NULL,
  `sitemap` text NOT NULL,
  `referring_urls` longtext NOT NULL,
  `raw_api_response` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `analytics_object_page` (`page`(190)),
  KEY `created` (`created`),
  KEY `index_verdict` (`index_verdict`),
  KEY `page_fetch_state` (`page_fetch_state`),
  KEY `robots_txt_state` (`robots_txt_state`),
  KEY `mobile_usability_verdict` (`mobile_usability_verdict`),
  KEY `rich_results_verdict` (`rich_results_verdict`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rank_math_analytics_keyword_manager` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `keyword` varchar(1000) NOT NULL,
  `collection` varchar(200) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rank_math_analytics_objects` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `title` text NOT NULL,
  `page` varchar(500) NOT NULL,
  `object_type` varchar(100) NOT NULL,
  `object_subtype` varchar(100) NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL,
  `primary_key` varchar(255) NOT NULL,
  `seo_score` tinyint(4) NOT NULL DEFAULT 0,
  `page_score` tinyint(4) NOT NULL DEFAULT 0,
  `is_indexable` tinyint(1) NOT NULL DEFAULT 1,
  `schemas_in_use` varchar(500) DEFAULT NULL,
  `desktop_interactive` double DEFAULT 0,
  `desktop_pagescore` double DEFAULT 0,
  `mobile_interactive` double DEFAULT 0,
  `mobile_pagescore` double DEFAULT 0,
  `pagespeed_refreshed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `analytics_object_page` (`page`(190))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rank_math_internal_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`)
) ENGINE=MyISAM AUTO_INCREMENT=5301 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rank_math_internal_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT 0,
  `external_link_count` int(10) unsigned DEFAULT 0,
  `incoming_link_count` int(10) unsigned DEFAULT 0,
  PRIMARY KEY (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rank_math_redirections` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sources` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `url_to` text NOT NULL,
  `header_code` smallint(4) unsigned NOT NULL,
  `hits` bigint(20) unsigned NOT NULL DEFAULT 0,
  `status` varchar(25) NOT NULL DEFAULT 'active',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rank_math_redirections_cache` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `from_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `redirection_id` bigint(20) unsigned NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `object_type` varchar(10) NOT NULL DEFAULT 'post',
  `is_redirected` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `redirection_id` (`redirection_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rmp_analytics` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ip` tinytext NOT NULL,
  `country` tinytext NOT NULL,
  `user` smallint(5) NOT NULL,
  `post` mediumint(9) NOT NULL,
  `action` smallint(5) NOT NULL,
  `duration` smallint(5) NOT NULL,
  `average` decimal(2,1) NOT NULL,
  `votes` smallint(5) NOT NULL,
  `value` smallint(5) NOT NULL,
  `token` tinytext NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=40 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=177 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT 0,
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wfblocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT 0,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT 0,
  `blockedHits` int(10) unsigned DEFAULT 0,
  `expiration` bigint(20) unsigned NOT NULL DEFAULT 0,
  `parameters` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob DEFAULT NULL,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `real_path` text NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT 0,
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wfhits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT 0,
  `statusCode` int(11) NOT NULL DEFAULT 200,
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text DEFAULT NULL,
  `referer` text DEFAULT NULL,
  `UA` text DEFAULT NULL,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text DEFAULT NULL,
  `actionData` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB AUTO_INCREMENT=850 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wfhoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text DEFAULT NULL,
  `host` text DEFAULT NULL,
  `path` text DEFAULT NULL,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wfissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB AUTO_INCREMENT=130 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wfknownfilelist` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `wordpress_path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8421 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT 0.0000000,
  `lon` float(10,7) DEFAULT 0.0000000,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wflogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB AUTO_INCREMENT=783 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wfls_2fa_secrets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `vtime` int(10) unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wfls_role_counts` (
  `serialized_roles` varbinary(255) NOT NULL,
  `two_factor_inactive` tinyint(1) NOT NULL,
  `user_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`serialized_roles`,`two_factor_inactive`)
) ENGINE=MEMORY DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob DEFAULT NULL,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT 1,
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT 1000,
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wfpendingissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wfsnipcache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT current_timestamp(),
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT 0,
  `type` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=428 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wfstatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=4072 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wftrafficrates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wpfm_backup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_name` text DEFAULT NULL,
  `backup_date` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wpr_rucss_resources` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `type` varchar(5) NOT NULL DEFAULT '',
  `media` varchar(255) DEFAULT 'all',
  `content` longtext DEFAULT NULL,
  `hash` varchar(100) NOT NULL DEFAULT '',
  `prewarmup` tinyint(1) unsigned DEFAULT 0,
  `warmup_status` tinyint(1) unsigned DEFAULT 0,
  `modified` datetime DEFAULT '0000-00-00 00:00:00',
  `last_accessed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`),
  KEY `url` (`url`(150)),
  KEY `type` (`type`),
  KEY `last_accessed` (`last_accessed`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_wpr_rucss_used_css` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `css` longtext DEFAULT NULL,
  `unprocessedcss` longtext NOT NULL DEFAULT '',
  `retries` tinyint(1) NOT NULL DEFAULT 1,
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("340", "rank_math/analytics/data_fetch", "complete", "2022-08-17 12:07:09", "2022-08-17 12:07:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1660738029;s:18:\"\0*\0first_timestamp\";i:1646853120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1660738029;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}", "3", "1", "2023-02-20 03:04:53", "2023-02-20 10:04:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("343", "rank_math/analytics/data_fetch", "complete", "2023-02-23 03:04:53", "2023-02-23 03:04:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1677121493;s:18:\"\0*\0first_timestamp\";i:1646853120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1677121493;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}", "3", "1", "2023-02-23 03:51:09", "2023-02-23 10:51:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("344", "action_scheduler/migration_hook", "complete", "2023-02-21 07:08:21", "2023-02-21 07:08:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1676963301;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1676963301;}", "1", "1", "2023-02-21 07:16:09", "2023-02-21 14:16:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("345", "action_scheduler/migration_hook", "complete", "2023-02-21 07:17:10", "2023-02-21 07:17:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1676963830;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1676963830;}", "1", "1", "2023-02-21 07:20:07", "2023-02-21 14:20:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("346", "rank_math/analytics/data_fetch", "complete", "2023-02-26 03:51:09", "2023-02-26 03:51:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1677383469;s:18:\"\0*\0first_timestamp\";i:1646853120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1677383469;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}", "3", "1", "2023-02-26 04:06:05", "2023-02-26 11:06:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("347", "rank_math/analytics/data_fetch", "complete", "2023-03-01 04:06:05", "2023-03-01 04:06:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1677643565;s:18:\"\0*\0first_timestamp\";i:1646853120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1677643565;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}", "3", "1", "2023-03-01 04:07:26", "2023-03-01 11:07:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("348", "rank_math/analytics/data_fetch", "complete", "2023-03-04 04:07:26", "2023-03-04 04:07:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1677902846;s:18:\"\0*\0first_timestamp\";i:1646853120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1677902846;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}", "3", "1", "2023-03-04 04:07:46", "2023-03-04 11:07:46", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("349", "rank_math/analytics/workflow", "complete", "2023-03-01 07:19:19", "2023-03-01 07:19:19", "[\"inspections\",0,null,null]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1677655159;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1677655159;}", "3", "1", "2023-03-01 07:19:53", "2023-03-01 14:19:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("350", "rank_math/analytics/workflow", "complete", "2023-03-01 08:40:10", "2023-03-01 08:40:10", "383290f42f151136ede4c435d59d04fd", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2023-03-01 08:41:10", "2023-03-01 15:41:10", "0", "[\"analytics\",90,{\"account_id\":false,\"property_id\":false,\"view_id\":false,\"country\":\"all\",\"install_code\":false,\"anonymize_ip\":false,\"local_ga_js\":false,\"cookieless_ga\":false,\"exclude_loggedin\":false},{\"account_id\":false,\"property_id\":false,\"view_id\":false,\"measurement_id\":false,\"stream_name\":false,\"country\":\"all\",\"install_code\":false,\"anonymize_ip\":false,\"local_ga_js\":false,\"exclude_loggedin\":false}]");
INSERT INTO `wp_actionscheduler_actions` VALUES("351", "rank_math/analytics/workflow", "complete", "2023-03-01 08:40:10", "2023-03-01 08:40:10", "[\"console\",90,{\"country\":\"all\",\"profile\":false,\"enable_index_status\":true},{\"country\":\"all\",\"profile\":false,\"enable_index_status\":false}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2023-03-01 08:41:11", "2023-03-01 15:41:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("352", "action_scheduler/migration_hook", "complete", "2023-03-01 09:37:04", "2023-03-01 09:37:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1677663424;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1677663424;}", "1", "1", "2023-03-01 09:37:20", "2023-03-01 16:37:20", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("353", "action_scheduler/migration_hook", "complete", "2023-03-01 09:42:05", "2023-03-01 09:42:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1677663725;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1677663725;}", "1", "1", "2023-03-01 09:42:50", "2023-03-01 16:42:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("354", "action_scheduler/migration_hook", "failed", "2023-03-01 09:43:50", "2023-03-01 09:43:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1677663830;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1677663830;}", "1", "1", "2023-03-01 09:45:07", "2023-03-01 16:45:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("355", "rank_math/analytics/workflow", "complete", "2023-03-01 10:16:22", "2023-03-01 10:16:22", "[\"console\",90,{\"country\":\"all\",\"profile\":false,\"enable_index_status\":false},{\"country\":\"all\",\"profile\":false,\"enable_index_status\":false}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2023-03-01 10:16:51", "2023-03-01 17:16:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("356", "rank_math/analytics/workflow", "complete", "2023-03-01 10:16:22", "2023-03-01 10:16:22", "b7b90d5ff072cface4f62bea5f97fc6d", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2023-03-01 10:16:51", "2023-03-01 17:16:51", "0", "[\"analytics\",90,{\"account_id\":false,\"property_id\":false,\"view_id\":false,\"measurement_id\":false,\"stream_name\":false,\"country\":\"all\",\"install_code\":false,\"anonymize_ip\":false,\"local_ga_js\":false,\"exclude_loggedin\":false},{\"account_id\":false,\"property_id\":false,\"view_id\":false,\"measurement_id\":false,\"stream_name\":false,\"country\":\"all\",\"install_code\":false,\"anonymize_ip\":false,\"local_ga_js\":false,\"exclude_loggedin\":false}]");
INSERT INTO `wp_actionscheduler_actions` VALUES("357", "action_scheduler/migration_hook", "complete", "2023-03-01 10:24:34", "2023-03-01 10:24:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1677666274;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1677666274;}", "1", "1", "2023-03-01 10:24:36", "2023-03-01 17:24:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("358", "action_scheduler/migration_hook", "complete", "2023-03-01 10:25:36", "2023-03-01 10:25:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1677666336;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1677666336;}", "1", "1", "2023-03-01 10:25:37", "2023-03-01 17:25:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("359", "action_scheduler/migration_hook", "failed", "2023-03-01 10:26:38", "2023-03-01 10:26:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1677666398;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1677666398;}", "1", "1", "2023-03-01 10:26:38", "2023-03-01 17:26:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("360", "action_scheduler/migration_hook", "complete", "2023-03-02 10:09:35", "2023-03-02 10:09:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1677751775;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1677751775;}", "1", "1", "2023-03-02 10:09:49", "2023-03-02 17:09:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("361", "action_scheduler/migration_hook", "complete", "2023-03-03 07:17:13", "2023-03-03 07:17:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1677827833;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1677827833;}", "1", "1", "2023-03-03 07:17:19", "2023-03-03 14:17:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("362", "action_scheduler/migration_hook", "complete", "2023-03-03 07:18:40", "2023-03-03 07:18:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1677827920;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1677827920;}", "1", "1", "2023-03-04 03:36:33", "2023-03-04 10:36:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("363", "action_scheduler/migration_hook", "failed", "2023-03-04 03:37:33", "2023-03-04 03:37:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1677901053;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1677901053;}", "1", "1", "2023-03-04 03:37:33", "2023-03-04 10:37:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("364", "rank_math/analytics/workflow", "complete", "2023-03-04 03:37:29", "2023-03-04 03:37:29", "[\"analytics\",90,null,null]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2023-03-04 03:37:33", "2023-03-04 10:37:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("365", "rank_math/analytics/workflow", "complete", "2023-03-04 03:37:29", "2023-03-04 03:37:29", "[\"adsense\",90,null,null]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2023-03-04 03:37:33", "2023-03-04 10:37:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("366", "rank_math/analytics/data_fetch", "failed", "2023-03-07 04:07:46", "2023-03-07 04:07:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1678162066;s:18:\"\0*\0first_timestamp\";i:1646853120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1678162066;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}", "3", "1", "2023-03-07 04:07:58", "2023-03-07 11:07:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("367", "action_scheduler/migration_hook", "complete", "2023-03-05 13:23:38", "2023-03-05 13:23:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1678022618;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1678022618;}", "1", "1", "2023-03-05 13:23:39", "2023-03-05 20:23:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("368", "action_scheduler/migration_hook", "complete", "2023-03-05 13:26:25", "2023-03-05 13:26:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1678022785;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1678022785;}", "1", "1", "2023-03-05 13:26:25", "2023-03-05 20:26:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("369", "action_scheduler/migration_hook", "failed", "2023-03-05 13:27:25", "2023-03-05 13:27:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1678022845;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1678022845;}", "1", "1", "2023-03-05 13:27:25", "2023-03-05 20:27:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("370", "action_scheduler/migration_hook", "complete", "2023-03-05 14:28:24", "2023-03-05 14:28:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1678026504;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1678026504;}", "1", "1", "2023-03-05 14:28:24", "2023-03-05 21:28:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("371", "action_scheduler/migration_hook", "complete", "2023-03-05 14:31:18", "2023-03-05 14:31:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1678026678;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1678026678;}", "1", "1", "2023-03-05 14:31:28", "2023-03-05 21:31:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("372", "action_scheduler/migration_hook", "complete", "2023-03-05 14:39:19", "2023-03-05 14:39:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1678027159;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1678027159;}", "1", "1", "2023-03-05 14:39:24", "2023-03-05 21:39:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("373", "rank_math/analytics/data_fetch", "failed", "2023-03-10 04:07:58", "2023-03-10 04:07:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1678421278;s:18:\"\0*\0first_timestamp\";i:1646853120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1678421278;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}", "3", "1", "2023-03-10 04:09:09", "2023-03-10 11:09:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("374", "rank_math/analytics/workflow", "complete", "2023-03-07 15:24:23", "2023-03-07 15:24:23", "[\"console\",90,{\"country\":\"all\",\"profile\":false,\"enable_index_status\":false},{\"country\":\"all\",\"profile\":false,\"enable_index_status\":false}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2023-03-07 15:24:24", "2023-03-07 22:24:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("375", "rank_math/analytics/workflow", "complete", "2023-03-07 15:24:23", "2023-03-07 15:24:23", "b7b90d5ff072cface4f62bea5f97fc6d", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2023-03-07 15:24:24", "2023-03-07 22:24:24", "0", "[\"analytics\",90,{\"account_id\":false,\"property_id\":false,\"view_id\":false,\"measurement_id\":false,\"stream_name\":false,\"country\":\"all\",\"install_code\":false,\"anonymize_ip\":false,\"local_ga_js\":false,\"exclude_loggedin\":false},{\"account_id\":false,\"property_id\":false,\"view_id\":false,\"measurement_id\":false,\"stream_name\":false,\"country\":\"all\",\"install_code\":false,\"anonymize_ip\":false,\"local_ga_js\":false,\"exclude_loggedin\":false}]");
INSERT INTO `wp_actionscheduler_actions` VALUES("376", "action_scheduler/migration_hook", "complete", "2023-03-10 02:54:06", "2023-03-10 02:54:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1678416846;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1678416846;}", "1", "1", "2023-03-10 02:54:29", "2023-03-10 09:54:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("377", "rank_math/analytics/data_fetch", "failed", "2023-03-13 04:09:09", "2023-03-13 04:09:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1678680549;s:18:\"\0*\0first_timestamp\";i:1646853120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1678680549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}", "3", "1", "2023-03-13 04:11:14", "2023-03-13 11:11:14", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("378", "rank_math/analytics/data_fetch", "failed", "2023-03-16 04:11:14", "2023-03-16 04:11:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1678939874;s:18:\"\0*\0first_timestamp\";i:1646853120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1678939874;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}", "3", "1", "2023-03-16 04:17:29", "2023-03-16 11:17:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("379", "action_scheduler/migration_hook", "complete", "2023-03-15 12:06:09", "2023-03-15 12:06:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1678881969;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1678881969;}", "1", "1", "2023-03-15 12:07:11", "2023-03-15 19:07:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("380", "action_scheduler/migration_hook", "failed", "2023-03-15 12:08:12", "2023-03-15 12:08:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1678882092;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1678882092;}", "1", "1", "2023-03-15 12:09:12", "2023-03-15 19:09:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("382", "action_scheduler/migration_hook", "complete", "2023-03-17 07:23:14", "2023-03-17 07:23:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1679037794;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1679037794;}", "1", "1", "2023-03-17 07:24:27", "2023-03-17 14:24:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("381", "rank_math/analytics/data_fetch", "pending", "2023-03-19 04:17:29", "2023-03-19 04:17:29", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1679199449;s:18:\"\0*\0first_timestamp\";i:1646853120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1679199449;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("383", "action_scheduler/migration_hook", "failed", "2023-03-17 07:25:27", "2023-03-17 07:25:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1679037927;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1679037927;}", "1", "1", "2023-03-17 07:29:30", "2023-03-17 14:29:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("384", "action_scheduler/migration_hook", "complete", "2023-03-17 07:31:58", "2023-03-17 07:31:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1679038318;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1679038318;}", "1", "1", "2023-03-17 07:32:08", "2023-03-17 14:32:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("385", "action_scheduler/migration_hook", "failed", "2023-03-17 07:33:08", "2023-03-17 07:33:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1679038388;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1679038388;}", "1", "1", "2023-03-17 07:34:10", "2023-03-17 14:34:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("386", "action_scheduler/migration_hook", "complete", "2023-03-18 07:10:35", "2023-03-18 07:10:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1679123435;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1679123435;}", "1", "1", "2023-03-18 07:10:57", "2023-03-18 14:10:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("387", "rank_math/analytics/workflow", "complete", "2023-03-18 07:14:59", "2023-03-18 07:14:59", "[\"analytics\",90,null,null]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2023-03-18 07:15:25", "2023-03-18 14:15:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("388", "rank_math/analytics/workflow", "complete", "2023-03-18 07:14:59", "2023-03-18 07:14:59", "[\"adsense\",90,null,null]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2023-03-18 07:15:25", "2023-03-18 14:15:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("389", "rank_math/analytics/workflow", "complete", "2023-03-18 07:15:25", "2023-03-18 07:15:25", "[\"console\",90,{\"country\":\"all\",\"profile\":false,\"enable_index_status\":false},{\"country\":\"all\",\"profile\":false,\"enable_index_status\":false}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2023-03-18 07:15:25", "2023-03-18 14:15:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("390", "rank_math/analytics/workflow", "complete", "2023-03-18 07:15:25", "2023-03-18 07:15:25", "b7b90d5ff072cface4f62bea5f97fc6d", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2023-03-18 07:15:25", "2023-03-18 14:15:25", "0", "[\"analytics\",90,{\"account_id\":false,\"property_id\":false,\"view_id\":false,\"measurement_id\":false,\"stream_name\":false,\"country\":\"all\",\"install_code\":false,\"anonymize_ip\":false,\"local_ga_js\":false,\"exclude_loggedin\":false},{\"account_id\":false,\"property_id\":false,\"view_id\":false,\"measurement_id\":false,\"stream_name\":false,\"country\":\"all\",\"install_code\":false,\"anonymize_ip\":false,\"local_ga_js\":false,\"exclude_loggedin\":false}]");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "rank-math");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("226", "340", "action created", "2022-08-14 12:07:09", "2022-08-14 12:07:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("233", "340", "action started via WP Cron", "2023-02-20 03:04:53", "2023-02-20 03:04:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("234", "340", "action complete via WP Cron", "2023-02-20 03:04:53", "2023-02-20 03:04:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("235", "343", "action created", "2023-02-20 03:04:53", "2023-02-20 03:04:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("236", "344", "action created", "2023-02-21 07:07:21", "2023-02-21 07:07:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("237", "344", "action started via WP Cron", "2023-02-21 07:16:09", "2023-02-21 07:16:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("238", "344", "action complete via WP Cron", "2023-02-21 07:16:09", "2023-02-21 07:16:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("239", "345", "action created", "2023-02-21 07:16:10", "2023-02-21 07:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("240", "345", "action started via WP Cron", "2023-02-21 07:20:07", "2023-02-21 07:20:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("241", "345", "action complete via WP Cron", "2023-02-21 07:20:07", "2023-02-21 07:20:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("242", "343", "action started via WP Cron", "2023-02-23 03:51:09", "2023-02-23 03:51:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("243", "343", "action complete via WP Cron", "2023-02-23 03:51:09", "2023-02-23 03:51:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("244", "346", "action created", "2023-02-23 03:51:09", "2023-02-23 03:51:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("245", "346", "action started via WP Cron", "2023-02-26 04:06:05", "2023-02-26 04:06:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("246", "346", "action complete via WP Cron", "2023-02-26 04:06:05", "2023-02-26 04:06:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("247", "347", "action created", "2023-02-26 04:06:05", "2023-02-26 04:06:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("248", "347", "action started via WP Cron", "2023-03-01 04:07:26", "2023-03-01 04:07:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("249", "347", "action complete via WP Cron", "2023-03-01 04:07:26", "2023-03-01 04:07:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("250", "348", "action created", "2023-03-01 04:07:26", "2023-03-01 04:07:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("251", "349", "action created", "2023-03-01 07:04:19", "2023-03-01 07:04:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("252", "349", "action started via WP Cron", "2023-03-01 07:19:52", "2023-03-01 07:19:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("253", "349", "action complete via WP Cron", "2023-03-01 07:19:53", "2023-03-01 07:19:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("254", "350", "action created", "2023-03-01 08:40:10", "2023-03-01 08:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("255", "351", "action created", "2023-03-01 08:40:10", "2023-03-01 08:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("256", "350", "action started via WP Cron", "2023-03-01 08:41:10", "2023-03-01 08:41:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("257", "350", "action complete via WP Cron", "2023-03-01 08:41:10", "2023-03-01 08:41:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("258", "351", "action started via WP Cron", "2023-03-01 08:41:10", "2023-03-01 08:41:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("259", "351", "action complete via WP Cron", "2023-03-01 08:41:11", "2023-03-01 08:41:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("260", "352", "action created", "2023-03-01 09:36:04", "2023-03-01 09:36:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("261", "352", "action started via Async Request", "2023-03-01 09:37:20", "2023-03-01 09:37:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("262", "352", "action complete via Async Request", "2023-03-01 09:37:20", "2023-03-01 09:37:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("263", "353", "action created", "2023-03-01 09:41:05", "2023-03-01 09:41:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("264", "353", "action started via WP Cron", "2023-03-01 09:42:50", "2023-03-01 09:42:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("265", "353", "action complete via WP Cron", "2023-03-01 09:42:50", "2023-03-01 09:42:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("266", "354", "action created", "2023-03-01 09:42:50", "2023-03-01 09:42:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("267", "354", "action started via WP Cron", "2023-03-01 09:45:07", "2023-03-01 09:45:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("268", "354", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-03-01 09:45:07", "2023-03-01 09:45:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("269", "355", "action created", "2023-03-01 10:16:22", "2023-03-01 10:16:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("270", "356", "action created", "2023-03-01 10:16:22", "2023-03-01 10:16:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("271", "355", "action started via WP Cron", "2023-03-01 10:16:51", "2023-03-01 10:16:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("272", "355", "action complete via WP Cron", "2023-03-01 10:16:51", "2023-03-01 10:16:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("273", "356", "action started via WP Cron", "2023-03-01 10:16:51", "2023-03-01 10:16:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("274", "356", "action complete via WP Cron", "2023-03-01 10:16:51", "2023-03-01 10:16:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("275", "357", "action created", "2023-03-01 10:23:34", "2023-03-01 10:23:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("276", "357", "action started via Async Request", "2023-03-01 10:24:36", "2023-03-01 10:24:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("277", "357", "action complete via Async Request", "2023-03-01 10:24:36", "2023-03-01 10:24:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("278", "358", "action created", "2023-03-01 10:24:36", "2023-03-01 10:24:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("279", "358", "action started via Async Request", "2023-03-01 10:25:37", "2023-03-01 10:25:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("280", "358", "action complete via Async Request", "2023-03-01 10:25:37", "2023-03-01 10:25:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("281", "359", "action created", "2023-03-01 10:25:38", "2023-03-01 10:25:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("282", "359", "action started via Async Request", "2023-03-01 10:26:38", "2023-03-01 10:26:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("283", "359", "action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-03-01 10:26:38", "2023-03-01 10:26:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("284", "360", "action created", "2023-03-02 10:08:35", "2023-03-02 10:08:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("285", "360", "action started via WP Cron", "2023-03-02 10:09:49", "2023-03-02 10:09:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("286", "360", "action complete via WP Cron", "2023-03-02 10:09:49", "2023-03-02 10:09:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("287", "361", "action created", "2023-03-03 07:16:13", "2023-03-03 07:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("288", "361", "action started via Async Request", "2023-03-03 07:17:19", "2023-03-03 07:17:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("289", "361", "action complete via Async Request", "2023-03-03 07:17:19", "2023-03-03 07:17:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("290", "362", "action created", "2023-03-03 07:17:40", "2023-03-03 07:17:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("291", "362", "action started via Async Request", "2023-03-04 03:36:33", "2023-03-04 03:36:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("292", "362", "action complete via Async Request", "2023-03-04 03:36:33", "2023-03-04 03:36:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("293", "363", "action created", "2023-03-04 03:36:33", "2023-03-04 03:36:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("294", "364", "action created", "2023-03-04 03:37:29", "2023-03-04 03:37:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("295", "365", "action created", "2023-03-04 03:37:29", "2023-03-04 03:37:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("296", "364", "action started via WP Cron", "2023-03-04 03:37:33", "2023-03-04 03:37:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("297", "364", "action complete via WP Cron", "2023-03-04 03:37:33", "2023-03-04 03:37:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("298", "365", "action started via WP Cron", "2023-03-04 03:37:33", "2023-03-04 03:37:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("299", "365", "action complete via WP Cron", "2023-03-04 03:37:33", "2023-03-04 03:37:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("300", "363", "action started via WP Cron", "2023-03-04 03:37:33", "2023-03-04 03:37:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("301", "363", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-03-04 03:37:33", "2023-03-04 03:37:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("302", "348", "action started via WP Cron", "2023-03-04 04:07:46", "2023-03-04 04:07:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("303", "348", "action complete via WP Cron", "2023-03-04 04:07:46", "2023-03-04 04:07:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("304", "366", "action created", "2023-03-04 04:07:46", "2023-03-04 04:07:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("305", "367", "action created", "2023-03-05 13:22:38", "2023-03-05 13:22:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("306", "367", "action started via Async Request", "2023-03-05 13:23:39", "2023-03-05 13:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("307", "367", "action complete via Async Request", "2023-03-05 13:23:39", "2023-03-05 13:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("308", "368", "action created", "2023-03-05 13:25:25", "2023-03-05 13:25:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("309", "368", "action started via WP Cron", "2023-03-05 13:26:25", "2023-03-05 13:26:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("310", "368", "action complete via WP Cron", "2023-03-05 13:26:25", "2023-03-05 13:26:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("311", "369", "action created", "2023-03-05 13:26:25", "2023-03-05 13:26:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("312", "369", "action started via WP Cron", "2023-03-05 13:27:25", "2023-03-05 13:27:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("313", "369", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-03-05 13:27:25", "2023-03-05 13:27:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("314", "370", "action created", "2023-03-05 14:27:24", "2023-03-05 14:27:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("315", "370", "action started via WP Cron", "2023-03-05 14:28:24", "2023-03-05 14:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("316", "370", "action complete via WP Cron", "2023-03-05 14:28:24", "2023-03-05 14:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("317", "371", "action created", "2023-03-05 14:30:18", "2023-03-05 14:30:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("318", "371", "action started via WP Cron", "2023-03-05 14:31:28", "2023-03-05 14:31:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("319", "371", "action complete via WP Cron", "2023-03-05 14:31:28", "2023-03-05 14:31:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("320", "372", "action created", "2023-03-05 14:38:19", "2023-03-05 14:38:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("321", "372", "action started via WP Cron", "2023-03-05 14:39:24", "2023-03-05 14:39:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("322", "372", "action complete via WP Cron", "2023-03-05 14:39:24", "2023-03-05 14:39:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("323", "366", "action started via WP Cron", "2023-03-07 04:07:58", "2023-03-07 04:07:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("324", "366", "action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.", "2023-03-07 04:07:58", "2023-03-07 04:07:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("325", "373", "action created", "2023-03-07 04:07:58", "2023-03-07 04:07:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("326", "374", "action created", "2023-03-07 15:24:23", "2023-03-07 15:24:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("327", "375", "action created", "2023-03-07 15:24:23", "2023-03-07 15:24:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("328", "374", "action started via Async Request", "2023-03-07 15:24:24", "2023-03-07 15:24:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("329", "374", "action complete via Async Request", "2023-03-07 15:24:24", "2023-03-07 15:24:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("330", "375", "action started via Async Request", "2023-03-07 15:24:24", "2023-03-07 15:24:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("331", "375", "action complete via Async Request", "2023-03-07 15:24:24", "2023-03-07 15:24:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("332", "376", "action created", "2023-03-10 02:53:06", "2023-03-10 02:53:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("333", "376", "action started via WP Cron", "2023-03-10 02:54:29", "2023-03-10 02:54:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("334", "376", "action complete via WP Cron", "2023-03-10 02:54:29", "2023-03-10 02:54:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("335", "373", "action started via WP Cron", "2023-03-10 04:09:09", "2023-03-10 04:09:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("336", "373", "action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.", "2023-03-10 04:09:09", "2023-03-10 04:09:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("337", "377", "action created", "2023-03-10 04:09:09", "2023-03-10 04:09:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("338", "377", "action started via WP Cron", "2023-03-13 04:11:14", "2023-03-13 04:11:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("339", "377", "action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.", "2023-03-13 04:11:14", "2023-03-13 04:11:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("340", "378", "action created", "2023-03-13 04:11:14", "2023-03-13 04:11:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("341", "379", "action created", "2023-03-15 12:05:09", "2023-03-15 12:05:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("342", "379", "action started via WP Cron", "2023-03-15 12:07:11", "2023-03-15 12:07:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("343", "379", "action complete via WP Cron", "2023-03-15 12:07:11", "2023-03-15 12:07:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("344", "380", "action created", "2023-03-15 12:07:12", "2023-03-15 12:07:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("345", "380", "action started via WP Cron", "2023-03-15 12:09:12", "2023-03-15 12:09:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("346", "380", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-03-15 12:09:12", "2023-03-15 12:09:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("347", "378", "action started via WP Cron", "2023-03-16 04:17:29", "2023-03-16 04:17:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("348", "378", "action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.", "2023-03-16 04:17:29", "2023-03-16 04:17:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("349", "381", "action created", "2023-03-16 04:17:29", "2023-03-16 04:17:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("350", "382", "action created", "2023-03-17 07:22:14", "2023-03-17 07:22:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("351", "382", "action started via WP Cron", "2023-03-17 07:24:27", "2023-03-17 07:24:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("352", "382", "action complete via WP Cron", "2023-03-17 07:24:27", "2023-03-17 07:24:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("353", "383", "action created", "2023-03-17 07:24:27", "2023-03-17 07:24:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("354", "383", "action started via WP Cron", "2023-03-17 07:29:30", "2023-03-17 07:29:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("355", "383", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-03-17 07:29:30", "2023-03-17 07:29:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("356", "384", "action created", "2023-03-17 07:30:58", "2023-03-17 07:30:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("357", "384", "action started via WP Cron", "2023-03-17 07:32:08", "2023-03-17 07:32:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("358", "384", "action complete via WP Cron", "2023-03-17 07:32:08", "2023-03-17 07:32:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("359", "385", "action created", "2023-03-17 07:32:08", "2023-03-17 07:32:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("360", "385", "action started via WP Cron", "2023-03-17 07:34:10", "2023-03-17 07:34:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("361", "385", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-03-17 07:34:10", "2023-03-17 07:34:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("362", "386", "action created", "2023-03-18 07:09:35", "2023-03-18 07:09:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("363", "386", "action started via WP Cron", "2023-03-18 07:10:57", "2023-03-18 07:10:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("364", "386", "action complete via WP Cron", "2023-03-18 07:10:57", "2023-03-18 07:10:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("365", "387", "action created", "2023-03-18 07:14:59", "2023-03-18 07:14:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("366", "388", "action created", "2023-03-18 07:14:59", "2023-03-18 07:14:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("367", "389", "action created", "2023-03-18 07:15:25", "2023-03-18 07:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("368", "390", "action created", "2023-03-18 07:15:25", "2023-03-18 07:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("369", "387", "action started via WP Cron", "2023-03-18 07:15:25", "2023-03-18 07:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("370", "387", "action complete via WP Cron", "2023-03-18 07:15:25", "2023-03-18 07:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("371", "388", "action started via WP Cron", "2023-03-18 07:15:25", "2023-03-18 07:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("372", "388", "action complete via WP Cron", "2023-03-18 07:15:25", "2023-03-18 07:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("373", "389", "action started via WP Cron", "2023-03-18 07:15:25", "2023-03-18 07:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("374", "389", "action complete via WP Cron", "2023-03-18 07:15:25", "2023-03-18 07:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("375", "390", "action started via WP Cron", "2023-03-18 07:15:25", "2023-03-18 07:15:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("376", "390", "action complete via WP Cron", "2023-03-18 07:15:25", "2023-03-18 07:15:25");

/* INSERT TABLE DATA: wp_automatic_cached */
INSERT INTO `wp_automatic_cached` VALUES("42", "https://78win78.com/wp-content/uploads/2021/11/vao-tien-nuoi-lo-cap-5-ngay.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/vao-tien-nuoi-lo-cap-5-ngay.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/vao-tien-nuoi-lo-cap-5-ngay.jpg", "c02de2caab26fd8589994cb3d65df0aa", "b12d4f8abfa39953c46733e0210d3502");
INSERT INTO `wp_automatic_cached` VALUES("43", "https://78win78.com/wp-content/uploads/2021/11/lo-hinh-qua-tram.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/lo-hinh-qua-tram.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/lo-hinh-qua-tram.jpg", "343ce5a2684c0acfd1e75ffc3d4f5a2d", "4da55a3a5dfbc2ec10b4cdb0daee4981");
INSERT INTO `wp_automatic_cached` VALUES("44", "https://78win78.com/wp-content/uploads/2021/11/cach-danh-lo-ngay-nao-cung-trung.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-danh-lo-ngay-nao-cung-trung.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-danh-lo-ngay-nao-cung-trung.jpg", "ec633c36e2fbbb84966f484a50cc872c", "8be6179fcc718f3c68db420aef041037");
INSERT INTO `wp_automatic_cached` VALUES("45", "https://78win78.com/wp-content/uploads/2021/11/trang-web-ban-so-lo-de-uy-tin.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/trang-web-ban-so-lo-de-uy-tin.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/trang-web-ban-so-lo-de-uy-tin.jpg", "b42d3776d7565d79c980744981f70e86", "c355e1b11dbfd11986b96d7fe8951b64");
INSERT INTO `wp_automatic_cached` VALUES("46", "https://78win78.com/wp-content/uploads/2021/11/cach-tinh-lo-chuan.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-tinh-lo-chuan.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-tinh-lo-chuan.jpg", "e6f1f86e5b7b975aef8c7ad9970e5cda", "5550fd267ea201a929f60fb461c1b606");
INSERT INTO `wp_automatic_cached` VALUES("47", "https://78win78.com/wp-content/uploads/2021/11/cach-tinh-lo-de-theo-ngu-hanh.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-tinh-lo-de-theo-ngu-hanh.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-tinh-lo-de-theo-ngu-hanh.jpg", "8346bc697bf956db85a5b781d7da8319", "2f7868abb3ec874995a78feeac6c830a");
INSERT INTO `wp_automatic_cached` VALUES("49", "https://78win78.com/wp-content/uploads/2021/11/cach-bat-lo-kep-mien-bac.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648109826_cach-bat-lo-kep-mien-bac.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648109826_cach-bat-lo-kep-mien-bac.jpg", "495d47be92c12b06fe9ed23e9a78cb6c", "001996edb4ee86730ea05d6c0f826e84");
INSERT INTO `wp_automatic_cached` VALUES("50", "https://78win78.com/wp-content/uploads/2021/11/phan-mem-tinh-xac-suat-lo-de.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/phan-mem-tinh-xac-suat-lo-de.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/phan-mem-tinh-xac-suat-lo-de.jpg", "4d17bad90626806e31ea5951089ce79c", "c146f16c4efef2cf13ce44b45db75814");
INSERT INTO `wp_automatic_cached` VALUES("51", "https://78win78.com/wp-content/uploads/2021/11/cach-om-lo-de-hieu-qua.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-om-lo-de-hieu-qua.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-om-lo-de-hieu-qua.jpg", "21257d843b128cb6e2a2db8ac4235e78", "8bbbcab16cb794ace34854c426bfcfce");
INSERT INTO `wp_automatic_cached` VALUES("53", "https://78win78.com/wp-content/uploads/2021/11/xiu-chu-la-gi.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648110189_xiu-chu-la-gi.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648110189_xiu-chu-la-gi.jpg", "4f64b10208ebb9123c1ee74a036af437", "3c1dd92971de1efe3349c0ca01c0bc14");
INSERT INTO `wp_automatic_cached` VALUES("54", "https://78win78.com/wp-content/uploads/2021/11/1-diem-lo-bao-nhieu-tien.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1-diem-lo-bao-nhieu-tien.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1-diem-lo-bao-nhieu-tien.jpg", "cce91e2c0b6ce1511d7b292d7ce9f246", "b2a8df7f6be813fdcc9afb3f3703d47a");
INSERT INTO `wp_automatic_cached` VALUES("55", "https://78win78.com/wp-content/uploads/2021/11/lo-kep-nuoi-khung-2-ngay.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/lo-kep-nuoi-khung-2-ngay.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/lo-kep-nuoi-khung-2-ngay.jpg", "33893739a7b174b6ea792a1250ed3e50", "bb4fdf24c69b64c4fe97d9328d84e2c1");
INSERT INTO `wp_automatic_cached` VALUES("56", "https://78win78.com/wp-content/uploads/2021/11/cach-vao-tien-nuoi-lo-7-ngay.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-vao-tien-nuoi-lo-7-ngay.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-vao-tien-nuoi-lo-7-ngay.jpg", "305733b90bf3deb38dbd3cbe6387ab82", "243d8ee9f2301d9a3e736804a7f1096b");
INSERT INTO `wp_automatic_cached` VALUES("57", "https://78win78.com/wp-content/uploads/2021/11/lo-ve-99-hom-sau-danh-con-gi.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/lo-ve-99-hom-sau-danh-con-gi.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/lo-ve-99-hom-sau-danh-con-gi.jpg", "cc5e1ef6d92a5246b0a7af80da0a4e45", "c70c7e10ead7149a59b959d5bea6451e");
INSERT INTO `wp_automatic_cached` VALUES("59", "https://78win78.com/wp-content/uploads/2021/11/lo-gan-la-gi.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648110907_lo-gan-la-gi.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648110907_lo-gan-la-gi.jpg", "dcb8e895b5774e831da52bb4fedd2f7b", "ce8dc1d2b5724aa36f8182a080093405");
INSERT INTO `wp_automatic_cached` VALUES("61", "https://78win78.com/wp-content/uploads/2021/11/bach-thu-de.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648111027_bach-thu-de.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648111027_bach-thu-de.jpg", "5d66924d0f77d6b83bbc5af5f2dfc2b0", "704ef48890953a8aa64fc023d38ceaf5");
INSERT INTO `wp_automatic_cached` VALUES("63", "https://78win78.com/wp-content/uploads/2021/11/song-thu-lo-khung-5-ngay.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648111151_song-thu-lo-khung-5-ngay.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648111151_song-thu-lo-khung-5-ngay.jpg", "6020130cd3e1d6f284d07dc50cb13352", "ff9e70ec14dce1575c8f55b7e35edf62");
INSERT INTO `wp_automatic_cached` VALUES("65", "https://78win78.com/wp-content/uploads/2021/11/song-thu-de.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648111273_song-thu-de.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648111273_song-thu-de.jpg", "97f873bc0d09873ab174bd23178e23fa", "c945929e1ea4a049924f5df97c5f9ec9");
INSERT INTO `wp_automatic_cached` VALUES("67", "https://78win78.com/wp-content/uploads/2021/11/nuoi-lo-bach-thu-khung-5-ngay.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648111388_nuoi-lo-bach-thu-khung-5-ngay.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648111388_nuoi-lo-bach-thu-khung-5-ngay.jpg", "b4f3d13fc18be16112503e701313ebd8", "b30c9921f407499013b9869eceafa946");
INSERT INTO `wp_automatic_cached` VALUES("69", "https://78win78.com/wp-content/uploads/2021/11/cach-bat-bach-thu-lo.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648111511_cach-bat-bach-thu-lo.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648111511_cach-bat-bach-thu-lo.jpg", "82d9b6d0ad63aad0a837e86dc4856ff6", "4e65d42ec2066f0986db1019f0e62a04");
INSERT INTO `wp_automatic_cached` VALUES("71", "https://78win78.com/wp-content/uploads/2021/11/bat-de-kep.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/bat-de-kep.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/bat-de-kep.jpeg", "31acbaa4d76f5287c7a08934d557838e", "375218aa561508e17f346858be904182");
INSERT INTO `wp_automatic_cached` VALUES("72", "https://78win78.com/wp-content/uploads/2021/11/sat-kep.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/sat-kep.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/sat-kep.jpeg", "759e69531967c364c092e1cc418bb0fb", "abbccc1061f7069546732e4fdead9f5b");
INSERT INTO `wp_automatic_cached` VALUES("73", "https://78win78.com/wp-content/uploads/2021/11/cach-bat-de-kep.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648111754_cach-bat-de-kep.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648111754_cach-bat-de-kep.jpeg", "56fc97da9b61f65de864474017583f7e", "7f7e146f342e321df2e248603f505df5");
INSERT INTO `wp_automatic_cached` VALUES("75", "https://78win78.com/wp-content/uploads/2021/11/bat-theo-giai-ba.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/bat-theo-giai-ba.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/bat-theo-giai-ba.jpeg", "62fa7f3a4e1e7034b0480b74db493e2d", "33c6517bd40c271ec79a81b1dec5bc32");
INSERT INTO `wp_automatic_cached` VALUES("76", "https://78win78.com/wp-content/uploads/2021/11/lo-hay-ra-cung-nhau.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/lo-hay-ra-cung-nhau.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/lo-hay-ra-cung-nhau.jpeg", "6969d1eed7fc8e396538adbff4091383", "bdf3f7c6896a9a6f2803ef22e4f76771");
INSERT INTO `wp_automatic_cached` VALUES("78", "https://78win78.com/wp-content/uploads/2021/11/cach-soi-cau-lo.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648111873_cach-soi-cau-lo.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648111873_cach-soi-cau-lo.jpeg", "98b62f55576901b7e1ee6435d335e2f9", "24d4e9d963fb2966e3e0532d1c00a1ee");
INSERT INTO `wp_automatic_cached` VALUES("80", "https://78win78.com/wp-content/uploads/2021/11/cach-bat-de-chan-le.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648111995_cach-bat-de-chan-le.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648111995_cach-bat-de-chan-le.jpg", "45f869a108832058d9a1535b9cd8215a", "028b23775bfe544817b18c3d10b24236");
INSERT INTO `wp_automatic_cached` VALUES("81", "https://78win78.com/wp-content/uploads/2021/11/phuong-phap-loai-cham-de-3.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/phuong-phap-loai-cham-de-3.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/phuong-phap-loai-cham-de-3.jpg", "6c56c75b34b1668350166cce9a714276", "2264561a0666499ab7ab36060832515d");
INSERT INTO `wp_automatic_cached` VALUES("82", "https://78win78.com/wp-content/uploads/2021/11/phuong-phap-loai-cham-de-2.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/phuong-phap-loai-cham-de-2.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/phuong-phap-loai-cham-de-2.jpg", "461efa3f9697117a59b4fabcf5144ccb", "c71bb0c3533058898b8fffb87eb6452c");
INSERT INTO `wp_automatic_cached` VALUES("84", "https://78win78.com/wp-content/uploads/2021/11/phuong-phap-loai-cham-de.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/phuong-phap-loai-cham-de.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/phuong-phap-loai-cham-de.jpg", "37b1eb7531286f2d3f3f486fa1750416", "fc685d106af3672d64698e89ddaf55db");
INSERT INTO `wp_automatic_cached` VALUES("85", "https://78win78.com/wp-content/uploads/2021/11/cach-bat-cham-de-chuan-hang-ngay-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-cham-de-chuan-hang-ngay-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-cham-de-chuan-hang-ngay-1.jpg", "23088862023a88f9b7b4d02dc7d9fefb", "ebfe4fb7df1868a3936776ca4773773f");
INSERT INTO `wp_automatic_cached` VALUES("86", "https://78win78.com/wp-content/uploads/2021/11/cach-bat-cham-de-chuan-hang-ngay-2.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-cham-de-chuan-hang-ngay-2.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-cham-de-chuan-hang-ngay-2.jpg", "8149e2ced5ae216ea3bbe000716a07f4", "1ba4307ab9213d49a5f6fe75524e6e2e");
INSERT INTO `wp_automatic_cached` VALUES("87", "https://78win78.com/wp-content/uploads/2021/11/cach-bat-cham-de-chuan-hang-ngay-3.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-cham-de-chuan-hang-ngay-3.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-cham-de-chuan-hang-ngay-3.jpg", "07ac5b9b5a77f8191b28cdc129887b84", "55e63ab0219d58caadede7dc46ae4a0d");
INSERT INTO `wp_automatic_cached` VALUES("88", "https://78win78.com/wp-content/uploads/2021/11/cach-bat-cham-de-chuan-hang-ngay.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-cham-de-chuan-hang-ngay.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-cham-de-chuan-hang-ngay.jpg", "6639a2e0ea08cd2876f2a82fb5bacc25", "27be1473a0a54b8dbce95c42b41ed333");
INSERT INTO `wp_automatic_cached` VALUES("90", "https://78win78.com/wp-content/uploads/2021/11/lo-xien-2.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648112358_lo-xien-2.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648112358_lo-xien-2.jpg", "d3758b818f82d1c2079f989502383d0d", "193f5130548771c83d34dc2532e1bdbc");
INSERT INTO `wp_automatic_cached` VALUES("91", "https://78win78.com/wp-content/uploads/2021/11/lo-xien-quay-5-co-bao-nhieu-cap.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/lo-xien-quay-5-co-bao-nhieu-cap.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/lo-xien-quay-5-co-bao-nhieu-cap.jpg", "bc019615d1aeb74ed449866d302c448f", "f818c73ca28ba5b8a2b02ca766d6d2a3");
INSERT INTO `wp_automatic_cached` VALUES("92", "https://78win78.com/wp-content/uploads/2021/11/lo-xien-quay-3.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/lo-xien-quay-3.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/lo-xien-quay-3.jpeg", "4b1f6df6f4bd0baa3a42f452abae3bc0", "6e1added409319b6fb70d075221fd428");
INSERT INTO `wp_automatic_cached` VALUES("93", "https://78win78.com/wp-content/uploads/2021/11/nuoi-lo-xien.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/nuoi-lo-xien.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/nuoi-lo-xien.jpeg", "0651f0acfba281465666b73972643952", "76c9b6171e22d173cd1137192a042365");
INSERT INTO `wp_automatic_cached` VALUES("94", "https://78win78.com/wp-content/uploads/2021/11/cach-tinh-lo-xien.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-tinh-lo-xien.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-tinh-lo-xien.jpeg", "d2d1765cedfe3c2887738c4e2899ac91", "bd8e6c0dbec0af10d90f2927b96b870b");
INSERT INTO `wp_automatic_cached` VALUES("95", "https://78win78.com/wp-content/uploads/2021/11/lo-xien-quay-3-co-bao-nhieu-cap.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/lo-xien-quay-3-co-bao-nhieu-cap.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/lo-xien-quay-3-co-bao-nhieu-cap.jpg", "e8ce1dc33c7576df9dabbc4aa281667d", "ee81edce8878d95d731e5f6c5b701cbe");
INSERT INTO `wp_automatic_cached` VALUES("96", "https://78win78.com/wp-content/uploads/2021/11/cach-tinh-tien-lo-xien.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-tinh-tien-lo-xien.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-tinh-tien-lo-xien.jpeg", "df90a36f81a61794b0a582192fbc3962", "05300677eadbabafa7b8330926d2c297");
INSERT INTO `wp_automatic_cached` VALUES("97", "https://78win78.com/wp-content/uploads/2021/11/tinh-tien-lo-xien.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/tinh-tien-lo-xien.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/tinh-tien-lo-xien.jpeg", "501c6170b5e0b53b097d69d83325dca1", "ab7eec936f63743a3d7eac67a9c80f14");
INSERT INTO `wp_automatic_cached` VALUES("98", "https://78win78.com/wp-content/uploads/2021/11/tinh-tien-lo-xien-1.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/tinh-tien-lo-xien-1.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/tinh-tien-lo-xien-1.jpeg", "f754c0b7338dc8b6aa65b52e588f3975", "ed405fd172149f7142eff4f32651f5ac");
INSERT INTO `wp_automatic_cached` VALUES("99", "https://78win78.com/wp-content/uploads/2021/11/cach-tinh-tien-lo-xien.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-tinh-tien-lo-xien.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-tinh-tien-lo-xien.jpg", "bff5ef5011259e16913d25fa999474c1", "d55f1ee7c2133471bfe6252773d0d1e2");
INSERT INTO `wp_automatic_cached` VALUES("100", "https://78win78.com/wp-content/uploads/2021/11/lo-xien.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/lo-xien.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/lo-xien.jpeg", "1dd7b71e806c4715fbe768a5fb552685", "91aa44734ca1f944e5697dad19b14b7c");
INSERT INTO `wp_automatic_cached` VALUES("101", "https://78win78.com/wp-content/uploads/2021/11/lo-xien-3.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/lo-xien-3.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/lo-xien-3.jpeg", "ca368c3d26d0490a7c402f05620b0b23", "8f9c59d2db2eb16abfd4ef1730ab074d");
INSERT INTO `wp_automatic_cached` VALUES("102", "https://78win78.com/wp-content/uploads/2021/11/lo-xien-2.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/lo-xien-2.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/lo-xien-2.jpeg", "3e75e4685bfb51e0ab2a5cd75d6e3332", "88bd2b12348d48cfbb27a04b0c60023d");
INSERT INTO `wp_automatic_cached` VALUES("103", "https://78win78.com/wp-content/uploads/2021/11/phuong-phap-loai-cham-de-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648112820_832_phuong-phap-loai-cham-de-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648112820_832_phuong-phap-loai-cham-de-1.jpg", "03fc485664b551b6676a839b57065a31", "18522a8d80879c76bdbe261c87fa30a2");
INSERT INTO `wp_automatic_cached` VALUES("104", "https://78win78.com/wp-content/uploads/2021/11/cach-danh-lo-xien.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-danh-lo-xien.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-danh-lo-xien.jpg", "c332568ecfd56ee7f6f36678063f78f0", "e22cda11a714164d7160aae4fe417d1d");
INSERT INTO `wp_automatic_cached` VALUES("105", "https://78win78.com/wp-content/uploads/2021/11/cac-dan-de-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cac-dan-de-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cac-dan-de-1.jpg", "261985bd2c9bf1dc37080f2bab32e337", "e967ba59c31ffee4b7022897e27d7026");
INSERT INTO `wp_automatic_cached` VALUES("106", "https://78win78.com/wp-content/uploads/2021/11/cac-dan-de-2.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cac-dan-de-2.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cac-dan-de-2.jpg", "75ce311672b37f81e52cd4692eadd52f", "9bd97429decbb388590f4e0f84daefc9");
INSERT INTO `wp_automatic_cached` VALUES("107", "https://78win78.com/wp-content/uploads/2021/11/cac-dan-de-3.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cac-dan-de-3.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cac-dan-de-3.jpg", "96eded864414af9b0b43dcac1934c167", "f8b9e590a981cbeffbcff35968f4f248");
INSERT INTO `wp_automatic_cached` VALUES("108", "https://78win78.com/wp-content/uploads/2021/11/cac-dan-de.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cac-dan-de.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cac-dan-de.jpg", "290aa0b5f82bfa1f5f8ac716ff67f479", "ee5f4e8e38582e7a93d1b322d85bd6c3");
INSERT INTO `wp_automatic_cached` VALUES("109", "https://78win78.com/wp-content/uploads/2021/11/cach-bat-dan-de-3.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-dan-de-3.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-dan-de-3.jpg", "d84e218cb58dbb45da31b1dbf1a8def1", "3eb850b08a1875bde44dd27d035f4d5f");
INSERT INTO `wp_automatic_cached` VALUES("110", "https://78win78.com/wp-content/uploads/2021/11/cach-bat-dan-de-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-dan-de-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-dan-de-1.jpg", "06b83e8363de0a37530f7693667622fc", "051e50004ad3b8ffc5f739a4561dd9ef");
INSERT INTO `wp_automatic_cached` VALUES("111", "https://78win78.com/wp-content/uploads/2021/11/cach-bat-dan-de-2.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-dan-de-2.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-dan-de-2.jpg", "65d1b7ed8933dd6f2b0c5641b4c3ad52", "5f6cf87819d588bbf775c09b8e40f78e");
INSERT INTO `wp_automatic_cached` VALUES("112", "https://78win78.com/wp-content/uploads/2021/11/12-con-giap.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/12-con-giap.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/12-con-giap.jpeg", "e9b447193f5da41f25c201f1a9b99eec", "0e013a201012b789057b41bebbe33505");
INSERT INTO `wp_automatic_cached` VALUES("113", "https://78win78.com/wp-content/uploads/2021/11/cach-bat-dan-de.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-dan-de.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-dan-de.jpg", "db8d7d65625b91c6db908c8cdbbcefd2", "4bfa828e6b3bbf9fdcbdeac2e5f37748");
INSERT INTO `wp_automatic_cached` VALUES("114", "https://78win78.com/wp-content/uploads/2021/11/dan-de-64-so-2.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-64-so-2.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-64-so-2.jpg", "eed05e13de599360b47ffa223371bcac", "0702969e19deebe2a4bebb0594034fa3");
INSERT INTO `wp_automatic_cached` VALUES("115", "https://78win78.com/wp-content/uploads/2021/11/dan-de-64-so-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-64-so-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-64-so-1.jpg", "65f45757b0865f7e4a2310ded7d03523", "908f84e5e5743cace290acbfed72989e");
INSERT INTO `wp_automatic_cached` VALUES("116", "https://78win78.com/wp-content/uploads/2021/11/dan-de-64-so-3.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-64-so-3.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-64-so-3.jpg", "df51c0e5cbc07261391a13d724f090a4", "90fe3f890f63268fc44a8dc58b1a8e26");
INSERT INTO `wp_automatic_cached` VALUES("117", "https://78win78.com/wp-content/uploads/2021/11/dan-de-64-so.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-64-so.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-64-so.jpeg", "ddce306c54ce052869c5fe545da213c6", "3f121903ff7f345e30eb576d706bcfa4");
INSERT INTO `wp_automatic_cached` VALUES("118", "https://78win78.com/wp-content/uploads/2021/11/meo-choi-lo-de.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648113341_513_meo-choi-lo-de.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648113341_513_meo-choi-lo-de.jpeg", "e4b232ad3f0e6f61cb40432639655e56", "91aa44734ca1f944e5697dad19b14b7c");
INSERT INTO `wp_automatic_cached` VALUES("119", "https://78win78.com/wp-content/uploads/2021/11/dan-de-64-so.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-64-so.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-64-so.jpg", "3203b37234e5bee556d1acd5febdbb62", "94346273da90d98bdca4a1d21c376b2e");
INSERT INTO `wp_automatic_cached` VALUES("120", "https://78win78.com/wp-content/uploads/2021/11/dan-de-49-so-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-49-so-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-49-so-1.jpg", "82fcdb18540188650f2adae1433be138", "80119b1c9b909ed21909ed0e31252708");
INSERT INTO `wp_automatic_cached` VALUES("121", "https://78win78.com/wp-content/uploads/2021/11/dan-de-49-so-2.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-49-so-2.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-49-so-2.jpg", "331782a7973a6f2f86c6845b0b0a8d12", "18e86808dc255a0530fefb6625801e6a");
INSERT INTO `wp_automatic_cached` VALUES("122", "https://78win78.com/wp-content/uploads/2021/11/dan-de-49-so-3.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-49-so-3.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-49-so-3.jpg", "00637d4016a06191e027bf3aca21c40d", "bf55ee3d60f9735ea99f8c4929aa94b0");
INSERT INTO `wp_automatic_cached` VALUES("123", "https://78win78.com/wp-content/uploads/2021/11/dan-de-49-so.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-49-so.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-49-so.jpg", "82f0b147c95521c6603dae5b36f0c467", "75920005cdd80c128307e0e9fea5032f");
INSERT INTO `wp_automatic_cached` VALUES("124", "https://78win78.com/wp-content/uploads/2021/11/dan-de-60-so-1.png", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-60-so-1.png", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-60-so-1.png", "95340a69824fff92e86533217e778474", "d9dc8176860da43980ff444918d18016");
INSERT INTO `wp_automatic_cached` VALUES("125", "https://78win78.com/wp-content/uploads/2021/11/Dan-de-60-so-2.png", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/Dan-de-60-so-2.png", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/Dan-de-60-so-2.png", "e65e9a742b116aaa067505201b3aee6e", "7b49e39181e746a5cbfaafdc9c64563a");
INSERT INTO `wp_automatic_cached` VALUES("126", "https://78win78.com/wp-content/uploads/2021/11/Dan-de-60-so-3.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/Dan-de-60-so-3.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/Dan-de-60-so-3.jpg", "b0f5ed0d400f240b8703324aae1e8b61", "49986fa5b66bd5e658bb295fa96e3911");
INSERT INTO `wp_automatic_cached` VALUES("127", "https://78win78.com/wp-content/uploads/2021/11/Dan-de-60-so.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/Dan-de-60-so.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/Dan-de-60-so.jpg", "574221ede1924d9c443f03bc525d730b", "6cb9d812e2a5111927326c2c25dc72ea");
INSERT INTO `wp_automatic_cached` VALUES("128", "https://78win78.com/wp-content/uploads/2021/11/Dan-de-4-so-mien-phi-3.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/Dan-de-4-so-mien-phi-3.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/Dan-de-4-so-mien-phi-3.jpg", "982405962eb739fa2c6b2d48cd76c4d4", "c2703898fe7ee9d176211a51274ed17c");
INSERT INTO `wp_automatic_cached` VALUES("129", "https://78win78.com/wp-content/uploads/2021/11/Dan-de-4-so-mien-phi-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/Dan-de-4-so-mien-phi-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/Dan-de-4-so-mien-phi-1.jpg", "2f742e4fddbeb1eb4c15d734cd74a88e", "6250e70b02ecb584d1772a60eed699e2");
INSERT INTO `wp_automatic_cached` VALUES("130", "https://78win78.com/wp-content/uploads/2021/11/Dan-de-4-so-mien-phi-2.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/Dan-de-4-so-mien-phi-2.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/Dan-de-4-so-mien-phi-2.jpg", "4e05fa9f9b568317f9973d1864fca18b", "71780fbe262b5479edc8bbdbb89ed789");
INSERT INTO `wp_automatic_cached` VALUES("131", "https://78win78.com/wp-content/uploads/2021/11/dan-de-4-so-mien-phi.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-4-so-mien-phi.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-4-so-mien-phi.jpg", "742a5e24b4000c924111c63d2aabccfe", "469edf3ec27274de88c67a9b69bf4b29");
INSERT INTO `wp_automatic_cached` VALUES("132", "https://78win78.com/wp-content/uploads/2021/11/lo-dan-theo-ngay-ty-le-thang-100-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/lo-dan-theo-ngay-ty-le-thang-100-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/lo-dan-theo-ngay-ty-le-thang-100-1.jpg", "aa2856a1ac7845eb6ad37cb27afe25bc", "a13b374e0eb7fde3d1f3c72e5e401811");
INSERT INTO `wp_automatic_cached` VALUES("133", "https://78win78.com/wp-content/uploads/2021/11/lo-dan-theo-ngay-ty-le-thang-100-2.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/lo-dan-theo-ngay-ty-le-thang-100-2.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/lo-dan-theo-ngay-ty-le-thang-100-2.jpg", "40eb55ce19758c1ee2f588e3fb9ba0b7", "781379610e4686a69976d0620e7bed8f");
INSERT INTO `wp_automatic_cached` VALUES("134", "https://78win78.com/wp-content/uploads/2021/11/choi-lo-dan.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/choi-lo-dan.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/choi-lo-dan.jpeg", "aa7da39be0862d4730db2e822da43990", "6d0f03d9013b52cabe467e7f68bd5f2d");
INSERT INTO `wp_automatic_cached` VALUES("135", "https://78win78.com/wp-content/uploads/2021/11/lo-dan-theo-ngay-ty-le-thang-100-3.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/lo-dan-theo-ngay-ty-le-thang-100-3.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/lo-dan-theo-ngay-ty-le-thang-100-3.jpg", "53c227196aea1220a3c472c9eb2b11ea", "a0a4bd809abe25036fcd69474688142a");
INSERT INTO `wp_automatic_cached` VALUES("136", "https://78win78.com/wp-content/uploads/2021/11/lo-dan-theo-ngay-ty-le-thang-100.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/lo-dan-theo-ngay-ty-le-thang-100.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/lo-dan-theo-ngay-ty-le-thang-100.jpg", "1d554dd2a701bd8d266830fccfcbf23f", "3ebd718008c517aa3df5b52cec4682cd");
INSERT INTO `wp_automatic_cached` VALUES("137", "https://78win78.com/wp-content/uploads/2021/11/cach-bat-lo-giai-7-3.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-lo-giai-7-3.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-lo-giai-7-3.jpg", "e88ed06662f364abd8c012d9a336dfa8", "b76bf03fbbc89460fe3c8b4a5fdb901a");
INSERT INTO `wp_automatic_cached` VALUES("138", "https://78win78.com/wp-content/uploads/2021/11/cach-bat-lo-giai-7-2.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-lo-giai-7-2.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-lo-giai-7-2.jpg", "7f07464d3e69f9e3bba1931c4c4e4394", "0637febc60fa7d53d027c0ed36597f8a");
INSERT INTO `wp_automatic_cached` VALUES("139", "https://78win78.com/wp-content/uploads/2021/11/cach-bat-lo-giai-7-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-lo-giai-7-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-lo-giai-7-1.jpg", "e3316e2447ef8bf449819fd39bb25f5d", "62bf2f63563ea5252e54db6ecb38b007");
INSERT INTO `wp_automatic_cached` VALUES("140", "https://78win78.com/wp-content/uploads/2021/11/bat-lo-giai-7.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/bat-lo-giai-7.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/bat-lo-giai-7.jpeg", "414525ba0403dc9e8a42318b7add553e", "f8b9e590a981cbeffbcff35968f4f248");
INSERT INTO `wp_automatic_cached` VALUES("141", "https://78win78.com/wp-content/uploads/2021/11/cach-bat-lo-giai-7.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-lo-giai-7.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-bat-lo-giai-7.jpg", "c88e0ca52d1254f12f3773299128f3b5", "8156d9aefc8b8ea6bdab33ad14f1471f");
INSERT INTO `wp_automatic_cached` VALUES("142", "https://78win78.com/wp-content/uploads/2021/11/danh-de-dau-duoi.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/danh-de-dau-duoi.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/danh-de-dau-duoi.jpg", "0dcc144186a44ec08d4c36f56638283c", "cb0ae552e81da1882e5bb117c9a62c43");
INSERT INTO `wp_automatic_cached` VALUES("143", "https://78win78.com/wp-content/uploads/2021/11/danh-de-dau-duoi-2.jpeg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/danh-de-dau-duoi-2.jpeg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/danh-de-dau-duoi-2.jpeg", "b66666a5ea9d67caf22ca6400719493f", "839433224765147a3080ac476021004d");
INSERT INTO `wp_automatic_cached` VALUES("144", "https://78win78.com/wp-content/uploads/2021/11/danh-de-dau-duoi-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/danh-de-dau-duoi-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/danh-de-dau-duoi-1.jpg", "4b69d76dc09597dbf022f5b6ff4a6312", "d28fa9228a3e8269b131d0e9ad001c03");
INSERT INTO `wp_automatic_cached` VALUES("145", "https://78win78.com/wp-content/uploads/2021/11/cach-danh-de-dau-duoi.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/cach-danh-de-dau-duoi.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/cach-danh-de-dau-duoi.jpg", "da5924949f9411caad02dc9d08cb8bdf", "be699018a6828327093aa4a3b0d66ac6");
INSERT INTO `wp_automatic_cached` VALUES("146", "https://78win78.com/wp-content/uploads/2021/11/dan-de-le-chan.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-le-chan.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-le-chan.jpg", "0129bc175fd2f4c50e457c47bd48ec91", "3f8c49ce75b48b99df7a083f7475b15b");
INSERT INTO `wp_automatic_cached` VALUES("147", "https://78win78.com/wp-content/uploads/2021/11/dan-de-chan-le.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-chan-le.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/dan-de-chan-le.jpg", "3413edd1d8e9e67c9435de71989bb41c", "a7fb7a4331c34ef73cee83b72706132f");
INSERT INTO `wp_automatic_cached` VALUES("148", "https://78win78.com/wp-content/uploads/2021/11/kinh-nghiem-soi-cau-chan-le.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/kinh-nghiem-soi-cau-chan-le.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/kinh-nghiem-soi-cau-chan-le.jpg", "055d26d14b429c919e7ada73de62b4e7", "7d87ffe867d68685638902563855a717");
INSERT INTO `wp_automatic_cached` VALUES("149", "https://78win78.com/wp-content/uploads/2021/11/dan-chan-le.png", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/dan-chan-le.png", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/dan-chan-le.png", "353d6f308a1f146f44e62652b7c779cb", "e76b02b0c506b4340fac8121cddb5265");
INSERT INTO `wp_automatic_cached` VALUES("158", "https://www.kubet.space/wp-content/uploads/2021/10/DONG-1-2-1-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648177549_DONG-1-2-1-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648177549_DONG-1-2-1-1.jpg", "c2628bad2456313b45d6f6268fb66b49", "b145dbe8d480e37e82ca93e22965b52c");
INSERT INTO `wp_automatic_cached` VALUES("161", "https://www.kubet.space/wp-content/uploads/2021/10/HOA-1-2-1-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648177726_HOA-1-2-1-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648177726_HOA-1-2-1-1.jpg", "9f441b960ac9979e782b211077ba7106", "1b163e2d81445e70a07a191a445b03b2");
INSERT INTO `wp_automatic_cached` VALUES("164", "https://www.kubet.space/wp-content/uploads/2021/10/VAN-1-2.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648177972_VAN-1-2.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648177972_VAN-1-2.jpg", "4219d665874e5f48e7bc50e56c46c2f8", "49c675fdda18eeddef50dff39cc42f66");
INSERT INTO `wp_automatic_cached` VALUES("167", "https://www.kubet.space/wp-content/uploads/2021/10/VANG-1-1-1-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648178229_VANG-1-1-1-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648178229_VANG-1-1-1-1.jpg", "a8d33e7067b767d5c1e293687597d5c9", "30623a36ea2488bb752ec15547255e53");
INSERT INTO `wp_automatic_cached` VALUES("170", "https://www.kubet.space/wp-content/uploads/2021/10/TRANG-1-1-1-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648178471_TRANG-1-1-1-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648178471_TRANG-1-1-1-1.jpg", "d1d25b6ce9afe58b80f441e4557af72b", "5d5d665484dd4ad36c85df0c17de61be");
INSERT INTO `wp_automatic_cached` VALUES("173", "https://www.kubet.space/wp-content/uploads/2021/10/MAT-1-1-1-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648178712_MAT-1-1-1-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648178712_MAT-1-1-1-1.jpg", "0c68345713593b04ee9d1361130a5a06", "dfd99c53c02b0694183c0809c4bc7674");
INSERT INTO `wp_automatic_cached` VALUES("176", "https://www.kubet.space/wp-content/uploads/2021/10/BAU-1-1-1-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648178954_BAU-1-1-1-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648178954_BAU-1-1-1-1.jpg", "aaef44c553e789720cd39162f914d1b7", "8a45422842d2768b7df2f98fc5679e58");
INSERT INTO `wp_automatic_cached` VALUES("179", "https://www.kubet.space/wp-content/uploads/2021/10/BIEN-1-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648179206_BIEN-1-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648179206_BIEN-1-1.jpg", "01f7cfc5415f841bc669c70681d0edb2", "4852d91ebf8899cb4a4c3d92a165357c");
INSERT INTO `wp_automatic_cached` VALUES("182", "https://www.kubet.space/wp-content/uploads/2021/10/LU-1-1-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648182979_LU-1-1-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648182979_LU-1-1-1.jpg", "4a7ec35461ef90565d50768642b3b185", "d81a024c965ec4dbb834ec2c0b037d81");
INSERT INTO `wp_automatic_cached` VALUES("185", "https://www.kubet.space/wp-content/uploads/2021/10/BO-1-2.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648183174_BO-1-2.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648183174_BO-1-2.jpg", "050d7ac1163ead358f51788142c36133", "6f29734ba9f71a03b39b861518416000");
INSERT INTO `wp_automatic_cached` VALUES("188", "https://www.kubet.space/wp-content/uploads/2021/10/CHO-1-1-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648183416_CHO-1-1-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648183416_CHO-1-1-1.jpg", "e9a513dd2c83abf505e17a8fb1ca556e", "a2ada426f09a1355bc7aff1a720859cf");
INSERT INTO `wp_automatic_cached` VALUES("191", "https://www.kubet.space/wp-content/uploads/2021/10/GA-1-2-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648183658_GA-1-2-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648183658_GA-1-2-1.jpg", "561d58e8893e418338ee47449af39041", "7830898c71760d0a0faba4b5d7d9541e");
INSERT INTO `wp_automatic_cached` VALUES("194", "https://www.kubet.space/wp-content/uploads/2021/10/Y-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648183899_Y-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648183899_Y-1.jpg", "83fbfb3281504d7eba570d4338518278", "ff7f6526a0040f745c998184725b53b1");
INSERT INTO `wp_automatic_cached` VALUES("197", "https://www.kubet.space/wp-content/uploads/2021/10/RUA-1-1-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648184291_RUA-1-1-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648184291_RUA-1-1-1.jpg", "a2ce8804d7d11f82d49a737bd623fe5f", "dd116fc32ea5dad2f5cd9f97c31c62b1");
INSERT INTO `wp_automatic_cached` VALUES("200", "https://www.kubet.space/wp-content/uploads/2021/10/NHIN-1-1-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648185861_NHIN-1-1-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648185861_NHIN-1-1-1.jpg", "5d15c54ba91e2e9d105445a74220958a", "874e99045da36104cbc44353b28362d6");
INSERT INTO `wp_automatic_cached` VALUES("202", "https://www.kubet.space/wp-content/uploads/2021/10/MA-2.gif", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648195010_194_MA-2.gif", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648195010_194_MA-2.gif", "d2992ef117cbe7e26627af46236fd520", "f227d822a232ab275fd9fd2b2b768a9f");
INSERT INTO `wp_automatic_cached` VALUES("203", "https://www.kubet.space/wp-content/uploads/2021/10/CHAY-1-1.jpg", "https://mami.gameh5.xyz/wp-content/uploads/2022/03/1648195010_CHAY-1-1.jpg", "/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads/2022/03/1648195010_CHAY-1-1.jpg", "fb73d6132436a8ab8906113b9e29e36e", "3d7d5f01a8260f08466c049eb3d5f9b8");

/* INSERT TABLE DATA: wp_automatic_camps */
INSERT INTO `wp_automatic_camps` VALUES("624", "Cẩm nang Lô Đề", "", "[original_title]", " [ad_1]\r\n<br>[matched_content]\r\n<br>[ad_2]", "All", "", "draft", "2000", "", "9", "a:39:{i:0;s:16:\"OPT_MUST_CONTENT\";i:1;s:14:\"OPT_MUST_IMAGE\";i:2;s:15:\"OPT_FEED_SCRIPT\";i:3;s:12:\"OPT_CJ_CACHE\";i:4;s:12:\"OPT_CL_CACHE\";i:5;s:12:\"OPT_WM_CACHE\";i:6;s:12:\"OPT_RD_CACHE\";i:7;s:21:\"OPT_RD_OFFICIAL_EMBED\";i:8;s:12:\"OPT_IU_CACHE\";i:9;s:12:\"OPT_EV_CACHE\";i:10;s:21:\"OPT_GENERATE_FB_TITLE\";i:11;s:12:\"OPT_FB_CACHE\";i:12;s:14:\"OPT_AM_GALLERY\";i:13;s:12:\"OPT_VM_CACHE\";i:14;s:12:\"OPT_SC_CACHE\";i:15;s:12:\"OPT_PT_CACHE\";i:16;s:17:\"OPT_PT_AUTO_TITLE\";i:17;s:12:\"OPT_IT_CACHE\";i:18;s:17:\"OPT_IT_AUTO_TITLE\";i:19;s:16:\"OPT_TW_VID_EMBED\";i:20;s:12:\"OPT_DM_CACHE\";i:21;s:12:\"OPT_YT_CACHE\";i:22;s:12:\"OPT_EB_CACHE\";i:23;s:12:\"OPT_FL_CACHE\";i:24;s:18:\"OPT_CB_DESCRIPTION\";i:25;s:9:\"OPT_THUMB\";i:26;s:14:\"OPT_THUMB_ALT2\";i:27;s:14:\"OPT_THUMB_ALT3\";i:28;s:16:\"OPT_FEEDS_OG_IMG\";i:29;s:9:\"OPT_CACHE\";i:30;s:14:\"OPT_FEED_MEDIA\";i:31;s:15:\"OPT_RGX_REPLACE\";i:32;s:23:\"OPT_RGX_REPLACE_PROTECT\";i:33;s:20:\"OPT_RGX_REPLACE_WORD\";i:34;s:9:\"OPT_STRIP\";i:35;s:13:\"OPT_LINK_ONCE\";i:36;s:19:\"OPT_NO_COMMENT_LINK\";i:37;s:12:\"OPT_LNK_BLNK\";i:38;s:16:\"OPT_LNK_NOFOLLOW\";}", "", "Multi", "", "", "All", "relevance", "com", "1", "a:1:{i:0;s:0:\"\";}", "a:1:{i:0;s:0:\"\";}", "", "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", "", "", "", "", "", "post");
INSERT INTO `wp_automatic_camps` VALUES("781", "Giải mã giấc mơ - https://www.kubet.space/giai-ma-giac-mo/", "", "[original_title]", " [ad_1]\r\n<br>[matched_content]\r\n<br>[ad_2]", "All", "", "draft", "2000", "", "10", "a:37:{i:0;s:16:\"OPT_MUST_CONTENT\";i:1;s:14:\"OPT_MUST_IMAGE\";i:2;s:15:\"OPT_FEED_SCRIPT\";i:3;s:12:\"OPT_CJ_CACHE\";i:4;s:12:\"OPT_CL_CACHE\";i:5;s:12:\"OPT_WM_CACHE\";i:6;s:12:\"OPT_RD_CACHE\";i:7;s:21:\"OPT_RD_OFFICIAL_EMBED\";i:8;s:12:\"OPT_IU_CACHE\";i:9;s:12:\"OPT_EV_CACHE\";i:10;s:21:\"OPT_GENERATE_FB_TITLE\";i:11;s:12:\"OPT_FB_CACHE\";i:12;s:14:\"OPT_AM_GALLERY\";i:13;s:12:\"OPT_VM_CACHE\";i:14;s:12:\"OPT_SC_CACHE\";i:15;s:12:\"OPT_PT_CACHE\";i:16;s:17:\"OPT_PT_AUTO_TITLE\";i:17;s:12:\"OPT_IT_CACHE\";i:18;s:17:\"OPT_IT_AUTO_TITLE\";i:19;s:16:\"OPT_TW_VID_EMBED\";i:20;s:12:\"OPT_DM_CACHE\";i:21;s:12:\"OPT_YT_CACHE\";i:22;s:12:\"OPT_EB_CACHE\";i:23;s:12:\"OPT_FL_CACHE\";i:24;s:18:\"OPT_CB_DESCRIPTION\";i:25;s:9:\"OPT_THUMB\";i:26;s:16:\"OPT_FEEDS_OG_IMG\";i:27;s:9:\"OPT_CACHE\";i:28;s:14:\"OPT_FEED_MEDIA\";i:29;s:15:\"OPT_RGX_REPLACE\";i:30;s:23:\"OPT_RGX_REPLACE_PROTECT\";i:31;s:20:\"OPT_RGX_REPLACE_WORD\";i:32;s:9:\"OPT_STRIP\";i:33;s:13:\"OPT_LINK_ONCE\";i:34;s:19:\"OPT_NO_COMMENT_LINK\";i:35;s:12:\"OPT_LNK_BLNK\";i:36;s:16:\"OPT_LNK_NOFOLLOW\";}", "", "Multi", "", "", "All", "relevance", "com", "1", "a:1:{i:0;s:0:\"\";}", "a:1:{i:0;s:0:\"\";}", "", "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", "", "", "", "", "", "post");

/* INSERT TABLE DATA: wp_automatic_categories */
INSERT INTO `wp_automatic_categories` VALUES("1253", "0", "Arts & Entertainment");
INSERT INTO `wp_automatic_categories` VALUES("1510", "0", "Betting Systems");
INSERT INTO `wp_automatic_categories` VALUES("1266", "0", "Business / Investing");
INSERT INTO `wp_automatic_categories` VALUES("1283", "0", "Computers / Internet");
INSERT INTO `wp_automatic_categories` VALUES("1297", "0", "Cooking, Food & Wine");
INSERT INTO `wp_automatic_categories` VALUES("1308", "0", "E-business & E-marketing");
INSERT INTO `wp_automatic_categories` VALUES("1362", "0", "Education");
INSERT INTO `wp_automatic_categories` VALUES("1332", "0", "Employment & Jobs");
INSERT INTO `wp_automatic_categories` VALUES("1338", "0", "Fiction");
INSERT INTO `wp_automatic_categories` VALUES("1340", "0", "Games");
INSERT INTO `wp_automatic_categories` VALUES("1344", "0", "Green Products");
INSERT INTO `wp_automatic_categories` VALUES("1347", "0", "Health & Fitness");
INSERT INTO `wp_automatic_categories` VALUES("1366", "0", "Home & Garden");
INSERT INTO `wp_automatic_categories` VALUES("1377", "0", "Languages");
INSERT INTO `wp_automatic_categories` VALUES("1392", "0", "Mobile");
INSERT INTO `wp_automatic_categories` VALUES("1400", "0", "Parenting & Families");
INSERT INTO `wp_automatic_categories` VALUES("1408", "0", "Politics / Current Events");
INSERT INTO `wp_automatic_categories` VALUES("1410", "0", "Reference");
INSERT INTO `wp_automatic_categories` VALUES("1419", "0", "Self-Help");
INSERT INTO `wp_automatic_categories` VALUES("1432", "0", "Software & Services");
INSERT INTO `wp_automatic_categories` VALUES("1461", "0", "Spirituality, New Age & Alternative Beliefs");
INSERT INTO `wp_automatic_categories` VALUES("1472", "0", "Sports");
INSERT INTO `wp_automatic_categories` VALUES("1494", "0", "Travel");
INSERT INTO `wp_automatic_categories` VALUES("1265", "1253", "Architecture");
INSERT INTO `wp_automatic_categories` VALUES("1259", "1253", "Art");
INSERT INTO `wp_automatic_categories` VALUES("1254", "1253", "Body Art");
INSERT INTO `wp_automatic_categories` VALUES("1261", "1253", "Dance");
INSERT INTO `wp_automatic_categories` VALUES("1263", "1253", "Fashion");
INSERT INTO `wp_automatic_categories` VALUES("1255", "1253", "Film & Television");
INSERT INTO `wp_automatic_categories` VALUES("1260", "1253", "General");
INSERT INTO `wp_automatic_categories` VALUES("1262", "1253", "Humor");
INSERT INTO `wp_automatic_categories` VALUES("1519", "1253", "Magic Tricks");
INSERT INTO `wp_automatic_categories` VALUES("1256", "1253", "Music");
INSERT INTO `wp_automatic_categories` VALUES("1257", "1253", "Photography");
INSERT INTO `wp_automatic_categories` VALUES("1258", "1253", "Radio");
INSERT INTO `wp_automatic_categories` VALUES("1264", "1253", "Theater");
INSERT INTO `wp_automatic_categories` VALUES("1515", "1510", "Casino Table Games");
INSERT INTO `wp_automatic_categories` VALUES("1517", "1510", "Football");
INSERT INTO `wp_automatic_categories` VALUES("1511", "1510", "General");
INSERT INTO `wp_automatic_categories` VALUES("1512", "1510", "Horse Racing");
INSERT INTO `wp_automatic_categories` VALUES("1514", "1510", "Lottery");
INSERT INTO `wp_automatic_categories` VALUES("1513", "1510", "Poker");
INSERT INTO `wp_automatic_categories` VALUES("1516", "1510", "Soccer");
INSERT INTO `wp_automatic_categories` VALUES("1275", "1266", "Careers, Industries & Professions");
INSERT INTO `wp_automatic_categories` VALUES("1520", "1266", "Commodities");
INSERT INTO `wp_automatic_categories` VALUES("1277", "1266", "Debt");
INSERT INTO `wp_automatic_categories` VALUES("1271", "1266", "Derivatives");
INSERT INTO `wp_automatic_categories` VALUES("1280", "1266", "Economics");
INSERT INTO `wp_automatic_categories` VALUES("1268", "1266", "Equities & Stocks");
INSERT INTO `wp_automatic_categories` VALUES("1267", "1266", "Foreign Exchange");
INSERT INTO `wp_automatic_categories` VALUES("1270", "1266", "General");
INSERT INTO `wp_automatic_categories` VALUES("1276", "1266", "International Business");
INSERT INTO `wp_automatic_categories` VALUES("1278", "1266", "Management & Leadership");
INSERT INTO `wp_automatic_categories` VALUES("1273", "1266", "Marketing & Sales");
INSERT INTO `wp_automatic_categories` VALUES("1279", "1266", "Outsourcing");
INSERT INTO `wp_automatic_categories` VALUES("1274", "1266", "Personal Finance");
INSERT INTO `wp_automatic_categories` VALUES("1269", "1266", "Real Estate");
INSERT INTO `wp_automatic_categories` VALUES("1272", "1266", "Small Biz / Entrepreneurship");
INSERT INTO `wp_automatic_categories` VALUES("1290", "1283", "Databases");
INSERT INTO `wp_automatic_categories` VALUES("1295", "1283", "Email Services");
INSERT INTO `wp_automatic_categories` VALUES("1292", "1283", "General");
INSERT INTO `wp_automatic_categories` VALUES("1285", "1283", "Graphics");
INSERT INTO `wp_automatic_categories` VALUES("1288", "1283", "Hardware");
INSERT INTO `wp_automatic_categories` VALUES("1291", "1283", "Networking");
INSERT INTO `wp_automatic_categories` VALUES("1293", "1283", "Operating Systems");
INSERT INTO `wp_automatic_categories` VALUES("1287", "1283", "Programming");
INSERT INTO `wp_automatic_categories` VALUES("1286", "1283", "Software");
INSERT INTO `wp_automatic_categories` VALUES("1296", "1283", "System Administration");
INSERT INTO `wp_automatic_categories` VALUES("1294", "1283", "System Analysis & Design");
INSERT INTO `wp_automatic_categories` VALUES("1289", "1283", "Web Hosting");
INSERT INTO `wp_automatic_categories` VALUES("1284", "1283", "Web Site Design");
INSERT INTO `wp_automatic_categories` VALUES("1300", "1297", "BBQ");
INSERT INTO `wp_automatic_categories` VALUES("1298", "1297", "Baking");
INSERT INTO `wp_automatic_categories` VALUES("1303", "1297", "Cooking");
INSERT INTO `wp_automatic_categories` VALUES("1304", "1297", "Drinks & Beverages");
INSERT INTO `wp_automatic_categories` VALUES("1305", "1297", "General");
INSERT INTO `wp_automatic_categories` VALUES("1299", "1297", "Recipes");
INSERT INTO `wp_automatic_categories` VALUES("1306", "1297", "Regional & Intl.");
INSERT INTO `wp_automatic_categories` VALUES("1301", "1297", "Special Diet");
INSERT INTO `wp_automatic_categories` VALUES("1302", "1297", "Special Occasions");
INSERT INTO `wp_automatic_categories` VALUES("1307", "1297", "Vegetables / Vegetarian");
INSERT INTO `wp_automatic_categories` VALUES("1521", "1297", "Wine Making");
INSERT INTO `wp_automatic_categories` VALUES("1309", "1308", "Affiliate Marketing");
INSERT INTO `wp_automatic_categories` VALUES("1311", "1308", "Article Marketing");
INSERT INTO `wp_automatic_categories` VALUES("1326", "1308", "Auctions");
INSERT INTO `wp_automatic_categories` VALUES("1330", "1308", "Banners");
INSERT INTO `wp_automatic_categories` VALUES("1318", "1308", "Blog Marketing");
INSERT INTO `wp_automatic_categories` VALUES("1323", "1308", "Classified Advertising");
INSERT INTO `wp_automatic_categories` VALUES("1328", "1308", "Consulting");
INSERT INTO `wp_automatic_categories` VALUES("1327", "1308", "Copywriting");
INSERT INTO `wp_automatic_categories` VALUES("1325", "1308", "Domains");
INSERT INTO `wp_automatic_categories` VALUES("1312", "1308", "E-commerce Operations");
INSERT INTO `wp_automatic_categories` VALUES("1320", "1308", "E-zine Strategies");
INSERT INTO `wp_automatic_categories` VALUES("1321", "1308", "Email Marketing");
INSERT INTO `wp_automatic_categories` VALUES("1324", "1308", "General");
INSERT INTO `wp_automatic_categories` VALUES("1317", "1308", "Market Research");
INSERT INTO `wp_automatic_categories` VALUES("1319", "1308", "Marketing");
INSERT INTO `wp_automatic_categories` VALUES("1322", "1308", "Niche Marketing");
INSERT INTO `wp_automatic_categories` VALUES("1314", "1308", "Paid Surveys");
INSERT INTO `wp_automatic_categories` VALUES("1313", "1308", "Pay Per Click Advertising");
INSERT INTO `wp_automatic_categories` VALUES("1310", "1308", "Promotion");
INSERT INTO `wp_automatic_categories` VALUES("1315", "1308", "SEM & SEO");
INSERT INTO `wp_automatic_categories` VALUES("1331", "1308", "Social Media Marketing");
INSERT INTO `wp_automatic_categories` VALUES("1316", "1308", "Submitters");
INSERT INTO `wp_automatic_categories` VALUES("1329", "1308", "Video Marketing");
INSERT INTO `wp_automatic_categories` VALUES("1364", "1362", "Admissions");
INSERT INTO `wp_automatic_categories` VALUES("1522", "1362", "Educational Materials");
INSERT INTO `wp_automatic_categories` VALUES("1523", "1362", "Higher Education");
INSERT INTO `wp_automatic_categories` VALUES("1524", "1362", "K-12");
INSERT INTO `wp_automatic_categories` VALUES("1365", "1362", "Student Loans");
INSERT INTO `wp_automatic_categories` VALUES("1363", "1362", "Test Prep & Study Guides");
INSERT INTO `wp_automatic_categories` VALUES("1335", "1332", "Cover Letter & Resume Guides");
INSERT INTO `wp_automatic_categories` VALUES("1337", "1332", "General");
INSERT INTO `wp_automatic_categories` VALUES("1334", "1332", "Job Listings");
INSERT INTO `wp_automatic_categories` VALUES("1336", "1332", "Job Search Guides");
INSERT INTO `wp_automatic_categories` VALUES("1333", "1332", "Job Skills / Training");
INSERT INTO `wp_automatic_categories` VALUES("1339", "1338", "General");
INSERT INTO `wp_automatic_categories` VALUES("1342", "1340", "Console Guides & Repairs");
INSERT INTO `wp_automatic_categories` VALUES("1343", "1340", "General");
INSERT INTO `wp_automatic_categories` VALUES("1341", "1340", "Strategy Guides");
INSERT INTO `wp_automatic_categories` VALUES("1345", "1344", "Alternative Energy");
INSERT INTO `wp_automatic_categories` VALUES("1346", "1344", "Conservation & Efficiency");
INSERT INTO `wp_automatic_categories` VALUES("1525", "1344", "General");
INSERT INTO `wp_automatic_categories` VALUES("1357", "1347", "Addiction");
INSERT INTO `wp_automatic_categories` VALUES("1361", "1347", "Beauty");
INSERT INTO `wp_automatic_categories` VALUES("1359", "1347", "Dental Health");
INSERT INTO `wp_automatic_categories` VALUES("1348", "1347", "Diets & Weight Loss");
INSERT INTO `wp_automatic_categories` VALUES("1354", "1347", "Exercise & Fitness");
INSERT INTO `wp_automatic_categories` VALUES("1360", "1347", "General");
INSERT INTO `wp_automatic_categories` VALUES("1526", "1347", "Meditation");
INSERT INTO `wp_automatic_categories` VALUES("1352", "1347", "Men & Health");
INSERT INTO `wp_automatic_categories` VALUES("1355", "1347", "Mental Health");
INSERT INTO `wp_automatic_categories` VALUES("1350", "1347", "Nutrition");
INSERT INTO `wp_automatic_categories` VALUES("1349", "1347", "Remedies");
INSERT INTO `wp_automatic_categories` VALUES("1527", "1347", "Sleep and Dreams");
INSERT INTO `wp_automatic_categories` VALUES("1356", "1347", "Spiritual Health");
INSERT INTO `wp_automatic_categories` VALUES("1351", "1347", "Strength Training");
INSERT INTO `wp_automatic_categories` VALUES("1353", "1347", "Women & Health");
INSERT INTO `wp_automatic_categories` VALUES("1358", "1347", "Yoga");
INSERT INTO `wp_automatic_categories` VALUES("1368", "1366", "Animal Care & Pets");
INSERT INTO `wp_automatic_categories` VALUES("1371", "1366", "Crafts & Hobbies");
INSERT INTO `wp_automatic_categories` VALUES("1374", "1366", "Entertaining");
INSERT INTO `wp_automatic_categories` VALUES("1367", "1366", "Gardening & Horticulture");
INSERT INTO `wp_automatic_categories` VALUES("1373", "1366", "General");
INSERT INTO `wp_automatic_categories` VALUES("1376", "1366", "Homebuying");
INSERT INTO `wp_automatic_categories` VALUES("1369", "1366", "How-to & Home Improvements");
INSERT INTO `wp_automatic_categories` VALUES("1375", "1366", "Interior Design");
INSERT INTO `wp_automatic_categories` VALUES("1372", "1366", "Sewing");
INSERT INTO `wp_automatic_categories` VALUES("1370", "1366", "Weddings");
INSERT INTO `wp_automatic_categories` VALUES("1391", "1377", "Arabic");
INSERT INTO `wp_automatic_categories` VALUES("1383", "1377", "Chinese");
INSERT INTO `wp_automatic_categories` VALUES("1385", "1377", "English");
INSERT INTO `wp_automatic_categories` VALUES("1378", "1377", "French");
INSERT INTO `wp_automatic_categories` VALUES("1381", "1377", "German");
INSERT INTO `wp_automatic_categories` VALUES("1389", "1377", "Hebrew");
INSERT INTO `wp_automatic_categories` VALUES("1390", "1377", "Hindi");
INSERT INTO `wp_automatic_categories` VALUES("1382", "1377", "Italian");
INSERT INTO `wp_automatic_categories` VALUES("1380", "1377", "Japanese");
INSERT INTO `wp_automatic_categories` VALUES("1387", "1377", "Other");
INSERT INTO `wp_automatic_categories` VALUES("1386", "1377", "Russian");
INSERT INTO `wp_automatic_categories` VALUES("1384", "1377", "Sign Language");
INSERT INTO `wp_automatic_categories` VALUES("1379", "1377", "Spanish");
INSERT INTO `wp_automatic_categories` VALUES("1388", "1377", "Thai");
INSERT INTO `wp_automatic_categories` VALUES("1518", "1392", "Apps");
INSERT INTO `wp_automatic_categories` VALUES("1397", "1392", "Developer Tools");
INSERT INTO `wp_automatic_categories` VALUES("1395", "1392", "General");
INSERT INTO `wp_automatic_categories` VALUES("1393", "1392", "Ringtones");
INSERT INTO `wp_automatic_categories` VALUES("1396", "1392", "Security");
INSERT INTO `wp_automatic_categories` VALUES("1394", "1392", "Video");
INSERT INTO `wp_automatic_categories` VALUES("1528", "1400", "Divorce");
INSERT INTO `wp_automatic_categories` VALUES("1402", "1400", "Education");
INSERT INTO `wp_automatic_categories` VALUES("1405", "1400", "Genealogy");
INSERT INTO `wp_automatic_categories` VALUES("1407", "1400", "General");
INSERT INTO `wp_automatic_categories` VALUES("1406", "1400", "Marriage");
INSERT INTO `wp_automatic_categories` VALUES("1403", "1400", "Parenting");
INSERT INTO `wp_automatic_categories` VALUES("1401", "1400", "Pregnancy & Childbirth");
INSERT INTO `wp_automatic_categories` VALUES("1404", "1400", "Special Needs");
INSERT INTO `wp_automatic_categories` VALUES("1409", "1408", "General");
INSERT INTO `wp_automatic_categories` VALUES("1529", "1410", "Automotive");
INSERT INTO `wp_automatic_categories` VALUES("1412", "1410", "Catalogs & Directories");
INSERT INTO `wp_automatic_categories` VALUES("1411", "1410", "Consumer Guides");
INSERT INTO `wp_automatic_categories` VALUES("1413", "1410", "Education");
INSERT INTO `wp_automatic_categories` VALUES("1418", "1410", "Etiquette");
INSERT INTO `wp_automatic_categories` VALUES("1416", "1410", "Gay / Lesbian");
INSERT INTO `wp_automatic_categories` VALUES("1417", "1410", "General");
INSERT INTO `wp_automatic_categories` VALUES("1414", "1410", "Law & Legal Issues");
INSERT INTO `wp_automatic_categories` VALUES("1530", "1410", "The Sciences");
INSERT INTO `wp_automatic_categories` VALUES("1415", "1410", "Writing");
INSERT INTO `wp_automatic_categories` VALUES("1431", "1419", "Abuse");
INSERT INTO `wp_automatic_categories` VALUES("1423", "1419", "Dating Guides");
INSERT INTO `wp_automatic_categories` VALUES("1430", "1419", "Eating Disorders");
INSERT INTO `wp_automatic_categories` VALUES("1427", "1419", "General");
INSERT INTO `wp_automatic_categories` VALUES("1420", "1419", "Marriage & Relationships");
INSERT INTO `wp_automatic_categories` VALUES("1422", "1419", "Motivational / Transformational");
INSERT INTO `wp_automatic_categories` VALUES("1426", "1419", "Personal Finance");
INSERT INTO `wp_automatic_categories` VALUES("1531", "1419", "Public Speaking");
INSERT INTO `wp_automatic_categories` VALUES("1532", "1419", "Self Defense");
INSERT INTO `wp_automatic_categories` VALUES("1429", "1419", "Self-Esteem");
INSERT INTO `wp_automatic_categories` VALUES("1421", "1419", "Stress Management");
INSERT INTO `wp_automatic_categories` VALUES("1425", "1419", "Success");
INSERT INTO `wp_automatic_categories` VALUES("1428", "1419", "Time Management");
INSERT INTO `wp_automatic_categories` VALUES("1438", "1432", "Anti Adware / Spyware");
INSERT INTO `wp_automatic_categories` VALUES("1436", "1432", "Background Investigations");
INSERT INTO `wp_automatic_categories` VALUES("1460", "1432", "Communications");
INSERT INTO `wp_automatic_categories` VALUES("1441", "1432", "Dating");
INSERT INTO `wp_automatic_categories` VALUES("1457", "1432", "Developer Tools");
INSERT INTO `wp_automatic_categories` VALUES("1456", "1432", "Digital Photos");
INSERT INTO `wp_automatic_categories` VALUES("1437", "1432", "Drivers");
INSERT INTO `wp_automatic_categories` VALUES("1453", "1432", "Education");
INSERT INTO `wp_automatic_categories` VALUES("1448", "1432", "Email");
INSERT INTO `wp_automatic_categories` VALUES("1433", "1432", "Foreign Exchange Investing");
INSERT INTO `wp_automatic_categories` VALUES("1445", "1432", "General");
INSERT INTO `wp_automatic_categories` VALUES("1452", "1432", "Graphic Design");
INSERT INTO `wp_automatic_categories` VALUES("1446", "1432", "Hosting");
INSERT INTO `wp_automatic_categories` VALUES("1444", "1432", "Internet Tools");
INSERT INTO `wp_automatic_categories` VALUES("1447", "1432", "MP3 & Audio");
INSERT INTO `wp_automatic_categories` VALUES("1458", "1432", "Networking");
INSERT INTO `wp_automatic_categories` VALUES("1455", "1432", "Operating Systems");
INSERT INTO `wp_automatic_categories` VALUES("1443", "1432", "Other Investment Software");
INSERT INTO `wp_automatic_categories` VALUES("1459", "1432", "Personal Finance");
INSERT INTO `wp_automatic_categories` VALUES("1450", "1432", "Productivity");
INSERT INTO `wp_automatic_categories` VALUES("1434", "1432", "Registry Cleaners");
INSERT INTO `wp_automatic_categories` VALUES("1435", "1432", "Reverse Phone Lookup");
INSERT INTO `wp_automatic_categories` VALUES("1454", "1432", "Screensavers & Wallpaper");
INSERT INTO `wp_automatic_categories` VALUES("1439", "1432", "Security");
INSERT INTO `wp_automatic_categories` VALUES("1440", "1432", "System Optimization");
INSERT INTO `wp_automatic_categories` VALUES("1449", "1432", "Utilities");
INSERT INTO `wp_automatic_categories` VALUES("1442", "1432", "Video");
INSERT INTO `wp_automatic_categories` VALUES("1451", "1432", "Web Design");
INSERT INTO `wp_automatic_categories` VALUES("1465", "1461", "Astrology");
INSERT INTO `wp_automatic_categories` VALUES("1470", "1461", "General");
INSERT INTO `wp_automatic_categories` VALUES("1463", "1461", "Hypnosis");
INSERT INTO `wp_automatic_categories` VALUES("1466", "1461", "Magic");
INSERT INTO `wp_automatic_categories` VALUES("1462", "1461", "Numerology");
INSERT INTO `wp_automatic_categories` VALUES("1468", "1461", "Paranormal");
INSERT INTO `wp_automatic_categories` VALUES("1467", "1461", "Psychics");
INSERT INTO `wp_automatic_categories` VALUES("1469", "1461", "Religion");
INSERT INTO `wp_automatic_categories` VALUES("1471", "1461", "Tarot");
INSERT INTO `wp_automatic_categories` VALUES("1464", "1461", "Witchcraft");
INSERT INTO `wp_automatic_categories` VALUES("1483", "1472", "Automotive");
INSERT INTO `wp_automatic_categories` VALUES("1476", "1472", "Baseball");
INSERT INTO `wp_automatic_categories` VALUES("1485", "1472", "Basketball");
INSERT INTO `wp_automatic_categories` VALUES("1473", "1472", "Coaching");
INSERT INTO `wp_automatic_categories` VALUES("1533", "1472", "Cycling");
INSERT INTO `wp_automatic_categories` VALUES("1491", "1472", "Extreme Sports");
INSERT INTO `wp_automatic_categories` VALUES("1488", "1472", "Football");
INSERT INTO `wp_automatic_categories` VALUES("1490", "1472", "General");
INSERT INTO `wp_automatic_categories` VALUES("1474", "1472", "Golf");
INSERT INTO `wp_automatic_categories` VALUES("1493", "1472", "Hockey");
INSERT INTO `wp_automatic_categories` VALUES("1481", "1472", "Individual Sports");
INSERT INTO `wp_automatic_categories` VALUES("1480", "1472", "Martial Arts");
INSERT INTO `wp_automatic_categories` VALUES("1492", "1472", "Mountaineering");
INSERT INTO `wp_automatic_categories` VALUES("1484", "1472", "Other Team Sports");
INSERT INTO `wp_automatic_categories` VALUES("1482", "1472", "Outdoors & Nature");
INSERT INTO `wp_automatic_categories` VALUES("1479", "1472", "Racket Sports");
INSERT INTO `wp_automatic_categories` VALUES("1534", "1472", "Running");
INSERT INTO `wp_automatic_categories` VALUES("1477", "1472", "Soccer");
INSERT INTO `wp_automatic_categories` VALUES("1489", "1472", "Softball");
INSERT INTO `wp_automatic_categories` VALUES("1478", "1472", "Training");
INSERT INTO `wp_automatic_categories` VALUES("1475", "1472", "Volleyball");
INSERT INTO `wp_automatic_categories` VALUES("1486", "1472", "Water Sports");
INSERT INTO `wp_automatic_categories` VALUES("1487", "1472", "Winter Sports");
INSERT INTO `wp_automatic_categories` VALUES("1535", "1494", "Africa");
INSERT INTO `wp_automatic_categories` VALUES("1495", "1494", "Asia");
INSERT INTO `wp_automatic_categories` VALUES("1500", "1494", "Canada");
INSERT INTO `wp_automatic_categories` VALUES("1503", "1494", "Caribbean");
INSERT INTO `wp_automatic_categories` VALUES("1499", "1494", "Europe");
INSERT INTO `wp_automatic_categories` VALUES("1498", "1494", "General");
INSERT INTO `wp_automatic_categories` VALUES("1501", "1494", "Latin America");
INSERT INTO `wp_automatic_categories` VALUES("1502", "1494", "Middle East");
INSERT INTO `wp_automatic_categories` VALUES("1496", "1494", "Specialty Travel");
INSERT INTO `wp_automatic_categories` VALUES("1497", "1494", "United States");

/* INSERT TABLE DATA: wp_automatic_links */
INSERT INTO `wp_automatic_links` VALUES("ef6bd7e0daaaa6e977d4deb74e26f5b7", "", "624", "", "1");
INSERT INTO `wp_automatic_links` VALUES("b81ddfcd0cc7453a9fcf965b83a63a1d", "", "624", "", "2");
INSERT INTO `wp_automatic_links` VALUES("f538083fc694106349458e0d5152e887", "", "624", "", "3");
INSERT INTO `wp_automatic_links` VALUES("4e843c26558c5739116225f0c91af74f", "", "624", "", "4");
INSERT INTO `wp_automatic_links` VALUES("ef5845c8d186a8826ad1f2d115398887", "", "624", "", "5");
INSERT INTO `wp_automatic_links` VALUES("b0429cc07e808038235ec10679165841", "", "624", "", "6");
INSERT INTO `wp_automatic_links` VALUES("ac900a6c1d23d3bbce28683167c8d30f", "", "624", "", "7");
INSERT INTO `wp_automatic_links` VALUES("d5fdf71b321152f78cac8b5804fde6fd", "", "624", "", "8");
INSERT INTO `wp_automatic_links` VALUES("b8771f9fb2afe1ee3f80be9c75874237", "", "624", "", "9");
INSERT INTO `wp_automatic_links` VALUES("d5ced39bce817c5c24976cfa4d1af0d6", "", "624", "", "10");
INSERT INTO `wp_automatic_links` VALUES("f597ee940af6171ce2334ba80ce56e71", "", "624", "", "11");
INSERT INTO `wp_automatic_links` VALUES("4d82009fca6d4ea56576c6be6e679268", "", "624", "", "12");
INSERT INTO `wp_automatic_links` VALUES("c263642ed479f1d5e73db5b82ea4e0c2", "", "624", "", "13");
INSERT INTO `wp_automatic_links` VALUES("ba0453a7e317866df62bc25b4368c5b7", "", "624", "", "14");
INSERT INTO `wp_automatic_links` VALUES("848ca36056d5da7967d0d78093cd3e32", "", "624", "", "15");
INSERT INTO `wp_automatic_links` VALUES("d8b47ba72261d68c4b52fd5880a274d3", "", "624", "", "16");
INSERT INTO `wp_automatic_links` VALUES("164ea9d0c2f9810e55dab8e363bda0dd", "", "624", "", "17");
INSERT INTO `wp_automatic_links` VALUES("edb7a7575f749da2f3bc27b49d287bbd", "", "624", "", "18");
INSERT INTO `wp_automatic_links` VALUES("d31efd853029413386457385593aaa50", "", "624", "", "19");
INSERT INTO `wp_automatic_links` VALUES("cd7aaa140f30fcfa9c63b8d070bc1f93", "", "624", "", "20");
INSERT INTO `wp_automatic_links` VALUES("7014a843442c2c0674e3ff7cf25c962f", "", "624", "", "21");
INSERT INTO `wp_automatic_links` VALUES("8df8475ce0d53779cb266da260589dac", "", "624", "", "22");
INSERT INTO `wp_automatic_links` VALUES("a8c08b65a0c40e8ebaa09cbdc3bdbe5a", "", "624", "", "23");
INSERT INTO `wp_automatic_links` VALUES("1902fe7a93ead265e793075f56bd5e4e", "", "624", "", "24");
INSERT INTO `wp_automatic_links` VALUES("98e6eb50ad6377e8087ec35c4a2a4e0a", "", "624", "", "25");
INSERT INTO `wp_automatic_links` VALUES("e23d5dbdc01b6e76f73362664a1f11b5", "", "624", "", "26");
INSERT INTO `wp_automatic_links` VALUES("9d33a06d337f322ca58d73ee837c8916", "", "624", "", "27");
INSERT INTO `wp_automatic_links` VALUES("3717ecc763de08f65b0560d3260a29e8", "", "624", "", "28");
INSERT INTO `wp_automatic_links` VALUES("68c76f2160306ca7f8a8002276112032", "", "624", "", "29");
INSERT INTO `wp_automatic_links` VALUES("12c33d08b24e364c3e5b50cd26422f82", "", "624", "", "30");
INSERT INTO `wp_automatic_links` VALUES("de6bb0bd6f0bb5b7fc8e568d82f58b45", "", "624", "", "31");
INSERT INTO `wp_automatic_links` VALUES("9e840b83140428f92bd7e3b7e36ff1f3", "", "624", "", "32");
INSERT INTO `wp_automatic_links` VALUES("eacee5f1a9865daaed415c0f8ae6d1e5", "", "624", "", "33");
INSERT INTO `wp_automatic_links` VALUES("a067710ea863073581c8dcb29b9b5743", "", "624", "", "34");
INSERT INTO `wp_automatic_links` VALUES("b4ae3adad2bfb45ac09a573a00731d7f", "", "624", "", "35");
INSERT INTO `wp_automatic_links` VALUES("211f72378da7f42cf50549be1b8e32da", "", "624", "", "36");
INSERT INTO `wp_automatic_links` VALUES("6cedf440711a9c6f32520109ac2d0f1d", "", "624", "", "37");
INSERT INTO `wp_automatic_links` VALUES("b4f6e449b75287a57c0ee26bad1abc31", "", "624", "", "38");
INSERT INTO `wp_automatic_links` VALUES("b7a9486ff95dbbb06241dc8786c6e9c2", "", "624", "", "39");
INSERT INTO `wp_automatic_links` VALUES("7a53d9e91a3527221698a1fc8be686f8", "", "624", "", "40");
INSERT INTO `wp_automatic_links` VALUES("af49969dea5f5eda5bd4a06b5d5d59e1", "", "781", "", "48");
INSERT INTO `wp_automatic_links` VALUES("fb2223172908c455218026e1149823c8", "", "781", "", "49");
INSERT INTO `wp_automatic_links` VALUES("654ba526c40a93f16fc25c18670f9cd5", "", "781", "", "50");
INSERT INTO `wp_automatic_links` VALUES("9a26569cce5b112b671d18b506f03cca", "", "781", "", "51");
INSERT INTO `wp_automatic_links` VALUES("36abd5010dac407e444b66c85dd94d04", "", "781", "", "52");
INSERT INTO `wp_automatic_links` VALUES("9774a0fa7a4cf94e11c8f059cddf651f", "", "781", "", "53");
INSERT INTO `wp_automatic_links` VALUES("1ab66f2cc8261ddcf362157ef65ce9b7", "", "781", "", "54");
INSERT INTO `wp_automatic_links` VALUES("d5795ccf0287c33c2dd58057b66a6878", "", "781", "", "55");
INSERT INTO `wp_automatic_links` VALUES("99bb34d45f2d8259c92945dadb31bd8a", "", "781", "", "56");
INSERT INTO `wp_automatic_links` VALUES("b1fcebf5b7ea891e0fd283477db63bef", "", "781", "", "57");
INSERT INTO `wp_automatic_links` VALUES("0ed6144b756423d605eb8792c25f95c4", "", "781", "", "58");
INSERT INTO `wp_automatic_links` VALUES("9fc775727f92b76180cf5db26afb4934", "", "781", "", "59");
INSERT INTO `wp_automatic_links` VALUES("5ac997477289043164562ab83c71c456", "", "781", "", "60");
INSERT INTO `wp_automatic_links` VALUES("fc0f7642171955b53b3ccdaebacb669a", "", "781", "", "61");
INSERT INTO `wp_automatic_links` VALUES("f7bd7767c775cef50d9e38a96ddf06b3", "", "781", "", "62");

/* INSERT TABLE DATA: wp_automatic_log */
INSERT INTO `wp_automatic_log` VALUES("283", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=625\">Tiết lộ cách vào tiền nuôi lô cặp 5 ngày tựa như cao thủ</a>", "2022-03-24 14:05:48", "");
INSERT INTO `wp_automatic_log` VALUES("288", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=627\">Cách bắt lô hình quả trám hiệu quả nhất 2021</a>", "2022-03-24 14:06:39", "");
INSERT INTO `wp_automatic_log` VALUES("293", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=629\">Cách đánh lô ngày nào cũng trúng cùng 78win78</a>", "2022-03-24 14:09:02", "");
INSERT INTO `wp_automatic_log` VALUES("298", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=631\">Bật mí các trang web bán số lô đề uy tín nhất hiện nay</a>", "2022-03-24 14:11:03", "");
INSERT INTO `wp_automatic_log` VALUES("303", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=633\">Tiết lộ những cách tính lô chuẩn không cần chỉnh từ cao thủ</a>", "2022-03-24 14:13:06", "");
INSERT INTO `wp_automatic_log` VALUES("308", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=635\">Cách tính lô đề theo ngũ hành chuẩn xác nhất hiện nay</a>", "2022-03-24 14:15:07", "");
INSERT INTO `wp_automatic_log` VALUES("313", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=637\">Chia sẻ cách bắt lô kép miền Bắc từ chuyên gia kinh nghiệm</a>", "2022-03-24 14:17:06", "");
INSERT INTO `wp_automatic_log` VALUES("318", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=640\">TOP các phần mềm tính xác suất lô đề chuẩn xác nhất 2021</a>", "2022-03-24 14:19:08", "");
INSERT INTO `wp_automatic_log` VALUES("323", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=642\">[Bật mí] Cách ôm lô đề hiệu quả và đơn giản nhất từ cao thủ</a>", "2022-03-24 14:21:09", "");
INSERT INTO `wp_automatic_log` VALUES("328", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=644\">Xỉu chủ là gì? &#8211; Tất cả thông tin về xỉu chủ bạn nên biết</a>", "2022-03-24 14:23:09", "");
INSERT INTO `wp_automatic_log` VALUES("336", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=647\">1 Điểm lô bao nhiêu tiền? Cách tính tiền điểm lô chi tiết</a>", "2022-03-24 14:27:27", "");
INSERT INTO `wp_automatic_log` VALUES("341", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=649\">Hướng dẫn cách bắt lô kép nuôi khung 2 ngày cực đỉnh</a>", "2022-03-24 14:29:27", "");
INSERT INTO `wp_automatic_log` VALUES("346", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=651\">Chia sẻ cách vào tiền nuôi lô 7 ngày hiệu quả chi tiết nhất</a>", "2022-03-24 14:31:28", "");
INSERT INTO `wp_automatic_log` VALUES("351", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=653\">Cách đánh lô 99 &#8211; Gợi ý lô về 99 hôm sau đánh con gì ?</a>", "2022-03-24 14:33:29", "");
INSERT INTO `wp_automatic_log` VALUES("356", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=655\">Lô gan là gì &#8211; Lô gan lâu nhất là bao nhiêu ngày?</a>", "2022-03-24 14:35:07", "");
INSERT INTO `wp_automatic_log` VALUES("361", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=658\">Bạch thủ đề là gì</a>", "2022-03-24 14:37:07", "");
INSERT INTO `wp_automatic_log` VALUES("366", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=661\">[Bật mí] Cách nuôi song thủ lô khung 5 ngày cực chuẩn xác</a>", "2022-03-24 14:39:11", "");
INSERT INTO `wp_automatic_log` VALUES("371", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=664\">Thông tin về song thủ đề và song thủ lô mới nhất 2021</a>", "2022-03-24 14:41:13", "");
INSERT INTO `wp_automatic_log` VALUES("376", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=667\">Hướng dẫn cách nuôi lô bạch thủ khung 5 ngày cực chuẩn</a>", "2022-03-24 14:43:08", "");
INSERT INTO `wp_automatic_log` VALUES("381", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=670\">Bật mí cách bắt bạch thủ lô đơn giản, hiệu quả nhất 2021</a>", "2022-03-24 14:45:11", "");
INSERT INTO `wp_automatic_log` VALUES("389", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=673\">Đề kép là gì &#8211; Cách bắt đề kép chuẩn không cần chỉnh</a>", "2022-03-24 14:49:14", "");
INSERT INTO `wp_automatic_log` VALUES("394", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=678\">Tiết lộ cách bắt cầu lô đỉnh cao từ cao thủ chi tiết nhất</a>", "2022-03-24 14:51:13", "");
INSERT INTO `wp_automatic_log` VALUES("399", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=684\">[Tiết lộ] Cách bắt đề chẵn lẻ bách phát bách trúng từ cao thủ</a>", "2022-03-24 14:53:15", "");
INSERT INTO `wp_automatic_log` VALUES("404", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=687\">Các phương pháp loại chạm đề hàng ngày chuẩn xác nhất 2021</a>", "2022-03-24 14:55:21", "");
INSERT INTO `wp_automatic_log` VALUES("409", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=692\">Cách bắt chạm đề chuẩn hàng ngày bách phát bách trúng</a>", "2022-03-24 14:57:20", "");
INSERT INTO `wp_automatic_log` VALUES("414", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=697\">Lô xiên 2 là gì? và cách tính tiền lô xiên 2 chuẩn nhất</a>", "2022-03-24 14:59:18", "");
INSERT INTO `wp_automatic_log` VALUES("419", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=700\">Lô xiên quay 5 có bao nhiêu cặp</a>", "2022-03-24 15:01:20", "");
INSERT INTO `wp_automatic_log` VALUES("424", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=702\">Lô xiên quay là gì</a>", "2022-03-24 15:03:20", "");
INSERT INTO `wp_automatic_log` VALUES("429", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=707\">Chia sẻ cách tính tiền lô xiên đơn giản và chi tiết nhất</a>", "2022-03-24 15:05:20", "");
INSERT INTO `wp_automatic_log` VALUES("434", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=712\">Bật mí cách đánh lô xiên chuẩn xác trăm trận trăm thắng</a>", "2022-03-24 15:07:00", "");
INSERT INTO `wp_automatic_log` VALUES("442", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=718\">Dàn đề là gì? Tổng hợp các dàn đề phổ biến hiện nay</a>", "2022-03-24 15:11:44", "");
INSERT INTO `wp_automatic_log` VALUES("447", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=723\">[Bật mí] Cách bắt dàn đề cực chuẩn xác cho người mới chơi</a>", "2022-03-24 15:13:41", "");
INSERT INTO `wp_automatic_log` VALUES("452", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=729\">Chia sẻ cách đánh dàn đề 64 số chuẩn không cần chỉnh</a>", "2022-03-24 15:15:41", "");
INSERT INTO `wp_automatic_log` VALUES("457", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=736\">Hướng dẫn cách tạo dàn đề 49 số chính xác nhất</a>", "2022-03-24 15:17:12", "");
INSERT INTO `wp_automatic_log` VALUES("462", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=741\">Cách chơi dàn đề 60 số bất bại đánh quanh năm</a>", "2022-03-24 15:18:43", "");
INSERT INTO `wp_automatic_log` VALUES("467", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=746\">Dàn đề 4 số miễn phí là gì? Cách soi dàn đề 4 số chuẩn nhất</a>", "2022-03-24 15:21:45", "");
INSERT INTO `wp_automatic_log` VALUES("472", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=751\">Chia sẻ cách chơi lô dàn theo ngày tỷ lệ thắng 100 cực chuẩn</a>", "2022-03-24 15:23:46", "");
INSERT INTO `wp_automatic_log` VALUES("477", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=757\">Tiết lộ cách bắt lô giải 7 chi tiết và chuẩn xác từ cao thủ</a>", "2022-03-24 15:33:52", "");
INSERT INTO `wp_automatic_log` VALUES("482", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=763\">Bật mí cách đánh đề đầu đuôi đơn giản và chuẩn xác nhất</a>", "2022-03-24 15:36:16", "");
INSERT INTO `wp_automatic_log` VALUES("487", "Posted:624", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=768\">Bật mí tất tần tật thông tin về dàn chẵn lẻ mới nhất 2021</a>", "2022-03-24 15:38:21", "");
INSERT INTO `wp_automatic_log` VALUES("1041", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=783\">Hoa hồng được GIẢI MÃ GIẤC MƠ THẤY HOA HỒNG, BẬT MÍ NHỮNG</a>", "2022-03-25 08:44:27", "");
INSERT INTO `wp_automatic_log` VALUES("1049", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=785\">TƯ VẤN NẰM MƠ THẤY KIM CƯƠNG CHO ĐIỂM BÁO VỚI NHỮNG</a>", "2022-03-25 08:48:26", "");
INSERT INTO `wp_automatic_log` VALUES("1056", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=787\">GIẢI MÃ NẰM MƠ THẤY VÀNG VÀ NHỮNG CON SỐ MANG LẠI MAY</a>", "2022-03-25 08:52:27", "");
INSERT INTO `wp_automatic_log` VALUES("1064", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=789\">MƠ THẤY TRĂNG LÀ ĐIỀM GÌ VÀ NÊN ĐÁNH CON SỐ BAO NHIÊU?</a>", "2022-03-25 08:56:29", "");
INSERT INTO `wp_automatic_log` VALUES("1072", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=791\">MƠ THẤY MẶT TRỜI VÀ ĐIỀM BÁO LÀNH HAY DỮ TRONG CUỘC</a>", "2022-03-25 09:00:29", "");
INSERT INTO `wp_automatic_log` VALUES("1080", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=793\">NẰM MƠ THẤY BẦU TRỜI ĐÁNH CON GÌ? LÝ GIẢI NHỮNG ĐIỂM</a>", "2022-03-25 09:03:37", "");
INSERT INTO `wp_automatic_log` VALUES("1088", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=796\">MƠ THẤY CÁNH ĐỒNG VÀ NHỮNG ĐIỀM BÁO BẬT MÍ CÁC CON SỐ</a>", "2022-03-25 09:05:49", "");
INSERT INTO `wp_automatic_log` VALUES("1095", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=800\">Hoa hồng được GIẢI MÃ GIẤC MƠ THẤY HOA HỒNG, BẬT MÍ NHỮNG</a>", "2022-03-25 09:08:46", "");
INSERT INTO `wp_automatic_log` VALUES("1103", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=804\">TƯ VẤN NẰM MƠ THẤY KIM CƯƠNG CHO ĐIỂM BÁO VỚI NHỮNG</a>", "2022-03-25 09:12:52", "");
INSERT INTO `wp_automatic_log` VALUES("1111", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=808\">GIẢI MÃ NẰM MƠ THẤY VÀNG VÀ NHỮNG CON SỐ MANG LẠI MAY</a>", "2022-03-25 09:17:09", "");
INSERT INTO `wp_automatic_log` VALUES("1119", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=812\">MƠ THẤY TRĂNG LÀ ĐIỀM GÌ VÀ NÊN ĐÁNH CON SỐ BAO NHIÊU?</a>", "2022-03-25 09:21:11", "");
INSERT INTO `wp_automatic_log` VALUES("1127", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=816\">MƠ THẤY MẶT TRỜI VÀ ĐIỀM BÁO LÀNH HAY DỮ TRONG CUỘC</a>", "2022-03-25 09:25:12", "");
INSERT INTO `wp_automatic_log` VALUES("1134", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=820\">NẰM MƠ THẤY BẦU TRỜI ĐÁNH CON GÌ? LÝ GIẢI NHỮNG ĐIỂM</a>", "2022-03-25 09:29:14", "");
INSERT INTO `wp_automatic_log` VALUES("1142", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=824\">NẰM MƠ THẤY BIỂN VÀ NHỮNG ĐIỀM BÁO CON SỐ MAY MẮN</a>", "2022-03-25 09:33:26", "");
INSERT INTO `wp_automatic_log` VALUES("1156", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=828\">MƠ THẤY LŨ LỤT VÀ NHỮNG LÝ GIẢI VỀ ĐIỀM BÁO VỚI CÁC CON SỐ</a>", "2022-03-25 10:36:19", "");
INSERT INTO `wp_automatic_log` VALUES("1164", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=832\">GIẤC MƠ THẤY BÒ TRONG KHI NGỦ VÀ NHỮNG ĐIỀM BÁO TỐT XẤU</a>", "2022-03-25 10:39:34", "");
INSERT INTO `wp_automatic_log` VALUES("1171", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=836\">MƠ THẤY CHÓ CÓ TỐT KHÔNG, ĐÁNH CON BAO NHIÊU THÌ TRÚNG?</a>", "2022-03-25 10:43:36", "");
INSERT INTO `wp_automatic_log` VALUES("1179", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=840\">GIẤC MƠ THẤY GÀ VÀ GIẢI MÃ SỐ HỌC KHI CHƠI LÔ ĐỀ</a>", "2022-03-25 10:47:38", "");
INSERT INTO `wp_automatic_log` VALUES("1187", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=844\">Ý NGHĨA GIẤC MƠ THẤY TRÂU VÀ NHỮNG ĐIỀM BÁO TỐT XẤU DÀNH</a>", "2022-03-25 10:51:40", "");
INSERT INTO `wp_automatic_log` VALUES("1195", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=848\">KHI MƠ THẤY RÙA BÁO HIỆU NHỮNG ĐIỀU NÀY GIÚP BẠN MAY MẮN</a>", "2022-03-25 10:58:11", "");
INSERT INTO `wp_automatic_log` VALUES("1218", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=852\">NẰM MƠ THẤY BỐ LÀ ĐIỀM BÁO GÌ? MƠ THẤY BỐ NÊN ĐÁNH</a>", "2022-03-25 11:24:21", "");
INSERT INTO `wp_automatic_log` VALUES("1401", "Posted:781", "New post posted:<a href=\"https://mami.gameh5.xyz/?p=856\">GIẤC MƠ THẤY CHÁY NHÀ VÀ ĐIỀM BÁO CHO BẠN VỀ SỐ ĐẸP</a>", "2022-03-25 13:56:50", "");
INSERT INTO `wp_automatic_log` VALUES("6313", "<strong>Cron</strong> >> Processing Campaign:624", "Cẩm nang Lô Đề{624}", "2022-04-13 21:24:12", "");
INSERT INTO `wp_automatic_log` VALUES("6314", "Process Feeds", "Processing 1 Feeds for this campaign Cẩm nang Lô Đề", "2022-04-13 21:24:12", "");
INSERT INTO `wp_automatic_log` VALUES("6315", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/f4a352ae7902baa892ade82ff014864d_624.xml\">https://mami.gameh5.xyz/wp-content/uploads/f4a352ae7902baa892ade82ff014864d_624.xml</a>", "2022-04-13 21:24:12", "");
INSERT INTO `wp_automatic_log` VALUES("6316", "<strong>Cron</strong> >> Processing Campaign:781", "Giải mã giấc mơ - https://www.kubet.space/giai-ma-giac-mo/{781}", "2022-04-13 21:25:24", "");
INSERT INTO `wp_automatic_log` VALUES("6317", "Process Feeds", "Processing 1 Feeds for this campaign Giải mã giấc mơ &#8211; https://www.kubet.space/giai-ma-giac-mo/", "2022-04-13 21:25:24", "");
INSERT INTO `wp_automatic_log` VALUES("6318", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/d3da4caceba424e207110f2b27ac1864_781.xml\">https://mami.gameh5.xyz/wp-content/uploads/d3da4caceba424e207110f2b27ac1864_781.xml</a>", "2022-04-13 21:25:24", "");
INSERT INTO `wp_automatic_log` VALUES("6319", "<strong>Cron</strong> >> Processing Campaign:624", "Cẩm nang Lô Đề{624}", "2022-04-13 21:28:15", "");
INSERT INTO `wp_automatic_log` VALUES("6320", "Process Feeds", "Processing 1 Feeds for this campaign Cẩm nang Lô Đề", "2022-04-13 21:28:15", "");
INSERT INTO `wp_automatic_log` VALUES("6321", "<strong>Cron</strong> >> Processing Campaign:781", "Giải mã giấc mơ - https://www.kubet.space/giai-ma-giac-mo/{781}", "2022-04-13 21:30:16", "");
INSERT INTO `wp_automatic_log` VALUES("6322", "Process Feeds", "Processing 1 Feeds for this campaign Giải mã giấc mơ &#8211; https://www.kubet.space/giai-ma-giac-mo/", "2022-04-13 21:30:16", "");
INSERT INTO `wp_automatic_log` VALUES("6323", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/0c105154c535bc9d27fd70c68fb0ad21_781.xml\">https://mami.gameh5.xyz/wp-content/uploads/0c105154c535bc9d27fd70c68fb0ad21_781.xml</a>", "2022-04-13 21:30:16", "");
INSERT INTO `wp_automatic_log` VALUES("6324", "<strong>Cron</strong> >> Processing Campaign:624", "Cẩm nang Lô Đề{624}", "2022-04-13 21:32:15", "");
INSERT INTO `wp_automatic_log` VALUES("6325", "Process Feeds", "Processing 1 Feeds for this campaign Cẩm nang Lô Đề", "2022-04-13 21:32:15", "");
INSERT INTO `wp_automatic_log` VALUES("6326", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/c516558eec3257345fffcf8c39936730_624.xml\">https://mami.gameh5.xyz/wp-content/uploads/c516558eec3257345fffcf8c39936730_624.xml</a>", "2022-04-13 21:32:15", "");
INSERT INTO `wp_automatic_log` VALUES("6327", "<strong>Cron</strong> >> Processing Campaign:781", "Giải mã giấc mơ - https://www.kubet.space/giai-ma-giac-mo/{781}", "2022-04-13 21:34:21", "");
INSERT INTO `wp_automatic_log` VALUES("6328", "Process Feeds", "Processing 1 Feeds for this campaign Giải mã giấc mơ &#8211; https://www.kubet.space/giai-ma-giac-mo/", "2022-04-13 21:34:21", "");
INSERT INTO `wp_automatic_log` VALUES("6329", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/d46bba61e7187b99a84604cbc10f1ef5_781.xml\">https://mami.gameh5.xyz/wp-content/uploads/d46bba61e7187b99a84604cbc10f1ef5_781.xml</a>", "2022-04-13 21:34:21", "");
INSERT INTO `wp_automatic_log` VALUES("6330", "<strong>Cron</strong> >> Processing Campaign:624", "Cẩm nang Lô Đề{624}", "2022-04-13 21:36:20", "");
INSERT INTO `wp_automatic_log` VALUES("6331", "Process Feeds", "Processing 1 Feeds for this campaign Cẩm nang Lô Đề", "2022-04-13 21:36:20", "");
INSERT INTO `wp_automatic_log` VALUES("6332", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/95853b8b4b7c9291313bfb9d8bd264ff_624.xml\">https://mami.gameh5.xyz/wp-content/uploads/95853b8b4b7c9291313bfb9d8bd264ff_624.xml</a>", "2022-04-13 21:36:20", "");
INSERT INTO `wp_automatic_log` VALUES("6333", "<strong>Cron</strong> >> Processing Campaign:781", "Giải mã giấc mơ - https://www.kubet.space/giai-ma-giac-mo/{781}", "2022-04-13 22:06:34", "");
INSERT INTO `wp_automatic_log` VALUES("6334", "Process Feeds", "Processing 1 Feeds for this campaign Giải mã giấc mơ &#8211; https://www.kubet.space/giai-ma-giac-mo/", "2022-04-13 22:06:34", "");
INSERT INTO `wp_automatic_log` VALUES("6335", "<strong>Cron</strong> >> Processing Campaign:624", "Cẩm nang Lô Đề{624}", "2022-04-13 23:09:21", "");
INSERT INTO `wp_automatic_log` VALUES("6336", "Process Feeds", "Processing 1 Feeds for this campaign Cẩm nang Lô Đề", "2022-04-13 23:09:21", "");
INSERT INTO `wp_automatic_log` VALUES("6337", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/a6c9fd705f3f17b47bc347e2ad6da29b_624.xml\">https://mami.gameh5.xyz/wp-content/uploads/a6c9fd705f3f17b47bc347e2ad6da29b_624.xml</a>", "2022-04-13 23:09:21", "");
INSERT INTO `wp_automatic_log` VALUES("6338", "<strong>Cron</strong> >> Processing Campaign:781", "Giải mã giấc mơ - https://www.kubet.space/giai-ma-giac-mo/{781}", "2022-04-13 23:11:40", "");
INSERT INTO `wp_automatic_log` VALUES("6339", "Process Feeds", "Processing 1 Feeds for this campaign Giải mã giấc mơ &#8211; https://www.kubet.space/giai-ma-giac-mo/", "2022-04-13 23:11:40", "");
INSERT INTO `wp_automatic_log` VALUES("6340", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/70d4713948ec32ee9e090b77d0282d23_781.xml\">https://mami.gameh5.xyz/wp-content/uploads/70d4713948ec32ee9e090b77d0282d23_781.xml</a>", "2022-04-13 23:11:40", "");
INSERT INTO `wp_automatic_log` VALUES("6341", "<strong>Cron</strong> >> Processing Campaign:624", "Cẩm nang Lô Đề{624}", "2022-04-13 23:13:16", "");
INSERT INTO `wp_automatic_log` VALUES("6342", "Process Feeds", "Processing 1 Feeds for this campaign Cẩm nang Lô Đề", "2022-04-13 23:13:16", "");
INSERT INTO `wp_automatic_log` VALUES("6343", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/f4a352ae7902baa892ade82ff014864d_624.xml\">https://mami.gameh5.xyz/wp-content/uploads/f4a352ae7902baa892ade82ff014864d_624.xml</a>", "2022-04-13 23:13:16", "");
INSERT INTO `wp_automatic_log` VALUES("6344", "<strong>Cron</strong> >> Processing Campaign:781", "Giải mã giấc mơ - https://www.kubet.space/giai-ma-giac-mo/{781}", "2022-04-13 23:14:18", "");
INSERT INTO `wp_automatic_log` VALUES("6345", "Process Feeds", "Processing 1 Feeds for this campaign Giải mã giấc mơ &#8211; https://www.kubet.space/giai-ma-giac-mo/", "2022-04-13 23:14:18", "");
INSERT INTO `wp_automatic_log` VALUES("6346", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/d3da4caceba424e207110f2b27ac1864_781.xml\">https://mami.gameh5.xyz/wp-content/uploads/d3da4caceba424e207110f2b27ac1864_781.xml</a>", "2022-04-13 23:14:18", "");
INSERT INTO `wp_automatic_log` VALUES("6347", "<strong>Cron</strong> >> Processing Campaign:624", "Cẩm nang Lô Đề{624}", "2022-04-13 23:15:32", "");
INSERT INTO `wp_automatic_log` VALUES("6348", "Process Feeds", "Processing 1 Feeds for this campaign Cẩm nang Lô Đề", "2022-04-13 23:15:32", "");
INSERT INTO `wp_automatic_log` VALUES("6349", "<strong>Cron</strong> >> Processing Campaign:781", "Giải mã giấc mơ - https://www.kubet.space/giai-ma-giac-mo/{781}", "2022-04-13 23:23:53", "");
INSERT INTO `wp_automatic_log` VALUES("6350", "Process Feeds", "Processing 1 Feeds for this campaign Giải mã giấc mơ &#8211; https://www.kubet.space/giai-ma-giac-mo/", "2022-04-13 23:23:53", "");
INSERT INTO `wp_automatic_log` VALUES("6351", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/0c105154c535bc9d27fd70c68fb0ad21_781.xml\">https://mami.gameh5.xyz/wp-content/uploads/0c105154c535bc9d27fd70c68fb0ad21_781.xml</a>", "2022-04-13 23:23:53", "");
INSERT INTO `wp_automatic_log` VALUES("6352", "<strong>Cron</strong> >> Processing Campaign:624", "Cẩm nang Lô Đề{624}", "2022-04-13 23:36:09", "");
INSERT INTO `wp_automatic_log` VALUES("6353", "Process Feeds", "Processing 1 Feeds for this campaign Cẩm nang Lô Đề", "2022-04-13 23:36:09", "");
INSERT INTO `wp_automatic_log` VALUES("6354", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/c516558eec3257345fffcf8c39936730_624.xml\">https://mami.gameh5.xyz/wp-content/uploads/c516558eec3257345fffcf8c39936730_624.xml</a>", "2022-04-13 23:36:09", "");
INSERT INTO `wp_automatic_log` VALUES("6355", "<strong>Cron</strong> >> Processing Campaign:781", "Giải mã giấc mơ - https://www.kubet.space/giai-ma-giac-mo/{781}", "2022-04-13 23:37:10", "");
INSERT INTO `wp_automatic_log` VALUES("6356", "Process Feeds", "Processing 1 Feeds for this campaign Giải mã giấc mơ &#8211; https://www.kubet.space/giai-ma-giac-mo/", "2022-04-13 23:37:10", "");
INSERT INTO `wp_automatic_log` VALUES("6357", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/d46bba61e7187b99a84604cbc10f1ef5_781.xml\">https://mami.gameh5.xyz/wp-content/uploads/d46bba61e7187b99a84604cbc10f1ef5_781.xml</a>", "2022-04-13 23:37:10", "");
INSERT INTO `wp_automatic_log` VALUES("6358", "<strong>Cron</strong> >> Processing Campaign:624", "Cẩm nang Lô Đề{624}", "2022-04-13 23:39:29", "");
INSERT INTO `wp_automatic_log` VALUES("6359", "Process Feeds", "Processing 1 Feeds for this campaign Cẩm nang Lô Đề", "2022-04-13 23:39:29", "");
INSERT INTO `wp_automatic_log` VALUES("6360", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/95853b8b4b7c9291313bfb9d8bd264ff_624.xml\">https://mami.gameh5.xyz/wp-content/uploads/95853b8b4b7c9291313bfb9d8bd264ff_624.xml</a>", "2022-04-13 23:39:29", "");
INSERT INTO `wp_automatic_log` VALUES("6361", "<strong>Cron</strong> >> Processing Campaign:781", "Giải mã giấc mơ - https://www.kubet.space/giai-ma-giac-mo/{781}", "2022-04-13 23:57:35", "");
INSERT INTO `wp_automatic_log` VALUES("6362", "Process Feeds", "Processing 1 Feeds for this campaign Giải mã giấc mơ &#8211; https://www.kubet.space/giai-ma-giac-mo/", "2022-04-13 23:57:35", "");
INSERT INTO `wp_automatic_log` VALUES("6363", "<strong>Cron</strong> >> Processing Campaign:624", "Cẩm nang Lô Đề{624}", "2022-04-14 01:02:07", "");
INSERT INTO `wp_automatic_log` VALUES("6364", "Process Feeds", "Processing 1 Feeds for this campaign Cẩm nang Lô Đề", "2022-04-14 01:02:07", "");
INSERT INTO `wp_automatic_log` VALUES("6365", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/a6c9fd705f3f17b47bc347e2ad6da29b_624.xml\">https://mami.gameh5.xyz/wp-content/uploads/a6c9fd705f3f17b47bc347e2ad6da29b_624.xml</a>", "2022-04-14 01:02:07", "");
INSERT INTO `wp_automatic_log` VALUES("6366", "<strong>Cron</strong> >> Processing Campaign:781", "Giải mã giấc mơ - https://www.kubet.space/giai-ma-giac-mo/{781}", "2022-04-14 01:10:01", "");
INSERT INTO `wp_automatic_log` VALUES("6367", "Process Feeds", "Processing 1 Feeds for this campaign Giải mã giấc mơ &#8211; https://www.kubet.space/giai-ma-giac-mo/", "2022-04-14 01:10:01", "");
INSERT INTO `wp_automatic_log` VALUES("6368", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/70d4713948ec32ee9e090b77d0282d23_781.xml\">https://mami.gameh5.xyz/wp-content/uploads/70d4713948ec32ee9e090b77d0282d23_781.xml</a>", "2022-04-14 01:10:01", "");
INSERT INTO `wp_automatic_log` VALUES("6369", "<strong>Cron</strong> >> Processing Campaign:624", "Cẩm nang Lô Đề{624}", "2022-04-14 01:31:40", "");
INSERT INTO `wp_automatic_log` VALUES("6370", "Process Feeds", "Processing 1 Feeds for this campaign Cẩm nang Lô Đề", "2022-04-14 01:31:40", "");
INSERT INTO `wp_automatic_log` VALUES("6371", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/f4a352ae7902baa892ade82ff014864d_624.xml\">https://mami.gameh5.xyz/wp-content/uploads/f4a352ae7902baa892ade82ff014864d_624.xml</a>", "2022-04-14 01:31:40", "");
INSERT INTO `wp_automatic_log` VALUES("6372", "<strong>Cron</strong> >> Processing Campaign:781", "Giải mã giấc mơ - https://www.kubet.space/giai-ma-giac-mo/{781}", "2022-04-14 01:54:43", "");
INSERT INTO `wp_automatic_log` VALUES("6373", "Process Feeds", "Processing 1 Feeds for this campaign Giải mã giấc mơ &#8211; https://www.kubet.space/giai-ma-giac-mo/", "2022-04-14 01:54:43", "");
INSERT INTO `wp_automatic_log` VALUES("6374", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/d3da4caceba424e207110f2b27ac1864_781.xml\">https://mami.gameh5.xyz/wp-content/uploads/d3da4caceba424e207110f2b27ac1864_781.xml</a>", "2022-04-14 01:54:43", "");
INSERT INTO `wp_automatic_log` VALUES("6375", "<strong>Cron</strong> >> Processing Campaign:624", "Cẩm nang Lô Đề{624}", "2022-04-14 02:50:27", "");
INSERT INTO `wp_automatic_log` VALUES("6376", "Process Feeds", "Processing 1 Feeds for this campaign Cẩm nang Lô Đề", "2022-04-14 02:50:27", "");
INSERT INTO `wp_automatic_log` VALUES("6377", "<strong>Cron</strong> >> Processing Campaign:781", "Giải mã giấc mơ - https://www.kubet.space/giai-ma-giac-mo/{781}", "2022-04-14 02:56:58", "");
INSERT INTO `wp_automatic_log` VALUES("6378", "Process Feeds", "Processing 1 Feeds for this campaign Giải mã giấc mơ &#8211; https://www.kubet.space/giai-ma-giac-mo/", "2022-04-14 02:56:58", "");
INSERT INTO `wp_automatic_log` VALUES("6379", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/0c105154c535bc9d27fd70c68fb0ad21_781.xml\">https://mami.gameh5.xyz/wp-content/uploads/0c105154c535bc9d27fd70c68fb0ad21_781.xml</a>", "2022-04-14 02:56:58", "");
INSERT INTO `wp_automatic_log` VALUES("6380", "<strong>Cron</strong> >> Processing Campaign:624", "Cẩm nang Lô Đề{624}", "2022-04-14 02:58:43", "");
INSERT INTO `wp_automatic_log` VALUES("6381", "Process Feeds", "Processing 1 Feeds for this campaign Cẩm nang Lô Đề", "2022-04-14 02:58:43", "");
INSERT INTO `wp_automatic_log` VALUES("6382", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/c516558eec3257345fffcf8c39936730_624.xml\">https://mami.gameh5.xyz/wp-content/uploads/c516558eec3257345fffcf8c39936730_624.xml</a>", "2022-04-14 02:58:43", "");
INSERT INTO `wp_automatic_log` VALUES("6383", "<strong>Cron</strong> >> Processing Campaign:781", "Giải mã giấc mơ - https://www.kubet.space/giai-ma-giac-mo/{781}", "2022-04-14 03:44:15", "");
INSERT INTO `wp_automatic_log` VALUES("6384", "Process Feeds", "Processing 1 Feeds for this campaign Giải mã giấc mơ &#8211; https://www.kubet.space/giai-ma-giac-mo/", "2022-04-14 03:44:15", "");
INSERT INTO `wp_automatic_log` VALUES("6385", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/d46bba61e7187b99a84604cbc10f1ef5_781.xml\">https://mami.gameh5.xyz/wp-content/uploads/d46bba61e7187b99a84604cbc10f1ef5_781.xml</a>", "2022-04-14 03:44:15", "");
INSERT INTO `wp_automatic_log` VALUES("6386", "<strong>Cron</strong> >> Processing Campaign:624", "Cẩm nang Lô Đề{624}", "2022-04-14 04:24:03", "");
INSERT INTO `wp_automatic_log` VALUES("6387", "Process Feeds", "Processing 1 Feeds for this campaign Cẩm nang Lô Đề", "2022-04-14 04:24:03", "");
INSERT INTO `wp_automatic_log` VALUES("6388", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/95853b8b4b7c9291313bfb9d8bd264ff_624.xml\">https://mami.gameh5.xyz/wp-content/uploads/95853b8b4b7c9291313bfb9d8bd264ff_624.xml</a>", "2022-04-14 04:24:03", "");
INSERT INTO `wp_automatic_log` VALUES("6389", "<strong>Cron</strong> >> Processing Campaign:781", "Giải mã giấc mơ - https://www.kubet.space/giai-ma-giac-mo/{781}", "2022-04-14 04:59:59", "");
INSERT INTO `wp_automatic_log` VALUES("6390", "Process Feeds", "Processing 1 Feeds for this campaign Giải mã giấc mơ &#8211; https://www.kubet.space/giai-ma-giac-mo/", "2022-04-14 04:59:59", "");
INSERT INTO `wp_automatic_log` VALUES("6391", "<strong>Cron</strong> >> Processing Campaign:624", "Cẩm nang Lô Đề{624}", "2022-04-14 05:44:17", "");
INSERT INTO `wp_automatic_log` VALUES("6392", "Process Feeds", "Processing 1 Feeds for this campaign Cẩm nang Lô Đề", "2022-04-14 05:44:17", "");
INSERT INTO `wp_automatic_log` VALUES("6393", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/a6c9fd705f3f17b47bc347e2ad6da29b_624.xml\">https://mami.gameh5.xyz/wp-content/uploads/a6c9fd705f3f17b47bc347e2ad6da29b_624.xml</a>", "2022-04-14 05:44:17", "");
INSERT INTO `wp_automatic_log` VALUES("6394", "<strong>Cron</strong> >> Processing Campaign:781", "Giải mã giấc mơ - https://www.kubet.space/giai-ma-giac-mo/{781}", "2022-04-14 06:12:24", "");
INSERT INTO `wp_automatic_log` VALUES("6395", "Process Feeds", "Processing 1 Feeds for this campaign Giải mã giấc mơ &#8211; https://www.kubet.space/giai-ma-giac-mo/", "2022-04-14 06:12:24", "");
INSERT INTO `wp_automatic_log` VALUES("6396", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/70d4713948ec32ee9e090b77d0282d23_781.xml\">https://mami.gameh5.xyz/wp-content/uploads/70d4713948ec32ee9e090b77d0282d23_781.xml</a>", "2022-04-14 06:12:24", "");
INSERT INTO `wp_automatic_log` VALUES("6397", "<strong>Cron</strong> >> Processing Campaign:624", "Cẩm nang Lô Đề{624}", "2022-04-14 06:17:18", "");
INSERT INTO `wp_automatic_log` VALUES("6398", "Process Feeds", "Processing 1 Feeds for this campaign Cẩm nang Lô Đề", "2022-04-14 06:17:18", "");
INSERT INTO `wp_automatic_log` VALUES("6399", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/f4a352ae7902baa892ade82ff014864d_624.xml\">https://mami.gameh5.xyz/wp-content/uploads/f4a352ae7902baa892ade82ff014864d_624.xml</a>", "2022-04-14 06:17:18", "");
INSERT INTO `wp_automatic_log` VALUES("6400", "<strong>Cron</strong> >> Processing Campaign:781", "Giải mã giấc mơ - https://www.kubet.space/giai-ma-giac-mo/{781}", "2022-04-14 06:18:47", "");
INSERT INTO `wp_automatic_log` VALUES("6401", "Process Feeds", "Processing 1 Feeds for this campaign Giải mã giấc mơ &#8211; https://www.kubet.space/giai-ma-giac-mo/", "2022-04-14 06:18:47", "");
INSERT INTO `wp_automatic_log` VALUES("6402", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/d3da4caceba424e207110f2b27ac1864_781.xml\">https://mami.gameh5.xyz/wp-content/uploads/d3da4caceba424e207110f2b27ac1864_781.xml</a>", "2022-04-14 06:18:47", "");
INSERT INTO `wp_automatic_log` VALUES("6403", "<strong>Cron</strong> >> Processing Campaign:624", "Cẩm nang Lô Đề{624}", "2022-04-14 06:34:37", "");
INSERT INTO `wp_automatic_log` VALUES("6404", "Process Feeds", "Processing 1 Feeds for this campaign Cẩm nang Lô Đề", "2022-04-14 06:34:37", "");
INSERT INTO `wp_automatic_log` VALUES("6405", "<strong>Cron</strong> >> Processing Campaign:781", "Giải mã giấc mơ - https://www.kubet.space/giai-ma-giac-mo/{781}", "2022-04-14 06:35:39", "");
INSERT INTO `wp_automatic_log` VALUES("6406", "Process Feeds", "Processing 1 Feeds for this campaign Giải mã giấc mơ &#8211; https://www.kubet.space/giai-ma-giac-mo/", "2022-04-14 06:35:39", "");
INSERT INTO `wp_automatic_log` VALUES("6407", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/0c105154c535bc9d27fd70c68fb0ad21_781.xml\">https://mami.gameh5.xyz/wp-content/uploads/0c105154c535bc9d27fd70c68fb0ad21_781.xml</a>", "2022-04-14 06:35:39", "");
INSERT INTO `wp_automatic_log` VALUES("6408", "<strong>Cron</strong> >> Processing Campaign:624", "Cẩm nang Lô Đề{624}", "2022-04-14 12:21:14", "");
INSERT INTO `wp_automatic_log` VALUES("6409", "Process Feeds", "Processing 1 Feeds for this campaign Cẩm nang Lô Đề", "2022-04-14 12:21:14", "");
INSERT INTO `wp_automatic_log` VALUES("6410", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/c516558eec3257345fffcf8c39936730_624.xml\">https://mami.gameh5.xyz/wp-content/uploads/c516558eec3257345fffcf8c39936730_624.xml</a>", "2022-04-14 12:21:14", "");
INSERT INTO `wp_automatic_log` VALUES("6411", "<strong>Cron</strong> >> Processing Campaign:781", "Giải mã giấc mơ - https://www.kubet.space/giai-ma-giac-mo/{781}", "2022-04-14 12:22:22", "");
INSERT INTO `wp_automatic_log` VALUES("6412", "Process Feeds", "Processing 1 Feeds for this campaign Giải mã giấc mơ &#8211; https://www.kubet.space/giai-ma-giac-mo/", "2022-04-14 12:22:22", "");
INSERT INTO `wp_automatic_log` VALUES("6413", "Process Feed", "<a href=\"https://mami.gameh5.xyz/wp-content/uploads/d46bba61e7187b99a84604cbc10f1ef5_781.xml\">https://mami.gameh5.xyz/wp-content/uploads/d46bba61e7187b99a84604cbc10f1ef5_781.xml</a>", "2022-04-14 12:22:22", "");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("62", "2497", "Hướng dẫn cách đăng ký 123B và cách quản lý tài khoản 123B", "", "https://mami.gameh5.xyz/dang-ky-123b/", "172.71.218.217", "2023-02-27 09:01:27", "2023-02-27 02:01:27", "[&#8230;] thao tác quản lý tài khoản 123B: Người dùng có thể thực hiện các thao tác như nạp tiền 123b, rút tiền, chuyển khoản, đặt cược và theo dõi các trò chơi mà mình đã tham [&#8230;]", "0", "0", "The Incutio XML-RPC PHP Library -- WordPress/6.1.1", "pingback", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20230318_123b", "1ab0596fcea4bf2c1522_20230318082400", "22", "2023-03-18 08:24:07", "admin123b", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-03-18 08:24:00\";s:7:\"Version\";s:5:\"1.5.3\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:7:\"10.3.38\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:13:\"20230318_123b\";s:4:\"Hash\";s:35:\"1ab0596fcea4bf2c1522_20230318082400\";s:8:\"NameHash\";s:49:\"20230318_123b_1ab0596fcea4bf2c1522_20230318082400\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:59:\"20230318_123b_1ab0596fcea4bf2c1522_20230318082400_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"22.3\";s:6:\"WPUser\";s:9:\"admin123b\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:61:\"20230318_123b_1ab0596fcea4bf2c1522_20230318082400_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:30:\"/home/ysscptnb/mami.gameh5.xyz\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1793;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11676;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-03-18 08:24:00\";s:7:\"Version\";s:5:\"1.5.3\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:7:\"10.3.38\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:13:\"20230318_123b\";s:4:\"Hash\";s:35:\"1ab0596fcea4bf2c1522_20230318082400\";s:8:\"NameHash\";s:49:\"20230318_123b_1ab0596fcea4bf2c1522_20230318082400\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:67:\"20230318_123b_1ab0596fcea4bf2c1522_20230318082400_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:44:\"/home/ysscptnb/mami.gameh5.xyz/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:62:\"20230318_123b_1ab0596fcea4bf2c1522_20230318082400_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:18:\"varLowerCaseTables\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:125:\"/home/ysscptnb/mami.gameh5.xyz/wp-content/backups-dup-lite/tmp/20230318_123b_1ab0596fcea4bf2c1522_20230318082400_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:39:\"/home/ysscptnb/mami.gameh5.xyz/wp-admin\";i:1;s:42:\"/home/ysscptnb/mami.gameh5.xyz/wp-includes\";i:2;s:51:\"/home/ysscptnb/mami.gameh5.xyz/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:30:\"/home/ysscptnb/mami.gameh5.xyz\";i:1;s:30:\"/home/ysscptnb/mami.gameh5.xyz\";i:2;s:41:\"/home/ysscptnb/mami.gameh5.xyz/wp-content\";i:3;s:49:\"/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads\";i:4;s:49:\"/home/ysscptnb/mami.gameh5.xyz/wp-content/plugins\";i:5;s:52:\"/home/ysscptnb/mami.gameh5.xyz/wp-content/mu-plugins\";i:6;s:48:\"/home/ysscptnb/mami.gameh5.xyz/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:62:\"/home/ysscptnb/mami.gameh5.xyz/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_index_now_log */
INSERT INTO `wp_index_now_log` VALUES("1", "2023-03-01 10:13:22", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/xo-so-123b/\" target=\"_blank\">https://mami.gameh5.xyz/xo-so-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("2", "2023-03-01 10:13:23", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/xo-so-123b/\" target=\"_blank\">Chơi xổ số 123B trực tuyến &#8211; Thử vận may của bạn ngay hôm nay!</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("3", "2023-03-01 10:13:24", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/xo-so-123b/\" target=\"_blank\">Chơi xổ số 123B trực tuyến &#8211; Thử vận may của bạn ngay hôm nay!</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("4", "2023-03-01 10:22:36", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/xo-so-123b/\" target=\"_blank\">https://mami.gameh5.xyz/xo-so-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("5", "2023-03-01 10:22:37", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/xo-so-123b/\" target=\"_blank\">Chơi xổ số 123B trực tuyến &#8211; Thử vận may của bạn ngay hôm nay!</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("6", "2023-03-01 10:22:38", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/xo-so-123b/\" target=\"_blank\">Chơi xổ số 123B trực tuyến &#8211; Thử vận may của bạn ngay hôm nay!</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("7", "2023-03-01 10:23:07", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/xo-so-123b/\" target=\"_blank\">https://mami.gameh5.xyz/xo-so-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("8", "2023-03-01 10:23:08", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/xo-so-123b/\" target=\"_blank\">Chơi xổ số 123B trực tuyến &#8211; Thử vận may của bạn ngay hôm nay!</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("9", "2023-03-01 10:23:09", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/xo-so-123b/\" target=\"_blank\">Chơi xổ số 123B trực tuyến &#8211; Thử vận may của bạn ngay hôm nay!</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("10", "2023-03-01 10:52:27", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/\" target=\"_blank\">https://mami.gameh5.xyz/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("11", "2023-03-01 10:52:27", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/\" target=\"_blank\">123b &#x26a1;&#xfe0f; Link đăng nhập chính thức nhà cái 123b Casino</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("12", "2023-03-01 10:52:29", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/\" target=\"_blank\">123b &#x26a1;&#xfe0f; Link đăng nhập chính thức nhà cái 123b Casino</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("13", "2023-03-01 11:06:54", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/rut-tien-123b/\" target=\"_blank\">https://mami.gameh5.xyz/rut-tien-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("14", "2023-03-01 11:06:54", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/rut-tien-123b/\" target=\"_blank\">Hướng dẫn cách rút tiền 123b nhanh chóng và chi tiết nhất</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("15", "2023-03-01 11:06:55", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/rut-tien-123b/\" target=\"_blank\">Hướng dẫn cách rút tiền 123b nhanh chóng và chi tiết nhất</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("16", "2023-03-01 11:07:25", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/tai-app-123b/\" target=\"_blank\">https://mami.gameh5.xyz/tai-app-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("17", "2023-03-01 11:07:26", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/tai-app-123b/\" target=\"_blank\">Hướng dẫn cách tải App 123b cho Mobile và PC chi tiết nhất</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("18", "2023-03-01 11:07:27", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/tai-app-123b/\" target=\"_blank\">Hướng dẫn cách tải App 123b cho Mobile và PC chi tiết nhất</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("19", "2023-03-01 11:07:29", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/dang-ky-123b/\" target=\"_blank\">https://mami.gameh5.xyz/dang-ky-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("20", "2023-03-01 11:07:29", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/dang-ky-123b/\" target=\"_blank\">Hướng dẫn cách đăng ký 123B và cách quản lý tài khoản 123B</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("21", "2023-03-01 11:07:31", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/dang-ky-123b/\" target=\"_blank\">Hướng dẫn cách đăng ký 123B và cách quản lý tài khoản 123B</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("22", "2023-03-01 11:07:31", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/dang-nhap-123b/\" target=\"_blank\">https://mami.gameh5.xyz/dang-nhap-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("23", "2023-03-01 11:07:32", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/dang-nhap-123b/\" target=\"_blank\">Hướng dẫn các bước đăng nhập 123b trên Mobile và PC chi tiết</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("24", "2023-03-01 11:07:33", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/dang-nhap-123b/\" target=\"_blank\">Hướng dẫn các bước đăng nhập 123b trên Mobile và PC chi tiết</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("25", "2023-03-01 11:07:38", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/nap-tien-123b/\" target=\"_blank\">https://mami.gameh5.xyz/nap-tien-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("26", "2023-03-01 11:07:39", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/nap-tien-123b/\" target=\"_blank\">Hướng dẫn cách nạp tiền 123b và các lưu ý khi nạp tiền 123B</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("27", "2023-03-01 11:07:41", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/nap-tien-123b/\" target=\"_blank\">Hướng dẫn cách nạp tiền 123b và các lưu ý khi nạp tiền 123B</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("28", "2023-03-01 11:07:49", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/rut-tien-123b/\" target=\"_blank\">https://mami.gameh5.xyz/rut-tien-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("29", "2023-03-01 11:07:49", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/rut-tien-123b/\" target=\"_blank\">Hướng dẫn cách rút tiền 123b nhanh chóng và chi tiết nhất</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("30", "2023-03-01 11:07:51", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/rut-tien-123b/\" target=\"_blank\">Hướng dẫn cách rút tiền 123b nhanh chóng và chi tiết nhất</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("31", "2023-03-01 11:09:00", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/tai-app-123b/\" target=\"_blank\">https://mami.gameh5.xyz/tai-app-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("32", "2023-03-01 11:09:01", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/tai-app-123b/\" target=\"_blank\">Hướng dẫn cách tải App 123b cho Mobile và PC chi tiết nhất</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("33", "2023-03-01 11:09:02", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/tai-app-123b/\" target=\"_blank\">Hướng dẫn cách tải App 123b cho Mobile và PC chi tiết nhất</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("34", "2023-03-01 11:09:35", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/dang-ky-123b/\" target=\"_blank\">https://mami.gameh5.xyz/dang-ky-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("35", "2023-03-01 11:09:35", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/dang-ky-123b/\" target=\"_blank\">Hướng dẫn cách đăng ký 123B và cách quản lý tài khoản 123B</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("36", "2023-03-01 11:09:37", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/dang-ky-123b/\" target=\"_blank\">Hướng dẫn cách đăng ký 123B và cách quản lý tài khoản 123B</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("37", "2023-03-01 11:10:01", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/dang-nhap-123b/\" target=\"_blank\">https://mami.gameh5.xyz/dang-nhap-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("38", "2023-03-01 11:10:02", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/dang-nhap-123b/\" target=\"_blank\">Hướng dẫn các bước đăng nhập 123b trên Mobile và PC chi tiết</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("39", "2023-03-01 11:10:03", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/dang-nhap-123b/\" target=\"_blank\">Hướng dẫn các bước đăng nhập 123b trên Mobile và PC chi tiết</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("40", "2023-03-01 11:11:00", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/nap-tien-123b/\" target=\"_blank\">https://mami.gameh5.xyz/nap-tien-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("41", "2023-03-01 11:11:01", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/nap-tien-123b/\" target=\"_blank\">Hướng dẫn cách nạp tiền 123b và các lưu ý khi nạp tiền 123B</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("42", "2023-03-01 11:11:02", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/nap-tien-123b/\" target=\"_blank\">Hướng dẫn cách nạp tiền 123b và các lưu ý khi nạp tiền 123B</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("43", "2023-03-01 11:11:29", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/rut-tien-123b/\" target=\"_blank\">https://mami.gameh5.xyz/rut-tien-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("44", "2023-03-01 11:11:30", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/rut-tien-123b/\" target=\"_blank\">Hướng dẫn cách rút tiền 123b nhanh chóng và chi tiết nhất</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("45", "2023-03-01 11:11:31", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/rut-tien-123b/\" target=\"_blank\">Hướng dẫn cách rút tiền 123b nhanh chóng và chi tiết nhất</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("46", "2023-03-02 05:12:23", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/lien-he/\" target=\"_blank\">https://mami.gameh5.xyz/lien-he/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("47", "2023-03-02 05:12:24", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/lien-he/\" target=\"_blank\">Liên hệ với nhà cái 123b để trải nghiệm cá cược tốt nhất</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("48", "2023-03-02 05:12:25", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/lien-he/\" target=\"_blank\">Liên hệ với nhà cái 123b để trải nghiệm cá cược tốt nhất</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("49", "2023-03-02 08:00:36", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/casino-123b/\" target=\"_blank\">https://mami.gameh5.xyz/casino-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("50", "2023-03-02 08:00:37", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/casino-123b/\" target=\"_blank\">Tham gia game casino 123b tuyệt vời tại casino 123b online</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("51", "2023-03-02 08:00:38", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/casino-123b/\" target=\"_blank\">Tham gia game casino 123b tuyệt vời tại casino 123b online</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("52", "2023-03-02 09:59:13", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/the-thao-123b/\" target=\"_blank\">https://mami.gameh5.xyz/the-thao-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("53", "2023-03-02 09:59:13", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/the-thao-123b/\" target=\"_blank\">Khám phá các môn thể thao 123b online hấp dẫn và đa dạng</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("54", "2023-03-02 09:59:15", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/the-thao-123b/\" target=\"_blank\">Khám phá các môn thể thao 123b online hấp dẫn và đa dạng</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("55", "2023-03-03 07:18:23", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/\" target=\"_blank\">https://mami.gameh5.xyz/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("56", "2023-03-03 07:18:53", "error", "bing-webmaster", "outgoing", "0", "");
INSERT INTO `wp_index_now_log` VALUES("57", "2023-03-03 07:18:55", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/\" target=\"_blank\">123b &#x26a1;&#xfe0f; Link đăng nhập chính thức nhà cái 123b Casino</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("58", "2023-03-03 07:18:58", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/\" target=\"_blank\">https://mami.gameh5.xyz/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("59", "2023-03-03 07:19:15", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/\" target=\"_blank\">123b &#x26a1;&#xfe0f; Link đăng nhập chính thức nhà cái 123b Casino</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("60", "2023-03-03 07:19:16", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/\" target=\"_blank\">123b &#x26a1;&#xfe0f; Link đăng nhập chính thức nhà cái 123b Casino</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("61", "2023-03-05 13:24:31", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/game-bai-123b/\" target=\"_blank\">https://mami.gameh5.xyz/game-bai-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("62", "2023-03-05 13:24:32", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/game-bai-123b/\" target=\"_blank\">Game bài 123B &#8211; Thế giới đánh bài online đa dạng và hấp dẫn</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("63", "2023-03-05 13:24:34", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/game-bai-123b/\" target=\"_blank\">Game bài 123B &#8211; Thế giới đánh bài online đa dạng và hấp dẫn</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("64", "2023-03-05 13:36:19", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/game-bai-123b/\" target=\"_blank\">https://mami.gameh5.xyz/game-bai-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("65", "2023-03-05 13:36:19", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/game-bai-123b/\" target=\"_blank\">Game bài 123B &#8211; Thế giới đánh bài online đa dạng và hấp dẫn</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("66", "2023-03-05 13:36:21", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/game-bai-123b/\" target=\"_blank\">Game bài 123B &#8211; Thế giới đánh bài online đa dạng và hấp dẫn</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("67", "2023-03-05 14:09:36", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/xo-so-mien-trung-123b/\" target=\"_blank\">https://mami.gameh5.xyz/xo-so-mien-trung-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("68", "2023-03-05 14:09:37", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/xo-so-mien-trung-123b/\" target=\"_blank\">Xổ số Miền Trung 123B &#8211; Cơ hội trúng giải lên đến 99.5%</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("69", "2023-03-05 14:09:38", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/xo-so-mien-trung-123b/\" target=\"_blank\">Xổ số Miền Trung 123B &#8211; Cơ hội trúng giải lên đến 99.5%</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("70", "2023-03-10 02:53:44", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/nhan-qua-sinh-nhat-123b/\" target=\"_blank\">https://mami.gameh5.xyz/nhan-qua-sinh-nhat-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("71", "2023-03-10 02:53:46", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/nhan-qua-sinh-nhat-123b/\" target=\"_blank\">Nhận quà sinh nhật 123b &#8211; Đón nhận niềm vui đầy bất ngờ</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("72", "2023-03-10 02:53:47", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/nhan-qua-sinh-nhat-123b/\" target=\"_blank\">Nhận quà sinh nhật 123b &#8211; Đón nhận niềm vui đầy bất ngờ</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("73", "2023-03-10 03:19:23", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/ban-ca-123b/\" target=\"_blank\">https://mami.gameh5.xyz/ban-ca-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("74", "2023-03-10 03:19:24", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/ban-ca-123b/\" target=\"_blank\">Chơi bắn cá 123B &#8211; Giải trí đỉnh cao, thưởng cực hấp dẫn</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("75", "2023-03-10 03:19:25", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/ban-ca-123b/\" target=\"_blank\">Chơi bắn cá 123B &#8211; Giải trí đỉnh cao, thưởng cực hấp dẫn</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("76", "2023-03-10 03:21:48", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/xo-so-mien-bac-123b/\" target=\"_blank\">https://mami.gameh5.xyz/xo-so-mien-bac-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("77", "2023-03-10 03:21:48", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/xo-so-mien-bac-123b/\" target=\"_blank\">Xổ số miền Bắc 123B &#8211; Tỷ lệ 1 ăn 99.9 thắng lớn dễ dàng.</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("78", "2023-03-10 03:21:50", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/xo-so-mien-bac-123b/\" target=\"_blank\">Xổ số miền Bắc 123B &#8211; Tỷ lệ 1 ăn 99.9 thắng lớn dễ dàng.</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("79", "2023-03-10 07:28:31", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/\" target=\"_blank\">https://mami.gameh5.xyz/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("80", "2023-03-10 07:28:32", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/\" target=\"_blank\">123b &#x26a1;&#xfe0f; Link đăng nhập chính thức nhà cái 123b Casino</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("81", "2023-03-10 07:28:33", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/\" target=\"_blank\">123b &#x26a1;&#xfe0f; Link đăng nhập chính thức nhà cái 123b Casino</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("82", "2023-03-10 07:50:18", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/khuyen-mai-hoan-tien-cuoc-123b/\" target=\"_blank\">https://mami.gameh5.xyz/khuyen-mai-hoan-tien-cuoc-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("83", "2023-03-10 07:50:19", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/khuyen-mai-hoan-tien-cuoc-123b/\" target=\"_blank\">Khám phá chương trình khuyến mãi hoàn tiền cược 123b cực hot</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("84", "2023-03-10 07:50:20", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/khuyen-mai-hoan-tien-cuoc-123b/\" target=\"_blank\">Khám phá chương trình khuyến mãi hoàn tiền cược 123b cực hot</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("85", "2023-03-10 07:51:10", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/khuyen-mai-hoan-tien-cuoc-123b/\" target=\"_blank\">https://mami.gameh5.xyz/khuyen-mai-hoan-tien-cuoc-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("86", "2023-03-10 07:51:11", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/khuyen-mai-hoan-tien-cuoc-123b/\" target=\"_blank\">Khám phá chương trình khuyến mãi hoàn tiền cược 123b cực hot</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("87", "2023-03-10 07:51:12", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/khuyen-mai-hoan-tien-cuoc-123b/\" target=\"_blank\">Khám phá chương trình khuyến mãi hoàn tiền cược 123b cực hot</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("88", "2023-03-10 07:57:24", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/khuyen-mai-hoan-tien-cuoc-123b/\" target=\"_blank\">https://mami.gameh5.xyz/khuyen-mai-hoan-tien-cuoc-123b/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("89", "2023-03-10 07:57:25", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/khuyen-mai-hoan-tien-cuoc-123b/\" target=\"_blank\">Khám phá chương trình khuyến mãi hoàn tiền cược 123b cực hot</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("90", "2023-03-10 07:57:26", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/khuyen-mai-hoan-tien-cuoc-123b/\" target=\"_blank\">Khám phá chương trình khuyến mãi hoàn tiền cược 123b cực hot</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("91", "2023-03-10 08:11:11", "info", "yandex-index-now", "outgoing", "202", "<a href=\"https://mami.gameh5.xyz/\" target=\"_blank\">https://mami.gameh5.xyz/</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("92", "2023-03-10 08:11:12", "info", "bing-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/\" target=\"_blank\">123b &#x26a1;&#xfe0f; Link đăng nhập chính thức nhà cái 123b Casino</a> - OK");
INSERT INTO `wp_index_now_log` VALUES("93", "2023-03-10 08:11:13", "info", "google-webmaster", "outgoing", "200", "<a href=\"https://mami.gameh5.xyz/\" target=\"_blank\">123b &#x26a1;&#xfe0f; Link đăng nhập chính thức nhà cái 123b Casino</a> - OK");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://mami.gameh5.xyz/", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://mami.gameh5.xyz", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "123B", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "Nhà cái 123b", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "Cskhhi88@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "12", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "1", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "12", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "1", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:167:{s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:25:\"index.php?xsl=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:16:\"featured_item/?$\";s:33:\"index.php?post_type=featured_item\";s:46:\"featured_item/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_type=featured_item&feed=$matches[1]\";s:41:\"featured_item/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_type=featured_item&feed=$matches[1]\";s:33:\"featured_item/page/([0-9]{1,})/?$\";s:51:\"index.php?post_type=featured_item&paged=$matches[1]\";s:32:\"category/(.+?)/schema-preview/?$\";s:57:\"index.php?category=$matches[1]&schema-preview=$matches[3]\";s:27:\"tag/(.+?)/schema-preview/?$\";s:57:\"index.php?post_tag=$matches[1]&schema-preview=$matches[3]\";s:28:\"type/(.+?)/schema-preview/?$\";s:60:\"index.php?post_format=$matches[1]&schema-preview=$matches[3]\";s:46:\"featured_item_category/(.+?)/schema-preview/?$\";s:71:\"index.php?featured_item_category=$matches[1]&schema-preview=$matches[3]\";s:41:\"featured_item_tag/(.+?)/schema-preview/?$\";s:66:\"index.php?featured_item_tag=$matches[1]&schema-preview=$matches[3]\";s:32:\"blocks/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"blocks/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"blocks/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"blocks/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"blocks/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"blocks/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"blocks/(.+?)/embed/?$\";s:39:\"index.php?blocks=$matches[1]&embed=true\";s:25:\"blocks/(.+?)/trackback/?$\";s:33:\"index.php?blocks=$matches[1]&tb=1\";s:33:\"blocks/(.+?)/page/?([0-9]{1,})/?$\";s:46:\"index.php?blocks=$matches[1]&paged=$matches[2]\";s:40:\"blocks/(.+?)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?blocks=$matches[1]&cpage=$matches[2]\";s:38:\"blocks/(.+?)/schema-preview(/(.*))?/?$\";s:55:\"index.php?blocks=$matches[1]&schema-preview=$matches[3]\";s:29:\"blocks/(.+?)(?:/([0-9]+))?/?$\";s:45:\"index.php?blocks=$matches[1]&page=$matches[2]\";s:44:\"(blog)/(?:feed/)?(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:27:\"(blog)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:9:\"(blog)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:49:\"(huong-dan)/(?:feed/)?(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:32:\"(huong-dan)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:14:\"(huong-dan)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:50:\"(khuyen-mai)/(?:feed/)?(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:33:\"(khuyen-mai)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:15:\"(khuyen-mai)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:47:\"(tin-tuc)/(?:feed/)?(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:30:\"(tin-tuc)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:12:\"(tin-tuc)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:68:\"(https-123-b-com-ve-chung-toi)/(?:feed/)?(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:51:\"(https-123-b-com-ve-chung-toi)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:33:\"(https-123-b-com-ve-chung-toi)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:14:\"category/(.+)$\";s:49:\"index.php?rank_math_category_redirect=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:57:\"block_categories/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?block_categories=$matches[1]&feed=$matches[2]\";s:52:\"block_categories/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?block_categories=$matches[1]&feed=$matches[2]\";s:33:\"block_categories/([^/]+)/embed/?$\";s:49:\"index.php?block_categories=$matches[1]&embed=true\";s:45:\"block_categories/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?block_categories=$matches[1]&paged=$matches[2]\";s:27:\"block_categories/([^/]+)/?$\";s:38:\"index.php?block_categories=$matches[1]\";s:41:\"featured_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"featured_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"featured_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"featured_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"featured_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"featured_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"featured_item/([^/]+)/embed/?$\";s:46:\"index.php?featured_item=$matches[1]&embed=true\";s:34:\"featured_item/([^/]+)/trackback/?$\";s:40:\"index.php?featured_item=$matches[1]&tb=1\";s:54:\"featured_item/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?featured_item=$matches[1]&feed=$matches[2]\";s:49:\"featured_item/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?featured_item=$matches[1]&feed=$matches[2]\";s:42:\"featured_item/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?featured_item=$matches[1]&paged=$matches[2]\";s:49:\"featured_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?featured_item=$matches[1]&cpage=$matches[2]\";s:47:\"featured_item/([^/]+)/schema-preview(/(.*))?/?$\";s:62:\"index.php?featured_item=$matches[1]&schema-preview=$matches[3]\";s:38:\"featured_item/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?featured_item=$matches[1]&page=$matches[2]\";s:30:\"featured_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"featured_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"featured_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"featured_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"featured_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"featured_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:63:\"featured_item_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:61:\"index.php?featured_item_category=$matches[1]&feed=$matches[2]\";s:58:\"featured_item_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:61:\"index.php?featured_item_category=$matches[1]&feed=$matches[2]\";s:39:\"featured_item_category/([^/]+)/embed/?$\";s:55:\"index.php?featured_item_category=$matches[1]&embed=true\";s:51:\"featured_item_category/([^/]+)/page/?([0-9]{1,})/?$\";s:62:\"index.php?featured_item_category=$matches[1]&paged=$matches[2]\";s:33:\"featured_item_category/([^/]+)/?$\";s:44:\"index.php?featured_item_category=$matches[1]\";s:58:\"featured_item_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?featured_item_tag=$matches[1]&feed=$matches[2]\";s:53:\"featured_item_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?featured_item_tag=$matches[1]&feed=$matches[2]\";s:34:\"featured_item_tag/([^/]+)/embed/?$\";s:50:\"index.php?featured_item_tag=$matches[1]&embed=true\";s:46:\"featured_item_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?featured_item_tag=$matches[1]&paged=$matches[2]\";s:28:\"featured_item_tag/([^/]+)/?$\";s:39:\"index.php?featured_item_tag=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=5&cpage=$matches[1]\";s:25:\"schema-preview(/(.*))?/?$\";s:37:\"index.php?&schema-preview=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:33:\"(.?.+?)/schema-preview(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&schema-preview=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:33:\"([^/]+)/schema-preview(/(.*))?/?$\";s:53:\"index.php?name=$matches[1]&schema-preview=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:13:{i:0;s:34:\"advanced-custom-fields-pro/acf.php\";i:1;s:33:\"classic-editor/classic-editor.php\";i:2;s:35:\"classic-widgets/classic-widgets.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:4;s:25:\"duplicator/duplicator.php\";i:5;s:49:\"easy-table-of-contents/easy-table-of-contents.php\";i:6;s:31:\"intelly-related-posts/index.php\";i:7;s:37:\"mihdan-index-now/mihdan-index-now.php\";i:8;s:29:\"rate-my-post/rate-my-post.php\";i:9;s:38:\"seo-by-rank-math-pro/rank-math-pro.php\";i:10;s:30:\"seo-by-rank-math/rank-math.php\";i:11;s:25:\"tablepress/tablepress.php\";i:12;s:23:\"wp-rocket/wp-rocket.php\";}", "yes");
INSERT INTO `wp_options` VALUES("77169", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:6016;}s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4818;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2784;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2664;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:2048;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1911;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1902;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1629;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1563;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1550;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1547;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1515;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1503;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1471;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1361;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1316;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1267;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1175;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1156;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1145;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:1046;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:1017;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:996;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:963;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:902;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:880;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:876;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:872;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:871;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:865;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:865;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:823;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:793;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:781;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:781;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:774;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:765;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:762;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:732;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:729;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:726;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:724;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:721;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:685;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:684;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:684;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:673;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:666;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:632;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:622;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:616;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:607;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:606;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:606;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:596;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:592;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:589;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:588;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:576;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:568;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:567;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:566;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:558;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:552;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:552;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:541;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:538;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:531;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:530;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:529;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:522;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:516;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:511;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:509;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:507;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:502;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:479;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:474;}s:6:\"blocks\";a:3:{s:4:\"name\";s:6:\"blocks\";s:4:\"slug\";s:6:\"blocks\";s:5:\"count\";i:472;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:469;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:450;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:449;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:448;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:437;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:431;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:426;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:425;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:421;}s:7:\"gateway\";a:3:{s:4:\"name\";s:7:\"gateway\";s:4:\"slug\";s:7:\"gateway\";s:5:\"count\";i:420;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:418;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:418;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:418;}s:8:\"payments\";a:3:{s:4:\"name\";s:8:\"payments\";s:4:\"slug\";s:8:\"payments\";s:5:\"count\";i:413;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:412;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:405;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:398;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:394;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:393;}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";i:391;}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";i:386;}}", "no");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "7", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:77:\"/home/ysscptnb/mami.gameh5.xyz/wp-content/themes/flatsome-child/functions.php\";i:2;s:74:\"/home/ysscptnb/mami.gameh5.xyz/wp-content/themes/flatsome-child/header.php\";i:3;s:73:\"/home/ysscptnb/mami.gameh5.xyz/wp-content/themes/flatsome-child/style.css\";i:4;s:68:\"/home/ysscptnb/mami.gameh5.xyz/wp-content/themes/flatsome/header.php\";i:5;s:67:\"/home/ysscptnb/mami.gameh5.xyz/wp-content/themes/flatsome/style.css\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "flatsome", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "flatsome-child", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "53496", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "0", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "0", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "0", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "0", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:5:{i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:162:\"<img class=\"alignnone size-full wp-image-3156\" src=\"https://mami.gameh5.xyz/wp-content/uploads/2023/03/demo-logo.png\" alt=\"\" width=\"700\" height=\"175\" />\r\n\r\n&nbsp;\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:4;a:4:{s:5:\"title\";s:10:\"LIÊN HỆ\";s:4:\"text\";s:1541:\"<div class=\"elementor-column elementor-col-20 elementor-top-column elementor-element elementor-element-97aa8a3\" data-id=\"97aa8a3\" data-element_type=\"column\">\r\n<div class=\"elementor-widget-wrap elementor-element-populated\">\r\n<div class=\"elementor-element elementor-element-da18485 elementor-align-left elementor-icon-list--layout-traditional elementor-list-item-link-full_width elementor-widget elementor-widget-icon-list\" data-id=\"da18485\" data-element_type=\"widget\" data-widget_type=\"icon-list.default\">\r\n<div class=\"elementor-widget-container\">\r\n<ul class=\"elementor-icon-list-items\">\r\n 	<li class=\"elementor-icon-list-item\"><i class=\"fas fa-phone-alt\"></i><span class=\"elementor-icon-list-text\">Số Điện Thoại:</span></li>\r\n 	<li class=\"elementor-icon-list-item\"><i class=\"fas fa-mail-bulk\" aria-hidden=\"true\"></i><span class=\"elementor-icon-list-text\"><span class=\"elementor-icon-list-text\">Email: </span></span></li>\r\n 	<li class=\"elementor-icon-list-item\"><i class=\"fas fa-home\" aria-hidden=\"true\"></i><span class=\"elementor-icon-list-text\">Địa Chỉ: </span></li>\r\n</ul>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"elementor-column elementor-col-20 elementor-top-column elementor-element elementor-element-3919ea7\" data-id=\"3919ea7\" data-element_type=\"column\">\r\n<div class=\"elementor-widget-wrap elementor-element-populated\">\r\n<div class=\"elementor-element elementor-element-24693c5 elementor-widget elementor-widget-html\" data-id=\"24693c5\" data-element_type=\"widget\" data-widget_type=\"html.default\"></div>\r\n</div>\r\n</div>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:6;a:4:{s:5:\"title\";s:16:\"Về chúng tôi\";s:4:\"text\";s:264:\"<ul class=\"widget-2-col\">\r\n 	<li class=\"bullet-arrow\">Giới thiệu</li>\r\n 	<li class=\"bullet-arrow\">Liên hệ</li>\r\n 	<li class=\"bullet-arrow\">Điều khoản dịch vụ</li>\r\n 	<li class=\"bullet-arrow\">Chính sách bảo mật</li>\r\n</ul>\r\n[show_socials_icon]\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:7;a:4:{s:5:\"title\";s:10:\"Danh mục\";s:4:\"text\";s:257:\"<ul class=\"widget-2-col\">\r\n 	<li class=\"bullet-arrow\">Tải app</li>\r\n 	<li class=\"bullet-arrow\">Đăng ký</li>\r\n 	<li class=\"bullet-arrow\">Đăng nhập</li>\r\n 	<li class=\"bullet-arrow\">Nạp tiền</li>\r\n 	<li class=\"bullet-arrow\">Rút tiền</li>\r\n</ul>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:3:{s:27:\"autoptimize/autoptimize.php\";s:29:\"autoptimizeMain::on_uninstall\";s:39:\"wp-external-links/wp-external-links.php\";a:2:{i:0;s:14:\"WPEL_Uninstall\";i:1;s:13:\"_cb_procedure\";}s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";a:2:{i:0;s:15:\"AIO_WP_Security\";i:1;s:17:\"uninstall_handler\";}}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "5", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "2818", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "2648", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1679131267", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "51917", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:108:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:23:\"rank_math_edit_htaccess\";b:1;s:16:\"rank_math_titles\";b:1;s:17:\"rank_math_general\";b:1;s:17:\"rank_math_sitemap\";b:1;s:21:\"rank_math_404_monitor\";b:1;s:22:\"rank_math_link_builder\";b:1;s:22:\"rank_math_redirections\";b:1;s:22:\"rank_math_role_manager\";b:1;s:19:\"rank_math_analytics\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:25:\"rank_math_onpage_advanced\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;s:20:\"rank_math_content_ai\";b:1;s:19:\"rank_math_admin_bar\";b:1;s:14:\"edit_watermark\";b:1;s:15:\"edit_watermarks\";b:1;s:22:\"edit_others_watermarks\";b:1;s:17:\"delete_watermarks\";b:1;s:24:\"delete_others_watermarks\";b:1;s:15:\"apply_watermark\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:23:\"tablepress_edit_options\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:54:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;s:14:\"edit_watermark\";b:1;s:15:\"edit_watermarks\";b:1;s:22:\"edit_others_watermarks\";b:1;s:17:\"delete_watermarks\";b:1;s:24:\"delete_others_watermarks\";b:1;s:15:\"apply_watermark\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:27:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:14:\"edit_watermark\";b:1;s:15:\"edit_watermarks\";b:1;s:17:\"delete_watermarks\";b:1;s:15:\"apply_watermark\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_block", "a:5:{i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "sidebars_widgets", "a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:8:\"footer_1\";a:0:{}s:8:\"footer_2\";a:1:{i:0;s:6:\"text-7\";}s:8:\"footer_3\";a:1:{i:0;s:6:\"text-6\";}s:8:\"footer_4\";a:1:{i:0;s:6:\"text-4\";}s:12:\"sidebar-main\";a:2:{i:0;s:7:\"block-3\";i:1;s:7:\"block-4\";}s:11:\"sidebar-cat\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:16:\"sidebar-footer-1\";a:1:{i:0;s:6:\"text-3\";}s:16:\"sidebar-footer-2\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("104", "cron", "a:18:{i:1679127864;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1679130514;a:1:{s:23:\"rocket_purge_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:34:\"rocket_expired_cache_cron_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1679130598;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1679131011;a:1:{s:27:\"mihdan-index-now__clear-log\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1679138303;a:1:{s:33:\"updraftplus_clean_temporary_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1679150826;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1679151984;a:1:{s:35:\"puc_cron_check_updates-wp-automatic\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1679156010;a:1:{s:26:\"irp_daily_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1679159160;a:4:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1679159424;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1679159427;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1679161019;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1679184000;a:2:{s:35:\"rank_math/redirection/clean_trashed\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"rank_math/links/internal_links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1679245560;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1679501610;a:1:{s:27:\"irp_weekly_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1679731712;a:1:{s:27:\"rocket_cache_dir_size_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1679731914;a:1:{s:39:\"rocket_database_optimization_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("75654", "updraft_lock_2ea2241085eb", "1678881256", "no");
INSERT INTO `wp_options` VALUES("105", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("118", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("119", "theme_mods_twentytwentytwo", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1646535888;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("120", "WPLANG", "vi", "yes");
INSERT INTO `wp_options` VALUES("162", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("168", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("334", "recently_activated", "a:4:{s:33:\"easy-watermark/easy-watermark.php\";i:1679123375;s:39:\"wp-file-manager/file_folder_manager.php\";i:1679037734;s:23:\"wordfence/wordfence.php\";i:1679037734;s:27:\"updraftplus/updraftplus.php\";i:1678881908;}", "yes");
INSERT INTO `wp_options` VALUES("341", "acf_version", "5.9.6", "yes");
INSERT INTO `wp_options` VALUES("342", "current_theme", "ProTheme", "yes");
INSERT INTO `wp_options` VALUES("343", "theme_mods_flatsome-child", "a:96:{i:0;b:0;s:17:\"flatsome_fallback\";i:0;s:20:\"topbar_elements_left\";a:1:{i:0;s:4:\"html\";}s:21:\"topbar_elements_right\";a:1:{i:0;s:7:\"nav-top\";}s:20:\"header_elements_left\";a:1:{i:0;s:6:\"search\";}s:21:\"header_elements_right\";a:0:{}s:27:\"header_elements_bottom_left\";a:0:{}s:29:\"header_elements_bottom_center\";a:0:{}s:28:\"header_elements_bottom_right\";a:0:{}s:27:\"header_mobile_elements_left\";a:0:{}s:28:\"header_mobile_elements_right\";a:0:{}s:26:\"header_mobile_elements_top\";a:1:{i:0;s:4:\"html\";}s:14:\"mobile_sidebar\";a:7:{i:0;s:11:\"search-form\";i:1;s:3:\"nav\";i:2;s:7:\"account\";i:3;s:10:\"newsletter\";i:4;s:6:\"social\";i:5;s:6:\"html-2\";i:6;s:6:\"html-3\";}s:14:\"product_layout\";s:19:\"right-sidebar-small\";s:23:\"payment_icons_placement\";s:6:\"footer\";s:14:\"follow_twitter\";s:0:\"\";s:15:\"follow_facebook\";s:0:\"\";s:16:\"follow_instagram\";s:0:\"\";s:12:\"follow_email\";s:0:\"\";s:16:\"flatsome_version\";i:3;s:24:\"portfolio_archive_filter\";s:4:\"left\";s:13:\"type_headings\";a:5:{s:11:\"font-family\";s:6:\"Roboto\";s:7:\"variant\";s:3:\"700\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:700;s:10:\"font-style\";s:6:\"normal\";}s:10:\"type_texts\";a:5:{s:11:\"font-family\";s:6:\"Roboto\";s:7:\"variant\";s:7:\"regular\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:400;s:10:\"font-style\";s:6:\"normal\";}s:8:\"type_nav\";a:5:{s:11:\"font-family\";s:6:\"Roboto\";s:7:\"variant\";s:3:\"700\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:700;s:10:\"font-style\";s:6:\"normal\";}s:8:\"type_alt\";a:5:{s:11:\"font-family\";s:6:\"Roboto\";s:7:\"variant\";s:7:\"regular\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:400;s:10:\"font-style\";s:6:\"normal\";}s:14:\"pages_template\";s:7:\"default\";s:11:\"site_loader\";s:0:\"\";s:19:\"flatsome_db_version\";s:6:\"3.14.3\";s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:8;s:11:\"menu_mobile\";i:20;}s:7:\"backups\";N;s:9:\"smof_init\";s:31:\"Sun, 06 Mar 2022 03:04:49 +0000\";s:18:\"custom_css_post_id\";i:-1;s:10:\"site_width\";s:4:\"1300\";s:10:\"logo_width\";s:3:\"200\";s:17:\"header_top_height\";s:2:\"30\";s:12:\"header_width\";s:9:\"container\";s:13:\"header_height\";s:2:\"90\";s:9:\"type_size\";s:3:\"100\";s:16:\"type_size_mobile\";s:3:\"100\";s:11:\"blog_layout\";s:10:\"no-sidebar\";s:10:\"blog_style\";s:5:\"3-col\";s:16:\"blog_post_layout\";s:10:\"no-sidebar\";s:15:\"blog_post_style\";s:3:\"top\";s:23:\"blog_single_footer_meta\";b:0;s:15:\"blog_author_box\";b:1;s:25:\"blog_single_next_prev_nav\";b:1;s:14:\"site_logo_dark\";s:65:\"https://mami.gameh5.xyz/wp-content/uploads/2023/02/logo-123-b.png\";s:12:\"logo_padding\";s:1:\"0\";s:8:\"footer_1\";b:0;s:8:\"footer_2\";b:0;s:16:\"footer_left_text\";s:0:\"\";s:19:\"html_scripts_header\";s:295:\"<!-- Google tag (gtag.js) -->\r\n<script async src=\"https://www.googletagmanager.com/gtag/js?id=G-6HJDTKDB4R\"></script>\r\n<script>\r\n  window.dataLayer = window.dataLayer || [];\r\n  function gtag(){dataLayer.push(arguments);}\r\n  gtag(\'js\', new Date());\r\n\r\n  gtag(\'config\', \'G-6HJDTKDB4R\');\r\n</script>\";s:19:\"html_scripts_footer\";s:0:\"\";s:23:\"html_scripts_after_body\";s:0:\"\";s:24:\"html_scripts_before_body\";s:0:\"\";s:15:\"html_custom_css\";s:0:\"\";s:22:\"html_custom_css_tablet\";s:0:\"\";s:22:\"html_custom_css_mobile\";s:0:\"\";s:17:\"perf_instant_page\";s:1:\"0\";s:21:\"lazy_load_backgrounds\";s:1:\"1\";s:16:\"lazy_load_images\";s:1:\"0\";s:26:\"flatsome_disable_style_css\";s:1:\"0\";s:13:\"disable_emoji\";s:1:\"0\";s:16:\"disable_blockcss\";s:1:\"0\";s:14:\"jquery_migrate\";s:1:\"0\";s:17:\"site_loader_color\";s:5:\"light\";s:14:\"site_loader_bg\";s:0:\"\";s:11:\"live_search\";s:1:\"1\";s:18:\"search_placeholder\";s:0:\"\";s:21:\"search_result_latency\";s:1:\"0\";s:17:\"facebook_accounts\";a:1:{i:0;s:1:\"0\";}s:14:\"google_map_api\";s:0:\"\";s:16:\"maintenance_mode\";s:1:\"0\";s:29:\"maintenance_mode_admin_notice\";s:1:\"1\";s:21:\"maintenance_mode_page\";s:1:\"0\";s:21:\"maintenance_mode_text\";s:24:\"Please check back soon..\";s:9:\"404_block\";s:1:\"0\";s:12:\"fl_portfolio\";s:1:\"1\";s:15:\"parallax_mobile\";s:1:\"0\";s:15:\"flatsome_studio\";s:1:\"1\";s:22:\"rank_math_primary_term\";s:1:\"0\";s:41:\"rank_math_manages_product_layout_priority\";s:1:\"0\";s:20:\"rank_math_breadcrumb\";s:1:\"0\";s:18:\"blog_style_archive\";s:5:\"3-col\";s:12:\"footer_block\";s:6:\"footer\";s:13:\"blog_featured\";s:0:\"\";s:20:\"blog_featured_height\";s:3:\"500\";s:9:\"site_logo\";s:65:\"https://mami.gameh5.xyz/wp-content/uploads/2023/02/logo-123-b.png\";s:18:\"blog_archive_title\";b:0;s:16:\"blog_hide_sticky\";b:0;s:16:\"blog_posts_depth\";s:1:\"0\";s:22:\"blog_posts_depth_hover\";s:1:\"0\";s:22:\"blog_posts_title_align\";s:4:\"left\";s:10:\"blog_badge\";b:0;s:19:\"blog_excerpt_suffix\";s:0:\"\";s:21:\"newsletter_icon_style\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("344", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("345", "widget_flatsome_recent_posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("346", "widget_block_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("389", "flatsome_update_cache", "a:2:{s:12:\"last_checked\";i:1679127771;s:7:\"version\";s:6:\"3.14.3\";}", "yes");
INSERT INTO `wp_options` VALUES("419", "options_logo_image", "3156", "no");
INSERT INTO `wp_options` VALUES("420", "_options_logo_image", "field_622407b367ee3", "no");
INSERT INTO `wp_options` VALUES("421", "options_favicon", "", "no");
INSERT INTO `wp_options` VALUES("422", "_options_favicon", "field_622407c267ee4", "no");
INSERT INTO `wp_options` VALUES("423", "options_phone", "", "no");
INSERT INTO `wp_options` VALUES("424", "_options_phone", "field_622407ee67ee6", "no");
INSERT INTO `wp_options` VALUES("425", "options_address", "", "no");
INSERT INTO `wp_options` VALUES("426", "_options_address", "field_622407f467ee7", "no");
INSERT INTO `wp_options` VALUES("427", "options_email", "", "no");
INSERT INTO `wp_options` VALUES("428", "_options_email", "field_622407f967ee8", "no");
INSERT INTO `wp_options` VALUES("429", "options_copyright", "COPYRIGHT © ALL RIGHTS RESERVED", "no");
INSERT INTO `wp_options` VALUES("430", "_options_copyright", "field_6224084267eeb", "no");
INSERT INTO `wp_options` VALUES("444", "options_background_ft", "1023", "no");
INSERT INTO `wp_options` VALUES("445", "_options_background_ft", "field_62246d6e55cc3", "no");
INSERT INTO `wp_options` VALUES("446", "options_manufacture", "a:16:{i:0;s:3:\"127\";i:1;s:3:\"128\";i:2;s:3:\"129\";i:3;s:3:\"130\";i:4;s:3:\"131\";i:5;s:3:\"132\";i:6;s:3:\"133\";i:7;s:3:\"134\";i:8;s:3:\"135\";i:9;s:3:\"136\";i:10;s:3:\"137\";i:11;s:3:\"138\";i:12;s:3:\"139\";i:13;s:3:\"140\";i:14;s:3:\"141\";i:15;s:3:\"142\";}", "no");
INSERT INTO `wp_options` VALUES("447", "_options_manufacture", "field_62246d8955cc4", "no");
INSERT INTO `wp_options` VALUES("448", "options_responsibility", "a:2:{i:0;s:3:\"142\";i:1;s:3:\"141\";}", "no");
INSERT INTO `wp_options` VALUES("449", "_options_responsibility", "field_62246e2455cc5", "no");
INSERT INTO `wp_options` VALUES("450", "options_license", "a:3:{i:0;s:4:\"2199\";i:1;s:4:\"2200\";i:2;s:4:\"2201\";}", "no");
INSERT INTO `wp_options` VALUES("451", "_options_license", "field_62246e3f55cc6", "no");
INSERT INTO `wp_options` VALUES("795", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("845", "options_list_contact_0_icon_contact", "2360", "no");
INSERT INTO `wp_options` VALUES("846", "_options_list_contact_0_icon_contact", "field_6224dcbc7a8b1", "no");
INSERT INTO `wp_options` VALUES("847", "options_list_contact_0_link_contact", "", "no");
INSERT INTO `wp_options` VALUES("848", "_options_list_contact_0_link_contact", "field_6224dcc97a8b2", "no");
INSERT INTO `wp_options` VALUES("849", "options_list_contact_0_title_contact", "Đăng ký ", "no");
INSERT INTO `wp_options` VALUES("850", "_options_list_contact_0_title_contact", "field_6224dd367a163", "no");
INSERT INTO `wp_options` VALUES("851", "options_list_contact_1_icon_contact", "2360", "no");
INSERT INTO `wp_options` VALUES("852", "_options_list_contact_1_icon_contact", "field_6224dcbc7a8b1", "no");
INSERT INTO `wp_options` VALUES("853", "options_list_contact_1_link_contact", "", "no");
INSERT INTO `wp_options` VALUES("854", "_options_list_contact_1_link_contact", "field_6224dcc97a8b2", "no");
INSERT INTO `wp_options` VALUES("855", "options_list_contact_1_title_contact", "Đăng nhập ", "no");
INSERT INTO `wp_options` VALUES("856", "_options_list_contact_1_title_contact", "field_6224dd367a163", "no");
INSERT INTO `wp_options` VALUES("881", "options_list_contact", "4", "no");
INSERT INTO `wp_options` VALUES("882", "_options_list_contact", "field_6224dc9f7a8b0", "no");
INSERT INTO `wp_options` VALUES("1037", "options_list_maintenance_0_title_maintenance", "AE_LOTTO-Xổ số", "no");
INSERT INTO `wp_options` VALUES("1038", "_options_list_maintenance_0_title_maintenance", "field_62255f7aef1d8", "no");
INSERT INTO `wp_options` VALUES("1039", "options_list_maintenance_0_desc_maintenance", "2022-03-06 00:29:01 ~ Thông báo sau khi hoàn tất", "no");
INSERT INTO `wp_options` VALUES("1040", "_options_list_maintenance_0_desc_maintenance", "field_62255fbeef1d9", "no");
INSERT INTO `wp_options` VALUES("1041", "options_list_maintenance_1_title_maintenance", "ALLBET-Live casino", "no");
INSERT INTO `wp_options` VALUES("1042", "_options_list_maintenance_1_title_maintenance", "field_62255f7aef1d8", "no");
INSERT INTO `wp_options` VALUES("1043", "options_list_maintenance_1_desc_maintenance", "2022-03-07 07:00 ~ 2022-03-07 11:00", "no");
INSERT INTO `wp_options` VALUES("1044", "_options_list_maintenance_1_desc_maintenance", "field_62255fbeef1d9", "no");
INSERT INTO `wp_options` VALUES("1045", "options_list_maintenance_2_title_maintenance", "SA-Live casino", "no");
INSERT INTO `wp_options` VALUES("1046", "_options_list_maintenance_2_title_maintenance", "field_62255f7aef1d8", "no");
INSERT INTO `wp_options` VALUES("1047", "options_list_maintenance_2_desc_maintenance", "2022-03-07 09:00 ~ 2022-03-07 11:30", "no");
INSERT INTO `wp_options` VALUES("1048", "_options_list_maintenance_2_desc_maintenance", "field_62255fbeef1d9", "no");
INSERT INTO `wp_options` VALUES("1049", "options_list_maintenance_3_title_maintenance", "SABA-Game bài", "no");
INSERT INTO `wp_options` VALUES("1050", "_options_list_maintenance_3_title_maintenance", "field_62255f7aef1d8", "no");
INSERT INTO `wp_options` VALUES("1051", "options_list_maintenance_3_desc_maintenance", "2022-01-06 18:35:06 ~ Thông báo sau khi hoàn tất", "no");
INSERT INTO `wp_options` VALUES("1052", "_options_list_maintenance_3_desc_maintenance", "field_62255fbeef1d9", "no");
INSERT INTO `wp_options` VALUES("1053", "options_list_maintenance", "4", "no");
INSERT INTO `wp_options` VALUES("1054", "_options_list_maintenance", "field_62255f70ef1d7", "no");
INSERT INTO `wp_options` VALUES("1088", "options_list_event_0_image_event", "", "no");
INSERT INTO `wp_options` VALUES("1089", "_options_list_event_0_image_event", "field_62256991bb592", "no");
INSERT INTO `wp_options` VALUES("1090", "options_list_event_0_link_event", "", "no");
INSERT INTO `wp_options` VALUES("1091", "_options_list_event_0_link_event", "field_6225699cbb593", "no");
INSERT INTO `wp_options` VALUES("1092", "options_list_event_1_image_event", "", "no");
INSERT INTO `wp_options` VALUES("1093", "_options_list_event_1_image_event", "field_62256991bb592", "no");
INSERT INTO `wp_options` VALUES("1094", "options_list_event_1_link_event", "", "no");
INSERT INTO `wp_options` VALUES("1095", "_options_list_event_1_link_event", "field_6225699cbb593", "no");
INSERT INTO `wp_options` VALUES("1096", "options_list_event_2_image_event", "", "no");
INSERT INTO `wp_options` VALUES("1097", "_options_list_event_2_image_event", "field_62256991bb592", "no");
INSERT INTO `wp_options` VALUES("1098", "options_list_event_2_link_event", "", "no");
INSERT INTO `wp_options` VALUES("1099", "_options_list_event_2_link_event", "field_6225699cbb593", "no");
INSERT INTO `wp_options` VALUES("1100", "options_list_event", "3", "no");
INSERT INTO `wp_options` VALUES("1101", "_options_list_event", "field_62256977bb591", "no");
INSERT INTO `wp_options` VALUES("1144", "options_logo_mini_game", "", "no");
INSERT INTO `wp_options` VALUES("1145", "_options_logo_mini_game", "field_622574f6657d1", "no");
INSERT INTO `wp_options` VALUES("1146", "options_list_mini_game_0_image_game", "", "no");
INSERT INTO `wp_options` VALUES("1147", "_options_list_mini_game_0_image_game", "field_6225752f657d4", "no");
INSERT INTO `wp_options` VALUES("1148", "options_list_mini_game_0_link_game", "", "no");
INSERT INTO `wp_options` VALUES("1149", "_options_list_mini_game_0_link_game", "field_6225753c657d5", "no");
INSERT INTO `wp_options` VALUES("1150", "options_list_mini_game_1_image_game", "", "no");
INSERT INTO `wp_options` VALUES("1151", "_options_list_mini_game_1_image_game", "field_6225752f657d4", "no");
INSERT INTO `wp_options` VALUES("1152", "options_list_mini_game_1_link_game", "", "no");
INSERT INTO `wp_options` VALUES("1153", "_options_list_mini_game_1_link_game", "field_6225753c657d5", "no");
INSERT INTO `wp_options` VALUES("1154", "options_list_mini_game_2_image_game", "", "no");
INSERT INTO `wp_options` VALUES("1155", "_options_list_mini_game_2_image_game", "field_6225752f657d4", "no");
INSERT INTO `wp_options` VALUES("1156", "options_list_mini_game_2_link_game", "", "no");
INSERT INTO `wp_options` VALUES("1157", "_options_list_mini_game_2_link_game", "field_6225753c657d5", "no");
INSERT INTO `wp_options` VALUES("1158", "options_list_mini_game_3_image_game", "", "no");
INSERT INTO `wp_options` VALUES("1159", "_options_list_mini_game_3_image_game", "field_6225752f657d4", "no");
INSERT INTO `wp_options` VALUES("1160", "options_list_mini_game_3_link_game", "", "no");
INSERT INTO `wp_options` VALUES("1161", "_options_list_mini_game_3_link_game", "field_6225753c657d5", "no");
INSERT INTO `wp_options` VALUES("1162", "options_list_mini_game_4_image_game", "", "no");
INSERT INTO `wp_options` VALUES("1163", "_options_list_mini_game_4_image_game", "field_6225752f657d4", "no");
INSERT INTO `wp_options` VALUES("1164", "options_list_mini_game_4_link_game", "", "no");
INSERT INTO `wp_options` VALUES("1165", "_options_list_mini_game_4_link_game", "field_6225753c657d5", "no");
INSERT INTO `wp_options` VALUES("1166", "options_list_mini_game", "5", "no");
INSERT INTO `wp_options` VALUES("1167", "_options_list_mini_game", "field_62257521657d3", "no");
INSERT INTO `wp_options` VALUES("1195", "options_icon_tele", "", "no");
INSERT INTO `wp_options` VALUES("1196", "_options_icon_tele", "field_62257b049f8b4", "no");
INSERT INTO `wp_options` VALUES("1197", "options_link_tele", "https://t.me/NguyenDoanSan", "no");
INSERT INTO `wp_options` VALUES("1198", "_options_link_tele", "field_62257b0f9f8b5", "no");
INSERT INTO `wp_options` VALUES("1691", "widget_recent-posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1692", "widget_recent-comments", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1756", "lyte_version", "1.7.19", "yes");
INSERT INTO `wp_options` VALUES("1757", "widget_wylwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1804", "rocket_cache_dir_size_check", "1", "yes");
INSERT INTO `wp_options` VALUES("2088", "action_scheduler_hybrid_store_demarkation", "264", "yes");
INSERT INTO `wp_options` VALUES("2089", "schema-ActionScheduler_StoreSchema", "6.0.1646709046", "yes");
INSERT INTO `wp_options` VALUES("2090", "schema-ActionScheduler_LoggerSchema", "3.0.1646709046", "yes");
INSERT INTO `wp_options` VALUES("2091", "rank_math_known_post_types", "a:5:{s:4:\"post\";s:4:\"post\";s:4:\"page\";s:4:\"page\";s:10:\"attachment\";s:10:\"attachment\";s:6:\"blocks\";s:6:\"blocks\";s:13:\"featured_item\";s:13:\"featured_item\";}", "yes");
INSERT INTO `wp_options` VALUES("2092", "rank_math_modules", "a:15:{i:0;s:12:\"link-counter\";i:1;s:9:\"analytics\";i:2;s:12:\"seo-analysis\";i:3;s:7:\"sitemap\";i:4;s:12:\"rich-snippet\";i:5;s:11:\"woocommerce\";i:6;s:10:\"buddypress\";i:7;s:7:\"bbpress\";i:8;s:3:\"acf\";i:9;s:11:\"web-stories\";i:11;s:16:\"instant-indexing\";i:12;s:9:\"local-seo\";i:13;s:12:\"redirections\";i:15;s:12:\"role-manager\";i:16;s:11:\"404-monitor\";}", "yes");
INSERT INTO `wp_options` VALUES("2093", "rank-math-options-general", "a:54:{s:19:\"strip_category_base\";s:2:\"on\";s:24:\"attachment_redirect_urls\";s:2:\"on\";s:27:\"attachment_redirect_default\";s:23:\"https://mami.gameh5.xyz\";s:23:\"nofollow_external_links\";s:3:\"off\";s:20:\"nofollow_image_links\";s:3:\"off\";s:25:\"new_window_external_links\";s:2:\"on\";s:11:\"add_img_alt\";s:3:\"off\";s:14:\"img_alt_format\";s:11:\" %filename%\";s:13:\"add_img_title\";s:3:\"off\";s:16:\"img_title_format\";s:22:\"%title% %count(title)%\";s:11:\"breadcrumbs\";s:2:\"on\";s:21:\"breadcrumbs_separator\";s:7:\"&raquo;\";s:16:\"breadcrumbs_home\";s:2:\"on\";s:22:\"breadcrumbs_home_label\";s:11:\"Trang chủ\";s:26:\"breadcrumbs_archive_format\";s:15:\"Archives for %s\";s:25:\"breadcrumbs_search_format\";s:14:\"Results for %s\";s:21:\"breadcrumbs_404_label\";s:25:\"404 Error: page not found\";s:31:\"breadcrumbs_ancestor_categories\";s:3:\"off\";s:21:\"breadcrumbs_blog_page\";s:3:\"off\";s:16:\"404_monitor_mode\";s:6:\"simple\";s:17:\"404_monitor_limit\";s:3:\"100\";s:35:\"404_monitor_ignore_query_parameters\";s:2:\"on\";s:24:\"redirections_header_code\";s:3:\"301\";s:18:\"redirections_debug\";s:3:\"off\";s:23:\"console_caching_control\";s:2:\"90\";s:21:\"console_email_reports\";b:0;s:23:\"console_email_frequency\";s:7:\"monthly\";s:27:\"link_builder_links_per_page\";s:1:\"7\";s:29:\"link_builder_links_per_target\";s:1:\"1\";s:22:\"wc_remove_product_base\";s:3:\"off\";s:23:\"wc_remove_category_base\";s:3:\"off\";s:31:\"wc_remove_category_parent_slugs\";s:3:\"off\";s:19:\"wc_remove_generator\";s:2:\"on\";s:24:\"remove_shop_snippet_data\";s:2:\"on\";s:18:\"frontend_seo_score\";s:3:\"off\";s:29:\"frontend_seo_score_post_types\";a:1:{i:0;s:4:\"post\";}s:27:\"frontend_seo_score_position\";s:3:\"top\";s:10:\"setup_mode\";s:8:\"advanced\";s:21:\"content_ai_post_types\";a:4:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:6:\"blocks\";i:3;s:13:\"featured_item\";}s:14:\"google_updates\";s:2:\"on\";s:21:\"breadcrumbs_home_link\";s:23:\"https://mami.gameh5.xyz\";s:29:\"breadcrumbs_remove_post_title\";s:3:\"off\";s:30:\"breadcrumbs_hide_taxonomy_name\";s:3:\"off\";s:16:\"headless_support\";s:3:\"off\";s:27:\"frontend_seo_score_template\";s:6:\"circle\";s:17:\"support_rank_math\";s:2:\"on\";s:17:\"disable_media_rss\";s:3:\"off\";s:18:\"content_ai_country\";s:3:\"all\";s:21:\"redirections_fallback\";s:7:\"default\";s:26:\"redirections_post_redirect\";s:3:\"off\";s:15:\"analytics_stats\";s:2:\"on\";s:15:\"toc_block_title\";s:17:\"Table of Contents\";s:20:\"toc_block_list_style\";s:2:\"ul\";s:19:\"404_monitor_exclude\";a:1:{i:0;a:1:{s:10:\"comparison\";s:5:\"exact\";}}}", "yes");
INSERT INTO `wp_options` VALUES("2094", "rank-math-options-titles", "a:222:{s:24:\"noindex_empty_taxonomies\";s:2:\"on\";s:15:\"title_separator\";s:1:\"-\";s:17:\"capitalize_titles\";s:3:\"off\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:19:\"knowledgegraph_type\";s:7:\"company\";s:19:\"local_business_type\";s:6:\"Casino\";s:20:\"local_address_format\";s:43:\"{address} {locality}, {region} {postalcode}\";s:13:\"opening_hours\";a:7:{i:0;a:2:{s:3:\"day\";s:6:\"Monday\";s:4:\"time\";s:10:\"0:00-24:00\";}i:1;a:2:{s:3:\"day\";s:7:\"Tuesday\";s:4:\"time\";s:10:\"0:00-24:00\";}i:2;a:2:{s:3:\"day\";s:9:\"Wednesday\";s:4:\"time\";s:10:\"0:00-24:00\";}i:3;a:2:{s:3:\"day\";s:8:\"Thursday\";s:4:\"time\";s:10:\"0:00-24:00\";}i:4;a:2:{s:3:\"day\";s:6:\"Friday\";s:4:\"time\";s:10:\"0:00-24:00\";}i:5;a:2:{s:3:\"day\";s:8:\"Saturday\";s:4:\"time\";s:10:\"0:00-24:00\";}i:6;a:2:{s:3:\"day\";s:6:\"Sunday\";s:4:\"time\";s:10:\"0:00-24:00\";}}s:20:\"opening_hours_format\";s:3:\"off\";s:14:\"homepage_title\";s:34:\"%sitename% %page% %sep% %sitedesc%\";s:20:\"homepage_description\";s:0:\"\";s:22:\"homepage_custom_robots\";s:3:\"off\";s:23:\"disable_author_archives\";s:3:\"off\";s:15:\"url_author_base\";s:6:\"author\";s:20:\"author_custom_robots\";s:2:\"on\";s:13:\"author_robots\";a:1:{i:0;s:7:\"noindex\";}s:20:\"author_archive_title\";s:30:\"%name% %sep% %sitename% %page%\";s:19:\"author_add_meta_box\";s:2:\"on\";s:21:\"disable_date_archives\";s:2:\"on\";s:18:\"date_archive_title\";s:30:\"%date% %page% %sep% %sitename%\";s:12:\"search_title\";s:38:\"%search_query% %page% %sep% %sitename%\";s:9:\"404_title\";s:31:\"Page Not Found %sep% %sitename%\";s:19:\"date_archive_robots\";a:1:{i:0;s:7:\"noindex\";}s:14:\"noindex_search\";s:2:\"on\";s:24:\"noindex_archive_subpages\";s:3:\"off\";s:26:\"noindex_password_protected\";s:3:\"off\";s:32:\"pt_download_default_rich_snippet\";s:7:\"product\";s:29:\"author_slack_enhanced_sharing\";s:2:\"on\";s:13:\"pt_post_title\";s:24:\"%title% %sep% %sitename%\";s:19:\"pt_post_description\";s:9:\"%excerpt%\";s:14:\"pt_post_robots\";a:1:{i:0;s:5:\"index\";}s:21:\"pt_post_custom_robots\";s:3:\"off\";s:28:\"pt_post_default_rich_snippet\";s:7:\"article\";s:28:\"pt_post_default_article_type\";s:11:\"BlogPosting\";s:28:\"pt_post_default_snippet_name\";s:11:\"%seo_title%\";s:28:\"pt_post_default_snippet_desc\";s:17:\"%seo_description%\";s:30:\"pt_post_slack_enhanced_sharing\";s:3:\"off\";s:17:\"pt_post_ls_use_fk\";s:6:\"titles\";s:20:\"pt_post_add_meta_box\";s:2:\"on\";s:20:\"pt_post_bulk_editing\";s:7:\"editing\";s:24:\"pt_post_link_suggestions\";s:2:\"on\";s:24:\"pt_post_primary_taxonomy\";s:8:\"category\";s:13:\"pt_page_title\";s:24:\"%title% %sep% %sitename%\";s:19:\"pt_page_description\";s:9:\"%excerpt%\";s:14:\"pt_page_robots\";a:1:{i:0;s:5:\"index\";}s:21:\"pt_page_custom_robots\";s:3:\"off\";s:28:\"pt_page_default_rich_snippet\";s:7:\"article\";s:28:\"pt_page_default_article_type\";s:7:\"Article\";s:28:\"pt_page_default_snippet_name\";s:11:\"%seo_title%\";s:28:\"pt_page_default_snippet_desc\";s:17:\"%seo_description%\";s:30:\"pt_page_slack_enhanced_sharing\";s:3:\"off\";s:17:\"pt_page_ls_use_fk\";s:6:\"titles\";s:20:\"pt_page_add_meta_box\";s:2:\"on\";s:20:\"pt_page_bulk_editing\";s:7:\"editing\";s:24:\"pt_page_link_suggestions\";s:2:\"on\";s:19:\"pt_attachment_title\";s:24:\"%title% %sep% %sitename%\";s:25:\"pt_attachment_description\";s:9:\"%excerpt%\";s:20:\"pt_attachment_robots\";a:1:{i:0;s:7:\"noindex\";}s:27:\"pt_attachment_custom_robots\";s:2:\"on\";s:34:\"pt_attachment_default_rich_snippet\";s:3:\"off\";s:34:\"pt_attachment_default_article_type\";s:7:\"Article\";s:34:\"pt_attachment_default_snippet_name\";s:11:\"%seo_title%\";s:34:\"pt_attachment_default_snippet_desc\";s:17:\"%seo_description%\";s:36:\"pt_attachment_slack_enhanced_sharing\";s:3:\"off\";s:26:\"pt_attachment_add_meta_box\";s:3:\"off\";s:15:\"pt_blocks_title\";s:24:\"%title% %sep% %sitename%\";s:21:\"pt_blocks_description\";s:9:\"%excerpt%\";s:16:\"pt_blocks_robots\";a:1:{i:0;s:5:\"index\";}s:23:\"pt_blocks_custom_robots\";s:3:\"off\";s:30:\"pt_blocks_default_rich_snippet\";s:3:\"off\";s:30:\"pt_blocks_default_article_type\";s:7:\"Article\";s:30:\"pt_blocks_default_snippet_name\";s:11:\"%seo_title%\";s:30:\"pt_blocks_default_snippet_desc\";s:17:\"%seo_description%\";s:32:\"pt_blocks_slack_enhanced_sharing\";s:3:\"off\";s:19:\"pt_blocks_ls_use_fk\";s:6:\"titles\";s:22:\"pt_blocks_add_meta_box\";s:2:\"on\";s:22:\"pt_blocks_bulk_editing\";s:7:\"editing\";s:26:\"pt_blocks_link_suggestions\";s:2:\"on\";s:22:\"pt_featured_item_title\";s:24:\"%title% %sep% %sitename%\";s:28:\"pt_featured_item_description\";s:9:\"%excerpt%\";s:23:\"pt_featured_item_robots\";a:1:{i:0;s:5:\"index\";}s:30:\"pt_featured_item_custom_robots\";s:3:\"off\";s:37:\"pt_featured_item_default_rich_snippet\";s:3:\"off\";s:37:\"pt_featured_item_default_article_type\";s:7:\"Article\";s:37:\"pt_featured_item_default_snippet_name\";s:11:\"%seo_title%\";s:37:\"pt_featured_item_default_snippet_desc\";s:17:\"%seo_description%\";s:30:\"pt_featured_item_archive_title\";s:31:\"%title% %page% %sep% %sitename%\";s:39:\"pt_featured_item_slack_enhanced_sharing\";s:3:\"off\";s:26:\"pt_featured_item_ls_use_fk\";s:6:\"titles\";s:29:\"pt_featured_item_add_meta_box\";s:2:\"on\";s:29:\"pt_featured_item_bulk_editing\";s:7:\"editing\";s:33:\"pt_featured_item_link_suggestions\";s:2:\"on\";s:16:\"pt_product_title\";s:24:\"%title% %sep% %sitename%\";s:22:\"pt_product_description\";s:9:\"%excerpt%\";s:17:\"pt_product_robots\";a:0:{}s:24:\"pt_product_custom_robots\";s:3:\"off\";s:31:\"pt_product_default_rich_snippet\";s:7:\"product\";s:31:\"pt_product_default_article_type\";s:7:\"Article\";s:31:\"pt_product_default_snippet_name\";s:11:\"%seo_title%\";s:31:\"pt_product_default_snippet_desc\";s:17:\"%seo_description%\";s:33:\"pt_product_slack_enhanced_sharing\";s:2:\"on\";s:20:\"pt_product_ls_use_fk\";s:6:\"titles\";s:23:\"pt_product_add_meta_box\";s:2:\"on\";s:23:\"pt_product_bulk_editing\";s:7:\"editing\";s:27:\"pt_product_link_suggestions\";s:2:\"on\";s:27:\"pt_product_primary_taxonomy\";s:11:\"product_cat\";s:18:\"pt_web-story_title\";s:24:\"%title% %sep% %sitename%\";s:24:\"pt_web-story_description\";s:9:\"%excerpt%\";s:19:\"pt_web-story_robots\";a:0:{}s:26:\"pt_web-story_custom_robots\";s:3:\"off\";s:33:\"pt_web-story_default_rich_snippet\";s:7:\"article\";s:33:\"pt_web-story_default_article_type\";s:7:\"Article\";s:33:\"pt_web-story_default_snippet_name\";s:11:\"%seo_title%\";s:33:\"pt_web-story_default_snippet_desc\";s:17:\"%seo_description%\";s:35:\"pt_web-story_slack_enhanced_sharing\";s:3:\"off\";s:25:\"pt_web-story_add_meta_box\";s:3:\"off\";s:18:\"tax_category_title\";s:23:\"%term% %sep% %sitename%\";s:19:\"tax_category_robots\";a:1:{i:0;s:5:\"index\";}s:25:\"tax_category_add_meta_box\";s:2:\"on\";s:26:\"tax_category_custom_robots\";s:3:\"off\";s:24:\"tax_category_description\";s:18:\"%term_description%\";s:35:\"tax_category_slack_enhanced_sharing\";s:2:\"on\";s:18:\"tax_post_tag_title\";s:23:\"%term% %sep% %sitename%\";s:19:\"tax_post_tag_robots\";a:1:{i:0;s:7:\"noindex\";}s:25:\"tax_post_tag_add_meta_box\";s:2:\"on\";s:26:\"tax_post_tag_custom_robots\";s:2:\"on\";s:24:\"tax_post_tag_description\";s:18:\"%term_description%\";s:35:\"tax_post_tag_slack_enhanced_sharing\";s:2:\"on\";s:21:\"tax_post_format_title\";s:23:\"%term% %sep% %sitename%\";s:22:\"tax_post_format_robots\";a:1:{i:0;s:7:\"noindex\";}s:28:\"tax_post_format_add_meta_box\";s:2:\"on\";s:29:\"tax_post_format_custom_robots\";s:2:\"on\";s:27:\"tax_post_format_description\";s:18:\"%term_description%\";s:38:\"tax_post_format_slack_enhanced_sharing\";s:2:\"on\";s:32:\"tax_featured_item_category_title\";s:23:\"%term% %sep% %sitename%\";s:33:\"tax_featured_item_category_robots\";a:1:{i:0;s:5:\"index\";}s:39:\"tax_featured_item_category_add_meta_box\";s:2:\"on\";s:40:\"tax_featured_item_category_custom_robots\";s:3:\"off\";s:38:\"tax_featured_item_category_description\";s:18:\"%term_description%\";s:49:\"tax_featured_item_category_slack_enhanced_sharing\";s:2:\"on\";s:27:\"tax_featured_item_tag_title\";s:23:\"%term% %sep% %sitename%\";s:28:\"tax_featured_item_tag_robots\";a:1:{i:0;s:5:\"index\";}s:34:\"tax_featured_item_tag_add_meta_box\";s:2:\"on\";s:35:\"tax_featured_item_tag_custom_robots\";s:3:\"off\";s:33:\"tax_featured_item_tag_description\";s:18:\"%term_description%\";s:44:\"tax_featured_item_tag_slack_enhanced_sharing\";s:2:\"on\";s:13:\"robots_global\";a:1:{i:0;s:5:\"index\";}s:22:\"advanced_robots_global\";a:3:{s:11:\"max-snippet\";s:2:\"-1\";s:17:\"max-video-preview\";s:2:\"-1\";s:17:\"max-image-preview\";s:5:\"large\";}s:21:\"custom_image_overlays\";a:0:{}s:3:\"url\";s:23:\"https://mami.gameh5.xyz\";s:22:\"use_multiple_locations\";s:3:\"off\";s:13:\"phone_numbers\";a:1:{i:0;a:1:{s:4:\"type\";s:16:\"customer support\";}}s:11:\"price_range\";s:9:\"1-1000000\";s:18:\"hide_opening_hours\";s:3:\"off\";s:12:\"closed_label\";s:6:\"Closed\";s:9:\"open_24_7\";s:9:\"Open 24/7\";s:8:\"open_24h\";s:8:\"Open 24h\";s:8:\"map_unit\";s:10:\"kilometers\";s:9:\"map_style\";s:6:\"hybrid\";s:13:\"limit_results\";i:0;s:11:\"route_label\";s:8:\"My Route\";s:25:\"enable_location_detection\";s:3:\"off\";s:27:\"same_organization_locations\";s:3:\"off\";s:25:\"locations_enhanced_search\";s:3:\"off\";s:12:\"maps_api_key\";s:39:\"AIzaSyDajU5oceKF6U4QfRzjys7gC9DjoKqcryg\";s:24:\"locations_post_type_base\";s:9:\"locations\";s:23:\"locations_category_base\";s:18:\"locations-category\";s:25:\"locations_post_type_label\";s:12:\"RM Locations\";s:32:\"locations_post_type_plural_label\";s:12:\"RM Locations\";s:20:\"local_seo_about_page\";s:4:\"2649\";s:22:\"local_seo_contact_page\";s:4:\"2790\";s:31:\"tax_post_format_advanced_robots\";a:3:{s:11:\"max-snippet\";s:2:\"-1\";s:17:\"max-video-preview\";s:2:\"-1\";s:17:\"max-image-preview\";s:5:\"large\";}s:22:\"author_advanced_robots\";a:3:{s:11:\"max-snippet\";s:2:\"-1\";s:17:\"max-video-preview\";s:2:\"-1\";s:17:\"max-image-preview\";s:5:\"large\";}s:20:\"date_advanced_robots\";a:3:{s:11:\"max-snippet\";s:2:\"-1\";s:17:\"max-video-preview\";s:2:\"-1\";s:17:\"max-image-preview\";s:5:\"large\";}s:23:\"noindex_paginated_pages\";s:3:\"off\";s:24:\"pt_post_autodetect_video\";s:2:\"on\";s:26:\"pt_post_autogenerate_image\";s:3:\"off\";s:23:\"pt_post_advanced_robots\";a:3:{s:11:\"max-snippet\";s:2:\"-1\";s:17:\"max-video-preview\";s:2:\"-1\";s:17:\"max-image-preview\";s:5:\"large\";}s:24:\"pt_page_autodetect_video\";s:2:\"on\";s:26:\"pt_page_autogenerate_image\";s:3:\"off\";s:23:\"pt_page_advanced_robots\";a:3:{s:11:\"max-snippet\";s:2:\"-1\";s:17:\"max-video-preview\";s:2:\"-1\";s:17:\"max-image-preview\";s:5:\"large\";}s:26:\"pt_blocks_autodetect_video\";s:2:\"on\";s:28:\"pt_blocks_autogenerate_image\";s:3:\"off\";s:25:\"pt_blocks_advanced_robots\";a:3:{s:11:\"max-snippet\";s:2:\"-1\";s:17:\"max-video-preview\";s:2:\"-1\";s:17:\"max-image-preview\";s:5:\"large\";}s:33:\"pt_featured_item_autodetect_video\";s:2:\"on\";s:35:\"pt_featured_item_autogenerate_image\";s:3:\"off\";s:32:\"pt_featured_item_advanced_robots\";a:3:{s:11:\"max-snippet\";s:2:\"-1\";s:17:\"max-video-preview\";s:2:\"-1\";s:17:\"max-image-preview\";s:5:\"large\";}s:33:\"pt_featured_item_primary_taxonomy\";s:3:\"off\";s:28:\"tax_category_advanced_robots\";a:3:{s:11:\"max-snippet\";s:2:\"-1\";s:17:\"max-video-preview\";s:2:\"-1\";s:17:\"max-image-preview\";s:5:\"large\";}s:28:\"remove_category_snippet_data\";s:3:\"off\";s:28:\"tax_post_tag_advanced_robots\";a:3:{s:11:\"max-snippet\";s:2:\"-1\";s:17:\"max-video-preview\";s:2:\"-1\";s:17:\"max-image-preview\";s:5:\"large\";}s:28:\"remove_post_tag_snippet_data\";s:3:\"off\";s:42:\"tax_featured_item_category_advanced_robots\";a:3:{s:11:\"max-snippet\";s:2:\"-1\";s:17:\"max-video-preview\";s:2:\"-1\";s:17:\"max-image-preview\";s:5:\"large\";}s:42:\"remove_featured_item_category_snippet_data\";s:3:\"off\";s:37:\"tax_featured_item_tag_advanced_robots\";a:3:{s:11:\"max-snippet\";s:2:\"-1\";s:17:\"max-video-preview\";s:2:\"-1\";s:17:\"max-image-preview\";s:5:\"large\";}s:37:\"remove_featured_item_tag_snippet_data\";s:3:\"off\";s:12:\"website_name\";s:4:\"123B\";s:22:\"website_alternate_name\";s:28:\"123B - Nhà cái 123B Casino\";s:22:\"pt_sp_faq_add_meta_box\";s:2:\"on\";s:24:\"tax_faq_cat_add_meta_box\";s:2:\"on\";s:30:\"pt_sp_faq_default_rich_snippet\";s:3:\"off\";s:30:\"pt_sp_faq_default_article_type\";s:7:\"Article\";s:15:\"pt_sp_faq_title\";s:31:\"%title% %page% %sep% %sitename%\";s:21:\"pt_sp_faq_description\";s:9:\"%excerpt%\";s:23:\"pt_sp_faq_archive_title\";s:31:\"%title% %page% %sep% %sitename%\";s:30:\"pt_sp_faq_default_snippet_name\";s:11:\"%seo_title%\";s:30:\"pt_sp_faq_default_snippet_desc\";s:17:\"%seo_description%\";s:23:\"pt_sp_faq_custom_robots\";s:3:\"off\";s:16:\"pt_sp_faq_robots\";a:1:{i:0;s:5:\"index\";}s:25:\"pt_sp_faq_advanced_robots\";a:3:{s:11:\"max-snippet\";s:2:\"-1\";s:17:\"max-video-preview\";s:2:\"-1\";s:17:\"max-image-preview\";s:5:\"large\";}s:26:\"pt_sp_faq_link_suggestions\";s:2:\"on\";s:19:\"pt_sp_faq_ls_use_fk\";s:6:\"titles\";s:26:\"pt_sp_faq_primary_taxonomy\";s:3:\"off\";s:32:\"pt_sp_faq_slack_enhanced_sharing\";s:3:\"off\";s:22:\"pt_sp_faq_bulk_editing\";s:7:\"editing\";s:17:\"tax_faq_cat_title\";s:39:\"%term% Archives %page% %sep% %sitename%\";s:23:\"tax_faq_cat_description\";s:18:\"%term_description%\";s:25:\"tax_faq_cat_custom_robots\";s:3:\"off\";s:18:\"tax_faq_cat_robots\";a:1:{i:0;s:5:\"index\";}s:27:\"tax_faq_cat_advanced_robots\";a:3:{s:11:\"max-snippet\";s:2:\"-1\";s:17:\"max-video-preview\";s:2:\"-1\";s:17:\"max-image-preview\";s:5:\"large\";}s:34:\"tax_faq_cat_slack_enhanced_sharing\";s:2:\"on\";s:27:\"remove_faq_cat_snippet_data\";s:3:\"off\";}", "yes");
INSERT INTO `wp_options` VALUES("2095", "rank-math-options-sitemap", "a:27:{s:14:\"items_per_page\";s:3:\"200\";s:14:\"include_images\";s:2:\"on\";s:22:\"include_featured_image\";s:2:\"on\";s:19:\"ping_search_engines\";s:2:\"on\";s:13:\"exclude_roles\";a:2:{s:11:\"contributor\";s:11:\"Contributor\";s:10:\"subscriber\";s:10:\"Subscriber\";}s:15:\"pt_post_sitemap\";s:2:\"on\";s:15:\"pt_page_sitemap\";s:2:\"on\";s:21:\"pt_attachment_sitemap\";s:3:\"off\";s:17:\"pt_blocks_sitemap\";s:2:\"on\";s:24:\"pt_featured_item_sitemap\";s:3:\"off\";s:18:\"pt_product_sitemap\";s:2:\"on\";s:20:\"pt_web-story_sitemap\";s:3:\"off\";s:20:\"tax_category_sitemap\";s:2:\"on\";s:20:\"tax_post_tag_sitemap\";s:3:\"off\";s:23:\"tax_post_format_sitemap\";s:3:\"off\";s:34:\"tax_featured_item_category_sitemap\";s:3:\"off\";s:29:\"tax_featured_item_tag_sitemap\";s:3:\"off\";s:23:\"video_sitemap_post_type\";a:5:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:10:\"attachment\";i:3;s:6:\"blocks\";i:4;s:13:\"featured_item\";}s:18:\"include_acf_images\";s:3:\"off\";s:26:\"tax_category_include_empty\";s:3:\"off\";s:26:\"tax_post_tag_include_empty\";s:3:\"off\";s:40:\"tax_featured_item_category_include_empty\";s:3:\"off\";s:35:\"tax_featured_item_tag_include_empty\";s:3:\"off\";s:13:\"local_sitemap\";s:3:\"off\";s:15:\"authors_sitemap\";s:2:\"on\";s:17:\"pt_sp_faq_sitemap\";s:2:\"on\";s:19:\"tax_faq_cat_sitemap\";s:3:\"off\";}", "yes");
INSERT INTO `wp_options` VALUES("2096", "rank-math-options-instant-indexing", "a:2:{s:15:\"bing_post_types\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:16:\"indexnow_api_key\";s:32:\"3af1a6566f4d4ba284e2a56a0e5c7c1b\";}", "yes");
INSERT INTO `wp_options` VALUES("2099", "rank_math_version", "1.0.109", "yes");
INSERT INTO `wp_options` VALUES("2100", "rank_math_db_version", "1", "yes");
INSERT INTO `wp_options` VALUES("2101", "rank_math_install_date", "1646709047", "yes");
INSERT INTO `wp_options` VALUES("2103", "action_scheduler_lock_async-request-runner", "1679127900", "yes");
INSERT INTO `wp_options` VALUES("2114", "widget_ezw_tco", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("2131", "wpcf7", "a:2:{s:7:\"version\";s:5:\"5.7.4\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1646709091;s:7:\"version\";s:5:\"5.5.6\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("2138", "wpel-first-install", "1646709093", "yes");
INSERT INTO `wp_options` VALUES("2148", "rank_math_registration_skip", "1", "yes");
INSERT INTO `wp_options` VALUES("2149", "rank_math_review_notice_date", "1647918739", "no");
INSERT INTO `wp_options` VALUES("2151", "rank_math_review_posts_converted", "1", "yes");
INSERT INTO `wp_options` VALUES("2153", "rank_math_pro_version", "3.0.0", "yes");
INSERT INTO `wp_options` VALUES("2156", "rank_math_pro_google_updates", "[{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/march-2023-core-algorithm-update\\/\",\"title\":\"March 2023 Core Algorithm Update\",\"content\":\"Google announced rolling out the core algorithm update on March 15, 2023. The rollout will take two weeks to complete.\",\"date\":\"1678838400\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/february-2023-product-reviews-update\\/\",\"title\":\"February 2023 Product Reviews Update\",\"content\":\"Google rolled out a product reviews update on February 22, 2023. The update expands to many languages in addition to just English and was completed on March 7, 2023.\",\"date\":\"1676937600\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/google-search-ranking-algorithm-feb-13th-14th-2023\\/\",\"title\":\"Unconfirmed Google Search Ranking Algorithm Update–February 13th and 14th, 2023\",\"content\":\"Google may have rolled out another unconfirmed Google search ranking algorithm update around February 13th, and tracking tools are showing huge spikes.\",\"date\":\"1676246400\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/google-search-ranking-feb-8th-9th-2023\\/\",\"title\":\"Unconfirmed Google Search Ranking Algorithm Update- February 8th and 9th 2023\",\"content\":\"Google may have rolled out another unconfirmed Google search ranking algorithm update around February 8th and 9th, and tracking tools are showing big spikes.\",\"date\":\"1675814400\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/unconfirmed-search-ranking-feb-3rd-4th\\/\",\"title\":\"Unconfirmed Google Search Ranking Algorithm Update - February 3rd and 4th\",\"content\":\"Google may have rolled out another unconfirmed Google search ranking algorithm update around February 3 and continued till February 4. The tracking tools are showing big spikes.\",\"date\":\"1675382400\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/december-2022-link-spam-update\\/\",\"title\":\"December 2022 Link Spam Update\",\"content\":\"Google is rolling out a link spam update on Dec 14, 2022. This update aims to identify and nullify link spam more broadly across multiple languages. The update took 29 days to roll out and was completed on January 12, 2023. \",\"date\":\"1670976000\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/december-2022-helpful-content-update\\/\",\"title\":\"December 2022 Helpful Content Update\",\"content\":\"Google announced another Helpful Content Update on December 5, 2022, which improves the classifier and works across all content globally in all languages. The update was completed on January 12, 2023.\\r\\n\",\"date\":\"1670198400\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/unconfirmed-search-ranking-nov-4th-5th\\/\",\"title\":\"Unconfirmed Google Search Ranking Algorithm Update - November 4th and 5th\",\"content\":\"Google may have rolled out another unconfirmed Google search ranking update around November 4th and 5th, and the tracking tools are showing big spikes.\",\"date\":\"1667520000\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/search-ranking-algorithm-update-oct-28\\/\",\"title\":\"Google Search Ranking Algorithm Update\\/ Adjustment On October 28\",\"content\":\"Google rolled out another search ranking update around October 28th that may have disrupted the search ranking algorithm. Users are noticing big swings in terms of their Google rankings and traffic.\",\"date\":\"1666915200\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/october-2022-spam-update\\/\",\"title\":\"October 2022 Spam Update\",\"content\":\"Google rolled out a new search ranking algorithm on October 19, 2022. The update targeted the more spammy side of the search results, and the rollout was completed on October 21, 2022.\",\"date\":\"1666137600\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/unconfirmed-search-ranking-oct-2022\\/\",\"title\":\"Unconfirmed Google Search Ranking Algorithm Update (October 2022)\",\"content\":\"Google may have rolled out a search ranking update around October 13th. Users have reported traffic changes from Google’s organic sources and Google Search over the past day or two. \",\"date\":\"1665619200\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/product-reviews-update-sep-2022\\/\",\"title\":\"September 2022 Product Reviews Algorithm Update\",\"content\":\"Google announced its fifth Product Reviews algorithm update on September 20, 2022. This update aims to reward product reviews that are most helpful to searchers. The update finished rolling out on Sep 26, 2022.\",\"date\":\"1663632000\",\"status\":\"confirmed\"}]", "no");
INSERT INTO `wp_options` VALUES("2161", "rank_math_content_ai_viewed", "1", "yes");
INSERT INTO `wp_options` VALUES("2162", "rank_math_yoast_block_posts", "a:2:{s:5:\"posts\";a:0:{}s:5:\"count\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("2163", "rank_math_old_schema_data", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2165", "rank_math_analytics_installed", "1", "yes");
INSERT INTO `wp_options` VALUES("2166", "rank_math_analytics_pro_installed", "1", "yes");
INSERT INTO `wp_options` VALUES("2167", "rank_math_ca_credits", "0", "no");
INSERT INTO `wp_options` VALUES("2191", "rank_math_indexnow_log", "a:100:{i:0;a:5:{s:3:\"url\";s:36:\"https://mami.gameh5.xyz/casino-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678183193;}i:1;a:5:{s:3:\"url\";s:38:\"https://mami.gameh5.xyz/rut-tien-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678204649;}i:2;a:5:{s:3:\"url\";s:38:\"https://mami.gameh5.xyz/nap-tien-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678204651;}i:3;a:5:{s:3:\"url\";s:39:\"https://mami.gameh5.xyz/dang-nhap-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678204653;}i:4;a:5:{s:3:\"url\";s:37:\"https://mami.gameh5.xyz/dang-ky-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678204656;}i:5;a:5:{s:3:\"url\";s:37:\"https://mami.gameh5.xyz/tai-app-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678204658;}i:6;a:5:{s:3:\"url\";s:44:\"https://mami.gameh5.xyz/xo-so-mien-bac-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678204660;}i:7;a:5:{s:3:\"url\";s:44:\"https://mami.gameh5.xyz/xo-so-mien-nam-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678204663;}i:8;a:5:{s:3:\"url\";s:46:\"https://mami.gameh5.xyz/xo-so-mien-trung-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678204665;}i:9;a:5:{s:3:\"url\";s:52:\"https://mami.gameh5.xyz/dien-dan-ca-do-bong-da-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678204668;}i:10;a:5:{s:3:\"url\";s:24:\"https://mami.gameh5.xyz/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678236039;}i:11;a:5:{s:3:\"url\";s:57:\"https://mami.gameh5.xyz/cach-tinh-ty-le-keo-bong-da-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678328324;}i:12;a:5:{s:3:\"url\";s:57:\"https://mami.gameh5.xyz/cach-tinh-ty-le-keo-bong-da-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678328724;}i:13;a:5:{s:3:\"url\";s:37:\"https://mami.gameh5.xyz/?page_id=2971\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678347495;}i:14;a:5:{s:3:\"url\";s:50:\"https://mami.gameh5.xyz/khuyen-mai-hang-ngay-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678372920;}i:15;a:5:{s:3:\"url\";s:50:\"https://mami.gameh5.xyz/khuyen-mai-hang-ngay-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678374771;}i:16;a:5:{s:3:\"url\";s:50:\"https://mami.gameh5.xyz/khuyen-mai-hang-ngay-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678374819;}i:17;a:5:{s:3:\"url\";s:50:\"https://mami.gameh5.xyz/khuyen-mai-hang-ngay-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678375306;}i:18;a:5:{s:3:\"url\";s:50:\"https://mami.gameh5.xyz/khuyen-mai-hang-ngay-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678375473;}i:19;a:5:{s:3:\"url\";s:47:\"https://mami.gameh5.xyz/vong-quay-may-man-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678377028;}i:20;a:5:{s:3:\"url\";s:48:\"https://mami.gameh5.xyz/nhan-qua-sinh-nhat-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678378559;}i:21;a:5:{s:3:\"url\";s:48:\"https://mami.gameh5.xyz/nhan-qua-sinh-nhat-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678416828;}i:22;a:5:{s:3:\"url\";s:36:\"https://mami.gameh5.xyz/ban-ca-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678418366;}i:23;a:5:{s:3:\"url\";s:44:\"https://mami.gameh5.xyz/xo-so-mien-bac-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678418511;}i:24;a:5:{s:3:\"url\";s:24:\"https://mami.gameh5.xyz/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678433314;}i:25;a:5:{s:3:\"url\";s:55:\"https://mami.gameh5.xyz/khuyen-mai-hoan-tien-cuoc-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678434621;}i:26;a:5:{s:3:\"url\";s:55:\"https://mami.gameh5.xyz/khuyen-mai-hoan-tien-cuoc-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678434673;}i:27;a:5:{s:3:\"url\";s:55:\"https://mami.gameh5.xyz/khuyen-mai-hoan-tien-cuoc-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678435047;}i:28;a:5:{s:3:\"url\";s:24:\"https://mami.gameh5.xyz/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678435874;}i:29;a:5:{s:3:\"url\";s:38:\"https://mami.gameh5.xyz/game-bai-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678768177;}i:30;a:5:{s:3:\"url\";s:37:\"https://mami.gameh5.xyz/dang-ky-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678768789;}i:31;a:5:{s:3:\"url\";s:47:\"https://mami.gameh5.xyz/vong-quay-may-man-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678793548;}i:32;a:5:{s:3:\"url\";s:38:\"https://mami.gameh5.xyz/the-thao-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678793961;}i:33;a:5:{s:3:\"url\";s:36:\"https://mami.gameh5.xyz/casino-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678794111;}i:34;a:5:{s:3:\"url\";s:38:\"https://mami.gameh5.xyz/game-bai-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678794971;}i:35;a:5:{s:3:\"url\";s:36:\"https://mami.gameh5.xyz/ban-ca-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678795085;}i:36;a:5:{s:3:\"url\";s:48:\"https://mami.gameh5.xyz/nhan-qua-sinh-nhat-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678795466;}i:37;a:5:{s:3:\"url\";s:55:\"https://mami.gameh5.xyz/khuyen-mai-hoan-tien-cuoc-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678795999;}i:38;a:5:{s:3:\"url\";s:47:\"https://mami.gameh5.xyz/vong-quay-may-man-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678798932;}i:39;a:5:{s:3:\"url\";s:42:\"https://mami.gameh5.xyz/le-hoi-xo-so-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678807843;}i:40;a:5:{s:3:\"url\";s:42:\"https://mami.gameh5.xyz/le-hoi-xo-so-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678807950;}i:41;a:5:{s:3:\"url\";s:42:\"https://mami.gameh5.xyz/le-hoi-xo-so-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678808036;}i:42;a:5:{s:3:\"url\";s:47:\"https://mami.gameh5.xyz/khuyen-mai-ban-ca-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678856453;}i:43;a:5:{s:3:\"url\";s:40:\"https://mami.gameh5.xyz/khuyen-mai-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678867307;}i:44;a:5:{s:3:\"url\";s:40:\"https://mami.gameh5.xyz/khuyen-mai-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678872098;}i:45;a:5:{s:3:\"url\";s:40:\"https://mami.gameh5.xyz/khuyen-mai-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678872113;}i:46;a:5:{s:3:\"url\";s:40:\"https://mami.gameh5.xyz/khuyen-mai-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678872702;}i:47;a:5:{s:3:\"url\";s:40:\"https://mami.gameh5.xyz/khuyen-mai-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678872891;}i:48;a:5:{s:3:\"url\";s:35:\"https://mami.gameh5.xyz/xo-so-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678872921;}i:49;a:5:{s:3:\"url\";s:35:\"https://mami.gameh5.xyz/xo-so-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678872930;}i:50;a:5:{s:3:\"url\";s:35:\"https://mami.gameh5.xyz/xo-so-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678873008;}i:51;a:5:{s:3:\"url\";s:38:\"https://mami.gameh5.xyz/the-thao-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678873018;}i:52;a:5:{s:3:\"url\";s:35:\"https://mami.gameh5.xyz/xo-so-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678873023;}i:53;a:5:{s:3:\"url\";s:38:\"https://mami.gameh5.xyz/the-thao-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678873024;}i:54;a:5:{s:3:\"url\";s:38:\"https://mami.gameh5.xyz/game-bai-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678873056;}i:55;a:5:{s:3:\"url\";s:38:\"https://mami.gameh5.xyz/game-bai-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678873063;}i:56;a:5:{s:3:\"url\";s:38:\"https://mami.gameh5.xyz/game-bai-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678873075;}i:57;a:5:{s:3:\"url\";s:36:\"https://mami.gameh5.xyz/ban-ca-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678873112;}i:58;a:5:{s:3:\"url\";s:35:\"https://mami.gameh5.xyz/xo-so-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678873150;}i:59;a:5:{s:3:\"url\";s:38:\"https://mami.gameh5.xyz/the-thao-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678873173;}i:60;a:5:{s:3:\"url\";s:36:\"https://mami.gameh5.xyz/casino-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678873214;}i:61;a:5:{s:3:\"url\";s:36:\"https://mami.gameh5.xyz/casino-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678873224;}i:62;a:5:{s:3:\"url\";s:37:\"https://mami.gameh5.xyz/123b-lua-dao/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678878557;}i:63;a:5:{s:3:\"url\";s:42:\"https://mami.gameh5.xyz/le-hoi-xo-so-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678933976;}i:64;a:5:{s:3:\"url\";s:45:\"https://mami.gameh5.xyz/thuat-ngu-no-hu-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678942897;}i:65;a:5:{s:3:\"url\";s:47:\"https://mami.gameh5.xyz/khuyen-mai-ban-ca-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1678984250;}i:66;a:5:{s:3:\"url\";s:46:\"https://mami.gameh5.xyz/cach-choi-ban-ca-123b/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679030724;}i:67;a:5:{s:3:\"url\";s:37:\"https://mami.gameh5.xyz/?page_id=2648\";s:6:\"status\";i:202;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040145;}i:68;a:5:{s:3:\"url\";s:37:\"https://mami.gameh5.xyz/?page_id=2931\";s:6:\"status\";i:202;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040146;}i:69;a:5:{s:3:\"url\";s:37:\"https://mami.gameh5.xyz/?page_id=2660\";s:6:\"status\";i:202;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040146;}i:70;a:5:{s:3:\"url\";s:37:\"https://mami.gameh5.xyz/?page_id=2738\";s:6:\"status\";i:202;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040147;}i:71;a:5:{s:3:\"url\";s:37:\"https://mami.gameh5.xyz/?page_id=2649\";s:6:\"status\";i:202;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040147;}i:72;a:5:{s:3:\"url\";s:37:\"https://mami.gameh5.xyz/?page_id=2712\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040148;}i:73;a:5:{s:3:\"url\";s:37:\"https://mami.gameh5.xyz/?page_id=2790\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040148;}i:74;a:5:{s:3:\"url\";s:37:\"https://mami.gameh5.xyz/?page_id=3094\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040149;}i:75;a:5:{s:3:\"url\";s:37:\"https://mami.gameh5.xyz/?page_id=2796\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040149;}i:76;a:5:{s:3:\"url\";s:37:\"https://mami.gameh5.xyz/?page_id=2654\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040150;}i:77;a:5:{s:3:\"url\";s:31:\"https://mami.gameh5.xyz/?p=3140\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040180;}i:78;a:5:{s:3:\"url\";s:31:\"https://mami.gameh5.xyz/?p=3131\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040180;}i:79;a:5:{s:3:\"url\";s:31:\"https://mami.gameh5.xyz/?p=3115\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040181;}i:80;a:5:{s:3:\"url\";s:31:\"https://mami.gameh5.xyz/?p=3085\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040181;}i:81;a:5:{s:3:\"url\";s:31:\"https://mami.gameh5.xyz/?p=3076\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040182;}i:82;a:5:{s:3:\"url\";s:31:\"https://mami.gameh5.xyz/?p=3044\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040183;}i:83;a:5:{s:3:\"url\";s:31:\"https://mami.gameh5.xyz/?p=3031\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040184;}i:84;a:5:{s:3:\"url\";s:31:\"https://mami.gameh5.xyz/?p=3024\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040184;}i:85;a:5:{s:3:\"url\";s:31:\"https://mami.gameh5.xyz/?p=3013\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040185;}i:86;a:5:{s:3:\"url\";s:31:\"https://mami.gameh5.xyz/?p=3002\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040185;}i:87;a:5:{s:3:\"url\";s:31:\"https://mami.gameh5.xyz/?p=2892\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040186;}i:88;a:5:{s:3:\"url\";s:31:\"https://mami.gameh5.xyz/?p=2882\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040186;}i:89;a:5:{s:3:\"url\";s:31:\"https://mami.gameh5.xyz/?p=2871\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040187;}i:90;a:5:{s:3:\"url\";s:31:\"https://mami.gameh5.xyz/?p=2850\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040187;}i:91;a:5:{s:3:\"url\";s:31:\"https://mami.gameh5.xyz/?p=2831\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040188;}i:92;a:5:{s:3:\"url\";s:31:\"https://mami.gameh5.xyz/?p=2457\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040188;}i:93;a:5:{s:3:\"url\";s:31:\"https://mami.gameh5.xyz/?p=2472\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040189;}i:94;a:5:{s:3:\"url\";s:31:\"https://mami.gameh5.xyz/?p=2476\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679040189;}i:95;a:5:{s:3:\"url\";s:24:\"https://mami.gameh5.xyz/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679122658;}i:96;a:5:{s:3:\"url\";s:24:\"https://mami.gameh5.xyz/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679122891;}i:97;a:5:{s:3:\"url\";s:24:\"https://mami.gameh5.xyz/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679122934;}i:98;a:5:{s:3:\"url\";s:24:\"https://mami.gameh5.xyz/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679122962;}i:99;a:5:{s:3:\"url\";s:24:\"https://mami.gameh5.xyz/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1679123393;}}", "no");
INSERT INTO `wp_options` VALUES("2720", "litespeed.conf.__activation", "4.4.7", "yes");
INSERT INTO `wp_options` VALUES("2721", "litespeed.purge.queue", "X-LiteSpeed-Purge: public,4c8_", "yes");
INSERT INTO `wp_options` VALUES("2722", "litespeed.purge.queue2", "-1", "yes");
INSERT INTO `wp_options` VALUES("2723", "litespeed.optimize.timestamp_purge_css", "1646799247", "yes");
INSERT INTO `wp_options` VALUES("2724", "litespeed.gui.lscwp_whm_install", "-1", "yes");
INSERT INTO `wp_options` VALUES("2725", "litespeed.cloud._summary", "{\"curr_request.ver\":0,\"last_request.ver\":1646799247}", "yes");
INSERT INTO `wp_options` VALUES("2826", "new_admin_email", "moto88dev@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("2876", "https_migration_required", "1", "yes");
INSERT INTO `wp_options` VALUES("3395", "easy-watermark-version", "1.0.11", "yes");
INSERT INTO `wp_options` VALUES("3410", "pmr_options", "a:1:{s:20:\"pmr_update_revisions\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("3411", "Activated_phoenix_media_rename", "phoenix-media-rename", "yes");
INSERT INTO `wp_options` VALUES("3412", "pmr_update_db_table", "1.0.1", "yes");
INSERT INTO `wp_options` VALUES("3413", "pmr_table_installed", "1", "yes");
INSERT INTO `wp_options` VALUES("3414", "pmr_db_version", "1.0.1", "yes");
INSERT INTO `wp_options` VALUES("3571", "rank_math_is_configured", "1", "yes");
INSERT INTO `wp_options` VALUES("3648", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:18:\"Cskhhi88@gmail.com\";s:7:\"version\";s:5:\"6.1.1\";s:9:\"timestamp\";i:1676862323;}", "no");
INSERT INTO `wp_options` VALUES("4736", "wp_calendar_block_has_published_posts", "1", "yes");
INSERT INTO `wp_options` VALUES("7305", "rank_math_google_analytic_profile", "a:3:{s:7:\"country\";s:3:\"all\";s:7:\"profile\";b:0;s:19:\"enable_index_status\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("7306", "rank_math_analytics_all_services", "a:1:{s:5:\"sites\";a:1:{i:0;b:0;}}", "yes");
INSERT INTO `wp_options` VALUES("7307", "rank_math_google_analytic_options", "a:10:{s:10:\"account_id\";b:0;s:11:\"property_id\";b:0;s:7:\"view_id\";b:0;s:14:\"measurement_id\";b:0;s:11:\"stream_name\";b:0;s:7:\"country\";s:3:\"all\";s:12:\"install_code\";b:0;s:12:\"anonymize_ip\";b:0;s:11:\"local_ga_js\";b:0;s:16:\"exclude_loggedin\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("7526", "rank_math_review_notice_added", "1", "no");
INSERT INTO `wp_options` VALUES("7724", "fm_key", "tj34rsk69BvHD1d5TLbIFmZhY", "yes");
INSERT INTO `wp_options` VALUES("7735", "filemanager_email_verified_1", "yes", "yes");
INSERT INTO `wp_options` VALUES("8820", "wp_automatic_license", "4308eedb-1add-43a9-bbba-6f5d5aa6b8ee", "yes");
INSERT INTO `wp_options` VALUES("8821", "wp_automatic_license_active", "active", "yes");
INSERT INTO `wp_options` VALUES("8822", "wp_automatic_license_active_date", "1649917339", "yes");
INSERT INTO `wp_options` VALUES("8823", "alb_license_active", "1", "yes");
INSERT INTO `wp_options` VALUES("8824", "alb_license_last", "01-01-2030", "yes");
INSERT INTO `wp_options` VALUES("8825", "wp_automatic_envato_token", "4308eedb-1add-43a9-bbba-6f5d5aa6b8ee", "yes");
INSERT INTO `wp_options` VALUES("8826", "wp_automatic_version", "202", "yes");
INSERT INTO `wp_options` VALUES("8828", "external_updates-wp-automatic", "O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1649917324;s:14:\"checkedVersion\";s:6:\"3.53.3\";s:6:\"update\";O:8:\"stdClass\":10:{s:4:\"slug\";s:12:\"wp-automatic\";s:7:\"version\";s:6:\"3.55.4\";s:12:\"download_url\";s:97:\"http://deandev.com/upgrades/plugin_update.php?id=1904470&key=4308eedb-1add-43a9-bbba-6f5d5aa6b8ee\";s:12:\"translations\";a:0:{}s:2:\"id\";i:0;s:8:\"homepage\";s:29:\"https://1.envato.market/rqbgD\";s:6:\"tested\";s:5:\"5.9.3\";s:14:\"upgrade_notice\";s:63:\"Upgrade to the most recent version for new features and more...\";s:5:\"icons\";a:0:{}s:8:\"filename\";s:29:\"wp-automatic/wp-automatic.php\";}s:11:\"updateClass\";s:22:\"Puc_v4p9_Plugin_Update\";s:15:\"updateBaseClass\";s:13:\"Plugin_Update\";}", "no");
INSERT INTO `wp_options` VALUES("8829", "wp_automatic_version_updated", "1649526506", "yes");
INSERT INTO `wp_options` VALUES("8830", "wp_automatic_version_last", "3.53.3", "yes");
INSERT INTO `wp_options` VALUES("8922", "gm_last_processed", "781", "yes");
INSERT INTO `wp_options` VALUES("8923", "wp_automatic_cjn", "rIzx7seU0D_E7AIbYhXm1", "yes");
INSERT INTO `wp_options` VALUES("11405", "rank_math_pro_notice_delayed", "1", "no");
INSERT INTO `wp_options` VALUES("11406", "rank_math_pro_notice_date", "1650229665", "no");
INSERT INTO `wp_options` VALUES("13970", "options_bottom_menu_0_text", "Điện thoại liên lạc", "no");
INSERT INTO `wp_options` VALUES("13971", "_options_bottom_menu_0_text", "field_6263f3e036722", "no");
INSERT INTO `wp_options` VALUES("13972", "options_bottom_menu_0_link", "", "no");
INSERT INTO `wp_options` VALUES("13973", "_options_bottom_menu_0_link", "field_6263f3e536723", "no");
INSERT INTO `wp_options` VALUES("13974", "options_bottom_menu_1_text", "", "no");
INSERT INTO `wp_options` VALUES("13975", "_options_bottom_menu_1_text", "field_6263f3e036722", "no");
INSERT INTO `wp_options` VALUES("13976", "options_bottom_menu_1_link", "", "no");
INSERT INTO `wp_options` VALUES("13977", "_options_bottom_menu_1_link", "field_6263f3e536723", "no");
INSERT INTO `wp_options` VALUES("13978", "options_bottom_menu_2_text", "ĐẠI LÝ", "no");
INSERT INTO `wp_options` VALUES("13979", "_options_bottom_menu_2_text", "field_6263f3e036722", "no");
INSERT INTO `wp_options` VALUES("13980", "options_bottom_menu_2_link", "", "no");
INSERT INTO `wp_options` VALUES("13981", "_options_bottom_menu_2_link", "field_6263f3e536723", "no");
INSERT INTO `wp_options` VALUES("13990", "options_bottom_menu", "5", "no");
INSERT INTO `wp_options` VALUES("13991", "_options_bottom_menu", "field_6263f3d536721", "no");
INSERT INTO `wp_options` VALUES("13996", "options_list_contact_2_icon_contact", "2361", "no");
INSERT INTO `wp_options` VALUES("13997", "_options_list_contact_2_icon_contact", "field_6224dcbc7a8b1", "no");
INSERT INTO `wp_options` VALUES("13998", "options_list_contact_2_link_contact", "", "no");
INSERT INTO `wp_options` VALUES("13999", "_options_list_contact_2_link_contact", "field_6224dcc97a8b2", "no");
INSERT INTO `wp_options` VALUES("14000", "options_list_contact_2_title_contact", "Tải App ", "no");
INSERT INTO `wp_options` VALUES("14001", "_options_list_contact_2_title_contact", "field_6224dd367a163", "no");
INSERT INTO `wp_options` VALUES("14760", "PMXE_Plugin_Options", "a:15:{s:12:\"info_api_url\";s:27:\"https://www.wpallimport.com\";s:7:\"dismiss\";i:0;s:18:\"dismiss_manage_top\";i:0;s:21:\"dismiss_manage_bottom\";i:0;s:12:\"cron_job_key\";s:12:\"PwUhp5ltJ9y1\";s:14:\"max_input_time\";i:-1;s:18:\"max_execution_time\";i:0;s:6:\"secure\";i:1;s:7:\"license\";s:0:\"\";s:14:\"license_status\";s:0:\"\";s:18:\"scheduling_license\";s:0:\"\";s:25:\"scheduling_license_status\";s:0:\"\";s:14:\"zapier_api_key\";s:32:\"uIMZcUPWwKv5elO2gtrRQVL2swIl01Hm\";s:21:\"zapier_invitation_url\";s:0:\"\";s:30:\"zapier_invitation_url_received\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("14761", "wp_all_export_free_addons_not_included", "1", "yes");
INSERT INTO `wp_options` VALUES("14762", "wp_all_export_free_db_version", "1.3.9", "yes");
INSERT INTO `wp_options` VALUES("16229", "adminhash", "a:2:{s:4:\"hash\";s:32:\"d9949800b95b2e451baa7c6741e5dad1\";s:8:\"newemail\";s:19:\"moto88dev@gmail.com\";}", "yes");
INSERT INTO `wp_options` VALUES("21536", "tablepress_plugin_options", "{\"plugin_options_db_version\":53,\"table_scheme_db_version\":3,\"prev_tablepress_version\":\"1.14\",\"tablepress_version\":\"2.0.4\",\"first_activation\":1653292114,\"message_plugin_update\":true,\"message_donation_nag\":true,\"use_custom_css\":true,\"use_custom_css_file\":true,\"custom_css\":\"\",\"custom_css_minified\":\"\",\"custom_css_version\":0,\"modules\":false}", "yes");
INSERT INTO `wp_options` VALUES("21780", "tablepress_tables", "{\"last_id\":27,\"table_post\":{\"24\":2639,\"25\":2706,\"26\":2726,\"27\":2748}}", "yes");
INSERT INTO `wp_options` VALUES("21875", "filemanager_email_verified_2", "yes", "yes");
INSERT INTO `wp_options` VALUES("40102", "user_count", "1", "no");
INSERT INTO `wp_options` VALUES("40103", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("41429", "can_compress_scripts", "1", "no");
INSERT INTO `wp_options` VALUES("49983", "rank_math_pro_notice_added", "1", "no");
INSERT INTO `wp_options` VALUES("50227", "options_logo_game", "2348", "no");
INSERT INTO `wp_options` VALUES("50228", "_options_logo_game", "field_62246d8955cc4", "no");
INSERT INTO `wp_options` VALUES("50229", "options_desc_footer", "<div class=\"spec spec1\" style=\"text-align: center;\" data-v-5cc8d818=\"\">Cờ bạc có thể gây nghiện, hãy chơi có trách nhiệm. Để biết thông tin về các biện pháp hỗ trợ, vui lòng truy cập trang trợ giúp của chúng tôi.</div>\r\n<div class=\"spec spec2\" style=\"text-align: center;\" data-v-5cc8d818=\"\">Chúng tôi được cấp giấy phép hợp pháp do Ủy ban Giám sát GC（GamblingCommission）của Vương quốc Anh (MGA) và (PAGCOR) do Chính phủ Philippines cấp. Công ty đăng ký tại Quần đảo Virgin thuộc Anh, được các hiệp hội quốc tế công nhận. Vui lòng đảm bảo bạn đủ 18 tuổi trở lên trước khi đăng ký tham gia trò chơi!</div>", "no");
INSERT INTO `wp_options` VALUES("50230", "_options_desc_footer", "field_62fb3f97907ea", "no");
INSERT INTO `wp_options` VALUES("50970", "options_logo_bank", "2347", "no");
INSERT INTO `wp_options` VALUES("50971", "_options_logo_bank", "field_63f32c652aac6", "no");
INSERT INTO `wp_options` VALUES("50981", "options_bottom_menu_0_icon_menu", "2350", "no");
INSERT INTO `wp_options` VALUES("50982", "_options_bottom_menu_0_icon_menu", "field_63f32e545ca0e", "no");
INSERT INTO `wp_options` VALUES("50983", "options_bottom_menu_1_icon_menu", "2351", "no");
INSERT INTO `wp_options` VALUES("50984", "_options_bottom_menu_1_icon_menu", "field_63f32e545ca0e", "no");
INSERT INTO `wp_options` VALUES("50985", "options_bottom_menu_2_icon_menu", "2352", "no");
INSERT INTO `wp_options` VALUES("50986", "_options_bottom_menu_2_icon_menu", "field_63f32e545ca0e", "no");
INSERT INTO `wp_options` VALUES("50987", "options_bottom_menu_3_icon_menu", "2353", "no");
INSERT INTO `wp_options` VALUES("50988", "_options_bottom_menu_3_icon_menu", "field_63f32e545ca0e", "no");
INSERT INTO `wp_options` VALUES("50989", "options_bottom_menu_3_text", "Hướng dẫn chống hack DNS", "no");
INSERT INTO `wp_options` VALUES("50990", "_options_bottom_menu_3_text", "field_6263f3e036722", "no");
INSERT INTO `wp_options` VALUES("50991", "options_bottom_menu_3_link", "Hướng dẫn chống hack DNS", "no");
INSERT INTO `wp_options` VALUES("50992", "_options_bottom_menu_3_link", "field_6263f3e536723", "no");
INSERT INTO `wp_options` VALUES("50993", "options_bottom_menu_4_icon_menu", "2354", "no");
INSERT INTO `wp_options` VALUES("50994", "_options_bottom_menu_4_icon_menu", "field_63f32e545ca0e", "no");
INSERT INTO `wp_options` VALUES("50995", "options_bottom_menu_4_text", "Chăm Sóc Khách Hàng", "no");
INSERT INTO `wp_options` VALUES("50996", "_options_bottom_menu_4_text", "field_6263f3e036722", "no");
INSERT INTO `wp_options` VALUES("50997", "options_bottom_menu_4_link", "Chăm Sóc Khách Hàng", "no");
INSERT INTO `wp_options` VALUES("50998", "_options_bottom_menu_4_link", "field_6263f3e536723", "no");
INSERT INTO `wp_options` VALUES("51128", "options_list_contact_3_icon_contact", "2362", "no");
INSERT INTO `wp_options` VALUES("51129", "_options_list_contact_3_icon_contact", "field_6224dcbc7a8b1", "no");
INSERT INTO `wp_options` VALUES("51130", "options_list_contact_3_link_contact", "", "no");
INSERT INTO `wp_options` VALUES("51131", "_options_list_contact_3_link_contact", "field_6224dcc97a8b2", "no");
INSERT INTO `wp_options` VALUES("51132", "options_list_contact_3_title_contact", "Liên hệ ", "no");
INSERT INTO `wp_options` VALUES("51133", "_options_list_contact_3_title_contact", "field_6224dd367a163", "no");
INSERT INTO `wp_options` VALUES("51354", "rank_math_already_upgraded", "1676915498", "yes");
INSERT INTO `wp_options` VALUES("51534", "options_list_social_0_icon", "<i class=\"fab fa-facebook\"></i>", "no");
INSERT INTO `wp_options` VALUES("51535", "_options_list_social_0_icon", "field_63f40e2cc4d0d", "no");
INSERT INTO `wp_options` VALUES("51536", "options_list_social_0_name", "Facebook", "no");
INSERT INTO `wp_options` VALUES("51537", "_options_list_social_0_name", "field_63f40e34c4d0e", "no");
INSERT INTO `wp_options` VALUES("51538", "options_list_social_0_link", "", "no");
INSERT INTO `wp_options` VALUES("51539", "_options_list_social_0_link", "field_63f40e3ec4d0f", "no");
INSERT INTO `wp_options` VALUES("51540", "options_list_social_1_icon", "<i class=\"fab fa-twitter\"></i>", "no");
INSERT INTO `wp_options` VALUES("51541", "_options_list_social_1_icon", "field_63f40e2cc4d0d", "no");
INSERT INTO `wp_options` VALUES("51542", "options_list_social_1_name", "Twitter", "no");
INSERT INTO `wp_options` VALUES("51543", "_options_list_social_1_name", "field_63f40e34c4d0e", "no");
INSERT INTO `wp_options` VALUES("51544", "options_list_social_1_link", "", "no");
INSERT INTO `wp_options` VALUES("51545", "_options_list_social_1_link", "field_63f40e3ec4d0f", "no");
INSERT INTO `wp_options` VALUES("51546", "options_list_social_2_icon", "<i class=\"fab fa-youtube\"></i>", "no");
INSERT INTO `wp_options` VALUES("51547", "_options_list_social_2_icon", "field_63f40e2cc4d0d", "no");
INSERT INTO `wp_options` VALUES("51548", "options_list_social_2_name", "Youtube", "no");
INSERT INTO `wp_options` VALUES("51549", "_options_list_social_2_name", "field_63f40e34c4d0e", "no");
INSERT INTO `wp_options` VALUES("51550", "options_list_social_2_link", "", "no");
INSERT INTO `wp_options` VALUES("51551", "_options_list_social_2_link", "field_63f40e3ec4d0f", "no");
INSERT INTO `wp_options` VALUES("51552", "options_list_social_3_icon", "<i class=\"fab fa-linkedin\"></i>", "no");
INSERT INTO `wp_options` VALUES("51553", "_options_list_social_3_icon", "field_63f40e2cc4d0d", "no");
INSERT INTO `wp_options` VALUES("51554", "options_list_social_3_name", "Linkedin", "no");
INSERT INTO `wp_options` VALUES("51555", "_options_list_social_3_name", "field_63f40e34c4d0e", "no");
INSERT INTO `wp_options` VALUES("51556", "options_list_social_3_link", "", "no");
INSERT INTO `wp_options` VALUES("51557", "_options_list_social_3_link", "field_63f40e3ec4d0f", "no");
INSERT INTO `wp_options` VALUES("51558", "options_list_social", "5", "no");
INSERT INTO `wp_options` VALUES("51559", "_options_list_social", "field_63f40e1dc4d0c", "no");
INSERT INTO `wp_options` VALUES("54849", "wpos_anylc_redirect", "", "yes");
INSERT INTO `wp_options` VALUES("54850", "wpos_anylc_site_uid", "d40de44ac731a7e2ebb08b98ae846650", "yes");
INSERT INTO `wp_options` VALUES("54851", "wpos_anylc_pdt_36", "a:1:{s:6:\"status\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("57023", "fs_active_plugins", "O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:29:\"tablepress/libraries/freemius\";O:8:\"stdClass\":4:{s:7:\"version\";s:5:\"2.5.3\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1677486184;s:11:\"plugin_path\";s:25:\"tablepress/tablepress.php\";}}s:7:\"abspath\";s:31:\"/home/ysscptnb/mami.gameh5.xyz/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:25:\"tablepress/tablepress.php\";s:8:\"sdk_path\";s:29:\"tablepress/libraries/freemius\";s:7:\"version\";s:5:\"2.5.3\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1677486184;}}", "yes");
INSERT INTO `wp_options` VALUES("57024", "fs_debug_mode", "", "yes");
INSERT INTO `wp_options` VALUES("57025", "fs_accounts", "a:5:{s:21:\"id_slug_type_path_map\";a:1:{i:10340;a:3:{s:4:\"slug\";s:10:\"tablepress\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:25:\"tablepress/tablepress.php\";}}s:11:\"plugin_data\";a:1:{s:10:\"tablepress\";a:16:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:25:\"tablepress/tablepress.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1677486184;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:1;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:5:\"2.5.3\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:5:\"2.0.4\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:9:\"123-b.com\";s:9:\"server_ip\";s:14:\"103.21.220.201\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1677486184;s:7:\"version\";s:5:\"2.0.4\";}s:15:\"prev_is_premium\";b:0;s:12:\"is_anonymous\";a:3:{s:2:\"is\";b:1;s:9:\"timestamp\";i:1677486188;s:7:\"version\";s:5:\"2.0.4\";}}}s:13:\"file_slug_map\";a:1:{s:25:\"tablepress/tablepress.php\";s:10:\"tablepress\";}s:7:\"plugins\";a:1:{s:10:\"tablepress\";O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:10:\"TablePress\";s:4:\"slug\";s:10:\"tablepress\";s:12:\"premium_slug\";s:18:\"tablepress-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:25:\"tablepress/tablepress.php\";s:7:\"version\";s:5:\"2.0.4\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_b215ca1bb4041cf43ed137ae7665b\";s:10:\"secret_key\";N;s:2:\"id\";s:5:\"10340\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:9:\"unique_id\";s:32:\"294e438604e66d9f56acb094019adff1\";}", "yes");
INSERT INTO `wp_options` VALUES("57026", "fs_gdpr", "a:1:{s:2:\"u4\";a:1:{s:8:\"required\";b:0;}}", "yes");
INSERT INTO `wp_options` VALUES("57027", "fs_api_cache", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("58083", "widget_lpwtoc_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("58084", "lwptoc_rate_time", "1677665817", "yes");
INSERT INTO `wp_options` VALUES("58090", "lwptoc_processingHeadings", "a:1:{s:9:\"postTypes\";a:1:{i:0;s:4:\"post\";}}", "yes");
INSERT INTO `wp_options` VALUES("58856", "aiwa_wp_plugin_activation_date", "1677645119", "yes");
INSERT INTO `wp_options` VALUES("58859", "aiwa_notices", "[{\"title\":\"<div style=\\\"color: red;margin-bottom: 5px;margin-top: 10px;\\\">Get 50% off!<\\/div>\",\"key\":\"50_percent_off\",\"publishing_date\":\"8 February 2023\",\"auto_hide\":\"false\",\"auto_hide_date\":\"9 March 2023\",\"is_right_sidebar\":\"true\",\"content\":\"<a href=\\\"https:\\/\\/myrecorp.com\\/ai-content-writing-assistant\\/\\\" class=\\\"get-pro-button\\\" target=\\\"_blank\\\">Go to Pro<\\/a>\",\"status\":\"true\",\"version\":[\"free\"],\"styles\":\".get-pro-button {\\r\\n\\t\\t\\t  background-color: #0097A7;\\r\\n\\t\\t\\t  color: white;\\r\\n\\t\\t\\t  border: none;\\r\\n\\t\\t\\t  border-radius: 5px;\\r\\n\\t\\t\\t  padding: 10px 20px;\\r\\n\\t\\t\\t  font-size: 18px;\\r\\n\\t\\t\\t  font-weight: bold;\\r\\n\\t\\t\\t  cursor: pointer;\\r\\n\\t\\t\\t  transition: all 0.3s ease-in-out;\\r\\n\\t\\t\\t}\\r\\n\\r\\n\\t\\t\\t.get-pro-button:hover {\\r\\n\\t\\t\\t  background-color: #01579B;\\r\\n\\t\\t\\t  transform: translateY(-2px);\\r\\n\\t\\t\\t  box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);\\r\\n\\t\\t\\t}\\r\\n\"},{\"title\":\"More plugins you may like!\",\"key\":\"any\",\"publishing_date\":\"9 February 2023\",\"auto_hide\":\"false\",\"auto_hide_date\":\"25 November 2070\",\"is_right_sidebar\":\"true\",\"content\":\"1. <a href=\\\"https:\\/\\/wordpress.org\\/plugins\\/export-wp-page-to-static-html\\/?r=export-html\\\">Export WP Pages to Static HTML\\/CSS<\\/a><\\/br>2. <a href=\\\"https:\\/\\/wordpress.org\\/plugins\\/different-menus-in-different-pages\\/?r=export-html\\\">Different Menu in Different Pages<\\/a><\\/br>3. <a href=\\\"https:\\/\\/myrecorp.com\\/product\\/menu-import-and-export-pro\\/?r=export-html\\\">Menu Import & Export Pro<\\/a><\\/br>4. <a href=\\\"https:\\/\\/myrecorp.com\\/product\\/mailchimp-for-divi-contact-form\\/?r=export-html\\\">Divi Contact Form MailChimp Extension<\\/a><\\/br>5. <a href=\\\"https:\\/\\/wordpress.org\\/plugins\\/pipe-recaptcha\\/\\\">Pipe ReCaptcha<\\/a>\",\"status\":\"true\",\"version\":[\"free\",\"pro\"],\"styles\":\".right_notice_title{font-size: 17px;font-weight: bold;margin-top: 10px;}\"}]", "yes");
INSERT INTO `wp_options` VALUES("58965", "rank_math_viewed_seo_analyer", "1", "no");
INSERT INTO `wp_options` VALUES("59037", "rank_math_aioseo_block_posts", "a:2:{s:5:\"posts\";a:0:{}s:5:\"count\";i:0;}", "no");
INSERT INTO `wp_options` VALUES("59063", "simba_tfa_priv_key_format", "1", "no");
INSERT INTO `wp_options` VALUES("59064", "updraft_lock_aios_15_minutes_cron_event", "0", "no");
INSERT INTO `wp_options` VALUES("59141", "_ew_preview_image_id", "2718", "yes");
INSERT INTO `wp_options` VALUES("59164", "rank_math_wizard_completed", "1", "yes");
INSERT INTO `wp_options` VALUES("59191", "ez-toc-shortcode-exist-and-render", "1", "yes");
INSERT INTO `wp_options` VALUES("59192", "ez-toc-list", "<div id=\"ez-toc-container\" class=\"ez-toc-v2_0_45_2 ez-toc-wrap-center counter-hierarchy ez-toc-counter ez-toc-grey ez-toc-container-direction\">\n<div class=\"ez-toc-title-container\">\n<p class=\"ez-toc-title\">Nội dung b&agrave;i viết</p>\n<span class=\"ez-toc-title-toggle\"><a href=\"#\" class=\"ez-toc-pull-right ez-toc-btn ez-toc-btn-xs ez-toc-btn-default ez-toc-toggle\" aria-label=\"ez-toc-toggle-icon-1\"><label for=\"item-6415725eefa33\" aria-label=\"Table of Content\"><span style=\"align-items: center;width: 35px;height: 30px;justify-content: center;direction:ltr\"></span></label></a></span></div>\n<nav><ul class=\'ez-toc-list ez-toc-list-level-1 eztoc-visibility-hide-by-default\'><li class=\'ez-toc-page-1 ez-toc-heading-level-2\'><a class=\"ez-toc-link ez-toc-heading-1\" href=\"#Gioi_thieu_doi_net_ve_nha_cai_123b\" title=\"Giới thiệu đôi nét về nhà cái 123b\">Giới thiệu đôi nét về nhà cái 123b</a></li><li class=\'ez-toc-page-1 ez-toc-heading-level-2\'><a class=\"ez-toc-link ez-toc-heading-2\" href=\"#Cac_phuong_thuc_ho_tro_nap_tien_123b\" title=\"Các phương thức hỗ trợ nạp tiền 123b\">Các phương thức hỗ trợ nạp tiền 123b</a></li><li class=\'ez-toc-page-1 ez-toc-heading-level-2\'><a class=\"ez-toc-link ez-toc-heading-3\" href=\"#Chi_tiet_cac_phuong_thuc_nap_tien_123b_vao_tai_khoan\" title=\"Chi tiết các phương thức nạp tiền 123b vào tài khoản\">Chi tiết các phương thức nạp tiền 123b vào tài khoản</a><ul class=\'ez-toc-list-level-3\'><li class=\'ez-toc-heading-level-3\'><a class=\"ez-toc-link ez-toc-heading-4\" href=\"#Nap_tien_123b_qua_the_ngan_hang\" title=\"Nạp tiền 123b qua thẻ ngân hàng\">Nạp tiền 123b qua thẻ ngân hàng</a></li><li class=\'ez-toc-page-1 ez-toc-heading-level-3\'><a class=\"ez-toc-link ez-toc-heading-5\" href=\"#Nap_tien_123b_online\" title=\"Nạp tiền 123b online\">Nạp tiền 123b online</a></li></ul></li><li class=\'ez-toc-page-1 ez-toc-heading-level-2\'><a class=\"ez-toc-link ez-toc-heading-6\" href=\"#Nhung_dieu_quan_trong_can_nho_khi_nap_tien_123b\" title=\"Những điều quan trọng cần nhớ khi nạp tiền 123b\">Những điều quan trọng cần nhớ khi nạp tiền 123b</a></li><li class=\'ez-toc-page-1 ez-toc-heading-level-2\'><a class=\"ez-toc-link ez-toc-heading-7\" href=\"#Mot_so_cau_hoi_thuong_gap_khi_nap_tien_123b\" title=\"Một số câu hỏi thường gặp khi nạp tiền 123b\">Một số câu hỏi thường gặp khi nạp tiền 123b</a><ul class=\'ez-toc-list-level-3\'><li class=\'ez-toc-heading-level-3\'><a class=\"ez-toc-link ez-toc-heading-8\" href=\"#Toi_co_the_nap_tien_vao_tai_khoan_123b_bang_the_tin_dung_duoc_khong\" title=\"Tôi có thể nạp tiền vào tài khoản 123b bằng thẻ tín dụng được không?\">Tôi có thể nạp tiền vào tài khoản 123b bằng thẻ tín dụng được không?</a></li><li class=\'ez-toc-page-1 ez-toc-heading-level-3\'><a class=\"ez-toc-link ez-toc-heading-9\" href=\"#Toi_nap_tien_vao_tai_khoan_123b_nhung_khong_thay_so_tien_duoc_cap_nhat_toi_phai_lam_gi\" title=\"Tôi nạp tiền vào tài khoản 123b nhưng không thấy số tiền được cập nhật, tôi phải làm gì?\">Tôi nạp tiền vào tài khoản 123b nhưng không thấy số tiền được cập nhật, tôi phải làm gì?</a></li><li class=\'ez-toc-page-1 ez-toc-heading-level-3\'><a class=\"ez-toc-link ez-toc-heading-10\" href=\"#Toi_muon_nap_mot_so_tien_lon_hon_han_muc_nap_tien_tren_123b_thi_phai_lam_sao\" title=\"Tôi muốn nạp một số tiền lớn hơn hạn mức nạp tiền trên 123b thì phải làm sao?\">Tôi muốn nạp một số tiền lớn hơn hạn mức nạp tiền trên 123b thì phải làm sao?</a></li><li class=\'ez-toc-page-1 ez-toc-heading-level-3\'><a class=\"ez-toc-link ez-toc-heading-11\" href=\"#Thoi_gian_de_tien_duoc_cap_nhat_vao_tai_khoan_123b_la_bao_lau\" title=\"Thời gian để tiền được cập nhật vào tài khoản 123b là bao lâu?\">Thời gian để tiền được cập nhật vào tài khoản 123b là bao lâu?</a></li><li class=\'ez-toc-page-1 ez-toc-heading-level-3\'><a class=\"ez-toc-link ez-toc-heading-12\" href=\"#Nhap_sai_thong_tin_tai_khoan_co_sua_duoc_khong\" title=\"Nhập sai thông tin tài khoản có sửa được không?\">Nhập sai thông tin tài khoản có sửa được không?</a></li></ul></li><li class=\'ez-toc-page-1 ez-toc-heading-level-2\'><a class=\"ez-toc-link ez-toc-heading-13\" href=\"#Ket_luan\" title=\"Kết luận\">Kết luận</a></li></ul></nav></div>\n", "yes");
INSERT INTO `wp_options` VALUES("59193", "widget_ez_toc_widget_sticky", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("59221", "ez-toc-settings", "a:51:{s:15:\"fragment_prefix\";s:1:\"i\";s:8:\"position\";s:9:\"afterpara\";s:5:\"start\";s:1:\"3\";s:17:\"show_heading_text\";s:1:\"1\";s:12:\"heading_text\";s:22:\"Nội dung bài viết\";s:18:\"enabled_post_types\";a:2:{s:4:\"post\";s:4:\"post\";s:4:\"page\";s:4:\"page\";}s:22:\"auto_insert_post_types\";a:2:{s:4:\"post\";s:4:\"post\";s:4:\"page\";s:4:\"page\";}s:14:\"show_hierarchy\";s:1:\"1\";s:7:\"counter\";s:7:\"decimal\";s:13:\"smooth_scroll\";s:1:\"1\";s:20:\"smooth_scroll_offset\";s:2:\"30\";s:10:\"visibility\";s:1:\"1\";s:11:\"toc_loading\";s:2:\"js\";s:5:\"width\";s:4:\"auto\";s:12:\"width_custom\";s:3:\"275\";s:18:\"width_custom_units\";s:2:\"px\";s:8:\"wrapping\";s:6:\"center\";s:15:\"title_font_size\";s:3:\"120\";s:21:\"title_font_size_units\";s:1:\"%\";s:17:\"title_font_weight\";s:3:\"500\";s:9:\"font_size\";s:2:\"95\";s:15:\"child_font_size\";s:2:\"90\";s:15:\"font_size_units\";s:1:\"%\";s:5:\"theme\";s:4:\"grey\";s:24:\"custom_background_colour\";s:7:\"#bfbfbf\";s:20:\"custom_border_colour\";s:4:\"#ddd\";s:19:\"custom_title_colour\";s:4:\"#999\";s:18:\"custom_link_colour\";s:7:\"#428bca\";s:24:\"custom_link_hover_colour\";s:7:\"#2a6496\";s:26:\"custom_link_visited_colour\";s:7:\"#428bca\";s:14:\"heading_levels\";a:3:{i:1;s:1:\"1\";i:2;s:1:\"2\";i:3;s:1:\"3\";}s:19:\"css_container_class\";s:0:\"\";s:22:\"heading-text-direction\";s:3:\"ltr\";s:19:\"sticky-toggle-width\";s:4:\"auto\";s:20:\"sticky-toggle-height\";s:4:\"auto\";s:30:\"sticky-toggle-open-button-text\";s:5:\"Index\";s:21:\"child_font_size_units\";s:1:\"%\";s:26:\"visibility_hide_by_default\";s:1:\"1\";s:16:\"include_homepage\";s:1:\"1\";s:26:\"sticky-toggle-width-custom\";s:0:\"\";s:27:\"sticky-toggle-height-custom\";s:0:\"\";s:7:\"exclude\";s:0:\"\";s:27:\"mobile_smooth_scroll_offset\";s:1:\"0\";s:13:\"restrict_path\";s:0:\"\";s:21:\"widget_affix_selector\";s:0:\"\";s:13:\"sticky-toggle\";s:1:\"0\";s:9:\"lowercase\";s:1:\"0\";s:9:\"hyphenate\";s:1:\"0\";s:11:\"exclude_css\";s:1:\"0\";s:10:\"inline_css\";s:1:\"0\";s:31:\"remove_special_chars_from_title\";s:1:\"0\";}", "yes");
INSERT INTO `wp_options` VALUES("59297", "IRP_PluginInstallDate[intelly-related-posts]", "1677662008", "yes");
INSERT INTO `wp_options` VALUES("59298", "IRP_PluginUpdateDate[intelly-related-posts]", "1677662008", "yes");
INSERT INTO `wp_options` VALUES("59299", "IRP_PluginFirstInstall", "0", "yes");
INSERT INTO `wp_options` VALUES("59300", "IRP_TrackingLastSend[intelly-related-posts]", "0", "yes");
INSERT INTO `wp_options` VALUES("59301", "IRP_ShowActivationNotice", "0", "yes");
INSERT INTO `wp_options` VALUES("59302", "IRP_ShowWhatsNew", "0", "yes");
INSERT INTO `wp_options` VALUES("59312", "IRP_MaxExecutionTime", "5", "yes");
INSERT INTO `wp_options` VALUES("59318", "IRP_Active", "1", "yes");
INSERT INTO `wp_options` VALUES("59319", "IRP_TemplateStyle", "a:11:{s:9:\"hasShadow\";s:1:\"1\";s:12:\"hasPoweredBy\";i:0;s:7:\"ctaText\";s:22:\"Bài viết liên quan\";s:8:\"template\";s:10:\"Minimalist\";s:10:\"boxOpacity\";s:3:\"100\";s:12:\"ctaTextColor\";s:7:\"#464646\";s:14:\"postTitleColor\";s:7:\"#000000\";s:8:\"boxColor\";s:7:\"#eaeaea\";s:11:\"borderColor\";s:7:\"#34495E\";s:7:\"linkRel\";s:8:\"dofollow\";s:10:\"linkTarget\";s:6:\"_blank\";}", "yes");
INSERT INTO `wp_options` VALUES("59320", "IRP_MarginTop", "0em", "yes");
INSERT INTO `wp_options` VALUES("59321", "IRP_MarginBottom", "1em", "yes");
INSERT INTO `wp_options` VALUES("59322", "IRP_RewriteActive", "1", "yes");
INSERT INTO `wp_options` VALUES("59323", "IRP_RewriteBoxesCount", "3", "yes");
INSERT INTO `wp_options` VALUES("59324", "IRP_RewritePostsDays", "0", "yes");
INSERT INTO `wp_options` VALUES("59325", "IRP_RewriteThreshold", "250", "yes");
INSERT INTO `wp_options` VALUES("59326", "IRP_HookPriority", "99999", "yes");
INSERT INTO `wp_options` VALUES("59327", "IRP_RewriteAtEnd", "1", "yes");
INSERT INTO `wp_options` VALUES("59328", "IRP_RewriteStaticLinks", "0", "yes");
INSERT INTO `wp_options` VALUES("59329", "IRP_PlaceInsideSpanElements", "1", "yes");
INSERT INTO `wp_options` VALUES("59330", "IRP_DoNotIncludeCssInBox", "0", "yes");
INSERT INTO `wp_options` VALUES("59331", "IRP_EngineSearch", "0", "yes");
INSERT INTO `wp_options` VALUES("59332", "IRP_RewritePostTypes", "a:3:{s:13:\"featured_item\";i:0;s:4:\"post\";i:1;s:6:\"sp_faq\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("59333", "IRP_MetaboxPostTypes", "a:3:{s:13:\"featured_item\";i:0;s:4:\"post\";i:1;s:6:\"sp_faq\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("59365", "ai_writing_assistant__api-key", "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", "yes");
INSERT INTO `wp_options` VALUES("59366", "ai_writing_assistant__best-of", "1", "yes");
INSERT INTO `wp_options` VALUES("59367", "ai_writing_assistant__frequency-penalty", "0", "yes");
INSERT INTO `wp_options` VALUES("59368", "ai_writing_assistant__max-tokens", "2000", "yes");
INSERT INTO `wp_options` VALUES("59369", "ai_writing_assistant__presence-penalty", "0", "yes");
INSERT INTO `wp_options` VALUES("59370", "ai_writing_assistant__temperature", "0.8", "yes");
INSERT INTO `wp_options` VALUES("59371", "ai_writing_assistant__top-p", "0.5", "yes");
INSERT INTO `wp_options` VALUES("59372", "ai_writing_assistant__ai-image-size", "thumbnail", "yes");
INSERT INTO `wp_options` VALUES("59373", "ai_writing_assistant__select-title-before-generate", "on", "yes");
INSERT INTO `wp_options` VALUES("59374", "ai_writing_assistant__how-many-titles-show-first", "3", "yes");
INSERT INTO `wp_options` VALUES("59375", "ai_writing_assistant__ai-content-structure", "topic_wise", "yes");
INSERT INTO `wp_options` VALUES("59376", "ai_writing_assistant__content-length", "long", "yes");
INSERT INTO `wp_options` VALUES("59377", "ai_writing_assistant__writing-style", "normal", "yes");
INSERT INTO `wp_options` VALUES("59378", "ai_writing_assistant__writing-tone", "informative", "yes");
INSERT INTO `wp_options` VALUES("59379", "ai_writing_assistant__aiwa-topics-tag", "h2", "yes");
INSERT INTO `wp_options` VALUES("59380", "ai_writing_assistant__topics-count", "5", "yes");
INSERT INTO `wp_options` VALUES("59381", "ai_writing_assistant__add-introduction", "on", "yes");
INSERT INTO `wp_options` VALUES("59382", "ai_writing_assistant__add-introduction-text", "off", "yes");
INSERT INTO `wp_options` VALUES("59383", "ai_writing_assistant__add-conclusion", "on", "yes");
INSERT INTO `wp_options` VALUES("59384", "ai_writing_assistant__add-conclusion-text", "off", "yes");
INSERT INTO `wp_options` VALUES("59385", "ai_writing_assistant__add-call-to-action", "off", "yes");
INSERT INTO `wp_options` VALUES("59386", "ai_writing_assistant__call-to-action-url", "", "yes");
INSERT INTO `wp_options` VALUES("59387", "ai_writing_assistant__call-to-action-position", "start", "yes");
INSERT INTO `wp_options` VALUES("59388", "ai_writing_assistant__pros-and-cons-count", "7", "yes");
INSERT INTO `wp_options` VALUES("59389", "ai_writing_assistant__list-items-count", "10", "yes");
INSERT INTO `wp_options` VALUES("59390", "ai_writing_assistant__faq-items-count", "7", "yes");
INSERT INTO `wp_options` VALUES("59391", "ai_writing_assistant__article-paragraphs-count", "3", "yes");
INSERT INTO `wp_options` VALUES("59392", "ai_writing_assistant__first-person-name", "", "yes");
INSERT INTO `wp_options` VALUES("59393", "ai_writing_assistant__second-person-name", "", "yes");
INSERT INTO `wp_options` VALUES("59394", "ai_writing_assistant__generate-title", "off", "yes");
INSERT INTO `wp_options` VALUES("59395", "ai_writing_assistant__introduction-size", "short", "yes");
INSERT INTO `wp_options` VALUES("59396", "ai_writing_assistant__conclusion-size", "short", "yes");
INSERT INTO `wp_options` VALUES("59397", "ai_writing_assistant__auto-generate-image", "off", "yes");
INSERT INTO `wp_options` VALUES("59398", "ai_writing_assistant__aiwa-language", "en", "yes");
INSERT INTO `wp_options` VALUES("59399", "ai_writing_assistant__aiwa_language_text", "English", "yes");
INSERT INTO `wp_options` VALUES("59400", "ai_writing_assistant__previously_failed", "off", "yes");
INSERT INTO `wp_options` VALUES("59401", "ai_writing_assistant__super_fast_generation_mode", "off", "yes");
INSERT INTO `wp_options` VALUES("59402", "ai_writing_assistant__how_many_minutes", "10", "yes");
INSERT INTO `wp_options` VALUES("59403", "ai_writing_assistant__image_experiments", "a:5:{i:0;s:9:\"realistic\";i:1;s:6:\"four_k\";i:2;s:15:\"high_resolution\";i:3;s:22:\"trending_in_artstation\";i:4;s:16:\"artstation_three\";}", "yes");
INSERT INTO `wp_options` VALUES("59404", "ai_writing_assistant__post_types", "a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}", "yes");
INSERT INTO `wp_options` VALUES("59405", "aiwa-placeholders", "1. Inserting and Deleting Text in vi,2. Searching and Replacing Text in vi,3. Using vi Macros,4. Using vi Keyboard Shortcuts,5. Working with Multiple Files in vi,6. Working with vi Buffers,7. Using vi Modes,8. Setting vi Options,9. Working with vi Plugins,10. Customizing vi Syntax Highlighting", "yes");
INSERT INTO `wp_options` VALUES("59429", "mihdan_index_now_general", "a:6:{s:10:\"post_types\";a:2:{s:4:\"post\";s:4:\"post\";s:4:\"page\";s:4:\"page\";}s:10:\"taxonomies\";a:1:{s:8:\"category\";s:8:\"category\";}s:12:\"ping_on_post\";s:2:\"on\";s:12:\"ping_on_term\";s:3:\"off\";s:15:\"ping_on_comment\";s:3:\"off\";s:21:\"disable_for_bulk_edit\";s:2:\"on\";}", "no");
INSERT INTO `wp_options` VALUES("59430", "mihdan_index_now_index_now", "", "no");
INSERT INTO `wp_options` VALUES("59431", "mihdan_index_now_bing_webmaster", "a:2:{s:6:\"enable\";s:2:\"on\";s:7:\"api_key\";s:32:\"95ea7c90dd78462faef4649ee2601783\";}", "no");
INSERT INTO `wp_options` VALUES("59432", "mihdan_index_now_google_webmaster", "a:2:{s:6:\"enable\";s:2:\"on\";s:8:\"json_key\";s:2313:\"{\r\n  \"type\": \"service_account\",\r\n  \"project_id\": \"b-379310\",\r\n  \"private_key_id\": \"8442a37f0f3c55c5090f33b73866dcfb86bdb14d\",\r\n  \"private_key\": \"-----BEGIN PRIVATE KEY-----\\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC5+76RS+V3EtuJ\\nHoTmO898o7J7d88nUtFOrHK0jPBYf+xazuE89T9Pp7/UABMxV9Ig1gh/hXVbS420\\nDn8kDT+au1yJ9Y9EPjN9fajWtVNPTnsp50tKRRdZ+1H+rTirUmQoe2Jt2LATXC3P\\n5wuVBHl8jXvymNhmBP/Ql3cQJsJYoODMzIn7SkHzvlXub3W3DTzAyqRmhckYnnwL\\n4Cz67FGmKKJKaVNt8aSiOP8ILvryvFI5MelaJpJqY9Tjdh2Ls4XS/bL6h/2Lm/M0\\nXzJrdAmIth5zqz8v7nPQ6kkLxhWLYX1N0F7WYtgf266K7k+fQcS72muBiLdd3Y1l\\nYFpsQsmxAgMBAAECggEACfU9td/fcGm1EXlt2jn3mQ/WvZ+jmtJnXJQFLD+jmsl2\\nqUIMc0waULSFo99BJ9Iw8Qskt1c4+mNoOezQx+hhsHI5uTVJr3i5Hw38XUqmJEfq\\ndkrpEBf08R9wu3cg4qNts3EvyvvgKZk05r3TM+5iZtXYfhvK8mNwIwYJHPdGTqJv\\nCCYqpHi8vnYVDxwFWweOutkg9+KjAMHSXaafjyJO0AYdML2Y4V1md84K0BFEPzdt\\ngdggS+3CMGu+7zxbPALExi6fwlowDjitS3JqFOx3MnUZvy3UExVS0JnfvJaJXlEz\\n/9E/UYVKClEZD1i9BWrCI0NZYeiRJ9JCMTZ2xDVgMQKBgQDyWQysQakjkiNoruD0\\nKmcEocmruPK8TKrnV4MgfRPL2hkdw7vmWuN4mPGZklKK0z+443hX+Yjkuk1lZg41\\npISooGkCRZAzFLM6u1gh7vepbi4gacgssheNFjJFxvBZcbav3BdpWtXSg7rd1w9r\\n0Jjkk33nZQ5avpBmqxfF3bWwbQKBgQDEddnHyr8DvPU1GF+1MrOpGWWEYuWku9dW\\nlcvHkQrwSZ85Ud+S8ORO0ikTKKsrlS/xcemP6g9C3kXnSKNUgbO7NDrQTFqdkTFF\\n/zaqZa8SDBB6Cssf2UvbIo6MrtGnBuBBcQxDj8nAsiaNHRY8b8LOpZcNUj/rg2b5\\n+MIgEjmb1QKBgQDIVDATnFtSWhUHDbhKXVq3C34Hg2SznrSPc1mjW4Enu2uTnR8P\\ntgXexJ7CEaBFvYYpMW9jWZR9bjtYHFqWoR4/vgnPpO0kLHJTlFWwBzeWSMu8Y3Ti\\n7XxmVfjMkTxQ05zuFgMMRdgGonmvs3y95LreB8XFp1WMUYZQOBH4r+LmqQKBgHGK\\netbRAhwy9LQ+5fFe4B52owkj7vyJ4yYTZLZtyRieM/t4qfHObuRu6XY9JtAFZLPx\\n1b5q028d7uCARoTsgOdMhEEmH6i45PVDTmCka83OUyd1XXeGqiR3kFMWJeyWOL0Z\\njLDvRPas/0LG8Lb1EG1FnksAohiG1NjbP7YxUkIRAoGBAMOyGuw9s3/brUz/EKcX\\nDJPe/xJD9MzPzsqJXaH2eSS3SBPIve+XtlwC+T1Mr7+S2pGOGkeluUnw5+vqZRSn\\nrYmEBErTR3ShC8YBKbNzn2hK5POYo/sqoWIaHgLdaYoLD3g05rPeR2DxSaJgNFDA\\ntYeoHgBS2TFA3PJgivvKUDpD\\n-----END PRIVATE KEY-----\\n\",\r\n  \"client_email\": \"id-23-b-com@b-379310.iam.gserviceaccount.com\",\r\n  \"client_id\": \"100784154514616284387\",\r\n  \"auth_uri\": \"https://accounts.google.com/o/oauth2/auth\",\r\n  \"token_uri\": \"https://oauth2.googleapis.com/token\",\r\n  \"auth_provider_x509_cert_url\": \"https://www.googleapis.com/oauth2/v1/certs\",\r\n  \"client_x509_cert_url\": \"https://www.googleapis.com/robot/v1/metadata/x509/id-23-b-com%40b-379310.iam.gserviceaccount.com\"\r\n}\r\n\";}", "no");
INSERT INTO `wp_options` VALUES("59433", "mihdan_index_now_yandex_webmaster", "", "no");
INSERT INTO `wp_options` VALUES("59434", "mihdan_index_now_logs", "a:6:{s:6:\"enable\";s:2:\"on\";s:11:\"key_logging\";s:2:\"on\";s:17:\"outgoing_requests\";s:2:\"on\";s:11:\"cron_events\";s:3:\"off\";s:12:\"bulk_actions\";s:3:\"off\";s:8:\"lifetime\";s:2:\"30\";}", "no");
INSERT INTO `wp_options` VALUES("59435", "mihdan_index_now_version", "2.4.0", "no");
INSERT INTO `wp_options` VALUES("59556", "PMXI_Plugin_Options", "a:28:{s:12:\"info_api_url\";s:27:\"https://www.wpallimport.com\";s:18:\"history_file_count\";i:10000;s:16:\"history_file_age\";i:365;s:15:\"highlight_limit\";i:10000;s:19:\"upload_max_filesize\";i:2048;s:13:\"post_max_size\";i:2048;s:14:\"max_input_time\";i:-1;s:18:\"max_execution_time\";i:-1;s:7:\"dismiss\";i:0;s:16:\"dismiss_speed_up\";i:0;s:18:\"dismiss_manage_top\";i:0;s:21:\"dismiss_manage_bottom\";i:0;s:13:\"html_entities\";i:0;s:11:\"utf8_decode\";i:0;s:12:\"cron_job_key\";s:9:\"edU2t1ZZf\";s:10:\"chunk_size\";i:32;s:9:\"pingbacks\";i:1;s:33:\"legacy_special_character_handling\";i:1;s:14:\"case_sensitive\";i:1;s:12:\"session_mode\";s:7:\"default\";s:17:\"enable_ftp_import\";i:0;s:16:\"large_feed_limit\";i:1000;s:26:\"cron_processing_time_limit\";i:59;s:6:\"secure\";i:1;s:11:\"log_storage\";i:5;s:10:\"cron_sleep\";s:0:\"\";s:4:\"port\";s:0:\"\";s:19:\"force_stream_reader\";i:0;}", "no");
INSERT INTO `wp_options` VALUES("59557", "pmxi_is_migrated", "3.7.2", "yes");
INSERT INTO `wp_options` VALUES("60837", "wfls_last_role_change", "1678506145", "no");
INSERT INTO `wp_options` VALUES("60838", "wordfence_version", "7.9.1", "yes");
INSERT INTO `wp_options` VALUES("60839", "wordfence_case", "1", "yes");
INSERT INTO `wp_options` VALUES("60840", "wordfence_installed", "1", "yes");
INSERT INTO `wp_options` VALUES("60841", "wordfenceActivated", "0", "yes");
INSERT INTO `wp_options` VALUES("60842", "wf_plugin_act_error", "", "yes");
INSERT INTO `wp_options` VALUES("61363", "wordfence_syncAttackDataAttempts", "0", "no");
INSERT INTO `wp_options` VALUES("61364", "wordfence_syncingAttackData", "0", "no");
INSERT INTO `wp_options` VALUES("61365", "wordfence_lastSyncAttackData", "1678973448", "no");
INSERT INTO `wp_options` VALUES("64290", "options_list_social_4_icon", "<i class=\"fab fa-pinterest\"></i>", "no");
INSERT INTO `wp_options` VALUES("64291", "_options_list_social_4_icon", "field_63f40e2cc4d0d", "no");
INSERT INTO `wp_options` VALUES("64292", "options_list_social_4_name", "Pinterest", "no");
INSERT INTO `wp_options` VALUES("64293", "_options_list_social_4_name", "field_63f40e34c4d0e", "no");
INSERT INTO `wp_options` VALUES("64294", "options_list_social_4_link", "", "no");
INSERT INTO `wp_options` VALUES("64295", "_options_list_social_4_link", "field_63f40e3ec4d0f", "no");
INSERT INTO `wp_options` VALUES("64385", "filemanager_email_verified_4", "yes", "yes");
INSERT INTO `wp_options` VALUES("65032", "rmp_options", "a:33:{s:9:\"icon_type\";i:1;s:11:\"widgetAlign\";i:1;s:5:\"posts\";i:2;s:5:\"pages\";i:2;s:10:\"resultPost\";i:1;s:11:\"resultPages\";i:1;s:10:\"rate_email\";i:1;s:10:\"hoverTexts\";i:1;s:17:\"preventAccidental\";i:1;s:13:\"notShowRating\";i:1;s:16:\"ampCompatibility\";i:1;s:13:\"cookieDisable\";i:1;s:18:\"structuredDataType\";s:18:\"CreativeWorkSeries\";s:7:\"exclude\";a:0:{}s:16:\"positiveNegative\";i:2;s:8:\"feedback\";i:1;s:14:\"feedback_email\";i:1;s:6:\"social\";i:1;s:11:\"socialShare\";i:1;s:2:\"fb\";s:0:\"\";s:9:\"pinterest\";s:0:\"\";s:7:\"youtube\";s:0:\"\";s:6:\"flickr\";s:0:\"\";s:9:\"instagram\";s:0:\"\";s:7:\"twitter\";s:0:\"\";s:8:\"linkedin\";s:0:\"\";s:9:\"cptRating\";a:0:{}s:9:\"cptResult\";a:0:{}s:12:\"archivePages\";i:1;s:12:\"multiLingual\";i:1;s:8:\"ajaxLoad\";i:1;s:15:\"wipeOnUninstall\";i:1;s:17:\"disableClearCache\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("65033", "rmp_customize_strings", "a:38:{s:9:\"rateTitle\";s:33:\"Bài đăng hữu ích như nào?\";s:12:\"rateSubtitle\";s:49:\"Bấm vào một ngôi sao để đánh giá nó!\";s:10:\"rateResult\";s:24:\"Xếp hạng trung bình\";s:11:\"rateResult2\";s:19:\"Số phiếu bầu:\";s:12:\"cookieNotice\";s:71:\"Bạn đã bình chọn! Phiếu bầu này sẽ không được tính!\";s:8:\"noRating\";s:101:\"Không có phiếu bầu cho đến nay! Hãy là người đầu tiên đánh giá bài viết này.\";s:9:\"afterVote\";s:50:\"Cảm ơn bạn đã đánh giá bài viết này!\";s:5:\"star1\";s:28:\"Không hữu ích chút nào\";s:5:\"star2\";s:15:\"Hơi hữu ích\";s:5:\"star3\";s:10:\"Hữu ích\";s:5:\"star4\";s:15:\"Khá hữu ích\";s:5:\"star5\";s:16:\"Rất hữu ích\";s:16:\"submitButtonText\";s:18:\"Gửi xếp hạng\";s:17:\"customResultsText\";s:0:\"\";s:11:\"socialTitle\";s:50:\"Nếu bạn thấy bài đăng này hữu ích ...\";s:14:\"socialSubtitle\";s:26:\"Follow us on social media!\";s:13:\"feedbackTitle\";s:71:\"Chúng tôi xin lỗi vì bài đăng này không hữu ích cho bạn!\";s:16:\"feedbackSubtitle\";s:54:\"Hãy để chúng tôi cải thiện bài viết này!\";s:12:\"feedbackText\";s:88:\"Hãy cho chúng tôi làm thế nào chúng ta có thể cải thiện bài viết này?\";s:14:\"feedbackNotice\";s:35:\"Cảm ơn phản hồi của bạn!\";s:14:\"feedbackButton\";s:18:\"Gửi phản hồi\";s:13:\"feedbackAlert\";s:62:\"Vui lòng điền phản hồi của bạn vào ô bên trên!\";s:13:\"titleFontSize\";i:0;s:16:\"subtitleFontSize\";i:0;s:12:\"textFontSize\";i:0;s:17:\"titleMarginBottom\";i:0;s:20:\"subtitleMarginBottom\";i:0;s:11:\"borderWidth\";i:0;s:12:\"borderRadius\";i:0;s:11:\"borderColor\";s:0:\"\";s:15:\"backgroundColor\";s:0:\"\";s:8:\"iconSize\";i:0;s:16:\"iconColorResults\";s:0:\"\";s:14:\"iconColorHover\";s:0:\"\";s:14:\"iconColorRated\";s:0:\"\";s:12:\"iconColorAvg\";s:0:\"\";s:10:\"iconMargin\";i:0;s:14:\"socialFontSize\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("65034", "rmp_security", "a:8:{s:10:\"privileges\";i:1;s:9:\"recaptcha\";i:1;s:7:\"siteKey\";s:0:\"\";s:9:\"secretKey\";s:0:\"\";s:10:\"votingPriv\";i:1;s:10:\"ipTracking\";i:1;s:12:\"userTracking\";i:1;s:12:\"ipDoubleVote\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("65035", "rmp_admin_notices", "a:4:{s:2:\"ls\";b:0;s:8:\"ampforwp\";b:0;s:3:\"pro\";b:1;s:9:\"installed\";i:1678169189;}", "yes");
INSERT INTO `wp_options` VALUES("65036", "rmp_version", "3.4.0", "yes");
INSERT INTO `wp_options` VALUES("65037", "widget_rate-my-post-top-rated-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("66079", "options_url_author", "#", "no");
INSERT INTO `wp_options` VALUES("66080", "_options_url_author", "field_6407dc5e31e0c", "no");
INSERT INTO `wp_options` VALUES("66081", "options_author_name", "Nguyễn Văn Minh", "no");
INSERT INTO `wp_options` VALUES("66082", "_options_author_name", "field_6407dcf99d506", "no");
INSERT INTO `wp_options` VALUES("66193", "options_author_avatar", "", "no");
INSERT INTO `wp_options` VALUES("66194", "_options_author_avatar", "field_6407f0860a9f5", "no");
INSERT INTO `wp_options` VALUES("66233", "ez-toc-post-content-core-level", "", "yes");
INSERT INTO `wp_options` VALUES("77318", "_site_transient_timeout_community-events-a1e22e4a1a1143087e1d28a378a3dbfc", "1679170931", "no");
INSERT INTO `wp_options` VALUES("77319", "_site_transient_community-events-a1e22e4a1a1143087e1d28a378a3dbfc", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:11:\"117.2.221.0\";}s:6:\"events\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("77112", "_site_transient_timeout_community-events-d7c0a0ffc36de759d92255f628d3192c", "1679165622", "no");
INSERT INTO `wp_options` VALUES("77113", "_site_transient_community-events-d7c0a0ffc36de759d92255f628d3192c", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"42.114.184.0\";}s:6:\"events\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("77243", "wpr_rucss_resources_version", "20210429", "yes");
INSERT INTO `wp_options` VALUES("77000", "_site_transient_timeout_browser_891f7416c39bb92469c92b1ed9a65c89", "1679644081", "no");
INSERT INTO `wp_options` VALUES("77001", "_site_transient_browser_891f7416c39bb92469c92b1ed9a65c89", "a:10:{s:4:\"name\";s:7:\"unknown\";s:7:\"version\";s:0:\"\";s:8:\"platform\";s:0:\"\";s:10:\"update_url\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:11:\"img_src_ssl\";s:0:\"\";s:15:\"current_version\";s:0:\"\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("77009", "_site_transient_timeout_browser_91973a9f67c3dd045da06b2a833474b0", "1679644947", "no");
INSERT INTO `wp_options` VALUES("77010", "_site_transient_browser_91973a9f67c3dd045da06b2a833474b0", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:14:\"103.0.5060.134\";s:8:\"platform\";s:0:\"\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("77025", "_site_transient_php_check_990bfacb848fa087bcfc06850f5e4447", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "no");
INSERT INTO `wp_options` VALUES("77117", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1679165624", "no");
INSERT INTO `wp_options` VALUES("77118", "_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1679165624", "no");
INSERT INTO `wp_options` VALUES("77206", "_site_transient_timeout_kirki_googlefonts_cache", "1679211078", "no");
INSERT INTO `wp_options` VALUES("77207", "_site_transient_kirki_googlefonts_cache", "a:1064:{s:7:\"ABeeZee\";a:3:{s:5:\"label\";s:7:\"ABeeZee\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Abel\";a:3:{s:5:\"label\";s:4:\"Abel\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Abhaya Libre\";a:3:{s:5:\"label\";s:12:\"Abhaya Libre\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Abril Fatface\";a:3:{s:5:\"label\";s:13:\"Abril Fatface\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Aclonica\";a:3:{s:5:\"label\";s:8:\"Aclonica\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Acme\";a:3:{s:5:\"label\";s:4:\"Acme\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Actor\";a:3:{s:5:\"label\";s:5:\"Actor\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Adamina\";a:3:{s:5:\"label\";s:7:\"Adamina\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Advent Pro\";a:3:{s:5:\"label\";s:10:\"Advent Pro\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Aguafina Script\";a:3:{s:5:\"label\";s:15:\"Aguafina Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Akaya Kanadaka\";a:3:{s:5:\"label\";s:14:\"Akaya Kanadaka\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Akaya Telivigala\";a:3:{s:5:\"label\";s:16:\"Akaya Telivigala\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Akronim\";a:3:{s:5:\"label\";s:7:\"Akronim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Aladin\";a:3:{s:5:\"label\";s:6:\"Aladin\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Alata\";a:3:{s:5:\"label\";s:5:\"Alata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Alatsi\";a:3:{s:5:\"label\";s:6:\"Alatsi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Aldrich\";a:3:{s:5:\"label\";s:7:\"Aldrich\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Alef\";a:3:{s:5:\"label\";s:4:\"Alef\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Alegreya\";a:3:{s:5:\"label\";s:8:\"Alegreya\";s:8:\"variants\";a:12:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Alegreya SC\";a:3:{s:5:\"label\";s:11:\"Alegreya SC\";s:8:\"variants\";a:10:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"800\";i:5;s:9:\"800italic\";i:6;s:3:\"900\";i:7;s:9:\"900italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Alegreya Sans\";a:3:{s:5:\"label\";s:13:\"Alegreya Sans\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Alegreya Sans SC\";a:3:{s:5:\"label\";s:16:\"Alegreya Sans SC\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Aleo\";a:3:{s:5:\"label\";s:4:\"Aleo\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Alex Brush\";a:3:{s:5:\"label\";s:10:\"Alex Brush\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Alfa Slab One\";a:3:{s:5:\"label\";s:13:\"Alfa Slab One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Alice\";a:3:{s:5:\"label\";s:5:\"Alice\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Alike\";a:3:{s:5:\"label\";s:5:\"Alike\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Alike Angular\";a:3:{s:5:\"label\";s:13:\"Alike Angular\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Allan\";a:3:{s:5:\"label\";s:5:\"Allan\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Allerta\";a:3:{s:5:\"label\";s:7:\"Allerta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Allerta Stencil\";a:3:{s:5:\"label\";s:15:\"Allerta Stencil\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Allura\";a:3:{s:5:\"label\";s:6:\"Allura\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Almarai\";a:3:{s:5:\"label\";s:7:\"Almarai\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:3:\"800\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Almendra\";a:3:{s:5:\"label\";s:8:\"Almendra\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Almendra Display\";a:3:{s:5:\"label\";s:16:\"Almendra Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Almendra SC\";a:3:{s:5:\"label\";s:11:\"Almendra SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Amarante\";a:3:{s:5:\"label\";s:8:\"Amarante\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Amaranth\";a:3:{s:5:\"label\";s:8:\"Amaranth\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Amatic SC\";a:3:{s:5:\"label\";s:9:\"Amatic SC\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Amethysta\";a:3:{s:5:\"label\";s:9:\"Amethysta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Amiko\";a:3:{s:5:\"label\";s:5:\"Amiko\";s:8:\"variants\";a:3:{i:0;s:3:\"600\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Amiri\";a:3:{s:5:\"label\";s:5:\"Amiri\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Amita\";a:3:{s:5:\"label\";s:5:\"Amita\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Anaheim\";a:3:{s:5:\"label\";s:7:\"Anaheim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Andada\";a:3:{s:5:\"label\";s:6:\"Andada\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Andika\";a:3:{s:5:\"label\";s:6:\"Andika\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Andika New Basic\";a:3:{s:5:\"label\";s:16:\"Andika New Basic\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Angkor\";a:3:{s:5:\"label\";s:6:\"Angkor\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:24:\"Annie Use Your Telescope\";a:3:{s:5:\"label\";s:24:\"Annie Use Your Telescope\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Anonymous Pro\";a:3:{s:5:\"label\";s:13:\"Anonymous Pro\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:5:\"Antic\";a:3:{s:5:\"label\";s:5:\"Antic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Antic Didone\";a:3:{s:5:\"label\";s:12:\"Antic Didone\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Antic Slab\";a:3:{s:5:\"label\";s:10:\"Antic Slab\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Anton\";a:3:{s:5:\"label\";s:5:\"Anton\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Antonio\";a:3:{s:5:\"label\";s:7:\"Antonio\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Arapey\";a:3:{s:5:\"label\";s:6:\"Arapey\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Arbutus\";a:3:{s:5:\"label\";s:7:\"Arbutus\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Arbutus Slab\";a:3:{s:5:\"label\";s:12:\"Arbutus Slab\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:19:\"Architects Daughter\";a:3:{s:5:\"label\";s:19:\"Architects Daughter\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Archivo\";a:3:{s:5:\"label\";s:7:\"Archivo\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Archivo Black\";a:3:{s:5:\"label\";s:13:\"Archivo Black\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Archivo Narrow\";a:3:{s:5:\"label\";s:14:\"Archivo Narrow\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Aref Ruqaa\";a:3:{s:5:\"label\";s:10:\"Aref Ruqaa\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Arima Madurai\";a:3:{s:5:\"label\";s:13:\"Arima Madurai\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Arimo\";a:3:{s:5:\"label\";s:5:\"Arimo\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Arizonia\";a:3:{s:5:\"label\";s:8:\"Arizonia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Armata\";a:3:{s:5:\"label\";s:6:\"Armata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Arsenal\";a:3:{s:5:\"label\";s:7:\"Arsenal\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Artifika\";a:3:{s:5:\"label\";s:8:\"Artifika\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Arvo\";a:3:{s:5:\"label\";s:4:\"Arvo\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Arya\";a:3:{s:5:\"label\";s:4:\"Arya\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Asap\";a:3:{s:5:\"label\";s:4:\"Asap\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Asap Condensed\";a:3:{s:5:\"label\";s:14:\"Asap Condensed\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Asar\";a:3:{s:5:\"label\";s:4:\"Asar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Asset\";a:3:{s:5:\"label\";s:5:\"Asset\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Assistant\";a:3:{s:5:\"label\";s:9:\"Assistant\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Astloch\";a:3:{s:5:\"label\";s:7:\"Astloch\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Asul\";a:3:{s:5:\"label\";s:4:\"Asul\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Athiti\";a:3:{s:5:\"label\";s:6:\"Athiti\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Atma\";a:3:{s:5:\"label\";s:4:\"Atma\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Atomic Age\";a:3:{s:5:\"label\";s:10:\"Atomic Age\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Aubrey\";a:3:{s:5:\"label\";s:6:\"Aubrey\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Audiowide\";a:3:{s:5:\"label\";s:9:\"Audiowide\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Autour One\";a:3:{s:5:\"label\";s:10:\"Autour One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Average\";a:3:{s:5:\"label\";s:7:\"Average\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Average Sans\";a:3:{s:5:\"label\";s:12:\"Average Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Averia Gruesa Libre\";a:3:{s:5:\"label\";s:19:\"Averia Gruesa Libre\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Averia Libre\";a:3:{s:5:\"label\";s:12:\"Averia Libre\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:17:\"Averia Sans Libre\";a:3:{s:5:\"label\";s:17:\"Averia Sans Libre\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:18:\"Averia Serif Libre\";a:3:{s:5:\"label\";s:18:\"Averia Serif Libre\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"B612\";a:3:{s:5:\"label\";s:4:\"B612\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"B612 Mono\";a:3:{s:5:\"label\";s:9:\"B612 Mono\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:10:\"Bad Script\";a:3:{s:5:\"label\";s:10:\"Bad Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Bahiana\";a:3:{s:5:\"label\";s:7:\"Bahiana\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Bahianita\";a:3:{s:5:\"label\";s:9:\"Bahianita\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Bai Jamjuree\";a:3:{s:5:\"label\";s:12:\"Bai Jamjuree\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Ballet\";a:3:{s:5:\"label\";s:6:\"Ballet\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Baloo 2\";a:3:{s:5:\"label\";s:7:\"Baloo 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Baloo Bhai 2\";a:3:{s:5:\"label\";s:12:\"Baloo Bhai 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Baloo Bhaina 2\";a:3:{s:5:\"label\";s:14:\"Baloo Bhaina 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Baloo Chettan 2\";a:3:{s:5:\"label\";s:15:\"Baloo Chettan 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Baloo Da 2\";a:3:{s:5:\"label\";s:10:\"Baloo Da 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Baloo Paaji 2\";a:3:{s:5:\"label\";s:13:\"Baloo Paaji 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Baloo Tamma 2\";a:3:{s:5:\"label\";s:13:\"Baloo Tamma 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Baloo Tammudu 2\";a:3:{s:5:\"label\";s:15:\"Baloo Tammudu 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Baloo Thambi 2\";a:3:{s:5:\"label\";s:14:\"Baloo Thambi 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Balsamiq Sans\";a:3:{s:5:\"label\";s:13:\"Balsamiq Sans\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Balthazar\";a:3:{s:5:\"label\";s:9:\"Balthazar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Bangers\";a:3:{s:5:\"label\";s:7:\"Bangers\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Barlow\";a:3:{s:5:\"label\";s:6:\"Barlow\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Barlow Condensed\";a:3:{s:5:\"label\";s:16:\"Barlow Condensed\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Barlow Semi Condensed\";a:3:{s:5:\"label\";s:21:\"Barlow Semi Condensed\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Barriecito\";a:3:{s:5:\"label\";s:10:\"Barriecito\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Barrio\";a:3:{s:5:\"label\";s:6:\"Barrio\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Basic\";a:3:{s:5:\"label\";s:5:\"Basic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Baskervville\";a:3:{s:5:\"label\";s:12:\"Baskervville\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Battambang\";a:3:{s:5:\"label\";s:10:\"Battambang\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Baumans\";a:3:{s:5:\"label\";s:7:\"Baumans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Bayon\";a:3:{s:5:\"label\";s:5:\"Bayon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Be Vietnam\";a:3:{s:5:\"label\";s:10:\"Be Vietnam\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Bebas Neue\";a:3:{s:5:\"label\";s:10:\"Bebas Neue\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Belgrano\";a:3:{s:5:\"label\";s:8:\"Belgrano\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Bellefair\";a:3:{s:5:\"label\";s:9:\"Bellefair\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Belleza\";a:3:{s:5:\"label\";s:7:\"Belleza\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Bellota\";a:3:{s:5:\"label\";s:7:\"Bellota\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Bellota Text\";a:3:{s:5:\"label\";s:12:\"Bellota Text\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"BenchNine\";a:3:{s:5:\"label\";s:9:\"BenchNine\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Benne\";a:3:{s:5:\"label\";s:5:\"Benne\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Bentham\";a:3:{s:5:\"label\";s:7:\"Bentham\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"Berkshire Swash\";a:3:{s:5:\"label\";s:15:\"Berkshire Swash\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Beth Ellen\";a:3:{s:5:\"label\";s:10:\"Beth Ellen\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Bevan\";a:3:{s:5:\"label\";s:5:\"Bevan\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:21:\"Big Shoulders Display\";a:3:{s:5:\"label\";s:21:\"Big Shoulders Display\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:28:\"Big Shoulders Inline Display\";a:3:{s:5:\"label\";s:28:\"Big Shoulders Inline Display\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:25:\"Big Shoulders Inline Text\";a:3:{s:5:\"label\";s:25:\"Big Shoulders Inline Text\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:29:\"Big Shoulders Stencil Display\";a:3:{s:5:\"label\";s:29:\"Big Shoulders Stencil Display\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:26:\"Big Shoulders Stencil Text\";a:3:{s:5:\"label\";s:26:\"Big Shoulders Stencil Text\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:18:\"Big Shoulders Text\";a:3:{s:5:\"label\";s:18:\"Big Shoulders Text\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Bigelow Rules\";a:3:{s:5:\"label\";s:13:\"Bigelow Rules\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Bigshot One\";a:3:{s:5:\"label\";s:11:\"Bigshot One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Bilbo\";a:3:{s:5:\"label\";s:5:\"Bilbo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:16:\"Bilbo Swash Caps\";a:3:{s:5:\"label\";s:16:\"Bilbo Swash Caps\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"BioRhyme\";a:3:{s:5:\"label\";s:8:\"BioRhyme\";s:8:\"variants\";a:5:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"BioRhyme Expanded\";a:3:{s:5:\"label\";s:17:\"BioRhyme Expanded\";s:8:\"variants\";a:5:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Biryani\";a:3:{s:5:\"label\";s:7:\"Biryani\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Bitter\";a:3:{s:5:\"label\";s:6:\"Bitter\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:23:\"Black And White Picture\";a:3:{s:5:\"label\";s:23:\"Black And White Picture\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Black Han Sans\";a:3:{s:5:\"label\";s:14:\"Black Han Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Black Ops One\";a:3:{s:5:\"label\";s:13:\"Black Ops One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Blinker\";a:3:{s:5:\"label\";s:7:\"Blinker\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Bodoni Moda\";a:3:{s:5:\"label\";s:11:\"Bodoni Moda\";s:8:\"variants\";a:12:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Bokor\";a:3:{s:5:\"label\";s:5:\"Bokor\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Bona Nova\";a:3:{s:5:\"label\";s:9:\"Bona Nova\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Bonbon\";a:3:{s:5:\"label\";s:6:\"Bonbon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Boogaloo\";a:3:{s:5:\"label\";s:8:\"Boogaloo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Bowlby One\";a:3:{s:5:\"label\";s:10:\"Bowlby One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Bowlby One SC\";a:3:{s:5:\"label\";s:13:\"Bowlby One SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Brawler\";a:3:{s:5:\"label\";s:7:\"Brawler\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Bree Serif\";a:3:{s:5:\"label\";s:10:\"Bree Serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Brygada 1918\";a:3:{s:5:\"label\";s:12:\"Brygada 1918\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Bubblegum Sans\";a:3:{s:5:\"label\";s:14:\"Bubblegum Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Bubbler One\";a:3:{s:5:\"label\";s:11:\"Bubbler One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Buda\";a:3:{s:5:\"label\";s:4:\"Buda\";s:8:\"variants\";a:1:{i:0;s:3:\"300\";}s:8:\"category\";s:7:\"display\";}s:7:\"Buenard\";a:3:{s:5:\"label\";s:7:\"Buenard\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Bungee\";a:3:{s:5:\"label\";s:6:\"Bungee\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Bungee Hairline\";a:3:{s:5:\"label\";s:15:\"Bungee Hairline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Bungee Inline\";a:3:{s:5:\"label\";s:13:\"Bungee Inline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Bungee Outline\";a:3:{s:5:\"label\";s:14:\"Bungee Outline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Bungee Shade\";a:3:{s:5:\"label\";s:12:\"Bungee Shade\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Butcherman\";a:3:{s:5:\"label\";s:10:\"Butcherman\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Butterfly Kids\";a:3:{s:5:\"label\";s:14:\"Butterfly Kids\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Cabin\";a:3:{s:5:\"label\";s:5:\"Cabin\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Cabin Condensed\";a:3:{s:5:\"label\";s:15:\"Cabin Condensed\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Cabin Sketch\";a:3:{s:5:\"label\";s:12:\"Cabin Sketch\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Caesar Dressing\";a:3:{s:5:\"label\";s:15:\"Caesar Dressing\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Cagliostro\";a:3:{s:5:\"label\";s:10:\"Cagliostro\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Cairo\";a:3:{s:5:\"label\";s:5:\"Cairo\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Caladea\";a:3:{s:5:\"label\";s:7:\"Caladea\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Calistoga\";a:3:{s:5:\"label\";s:9:\"Calistoga\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Calligraffitti\";a:3:{s:5:\"label\";s:14:\"Calligraffitti\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Cambay\";a:3:{s:5:\"label\";s:6:\"Cambay\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Cambo\";a:3:{s:5:\"label\";s:5:\"Cambo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Candal\";a:3:{s:5:\"label\";s:6:\"Candal\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Cantarell\";a:3:{s:5:\"label\";s:9:\"Cantarell\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Cantata One\";a:3:{s:5:\"label\";s:11:\"Cantata One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Cantora One\";a:3:{s:5:\"label\";s:11:\"Cantora One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Capriola\";a:3:{s:5:\"label\";s:8:\"Capriola\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Cardo\";a:3:{s:5:\"label\";s:5:\"Cardo\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Carme\";a:3:{s:5:\"label\";s:5:\"Carme\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Carrois Gothic\";a:3:{s:5:\"label\";s:14:\"Carrois Gothic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Carrois Gothic SC\";a:3:{s:5:\"label\";s:17:\"Carrois Gothic SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Carter One\";a:3:{s:5:\"label\";s:10:\"Carter One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Castoro\";a:3:{s:5:\"label\";s:7:\"Castoro\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Catamaran\";a:3:{s:5:\"label\";s:9:\"Catamaran\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Caudex\";a:3:{s:5:\"label\";s:6:\"Caudex\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Caveat\";a:3:{s:5:\"label\";s:6:\"Caveat\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Caveat Brush\";a:3:{s:5:\"label\";s:12:\"Caveat Brush\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:18:\"Cedarville Cursive\";a:3:{s:5:\"label\";s:18:\"Cedarville Cursive\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:11:\"Ceviche One\";a:3:{s:5:\"label\";s:11:\"Ceviche One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Chakra Petch\";a:3:{s:5:\"label\";s:12:\"Chakra Petch\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Changa\";a:3:{s:5:\"label\";s:6:\"Changa\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Changa One\";a:3:{s:5:\"label\";s:10:\"Changa One\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Chango\";a:3:{s:5:\"label\";s:6:\"Chango\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Charm\";a:3:{s:5:\"label\";s:5:\"Charm\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Charmonman\";a:3:{s:5:\"label\";s:10:\"Charmonman\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Chathura\";a:3:{s:5:\"label\";s:8:\"Chathura\";s:8:\"variants\";a:5:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Chau Philomene One\";a:3:{s:5:\"label\";s:18:\"Chau Philomene One\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Chela One\";a:3:{s:5:\"label\";s:9:\"Chela One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Chelsea Market\";a:3:{s:5:\"label\";s:14:\"Chelsea Market\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Chenla\";a:3:{s:5:\"label\";s:6:\"Chenla\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:17:\"Cherry Cream Soda\";a:3:{s:5:\"label\";s:17:\"Cherry Cream Soda\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Cherry Swash\";a:3:{s:5:\"label\";s:12:\"Cherry Swash\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Chewy\";a:3:{s:5:\"label\";s:5:\"Chewy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Chicle\";a:3:{s:5:\"label\";s:6:\"Chicle\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Chilanka\";a:3:{s:5:\"label\";s:8:\"Chilanka\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Chivo\";a:3:{s:5:\"label\";s:5:\"Chivo\";s:8:\"variants\";a:8:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Chonburi\";a:3:{s:5:\"label\";s:8:\"Chonburi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Cinzel\";a:3:{s:5:\"label\";s:6:\"Cinzel\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Cinzel Decorative\";a:3:{s:5:\"label\";s:17:\"Cinzel Decorative\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"900\";i:2;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Clicker Script\";a:3:{s:5:\"label\";s:14:\"Clicker Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:4:\"Coda\";a:3:{s:5:\"label\";s:4:\"Coda\";s:8:\"variants\";a:2:{i:0;s:3:\"800\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Coda Caption\";a:3:{s:5:\"label\";s:12:\"Coda Caption\";s:8:\"variants\";a:1:{i:0;s:3:\"800\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Codystar\";a:3:{s:5:\"label\";s:8:\"Codystar\";s:8:\"variants\";a:2:{i:0;s:3:\"300\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Coiny\";a:3:{s:5:\"label\";s:5:\"Coiny\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Combo\";a:3:{s:5:\"label\";s:5:\"Combo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Comfortaa\";a:3:{s:5:\"label\";s:9:\"Comfortaa\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Comic Neue\";a:3:{s:5:\"label\";s:10:\"Comic Neue\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:11:\"Coming Soon\";a:3:{s:5:\"label\";s:11:\"Coming Soon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Commissioner\";a:3:{s:5:\"label\";s:12:\"Commissioner\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Concert One\";a:3:{s:5:\"label\";s:11:\"Concert One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Condiment\";a:3:{s:5:\"label\";s:9:\"Condiment\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Content\";a:3:{s:5:\"label\";s:7:\"Content\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Contrail One\";a:3:{s:5:\"label\";s:12:\"Contrail One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Convergence\";a:3:{s:5:\"label\";s:11:\"Convergence\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Cookie\";a:3:{s:5:\"label\";s:6:\"Cookie\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Copse\";a:3:{s:5:\"label\";s:5:\"Copse\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Corben\";a:3:{s:5:\"label\";s:6:\"Corben\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Cormorant\";a:3:{s:5:\"label\";s:9:\"Cormorant\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"Cormorant Garamond\";a:3:{s:5:\"label\";s:18:\"Cormorant Garamond\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Cormorant Infant\";a:3:{s:5:\"label\";s:16:\"Cormorant Infant\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Cormorant SC\";a:3:{s:5:\"label\";s:12:\"Cormorant SC\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Cormorant Unicase\";a:3:{s:5:\"label\";s:17:\"Cormorant Unicase\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Cormorant Upright\";a:3:{s:5:\"label\";s:17:\"Cormorant Upright\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Courgette\";a:3:{s:5:\"label\";s:9:\"Courgette\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Courier Prime\";a:3:{s:5:\"label\";s:13:\"Courier Prime\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:7:\"Cousine\";a:3:{s:5:\"label\";s:7:\"Cousine\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:8:\"Coustard\";a:3:{s:5:\"label\";s:8:\"Coustard\";s:8:\"variants\";a:2:{i:0;s:3:\"900\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:21:\"Covered By Your Grace\";a:3:{s:5:\"label\";s:21:\"Covered By Your Grace\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Crafty Girls\";a:3:{s:5:\"label\";s:12:\"Crafty Girls\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Creepster\";a:3:{s:5:\"label\";s:9:\"Creepster\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Crete Round\";a:3:{s:5:\"label\";s:11:\"Crete Round\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Crimson Pro\";a:3:{s:5:\"label\";s:11:\"Crimson Pro\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Crimson Text\";a:3:{s:5:\"label\";s:12:\"Crimson Text\";s:8:\"variants\";a:6:{i:0;s:3:\"600\";i:1;s:9:\"600italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Croissant One\";a:3:{s:5:\"label\";s:13:\"Croissant One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Crushed\";a:3:{s:5:\"label\";s:7:\"Crushed\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Cuprum\";a:3:{s:5:\"label\";s:6:\"Cuprum\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Cute Font\";a:3:{s:5:\"label\";s:9:\"Cute Font\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Cutive\";a:3:{s:5:\"label\";s:6:\"Cutive\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Cutive Mono\";a:3:{s:5:\"label\";s:11:\"Cutive Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:7:\"DM Mono\";a:3:{s:5:\"label\";s:7:\"DM Mono\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:7:\"DM Sans\";a:3:{s:5:\"label\";s:7:\"DM Sans\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"DM Serif Display\";a:3:{s:5:\"label\";s:16:\"DM Serif Display\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"DM Serif Text\";a:3:{s:5:\"label\";s:13:\"DM Serif Text\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Damion\";a:3:{s:5:\"label\";s:6:\"Damion\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Dancing Script\";a:3:{s:5:\"label\";s:14:\"Dancing Script\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Dangrek\";a:3:{s:5:\"label\";s:7:\"Dangrek\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Darker Grotesque\";a:3:{s:5:\"label\";s:16:\"Darker Grotesque\";s:8:\"variants\";a:7:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"David Libre\";a:3:{s:5:\"label\";s:11:\"David Libre\";s:8:\"variants\";a:3:{i:0;s:3:\"500\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:20:\"Dawning of a New Day\";a:3:{s:5:\"label\";s:20:\"Dawning of a New Day\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Days One\";a:3:{s:5:\"label\";s:8:\"Days One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Dekko\";a:3:{s:5:\"label\";s:5:\"Dekko\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Dela Gothic One\";a:3:{s:5:\"label\";s:15:\"Dela Gothic One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Delius\";a:3:{s:5:\"label\";s:6:\"Delius\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:17:\"Delius Swash Caps\";a:3:{s:5:\"label\";s:17:\"Delius Swash Caps\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Delius Unicase\";a:3:{s:5:\"label\";s:14:\"Delius Unicase\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Della Respira\";a:3:{s:5:\"label\";s:13:\"Della Respira\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Denk One\";a:3:{s:5:\"label\";s:8:\"Denk One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Devonshire\";a:3:{s:5:\"label\";s:10:\"Devonshire\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Dhurjati\";a:3:{s:5:\"label\";s:8:\"Dhurjati\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Didact Gothic\";a:3:{s:5:\"label\";s:13:\"Didact Gothic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Diplomata\";a:3:{s:5:\"label\";s:9:\"Diplomata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Diplomata SC\";a:3:{s:5:\"label\";s:12:\"Diplomata SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Do Hyeon\";a:3:{s:5:\"label\";s:8:\"Do Hyeon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Dokdo\";a:3:{s:5:\"label\";s:5:\"Dokdo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Domine\";a:3:{s:5:\"label\";s:6:\"Domine\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Donegal One\";a:3:{s:5:\"label\";s:11:\"Donegal One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Doppio One\";a:3:{s:5:\"label\";s:10:\"Doppio One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Dorsa\";a:3:{s:5:\"label\";s:5:\"Dorsa\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Dosis\";a:3:{s:5:\"label\";s:5:\"Dosis\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"DotGothic16\";a:3:{s:5:\"label\";s:11:\"DotGothic16\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Dr Sugiyama\";a:3:{s:5:\"label\";s:11:\"Dr Sugiyama\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Duru Sans\";a:3:{s:5:\"label\";s:9:\"Duru Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Dynalight\";a:3:{s:5:\"label\";s:9:\"Dynalight\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"EB Garamond\";a:3:{s:5:\"label\";s:11:\"EB Garamond\";s:8:\"variants\";a:10:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Eagle Lake\";a:3:{s:5:\"label\";s:10:\"Eagle Lake\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"East Sea Dokdo\";a:3:{s:5:\"label\";s:14:\"East Sea Dokdo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Eater\";a:3:{s:5:\"label\";s:5:\"Eater\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Economica\";a:3:{s:5:\"label\";s:9:\"Economica\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Eczar\";a:3:{s:5:\"label\";s:5:\"Eczar\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"El Messiri\";a:3:{s:5:\"label\";s:10:\"El Messiri\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Electrolize\";a:3:{s:5:\"label\";s:11:\"Electrolize\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Elsie\";a:3:{s:5:\"label\";s:5:\"Elsie\";s:8:\"variants\";a:2:{i:0;s:3:\"900\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Elsie Swash Caps\";a:3:{s:5:\"label\";s:16:\"Elsie Swash Caps\";s:8:\"variants\";a:2:{i:0;s:3:\"900\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Emblema One\";a:3:{s:5:\"label\";s:11:\"Emblema One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Emilys Candy\";a:3:{s:5:\"label\";s:12:\"Emilys Candy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Encode Sans\";a:3:{s:5:\"label\";s:11:\"Encode Sans\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Encode Sans Condensed\";a:3:{s:5:\"label\";s:21:\"Encode Sans Condensed\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Encode Sans Expanded\";a:3:{s:5:\"label\";s:20:\"Encode Sans Expanded\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Encode Sans SC\";a:3:{s:5:\"label\";s:14:\"Encode Sans SC\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:26:\"Encode Sans Semi Condensed\";a:3:{s:5:\"label\";s:26:\"Encode Sans Semi Condensed\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:25:\"Encode Sans Semi Expanded\";a:3:{s:5:\"label\";s:25:\"Encode Sans Semi Expanded\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Engagement\";a:3:{s:5:\"label\";s:10:\"Engagement\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Englebert\";a:3:{s:5:\"label\";s:9:\"Englebert\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Enriqueta\";a:3:{s:5:\"label\";s:9:\"Enriqueta\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Epilogue\";a:3:{s:5:\"label\";s:8:\"Epilogue\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Erica One\";a:3:{s:5:\"label\";s:9:\"Erica One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Esteban\";a:3:{s:5:\"label\";s:7:\"Esteban\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"Euphoria Script\";a:3:{s:5:\"label\";s:15:\"Euphoria Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Ewert\";a:3:{s:5:\"label\";s:5:\"Ewert\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:3:\"Exo\";a:3:{s:5:\"label\";s:3:\"Exo\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Exo 2\";a:3:{s:5:\"label\";s:5:\"Exo 2\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Expletus Sans\";a:3:{s:5:\"label\";s:13:\"Expletus Sans\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Fahkwang\";a:3:{s:5:\"label\";s:8:\"Fahkwang\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Fanwood Text\";a:3:{s:5:\"label\";s:12:\"Fanwood Text\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Farro\";a:3:{s:5:\"label\";s:5:\"Farro\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Farsan\";a:3:{s:5:\"label\";s:6:\"Farsan\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Fascinate\";a:3:{s:5:\"label\";s:9:\"Fascinate\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Fascinate Inline\";a:3:{s:5:\"label\";s:16:\"Fascinate Inline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Faster One\";a:3:{s:5:\"label\";s:10:\"Faster One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Fasthand\";a:3:{s:5:\"label\";s:8:\"Fasthand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Fauna One\";a:3:{s:5:\"label\";s:9:\"Fauna One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Faustina\";a:3:{s:5:\"label\";s:8:\"Faustina\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Federant\";a:3:{s:5:\"label\";s:8:\"Federant\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Federo\";a:3:{s:5:\"label\";s:6:\"Federo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Felipa\";a:3:{s:5:\"label\";s:6:\"Felipa\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Fenix\";a:3:{s:5:\"label\";s:5:\"Fenix\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Festive\";a:3:{s:5:\"label\";s:7:\"Festive\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Finger Paint\";a:3:{s:5:\"label\";s:12:\"Finger Paint\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Fira Code\";a:3:{s:5:\"label\";s:9:\"Fira Code\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:9:\"Fira Mono\";a:3:{s:5:\"label\";s:9:\"Fira Mono\";s:8:\"variants\";a:3:{i:0;s:3:\"500\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:9:\"Fira Sans\";a:3:{s:5:\"label\";s:9:\"Fira Sans\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Fira Sans Condensed\";a:3:{s:5:\"label\";s:19:\"Fira Sans Condensed\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:25:\"Fira Sans Extra Condensed\";a:3:{s:5:\"label\";s:25:\"Fira Sans Extra Condensed\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Fjalla One\";a:3:{s:5:\"label\";s:10:\"Fjalla One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Fjord One\";a:3:{s:5:\"label\";s:9:\"Fjord One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Flamenco\";a:3:{s:5:\"label\";s:8:\"Flamenco\";s:8:\"variants\";a:2:{i:0;s:3:\"300\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Flavors\";a:3:{s:5:\"label\";s:7:\"Flavors\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Fondamento\";a:3:{s:5:\"label\";s:10:\"Fondamento\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:16:\"Fontdiner Swanky\";a:3:{s:5:\"label\";s:16:\"Fontdiner Swanky\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Forum\";a:3:{s:5:\"label\";s:5:\"Forum\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Francois One\";a:3:{s:5:\"label\";s:12:\"Francois One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Frank Ruhl Libre\";a:3:{s:5:\"label\";s:16:\"Frank Ruhl Libre\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"700\";i:3;s:3:\"900\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Fraunces\";a:3:{s:5:\"label\";s:8:\"Fraunces\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Freckle Face\";a:3:{s:5:\"label\";s:12:\"Freckle Face\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:20:\"Fredericka the Great\";a:3:{s:5:\"label\";s:20:\"Fredericka the Great\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Fredoka One\";a:3:{s:5:\"label\";s:11:\"Fredoka One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Freehand\";a:3:{s:5:\"label\";s:8:\"Freehand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Fresca\";a:3:{s:5:\"label\";s:6:\"Fresca\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Frijole\";a:3:{s:5:\"label\";s:7:\"Frijole\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Fruktur\";a:3:{s:5:\"label\";s:7:\"Fruktur\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Fugaz One\";a:3:{s:5:\"label\";s:9:\"Fugaz One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Fuggles\";a:3:{s:5:\"label\";s:7:\"Fuggles\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"GFS Didot\";a:3:{s:5:\"label\";s:9:\"GFS Didot\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"GFS Neohellenic\";a:3:{s:5:\"label\";s:15:\"GFS Neohellenic\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Gabriela\";a:3:{s:5:\"label\";s:8:\"Gabriela\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Gaegu\";a:3:{s:5:\"label\";s:5:\"Gaegu\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Gafata\";a:3:{s:5:\"label\";s:6:\"Gafata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Galada\";a:3:{s:5:\"label\";s:6:\"Galada\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Galdeano\";a:3:{s:5:\"label\";s:8:\"Galdeano\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Galindo\";a:3:{s:5:\"label\";s:7:\"Galindo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Gamja Flower\";a:3:{s:5:\"label\";s:12:\"Gamja Flower\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Gayathri\";a:3:{s:5:\"label\";s:8:\"Gayathri\";s:8:\"variants\";a:3:{i:0;s:3:\"100\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Gelasio\";a:3:{s:5:\"label\";s:7:\"Gelasio\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Gentium Basic\";a:3:{s:5:\"label\";s:13:\"Gentium Basic\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"Gentium Book Basic\";a:3:{s:5:\"label\";s:18:\"Gentium Book Basic\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:3:\"Geo\";a:3:{s:5:\"label\";s:3:\"Geo\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Geostar\";a:3:{s:5:\"label\";s:7:\"Geostar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Geostar Fill\";a:3:{s:5:\"label\";s:12:\"Geostar Fill\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Germania One\";a:3:{s:5:\"label\";s:12:\"Germania One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Gidugu\";a:3:{s:5:\"label\";s:6:\"Gidugu\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Gilda Display\";a:3:{s:5:\"label\";s:13:\"Gilda Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Girassol\";a:3:{s:5:\"label\";s:8:\"Girassol\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Give You Glory\";a:3:{s:5:\"label\";s:14:\"Give You Glory\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Glass Antiqua\";a:3:{s:5:\"label\";s:13:\"Glass Antiqua\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Glegoo\";a:3:{s:5:\"label\";s:6:\"Glegoo\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Gloria Hallelujah\";a:3:{s:5:\"label\";s:17:\"Gloria Hallelujah\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Goblin One\";a:3:{s:5:\"label\";s:10:\"Goblin One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Gochi Hand\";a:3:{s:5:\"label\";s:10:\"Gochi Hand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Goldman\";a:3:{s:5:\"label\";s:7:\"Goldman\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Gorditas\";a:3:{s:5:\"label\";s:8:\"Gorditas\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Gothic A1\";a:3:{s:5:\"label\";s:9:\"Gothic A1\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Gotu\";a:3:{s:5:\"label\";s:4:\"Gotu\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Goudy Bookletter 1911\";a:3:{s:5:\"label\";s:21:\"Goudy Bookletter 1911\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Graduate\";a:3:{s:5:\"label\";s:8:\"Graduate\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Grand Hotel\";a:3:{s:5:\"label\";s:11:\"Grand Hotel\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Grandstander\";a:3:{s:5:\"label\";s:12:\"Grandstander\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Gravitas One\";a:3:{s:5:\"label\";s:12:\"Gravitas One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Great Vibes\";a:3:{s:5:\"label\";s:11:\"Great Vibes\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Grenze\";a:3:{s:5:\"label\";s:6:\"Grenze\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Grenze Gotisch\";a:3:{s:5:\"label\";s:14:\"Grenze Gotisch\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Griffy\";a:3:{s:5:\"label\";s:6:\"Griffy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Gruppo\";a:3:{s:5:\"label\";s:6:\"Gruppo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Gudea\";a:3:{s:5:\"label\";s:5:\"Gudea\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Gugi\";a:3:{s:5:\"label\";s:4:\"Gugi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Gupter\";a:3:{s:5:\"label\";s:6:\"Gupter\";s:8:\"variants\";a:3:{i:0;s:3:\"500\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Gurajada\";a:3:{s:5:\"label\";s:8:\"Gurajada\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Habibi\";a:3:{s:5:\"label\";s:6:\"Habibi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Hachi Maru Pop\";a:3:{s:5:\"label\";s:14:\"Hachi Maru Pop\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Halant\";a:3:{s:5:\"label\";s:6:\"Halant\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"Hammersmith One\";a:3:{s:5:\"label\";s:15:\"Hammersmith One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Hanalei\";a:3:{s:5:\"label\";s:7:\"Hanalei\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Hanalei Fill\";a:3:{s:5:\"label\";s:12:\"Hanalei Fill\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Handlee\";a:3:{s:5:\"label\";s:7:\"Handlee\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Hanuman\";a:3:{s:5:\"label\";s:7:\"Hanuman\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Happy Monkey\";a:3:{s:5:\"label\";s:12:\"Happy Monkey\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Harmattan\";a:3:{s:5:\"label\";s:9:\"Harmattan\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Headland One\";a:3:{s:5:\"label\";s:12:\"Headland One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Heebo\";a:3:{s:5:\"label\";s:5:\"Heebo\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Henny Penny\";a:3:{s:5:\"label\";s:11:\"Henny Penny\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Hepta Slab\";a:3:{s:5:\"label\";s:10:\"Hepta Slab\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:20:\"Herr Von Muellerhoff\";a:3:{s:5:\"label\";s:20:\"Herr Von Muellerhoff\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Hi Melody\";a:3:{s:5:\"label\";s:9:\"Hi Melody\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:4:\"Hind\";a:3:{s:5:\"label\";s:4:\"Hind\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Hind Guntur\";a:3:{s:5:\"label\";s:11:\"Hind Guntur\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Hind Madurai\";a:3:{s:5:\"label\";s:12:\"Hind Madurai\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Hind Siliguri\";a:3:{s:5:\"label\";s:13:\"Hind Siliguri\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Hind Vadodara\";a:3:{s:5:\"label\";s:13:\"Hind Vadodara\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Holtwood One SC\";a:3:{s:5:\"label\";s:15:\"Holtwood One SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Homemade Apple\";a:3:{s:5:\"label\";s:14:\"Homemade Apple\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Homenaje\";a:3:{s:5:\"label\";s:8:\"Homenaje\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"IBM Plex Mono\";a:3:{s:5:\"label\";s:13:\"IBM Plex Mono\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:13:\"IBM Plex Sans\";a:3:{s:5:\"label\";s:13:\"IBM Plex Sans\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:23:\"IBM Plex Sans Condensed\";a:3:{s:5:\"label\";s:23:\"IBM Plex Sans Condensed\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"IBM Plex Serif\";a:3:{s:5:\"label\";s:14:\"IBM Plex Serif\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"IM Fell DW Pica\";a:3:{s:5:\"label\";s:15:\"IM Fell DW Pica\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"IM Fell DW Pica SC\";a:3:{s:5:\"label\";s:18:\"IM Fell DW Pica SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:19:\"IM Fell Double Pica\";a:3:{s:5:\"label\";s:19:\"IM Fell Double Pica\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:22:\"IM Fell Double Pica SC\";a:3:{s:5:\"label\";s:22:\"IM Fell Double Pica SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"IM Fell English\";a:3:{s:5:\"label\";s:15:\"IM Fell English\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"IM Fell English SC\";a:3:{s:5:\"label\";s:18:\"IM Fell English SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:20:\"IM Fell French Canon\";a:3:{s:5:\"label\";s:20:\"IM Fell French Canon\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:23:\"IM Fell French Canon SC\";a:3:{s:5:\"label\";s:23:\"IM Fell French Canon SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:20:\"IM Fell Great Primer\";a:3:{s:5:\"label\";s:20:\"IM Fell Great Primer\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:23:\"IM Fell Great Primer SC\";a:3:{s:5:\"label\";s:23:\"IM Fell Great Primer SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Ibarra Real Nova\";a:3:{s:5:\"label\";s:16:\"Ibarra Real Nova\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Iceberg\";a:3:{s:5:\"label\";s:7:\"Iceberg\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Iceland\";a:3:{s:5:\"label\";s:7:\"Iceland\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Imbue\";a:3:{s:5:\"label\";s:5:\"Imbue\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Imprima\";a:3:{s:5:\"label\";s:7:\"Imprima\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Inconsolata\";a:3:{s:5:\"label\";s:11:\"Inconsolata\";s:8:\"variants\";a:8:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:5:\"Inder\";a:3:{s:5:\"label\";s:5:\"Inder\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Indie Flower\";a:3:{s:5:\"label\";s:12:\"Indie Flower\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Inika\";a:3:{s:5:\"label\";s:5:\"Inika\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Inknut Antiqua\";a:3:{s:5:\"label\";s:14:\"Inknut Antiqua\";s:8:\"variants\";a:7:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Inria Sans\";a:3:{s:5:\"label\";s:10:\"Inria Sans\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Inria Serif\";a:3:{s:5:\"label\";s:11:\"Inria Serif\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Inter\";a:3:{s:5:\"label\";s:5:\"Inter\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Irish Grover\";a:3:{s:5:\"label\";s:12:\"Irish Grover\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Istok Web\";a:3:{s:5:\"label\";s:9:\"Istok Web\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Italiana\";a:3:{s:5:\"label\";s:8:\"Italiana\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Italianno\";a:3:{s:5:\"label\";s:9:\"Italianno\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:4:\"Itim\";a:3:{s:5:\"label\";s:4:\"Itim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:16:\"Jacques Francois\";a:3:{s:5:\"label\";s:16:\"Jacques Francois\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:23:\"Jacques Francois Shadow\";a:3:{s:5:\"label\";s:23:\"Jacques Francois Shadow\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Jaldi\";a:3:{s:5:\"label\";s:5:\"Jaldi\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"JetBrains Mono\";a:3:{s:5:\"label\";s:14:\"JetBrains Mono\";s:8:\"variants\";a:16:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:14:\"Jim Nightshade\";a:3:{s:5:\"label\";s:14:\"Jim Nightshade\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Jockey One\";a:3:{s:5:\"label\";s:10:\"Jockey One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Jolly Lodger\";a:3:{s:5:\"label\";s:12:\"Jolly Lodger\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Jomhuria\";a:3:{s:5:\"label\";s:8:\"Jomhuria\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Jomolhari\";a:3:{s:5:\"label\";s:9:\"Jomolhari\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Josefin Sans\";a:3:{s:5:\"label\";s:12:\"Josefin Sans\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Josefin Slab\";a:3:{s:5:\"label\";s:12:\"Josefin Slab\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Jost\";a:3:{s:5:\"label\";s:4:\"Jost\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Joti One\";a:3:{s:5:\"label\";s:8:\"Joti One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:3:\"Jua\";a:3:{s:5:\"label\";s:3:\"Jua\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Judson\";a:3:{s:5:\"label\";s:6:\"Judson\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Julee\";a:3:{s:5:\"label\";s:5:\"Julee\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Julius Sans One\";a:3:{s:5:\"label\";s:15:\"Julius Sans One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Junge\";a:3:{s:5:\"label\";s:5:\"Junge\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Jura\";a:3:{s:5:\"label\";s:4:\"Jura\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Just Another Hand\";a:3:{s:5:\"label\";s:17:\"Just Another Hand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:23:\"Just Me Again Down Here\";a:3:{s:5:\"label\";s:23:\"Just Me Again Down Here\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:3:\"K2D\";a:3:{s:5:\"label\";s:3:\"K2D\";s:8:\"variants\";a:16:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Kadwa\";a:3:{s:5:\"label\";s:5:\"Kadwa\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Kalam\";a:3:{s:5:\"label\";s:5:\"Kalam\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Kameron\";a:3:{s:5:\"label\";s:7:\"Kameron\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Kanit\";a:3:{s:5:\"label\";s:5:\"Kanit\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Kantumruy\";a:3:{s:5:\"label\";s:9:\"Kantumruy\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Karantina\";a:3:{s:5:\"label\";s:9:\"Karantina\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Karla\";a:3:{s:5:\"label\";s:5:\"Karla\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Karma\";a:3:{s:5:\"label\";s:5:\"Karma\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Katibeh\";a:3:{s:5:\"label\";s:7:\"Katibeh\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Kaushan Script\";a:3:{s:5:\"label\";s:14:\"Kaushan Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Kavivanar\";a:3:{s:5:\"label\";s:9:\"Kavivanar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Kavoon\";a:3:{s:5:\"label\";s:6:\"Kavoon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Kdam Thmor\";a:3:{s:5:\"label\";s:10:\"Kdam Thmor\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Keania One\";a:3:{s:5:\"label\";s:10:\"Keania One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Kelly Slab\";a:3:{s:5:\"label\";s:10:\"Kelly Slab\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Kenia\";a:3:{s:5:\"label\";s:5:\"Kenia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Khand\";a:3:{s:5:\"label\";s:5:\"Khand\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Khmer\";a:3:{s:5:\"label\";s:5:\"Khmer\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Khula\";a:3:{s:5:\"label\";s:5:\"Khula\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Kirang Haerang\";a:3:{s:5:\"label\";s:14:\"Kirang Haerang\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Kite One\";a:3:{s:5:\"label\";s:8:\"Kite One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Kiwi Maru\";a:3:{s:5:\"label\";s:9:\"Kiwi Maru\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Knewave\";a:3:{s:5:\"label\";s:7:\"Knewave\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"KoHo\";a:3:{s:5:\"label\";s:4:\"KoHo\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Kodchasan\";a:3:{s:5:\"label\";s:9:\"Kodchasan\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Kosugi\";a:3:{s:5:\"label\";s:6:\"Kosugi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Kosugi Maru\";a:3:{s:5:\"label\";s:11:\"Kosugi Maru\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Kotta One\";a:3:{s:5:\"label\";s:9:\"Kotta One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Koulen\";a:3:{s:5:\"label\";s:6:\"Koulen\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Kranky\";a:3:{s:5:\"label\";s:6:\"Kranky\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Kreon\";a:3:{s:5:\"label\";s:5:\"Kreon\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Kristi\";a:3:{s:5:\"label\";s:6:\"Kristi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Krona One\";a:3:{s:5:\"label\";s:9:\"Krona One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Krub\";a:3:{s:5:\"label\";s:4:\"Krub\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Kufam\";a:3:{s:5:\"label\";s:5:\"Kufam\";s:8:\"variants\";a:12:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Kulim Park\";a:3:{s:5:\"label\";s:10:\"Kulim Park\";s:8:\"variants\";a:10:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Kumar One\";a:3:{s:5:\"label\";s:9:\"Kumar One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:17:\"Kumar One Outline\";a:3:{s:5:\"label\";s:17:\"Kumar One Outline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Kumbh Sans\";a:3:{s:5:\"label\";s:10:\"Kumbh Sans\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Kurale\";a:3:{s:5:\"label\";s:6:\"Kurale\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"La Belle Aurore\";a:3:{s:5:\"label\";s:15:\"La Belle Aurore\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Lacquer\";a:3:{s:5:\"label\";s:7:\"Lacquer\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Laila\";a:3:{s:5:\"label\";s:5:\"Laila\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Lakki Reddy\";a:3:{s:5:\"label\";s:11:\"Lakki Reddy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Lalezar\";a:3:{s:5:\"label\";s:7:\"Lalezar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Lancelot\";a:3:{s:5:\"label\";s:8:\"Lancelot\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Langar\";a:3:{s:5:\"label\";s:6:\"Langar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Lateef\";a:3:{s:5:\"label\";s:6:\"Lateef\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:4:\"Lato\";a:3:{s:5:\"label\";s:4:\"Lato\";s:8:\"variants\";a:10:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"900\";i:7;s:9:\"900italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"League Script\";a:3:{s:5:\"label\";s:13:\"League Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Leckerli One\";a:3:{s:5:\"label\";s:12:\"Leckerli One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Ledger\";a:3:{s:5:\"label\";s:6:\"Ledger\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Lekton\";a:3:{s:5:\"label\";s:6:\"Lekton\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Lemon\";a:3:{s:5:\"label\";s:5:\"Lemon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Lemonada\";a:3:{s:5:\"label\";s:8:\"Lemonada\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Lexend\";a:3:{s:5:\"label\";s:6:\"Lexend\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Lexend Deca\";a:3:{s:5:\"label\";s:11:\"Lexend Deca\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Lexend Exa\";a:3:{s:5:\"label\";s:10:\"Lexend Exa\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Lexend Giga\";a:3:{s:5:\"label\";s:11:\"Lexend Giga\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Lexend Mega\";a:3:{s:5:\"label\";s:11:\"Lexend Mega\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Lexend Peta\";a:3:{s:5:\"label\";s:11:\"Lexend Peta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Lexend Tera\";a:3:{s:5:\"label\";s:11:\"Lexend Tera\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Lexend Zetta\";a:3:{s:5:\"label\";s:12:\"Lexend Zetta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Libre Barcode 128\";a:3:{s:5:\"label\";s:17:\"Libre Barcode 128\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:22:\"Libre Barcode 128 Text\";a:3:{s:5:\"label\";s:22:\"Libre Barcode 128 Text\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Libre Barcode 39\";a:3:{s:5:\"label\";s:16:\"Libre Barcode 39\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:25:\"Libre Barcode 39 Extended\";a:3:{s:5:\"label\";s:25:\"Libre Barcode 39 Extended\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:30:\"Libre Barcode 39 Extended Text\";a:3:{s:5:\"label\";s:30:\"Libre Barcode 39 Extended Text\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:21:\"Libre Barcode 39 Text\";a:3:{s:5:\"label\";s:21:\"Libre Barcode 39 Text\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:24:\"Libre Barcode EAN13 Text\";a:3:{s:5:\"label\";s:24:\"Libre Barcode EAN13 Text\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:17:\"Libre Baskerville\";a:3:{s:5:\"label\";s:17:\"Libre Baskerville\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:20:\"Libre Caslon Display\";a:3:{s:5:\"label\";s:20:\"Libre Caslon Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Libre Caslon Text\";a:3:{s:5:\"label\";s:17:\"Libre Caslon Text\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Libre Franklin\";a:3:{s:5:\"label\";s:14:\"Libre Franklin\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Life Savers\";a:3:{s:5:\"label\";s:11:\"Life Savers\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"800\";i:2;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Lilita One\";a:3:{s:5:\"label\";s:10:\"Lilita One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Lily Script One\";a:3:{s:5:\"label\";s:15:\"Lily Script One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Limelight\";a:3:{s:5:\"label\";s:9:\"Limelight\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Linden Hill\";a:3:{s:5:\"label\";s:11:\"Linden Hill\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Literata\";a:3:{s:5:\"label\";s:8:\"Literata\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Liu Jian Mao Cao\";a:3:{s:5:\"label\";s:16:\"Liu Jian Mao Cao\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Livvic\";a:3:{s:5:\"label\";s:6:\"Livvic\";s:8:\"variants\";a:16:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Lobster\";a:3:{s:5:\"label\";s:7:\"Lobster\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Lobster Two\";a:3:{s:5:\"label\";s:11:\"Lobster Two\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Londrina Outline\";a:3:{s:5:\"label\";s:16:\"Londrina Outline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Londrina Shadow\";a:3:{s:5:\"label\";s:15:\"Londrina Shadow\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Londrina Sketch\";a:3:{s:5:\"label\";s:15:\"Londrina Sketch\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Londrina Solid\";a:3:{s:5:\"label\";s:14:\"Londrina Solid\";s:8:\"variants\";a:4:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"900\";i:3;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Long Cang\";a:3:{s:5:\"label\";s:9:\"Long Cang\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:4:\"Lora\";a:3:{s:5:\"label\";s:4:\"Lora\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:21:\"Love Ya Like A Sister\";a:3:{s:5:\"label\";s:21:\"Love Ya Like A Sister\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:17:\"Loved by the King\";a:3:{s:5:\"label\";s:17:\"Loved by the King\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Lovers Quarrel\";a:3:{s:5:\"label\";s:14:\"Lovers Quarrel\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Luckiest Guy\";a:3:{s:5:\"label\";s:12:\"Luckiest Guy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Lusitana\";a:3:{s:5:\"label\";s:8:\"Lusitana\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Lustria\";a:3:{s:5:\"label\";s:7:\"Lustria\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"M PLUS 1p\";a:3:{s:5:\"label\";s:9:\"M PLUS 1p\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"M PLUS Rounded 1c\";a:3:{s:5:\"label\";s:17:\"M PLUS Rounded 1c\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Ma Shan Zheng\";a:3:{s:5:\"label\";s:13:\"Ma Shan Zheng\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Macondo\";a:3:{s:5:\"label\";s:7:\"Macondo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:18:\"Macondo Swash Caps\";a:3:{s:5:\"label\";s:18:\"Macondo Swash Caps\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Mada\";a:3:{s:5:\"label\";s:4:\"Mada\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Magra\";a:3:{s:5:\"label\";s:5:\"Magra\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Maiden Orange\";a:3:{s:5:\"label\";s:13:\"Maiden Orange\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Maitree\";a:3:{s:5:\"label\";s:7:\"Maitree\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"Major Mono Display\";a:3:{s:5:\"label\";s:18:\"Major Mono Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:4:\"Mako\";a:3:{s:5:\"label\";s:4:\"Mako\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Mali\";a:3:{s:5:\"label\";s:4:\"Mali\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Mallanna\";a:3:{s:5:\"label\";s:8:\"Mallanna\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Mandali\";a:3:{s:5:\"label\";s:7:\"Mandali\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Manjari\";a:3:{s:5:\"label\";s:7:\"Manjari\";s:8:\"variants\";a:3:{i:0;s:3:\"100\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Manrope\";a:3:{s:5:\"label\";s:7:\"Manrope\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Mansalva\";a:3:{s:5:\"label\";s:8:\"Mansalva\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Manuale\";a:3:{s:5:\"label\";s:7:\"Manuale\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Marcellus\";a:3:{s:5:\"label\";s:9:\"Marcellus\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Marcellus SC\";a:3:{s:5:\"label\";s:12:\"Marcellus SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Marck Script\";a:3:{s:5:\"label\";s:12:\"Marck Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Margarine\";a:3:{s:5:\"label\";s:9:\"Margarine\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Markazi Text\";a:3:{s:5:\"label\";s:12:\"Markazi Text\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Marko One\";a:3:{s:5:\"label\";s:9:\"Marko One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Marmelad\";a:3:{s:5:\"label\";s:8:\"Marmelad\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Martel\";a:3:{s:5:\"label\";s:6:\"Martel\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Martel Sans\";a:3:{s:5:\"label\";s:11:\"Martel Sans\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Marvel\";a:3:{s:5:\"label\";s:6:\"Marvel\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Mate\";a:3:{s:5:\"label\";s:4:\"Mate\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Mate SC\";a:3:{s:5:\"label\";s:7:\"Mate SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Maven Pro\";a:3:{s:5:\"label\";s:9:\"Maven Pro\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"McLaren\";a:3:{s:5:\"label\";s:7:\"McLaren\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Meddon\";a:3:{s:5:\"label\";s:6:\"Meddon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"MedievalSharp\";a:3:{s:5:\"label\";s:13:\"MedievalSharp\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Medula One\";a:3:{s:5:\"label\";s:10:\"Medula One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Meera Inimai\";a:3:{s:5:\"label\";s:12:\"Meera Inimai\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Megrim\";a:3:{s:5:\"label\";s:6:\"Megrim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Meie Script\";a:3:{s:5:\"label\";s:11:\"Meie Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Merienda\";a:3:{s:5:\"label\";s:8:\"Merienda\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Merienda One\";a:3:{s:5:\"label\";s:12:\"Merienda One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Merriweather\";a:3:{s:5:\"label\";s:12:\"Merriweather\";s:8:\"variants\";a:8:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Merriweather Sans\";a:3:{s:5:\"label\";s:17:\"Merriweather Sans\";s:8:\"variants\";a:12:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Metal\";a:3:{s:5:\"label\";s:5:\"Metal\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Metal Mania\";a:3:{s:5:\"label\";s:11:\"Metal Mania\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Metamorphous\";a:3:{s:5:\"label\";s:12:\"Metamorphous\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Metrophobic\";a:3:{s:5:\"label\";s:11:\"Metrophobic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Michroma\";a:3:{s:5:\"label\";s:8:\"Michroma\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Milonga\";a:3:{s:5:\"label\";s:7:\"Milonga\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Miltonian\";a:3:{s:5:\"label\";s:9:\"Miltonian\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Miltonian Tattoo\";a:3:{s:5:\"label\";s:16:\"Miltonian Tattoo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Mina\";a:3:{s:5:\"label\";s:4:\"Mina\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Miniver\";a:3:{s:5:\"label\";s:7:\"Miniver\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Miriam Libre\";a:3:{s:5:\"label\";s:12:\"Miriam Libre\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Mirza\";a:3:{s:5:\"label\";s:5:\"Mirza\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Miss Fajardose\";a:3:{s:5:\"label\";s:14:\"Miss Fajardose\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:4:\"Mitr\";a:3:{s:5:\"label\";s:4:\"Mitr\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Modak\";a:3:{s:5:\"label\";s:5:\"Modak\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Modern Antiqua\";a:3:{s:5:\"label\";s:14:\"Modern Antiqua\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Mogra\";a:3:{s:5:\"label\";s:5:\"Mogra\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Molengo\";a:3:{s:5:\"label\";s:7:\"Molengo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Molle\";a:3:{s:5:\"label\";s:5:\"Molle\";s:8:\"variants\";a:1:{i:0;s:6:\"italic\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Monda\";a:3:{s:5:\"label\";s:5:\"Monda\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Monofett\";a:3:{s:5:\"label\";s:8:\"Monofett\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Monoton\";a:3:{s:5:\"label\";s:7:\"Monoton\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:20:\"Monsieur La Doulaise\";a:3:{s:5:\"label\";s:20:\"Monsieur La Doulaise\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Montaga\";a:3:{s:5:\"label\";s:7:\"Montaga\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Montez\";a:3:{s:5:\"label\";s:6:\"Montez\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Montserrat\";a:3:{s:5:\"label\";s:10:\"Montserrat\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Montserrat Alternates\";a:3:{s:5:\"label\";s:21:\"Montserrat Alternates\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Montserrat Subrayada\";a:3:{s:5:\"label\";s:20:\"Montserrat Subrayada\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Moul\";a:3:{s:5:\"label\";s:4:\"Moul\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Moulpali\";a:3:{s:5:\"label\";s:8:\"Moulpali\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:22:\"Mountains of Christmas\";a:3:{s:5:\"label\";s:22:\"Mountains of Christmas\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Mouse Memoirs\";a:3:{s:5:\"label\";s:13:\"Mouse Memoirs\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Mr Bedfort\";a:3:{s:5:\"label\";s:10:\"Mr Bedfort\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Mr Dafoe\";a:3:{s:5:\"label\";s:8:\"Mr Dafoe\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Mr De Haviland\";a:3:{s:5:\"label\";s:14:\"Mr De Haviland\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:19:\"Mrs Saint Delafield\";a:3:{s:5:\"label\";s:19:\"Mrs Saint Delafield\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Mrs Sheppards\";a:3:{s:5:\"label\";s:13:\"Mrs Sheppards\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Mukta\";a:3:{s:5:\"label\";s:5:\"Mukta\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Mukta Mahee\";a:3:{s:5:\"label\";s:11:\"Mukta Mahee\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Mukta Malar\";a:3:{s:5:\"label\";s:11:\"Mukta Malar\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Mukta Vaani\";a:3:{s:5:\"label\";s:11:\"Mukta Vaani\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Mulish\";a:3:{s:5:\"label\";s:6:\"Mulish\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"MuseoModerno\";a:3:{s:5:\"label\";s:12:\"MuseoModerno\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Mystery Quest\";a:3:{s:5:\"label\";s:13:\"Mystery Quest\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:3:\"NTR\";a:3:{s:5:\"label\";s:3:\"NTR\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Nanum Brush Script\";a:3:{s:5:\"label\";s:18:\"Nanum Brush Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Nanum Gothic\";a:3:{s:5:\"label\";s:12:\"Nanum Gothic\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"800\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Nanum Gothic Coding\";a:3:{s:5:\"label\";s:19:\"Nanum Gothic Coding\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:14:\"Nanum Myeongjo\";a:3:{s:5:\"label\";s:14:\"Nanum Myeongjo\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"800\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Nanum Pen Script\";a:3:{s:5:\"label\";s:16:\"Nanum Pen Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Nerko One\";a:3:{s:5:\"label\";s:9:\"Nerko One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Neucha\";a:3:{s:5:\"label\";s:6:\"Neucha\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Neuton\";a:3:{s:5:\"label\";s:6:\"Neuton\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"New Rocker\";a:3:{s:5:\"label\";s:10:\"New Rocker\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"New Tegomin\";a:3:{s:5:\"label\";s:11:\"New Tegomin\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"News Cycle\";a:3:{s:5:\"label\";s:10:\"News Cycle\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Newsreader\";a:3:{s:5:\"label\";s:10:\"Newsreader\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Niconne\";a:3:{s:5:\"label\";s:7:\"Niconne\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Niramit\";a:3:{s:5:\"label\";s:7:\"Niramit\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Nixie One\";a:3:{s:5:\"label\";s:9:\"Nixie One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Nobile\";a:3:{s:5:\"label\";s:6:\"Nobile\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Nokora\";a:3:{s:5:\"label\";s:6:\"Nokora\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Norican\";a:3:{s:5:\"label\";s:7:\"Norican\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Nosifer\";a:3:{s:5:\"label\";s:7:\"Nosifer\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Notable\";a:3:{s:5:\"label\";s:7:\"Notable\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Nothing You Could Do\";a:3:{s:5:\"label\";s:20:\"Nothing You Could Do\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Noticia Text\";a:3:{s:5:\"label\";s:12:\"Noticia Text\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Noto Sans\";a:3:{s:5:\"label\";s:9:\"Noto Sans\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Noto Sans HK\";a:3:{s:5:\"label\";s:12:\"Noto Sans HK\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Noto Sans JP\";a:3:{s:5:\"label\";s:12:\"Noto Sans JP\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Noto Sans KR\";a:3:{s:5:\"label\";s:12:\"Noto Sans KR\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Noto Sans SC\";a:3:{s:5:\"label\";s:12:\"Noto Sans SC\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Noto Sans TC\";a:3:{s:5:\"label\";s:12:\"Noto Sans TC\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Noto Serif\";a:3:{s:5:\"label\";s:10:\"Noto Serif\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Noto Serif JP\";a:3:{s:5:\"label\";s:13:\"Noto Serif JP\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Noto Serif KR\";a:3:{s:5:\"label\";s:13:\"Noto Serif KR\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Noto Serif SC\";a:3:{s:5:\"label\";s:13:\"Noto Serif SC\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Noto Serif TC\";a:3:{s:5:\"label\";s:13:\"Noto Serif TC\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Nova Cut\";a:3:{s:5:\"label\";s:8:\"Nova Cut\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Nova Flat\";a:3:{s:5:\"label\";s:9:\"Nova Flat\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Nova Mono\";a:3:{s:5:\"label\";s:9:\"Nova Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:9:\"Nova Oval\";a:3:{s:5:\"label\";s:9:\"Nova Oval\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Nova Round\";a:3:{s:5:\"label\";s:10:\"Nova Round\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Nova Script\";a:3:{s:5:\"label\";s:11:\"Nova Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Nova Slim\";a:3:{s:5:\"label\";s:9:\"Nova Slim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Nova Square\";a:3:{s:5:\"label\";s:11:\"Nova Square\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Numans\";a:3:{s:5:\"label\";s:6:\"Numans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Nunito\";a:3:{s:5:\"label\";s:6:\"Nunito\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Nunito Sans\";a:3:{s:5:\"label\";s:11:\"Nunito Sans\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Odibee Sans\";a:3:{s:5:\"label\";s:11:\"Odibee Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Odor Mean Chey\";a:3:{s:5:\"label\";s:14:\"Odor Mean Chey\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Offside\";a:3:{s:5:\"label\";s:7:\"Offside\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:2:\"Oi\";a:3:{s:5:\"label\";s:2:\"Oi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Old Standard TT\";a:3:{s:5:\"label\";s:15:\"Old Standard TT\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Oldenburg\";a:3:{s:5:\"label\";s:9:\"Oldenburg\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Oleo Script\";a:3:{s:5:\"label\";s:11:\"Oleo Script\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:22:\"Oleo Script Swash Caps\";a:3:{s:5:\"label\";s:22:\"Oleo Script Swash Caps\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Open Sans\";a:3:{s:5:\"label\";s:9:\"Open Sans\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Open Sans Condensed\";a:3:{s:5:\"label\";s:19:\"Open Sans Condensed\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Oranienbaum\";a:3:{s:5:\"label\";s:11:\"Oranienbaum\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Orbitron\";a:3:{s:5:\"label\";s:8:\"Orbitron\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Oregano\";a:3:{s:5:\"label\";s:7:\"Oregano\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Orelega One\";a:3:{s:5:\"label\";s:11:\"Orelega One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Orienta\";a:3:{s:5:\"label\";s:7:\"Orienta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Original Surfer\";a:3:{s:5:\"label\";s:15:\"Original Surfer\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Oswald\";a:3:{s:5:\"label\";s:6:\"Oswald\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Otomanopee One\";a:3:{s:5:\"label\";s:14:\"Otomanopee One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Over the Rainbow\";a:3:{s:5:\"label\";s:16:\"Over the Rainbow\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Overlock\";a:3:{s:5:\"label\";s:8:\"Overlock\";s:8:\"variants\";a:6:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:3:\"900\";i:3;s:9:\"900italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Overlock SC\";a:3:{s:5:\"label\";s:11:\"Overlock SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Overpass\";a:3:{s:5:\"label\";s:8:\"Overpass\";s:8:\"variants\";a:16:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Overpass Mono\";a:3:{s:5:\"label\";s:13:\"Overpass Mono\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:3:\"Ovo\";a:3:{s:5:\"label\";s:3:\"Ovo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Oxanium\";a:3:{s:5:\"label\";s:7:\"Oxanium\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Oxygen\";a:3:{s:5:\"label\";s:6:\"Oxygen\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Oxygen Mono\";a:3:{s:5:\"label\";s:11:\"Oxygen Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:7:\"PT Mono\";a:3:{s:5:\"label\";s:7:\"PT Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:7:\"PT Sans\";a:3:{s:5:\"label\";s:7:\"PT Sans\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"PT Sans Caption\";a:3:{s:5:\"label\";s:15:\"PT Sans Caption\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"PT Sans Narrow\";a:3:{s:5:\"label\";s:14:\"PT Sans Narrow\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"PT Serif\";a:3:{s:5:\"label\";s:8:\"PT Serif\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"PT Serif Caption\";a:3:{s:5:\"label\";s:16:\"PT Serif Caption\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Pacifico\";a:3:{s:5:\"label\";s:8:\"Pacifico\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Padauk\";a:3:{s:5:\"label\";s:6:\"Padauk\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Palanquin\";a:3:{s:5:\"label\";s:9:\"Palanquin\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Palanquin Dark\";a:3:{s:5:\"label\";s:14:\"Palanquin Dark\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Pangolin\";a:3:{s:5:\"label\";s:8:\"Pangolin\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Paprika\";a:3:{s:5:\"label\";s:7:\"Paprika\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Parisienne\";a:3:{s:5:\"label\";s:10:\"Parisienne\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:11:\"Passero One\";a:3:{s:5:\"label\";s:11:\"Passero One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Passion One\";a:3:{s:5:\"label\";s:11:\"Passion One\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"900\";i:2;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:18:\"Pathway Gothic One\";a:3:{s:5:\"label\";s:18:\"Pathway Gothic One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Patrick Hand\";a:3:{s:5:\"label\";s:12:\"Patrick Hand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Patrick Hand SC\";a:3:{s:5:\"label\";s:15:\"Patrick Hand SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Pattaya\";a:3:{s:5:\"label\";s:7:\"Pattaya\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Patua One\";a:3:{s:5:\"label\";s:9:\"Patua One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Pavanam\";a:3:{s:5:\"label\";s:7:\"Pavanam\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Paytone One\";a:3:{s:5:\"label\";s:11:\"Paytone One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Peddana\";a:3:{s:5:\"label\";s:7:\"Peddana\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Peralta\";a:3:{s:5:\"label\";s:7:\"Peralta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Permanent Marker\";a:3:{s:5:\"label\";s:16:\"Permanent Marker\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:19:\"Petit Formal Script\";a:3:{s:5:\"label\";s:19:\"Petit Formal Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Petrona\";a:3:{s:5:\"label\";s:7:\"Petrona\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Philosopher\";a:3:{s:5:\"label\";s:11:\"Philosopher\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Piazzolla\";a:3:{s:5:\"label\";s:9:\"Piazzolla\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Piedra\";a:3:{s:5:\"label\";s:6:\"Piedra\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Pinyon Script\";a:3:{s:5:\"label\";s:13:\"Pinyon Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Pirata One\";a:3:{s:5:\"label\";s:10:\"Pirata One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Plaster\";a:3:{s:5:\"label\";s:7:\"Plaster\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Play\";a:3:{s:5:\"label\";s:4:\"Play\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Playball\";a:3:{s:5:\"label\";s:8:\"Playball\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Playfair Display\";a:3:{s:5:\"label\";s:16:\"Playfair Display\";s:8:\"variants\";a:12:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:19:\"Playfair Display SC\";a:3:{s:5:\"label\";s:19:\"Playfair Display SC\";s:8:\"variants\";a:6:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:3:\"900\";i:3;s:9:\"900italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Podkova\";a:3:{s:5:\"label\";s:7:\"Podkova\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Poiret One\";a:3:{s:5:\"label\";s:10:\"Poiret One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Poller One\";a:3:{s:5:\"label\";s:10:\"Poller One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Poly\";a:3:{s:5:\"label\";s:4:\"Poly\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Pompiere\";a:3:{s:5:\"label\";s:8:\"Pompiere\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Pontano Sans\";a:3:{s:5:\"label\";s:12:\"Pontano Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Poor Story\";a:3:{s:5:\"label\";s:10:\"Poor Story\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Poppins\";a:3:{s:5:\"label\";s:7:\"Poppins\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Port Lligat Sans\";a:3:{s:5:\"label\";s:16:\"Port Lligat Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Port Lligat Slab\";a:3:{s:5:\"label\";s:16:\"Port Lligat Slab\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Potta One\";a:3:{s:5:\"label\";s:9:\"Potta One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Pragati Narrow\";a:3:{s:5:\"label\";s:14:\"Pragati Narrow\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Prata\";a:3:{s:5:\"label\";s:5:\"Prata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Preahvihear\";a:3:{s:5:\"label\";s:11:\"Preahvihear\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Press Start 2P\";a:3:{s:5:\"label\";s:14:\"Press Start 2P\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Pridi\";a:3:{s:5:\"label\";s:5:\"Pridi\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Princess Sofia\";a:3:{s:5:\"label\";s:14:\"Princess Sofia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Prociono\";a:3:{s:5:\"label\";s:8:\"Prociono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Prompt\";a:3:{s:5:\"label\";s:6:\"Prompt\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Prosto One\";a:3:{s:5:\"label\";s:10:\"Prosto One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Proza Libre\";a:3:{s:5:\"label\";s:11:\"Proza Libre\";s:8:\"variants\";a:10:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Public Sans\";a:3:{s:5:\"label\";s:11:\"Public Sans\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Puritan\";a:3:{s:5:\"label\";s:7:\"Puritan\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Purple Purse\";a:3:{s:5:\"label\";s:12:\"Purple Purse\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Qahiri\";a:3:{s:5:\"label\";s:6:\"Qahiri\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Quando\";a:3:{s:5:\"label\";s:6:\"Quando\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Quantico\";a:3:{s:5:\"label\";s:8:\"Quantico\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Quattrocento\";a:3:{s:5:\"label\";s:12:\"Quattrocento\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Quattrocento Sans\";a:3:{s:5:\"label\";s:17:\"Quattrocento Sans\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Questrial\";a:3:{s:5:\"label\";s:9:\"Questrial\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Quicksand\";a:3:{s:5:\"label\";s:9:\"Quicksand\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Quintessential\";a:3:{s:5:\"label\";s:14:\"Quintessential\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Qwigley\";a:3:{s:5:\"label\";s:7:\"Qwigley\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Racing Sans One\";a:3:{s:5:\"label\";s:15:\"Racing Sans One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Radley\";a:3:{s:5:\"label\";s:6:\"Radley\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Rajdhani\";a:3:{s:5:\"label\";s:8:\"Rajdhani\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Rakkas\";a:3:{s:5:\"label\";s:6:\"Rakkas\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Raleway\";a:3:{s:5:\"label\";s:7:\"Raleway\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Raleway Dots\";a:3:{s:5:\"label\";s:12:\"Raleway Dots\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Ramabhadra\";a:3:{s:5:\"label\";s:10:\"Ramabhadra\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Ramaraja\";a:3:{s:5:\"label\";s:8:\"Ramaraja\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Rambla\";a:3:{s:5:\"label\";s:6:\"Rambla\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Rammetto One\";a:3:{s:5:\"label\";s:12:\"Rammetto One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Ranchers\";a:3:{s:5:\"label\";s:8:\"Ranchers\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Rancho\";a:3:{s:5:\"label\";s:6:\"Rancho\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Ranga\";a:3:{s:5:\"label\";s:5:\"Ranga\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Rasa\";a:3:{s:5:\"label\";s:4:\"Rasa\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Rationale\";a:3:{s:5:\"label\";s:9:\"Rationale\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Ravi Prakash\";a:3:{s:5:\"label\";s:12:\"Ravi Prakash\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Recursive\";a:3:{s:5:\"label\";s:9:\"Recursive\";s:8:\"variants\";a:7:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Red Hat Display\";a:3:{s:5:\"label\";s:15:\"Red Hat Display\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Red Hat Text\";a:3:{s:5:\"label\";s:12:\"Red Hat Text\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Red Rose\";a:3:{s:5:\"label\";s:8:\"Red Rose\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Redressed\";a:3:{s:5:\"label\";s:9:\"Redressed\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Reem Kufi\";a:3:{s:5:\"label\";s:9:\"Reem Kufi\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Reenie Beanie\";a:3:{s:5:\"label\";s:13:\"Reenie Beanie\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Reggae One\";a:3:{s:5:\"label\";s:10:\"Reggae One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Revalia\";a:3:{s:5:\"label\";s:7:\"Revalia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Rhodium Libre\";a:3:{s:5:\"label\";s:13:\"Rhodium Libre\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Ribeye\";a:3:{s:5:\"label\";s:6:\"Ribeye\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Ribeye Marrow\";a:3:{s:5:\"label\";s:13:\"Ribeye Marrow\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Righteous\";a:3:{s:5:\"label\";s:9:\"Righteous\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Risque\";a:3:{s:5:\"label\";s:6:\"Risque\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Roboto\";a:3:{s:5:\"label\";s:6:\"Roboto\";s:8:\"variants\";a:12:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Roboto Condensed\";a:3:{s:5:\"label\";s:16:\"Roboto Condensed\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Roboto Mono\";a:3:{s:5:\"label\";s:11:\"Roboto Mono\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:11:\"Roboto Slab\";a:3:{s:5:\"label\";s:11:\"Roboto Slab\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Rochester\";a:3:{s:5:\"label\";s:9:\"Rochester\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Rock Salt\";a:3:{s:5:\"label\";s:9:\"Rock Salt\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"RocknRoll One\";a:3:{s:5:\"label\";s:13:\"RocknRoll One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Rokkitt\";a:3:{s:5:\"label\";s:7:\"Rokkitt\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Romanesco\";a:3:{s:5:\"label\";s:9:\"Romanesco\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Ropa Sans\";a:3:{s:5:\"label\";s:9:\"Ropa Sans\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Rosario\";a:3:{s:5:\"label\";s:7:\"Rosario\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Rosarivo\";a:3:{s:5:\"label\";s:8:\"Rosarivo\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Rouge Script\";a:3:{s:5:\"label\";s:12:\"Rouge Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Rowdies\";a:3:{s:5:\"label\";s:7:\"Rowdies\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Rozha One\";a:3:{s:5:\"label\";s:9:\"Rozha One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Rubik\";a:3:{s:5:\"label\";s:5:\"Rubik\";s:8:\"variants\";a:14:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Rubik Mono One\";a:3:{s:5:\"label\";s:14:\"Rubik Mono One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Ruda\";a:3:{s:5:\"label\";s:4:\"Ruda\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Rufina\";a:3:{s:5:\"label\";s:6:\"Rufina\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Ruge Boogie\";a:3:{s:5:\"label\";s:11:\"Ruge Boogie\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Ruluko\";a:3:{s:5:\"label\";s:6:\"Ruluko\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Rum Raisin\";a:3:{s:5:\"label\";s:10:\"Rum Raisin\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Ruslan Display\";a:3:{s:5:\"label\";s:14:\"Ruslan Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Russo One\";a:3:{s:5:\"label\";s:9:\"Russo One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Ruthie\";a:3:{s:5:\"label\";s:6:\"Ruthie\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:3:\"Rye\";a:3:{s:5:\"label\";s:3:\"Rye\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"STIX Two Math\";a:3:{s:5:\"label\";s:13:\"STIX Two Math\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Sacramento\";a:3:{s:5:\"label\";s:10:\"Sacramento\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Sahitya\";a:3:{s:5:\"label\";s:7:\"Sahitya\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Sail\";a:3:{s:5:\"label\";s:4:\"Sail\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Saira\";a:3:{s:5:\"label\";s:5:\"Saira\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Saira Condensed\";a:3:{s:5:\"label\";s:15:\"Saira Condensed\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Saira Extra Condensed\";a:3:{s:5:\"label\";s:21:\"Saira Extra Condensed\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Saira Semi Condensed\";a:3:{s:5:\"label\";s:20:\"Saira Semi Condensed\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Saira Stencil One\";a:3:{s:5:\"label\";s:17:\"Saira Stencil One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Salsa\";a:3:{s:5:\"label\";s:5:\"Salsa\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Sanchez\";a:3:{s:5:\"label\";s:7:\"Sanchez\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Sancreek\";a:3:{s:5:\"label\";s:8:\"Sancreek\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Sansita\";a:3:{s:5:\"label\";s:7:\"Sansita\";s:8:\"variants\";a:8:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:3:\"800\";i:3;s:9:\"800italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Sansita Swashed\";a:3:{s:5:\"label\";s:15:\"Sansita Swashed\";s:8:\"variants\";a:7:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Sarabun\";a:3:{s:5:\"label\";s:7:\"Sarabun\";s:8:\"variants\";a:16:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Sarala\";a:3:{s:5:\"label\";s:6:\"Sarala\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Sarina\";a:3:{s:5:\"label\";s:6:\"Sarina\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Sarpanch\";a:3:{s:5:\"label\";s:8:\"Sarpanch\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Satisfy\";a:3:{s:5:\"label\";s:7:\"Satisfy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Sawarabi Gothic\";a:3:{s:5:\"label\";s:15:\"Sawarabi Gothic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Sawarabi Mincho\";a:3:{s:5:\"label\";s:15:\"Sawarabi Mincho\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Scada\";a:3:{s:5:\"label\";s:5:\"Scada\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Scheherazade\";a:3:{s:5:\"label\";s:12:\"Scheherazade\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Schoolbell\";a:3:{s:5:\"label\";s:10:\"Schoolbell\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Scope One\";a:3:{s:5:\"label\";s:9:\"Scope One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Seaweed Script\";a:3:{s:5:\"label\";s:14:\"Seaweed Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Secular One\";a:3:{s:5:\"label\";s:11:\"Secular One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Sedgwick Ave\";a:3:{s:5:\"label\";s:12:\"Sedgwick Ave\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:20:\"Sedgwick Ave Display\";a:3:{s:5:\"label\";s:20:\"Sedgwick Ave Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:3:\"Sen\";a:3:{s:5:\"label\";s:3:\"Sen\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"800\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Sevillana\";a:3:{s:5:\"label\";s:9:\"Sevillana\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Seymour One\";a:3:{s:5:\"label\";s:11:\"Seymour One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Shadows Into Light\";a:3:{s:5:\"label\";s:18:\"Shadows Into Light\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:22:\"Shadows Into Light Two\";a:3:{s:5:\"label\";s:22:\"Shadows Into Light Two\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Shanti\";a:3:{s:5:\"label\";s:6:\"Shanti\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Share\";a:3:{s:5:\"label\";s:5:\"Share\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Share Tech\";a:3:{s:5:\"label\";s:10:\"Share Tech\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Share Tech Mono\";a:3:{s:5:\"label\";s:15:\"Share Tech Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:15:\"Shippori Mincho\";a:3:{s:5:\"label\";s:15:\"Shippori Mincho\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"Shippori Mincho B1\";a:3:{s:5:\"label\";s:18:\"Shippori Mincho B1\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Shojumaru\";a:3:{s:5:\"label\";s:9:\"Shojumaru\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Short Stack\";a:3:{s:5:\"label\";s:11:\"Short Stack\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Shrikhand\";a:3:{s:5:\"label\";s:9:\"Shrikhand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Siemreap\";a:3:{s:5:\"label\";s:8:\"Siemreap\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Sigmar One\";a:3:{s:5:\"label\";s:10:\"Sigmar One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Signika\";a:3:{s:5:\"label\";s:7:\"Signika\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Signika Negative\";a:3:{s:5:\"label\";s:16:\"Signika Negative\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Simonetta\";a:3:{s:5:\"label\";s:9:\"Simonetta\";s:8:\"variants\";a:4:{i:0;s:3:\"900\";i:1;s:9:\"900italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Single Day\";a:3:{s:5:\"label\";s:10:\"Single Day\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Sintony\";a:3:{s:5:\"label\";s:7:\"Sintony\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Sirin Stencil\";a:3:{s:5:\"label\";s:13:\"Sirin Stencil\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Six Caps\";a:3:{s:5:\"label\";s:8:\"Six Caps\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Skranji\";a:3:{s:5:\"label\";s:7:\"Skranji\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Slabo 13px\";a:3:{s:5:\"label\";s:10:\"Slabo 13px\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Slabo 27px\";a:3:{s:5:\"label\";s:10:\"Slabo 27px\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Slackey\";a:3:{s:5:\"label\";s:7:\"Slackey\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Smokum\";a:3:{s:5:\"label\";s:6:\"Smokum\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Smythe\";a:3:{s:5:\"label\";s:6:\"Smythe\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Sniglet\";a:3:{s:5:\"label\";s:7:\"Sniglet\";s:8:\"variants\";a:2:{i:0;s:3:\"800\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Snippet\";a:3:{s:5:\"label\";s:7:\"Snippet\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Snowburst One\";a:3:{s:5:\"label\";s:13:\"Snowburst One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Sofadi One\";a:3:{s:5:\"label\";s:10:\"Sofadi One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Sofia\";a:3:{s:5:\"label\";s:5:\"Sofia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Solway\";a:3:{s:5:\"label\";s:6:\"Solway\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Song Myung\";a:3:{s:5:\"label\";s:10:\"Song Myung\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Sonsie One\";a:3:{s:5:\"label\";s:10:\"Sonsie One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Sora\";a:3:{s:5:\"label\";s:4:\"Sora\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Sorts Mill Goudy\";a:3:{s:5:\"label\";s:16:\"Sorts Mill Goudy\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"Source Code Pro\";a:3:{s:5:\"label\";s:15:\"Source Code Pro\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:15:\"Source Sans Pro\";a:3:{s:5:\"label\";s:15:\"Source Sans Pro\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Source Serif Pro\";a:3:{s:5:\"label\";s:16:\"Source Serif Pro\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Space Grotesk\";a:3:{s:5:\"label\";s:13:\"Space Grotesk\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Space Mono\";a:3:{s:5:\"label\";s:10:\"Space Mono\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:7:\"Spartan\";a:3:{s:5:\"label\";s:7:\"Spartan\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Special Elite\";a:3:{s:5:\"label\";s:13:\"Special Elite\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Spectral\";a:3:{s:5:\"label\";s:8:\"Spectral\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Spectral SC\";a:3:{s:5:\"label\";s:11:\"Spectral SC\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Spicy Rice\";a:3:{s:5:\"label\";s:10:\"Spicy Rice\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Spinnaker\";a:3:{s:5:\"label\";s:9:\"Spinnaker\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Spirax\";a:3:{s:5:\"label\";s:6:\"Spirax\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Squada One\";a:3:{s:5:\"label\";s:10:\"Squada One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:20:\"Sree Krushnadevaraya\";a:3:{s:5:\"label\";s:20:\"Sree Krushnadevaraya\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Sriracha\";a:3:{s:5:\"label\";s:8:\"Sriracha\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Srisakdi\";a:3:{s:5:\"label\";s:8:\"Srisakdi\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Staatliches\";a:3:{s:5:\"label\";s:11:\"Staatliches\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Stalemate\";a:3:{s:5:\"label\";s:9:\"Stalemate\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Stalinist One\";a:3:{s:5:\"label\";s:13:\"Stalinist One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Stardos Stencil\";a:3:{s:5:\"label\";s:15:\"Stardos Stencil\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Stick\";a:3:{s:5:\"label\";s:5:\"Stick\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Stint Ultra Condensed\";a:3:{s:5:\"label\";s:21:\"Stint Ultra Condensed\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:20:\"Stint Ultra Expanded\";a:3:{s:5:\"label\";s:20:\"Stint Ultra Expanded\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Stoke\";a:3:{s:5:\"label\";s:5:\"Stoke\";s:8:\"variants\";a:2:{i:0;s:3:\"300\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Strait\";a:3:{s:5:\"label\";s:6:\"Strait\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Stylish\";a:3:{s:5:\"label\";s:7:\"Stylish\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Sue Ellen Francisco\";a:3:{s:5:\"label\";s:19:\"Sue Ellen Francisco\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Suez One\";a:3:{s:5:\"label\";s:8:\"Suez One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Sulphur Point\";a:3:{s:5:\"label\";s:13:\"Sulphur Point\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Sumana\";a:3:{s:5:\"label\";s:6:\"Sumana\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Sunflower\";a:3:{s:5:\"label\";s:9:\"Sunflower\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"700\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Sunshiney\";a:3:{s:5:\"label\";s:9:\"Sunshiney\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:16:\"Supermercado One\";a:3:{s:5:\"label\";s:16:\"Supermercado One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Sura\";a:3:{s:5:\"label\";s:4:\"Sura\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Suranna\";a:3:{s:5:\"label\";s:7:\"Suranna\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Suravaram\";a:3:{s:5:\"label\";s:9:\"Suravaram\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Suwannaphum\";a:3:{s:5:\"label\";s:11:\"Suwannaphum\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:18:\"Swanky and Moo Moo\";a:3:{s:5:\"label\";s:18:\"Swanky and Moo Moo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Syncopate\";a:3:{s:5:\"label\";s:9:\"Syncopate\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Syne\";a:3:{s:5:\"label\";s:4:\"Syne\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Syne Mono\";a:3:{s:5:\"label\";s:9:\"Syne Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:12:\"Syne Tactile\";a:3:{s:5:\"label\";s:12:\"Syne Tactile\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Tajawal\";a:3:{s:5:\"label\";s:7:\"Tajawal\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Tangerine\";a:3:{s:5:\"label\";s:9:\"Tangerine\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Taprom\";a:3:{s:5:\"label\";s:6:\"Taprom\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Tauri\";a:3:{s:5:\"label\";s:5:\"Tauri\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Taviraj\";a:3:{s:5:\"label\";s:7:\"Taviraj\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Teko\";a:3:{s:5:\"label\";s:4:\"Teko\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Telex\";a:3:{s:5:\"label\";s:5:\"Telex\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Tenali Ramakrishna\";a:3:{s:5:\"label\";s:18:\"Tenali Ramakrishna\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Tenor Sans\";a:3:{s:5:\"label\";s:10:\"Tenor Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Text Me One\";a:3:{s:5:\"label\";s:11:\"Text Me One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Texturina\";a:3:{s:5:\"label\";s:9:\"Texturina\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Thasadith\";a:3:{s:5:\"label\";s:9:\"Thasadith\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"The Girl Next Door\";a:3:{s:5:\"label\";s:18:\"The Girl Next Door\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Tienne\";a:3:{s:5:\"label\";s:6:\"Tienne\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"900\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Tillana\";a:3:{s:5:\"label\";s:7:\"Tillana\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Timmana\";a:3:{s:5:\"label\";s:7:\"Timmana\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Tinos\";a:3:{s:5:\"label\";s:5:\"Tinos\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Titan One\";a:3:{s:5:\"label\";s:9:\"Titan One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Titillium Web\";a:3:{s:5:\"label\";s:13:\"Titillium Web\";s:8:\"variants\";a:11:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"900\";i:9;s:6:\"italic\";i:10;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Tomorrow\";a:3:{s:5:\"label\";s:8:\"Tomorrow\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Tourney\";a:3:{s:5:\"label\";s:7:\"Tourney\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Trade Winds\";a:3:{s:5:\"label\";s:11:\"Trade Winds\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Train One\";a:3:{s:5:\"label\";s:9:\"Train One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Trirong\";a:3:{s:5:\"label\";s:7:\"Trirong\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Trispace\";a:3:{s:5:\"label\";s:8:\"Trispace\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Trocchi\";a:3:{s:5:\"label\";s:7:\"Trocchi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Trochut\";a:3:{s:5:\"label\";s:7:\"Trochut\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Truculenta\";a:3:{s:5:\"label\";s:10:\"Truculenta\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Trykker\";a:3:{s:5:\"label\";s:7:\"Trykker\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Tulpen One\";a:3:{s:5:\"label\";s:10:\"Tulpen One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Turret Road\";a:3:{s:5:\"label\";s:11:\"Turret Road\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Ubuntu\";a:3:{s:5:\"label\";s:6:\"Ubuntu\";s:8:\"variants\";a:8:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Ubuntu Condensed\";a:3:{s:5:\"label\";s:16:\"Ubuntu Condensed\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Ubuntu Mono\";a:3:{s:5:\"label\";s:11:\"Ubuntu Mono\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:5:\"Uchen\";a:3:{s:5:\"label\";s:5:\"Uchen\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Ultra\";a:3:{s:5:\"label\";s:5:\"Ultra\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Uncial Antiqua\";a:3:{s:5:\"label\";s:14:\"Uncial Antiqua\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Underdog\";a:3:{s:5:\"label\";s:8:\"Underdog\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Unica One\";a:3:{s:5:\"label\";s:9:\"Unica One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"UnifrakturCook\";a:3:{s:5:\"label\";s:14:\"UnifrakturCook\";s:8:\"variants\";a:1:{i:0;s:3:\"700\";}s:8:\"category\";s:7:\"display\";}s:18:\"UnifrakturMaguntia\";a:3:{s:5:\"label\";s:18:\"UnifrakturMaguntia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Unkempt\";a:3:{s:5:\"label\";s:7:\"Unkempt\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Unlock\";a:3:{s:5:\"label\";s:6:\"Unlock\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Unna\";a:3:{s:5:\"label\";s:4:\"Unna\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"VT323\";a:3:{s:5:\"label\";s:5:\"VT323\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:11:\"Vampiro One\";a:3:{s:5:\"label\";s:11:\"Vampiro One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Varela\";a:3:{s:5:\"label\";s:6:\"Varela\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Varela Round\";a:3:{s:5:\"label\";s:12:\"Varela Round\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Varta\";a:3:{s:5:\"label\";s:5:\"Varta\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Vast Shadow\";a:3:{s:5:\"label\";s:11:\"Vast Shadow\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Vesper Libre\";a:3:{s:5:\"label\";s:12:\"Vesper Libre\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"700\";i:2;s:3:\"900\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Viaoda Libre\";a:3:{s:5:\"label\";s:12:\"Viaoda Libre\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Vibes\";a:3:{s:5:\"label\";s:5:\"Vibes\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Vibur\";a:3:{s:5:\"label\";s:5:\"Vibur\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Vidaloka\";a:3:{s:5:\"label\";s:8:\"Vidaloka\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Viga\";a:3:{s:5:\"label\";s:4:\"Viga\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Voces\";a:3:{s:5:\"label\";s:5:\"Voces\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Volkhov\";a:3:{s:5:\"label\";s:7:\"Volkhov\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Vollkorn\";a:3:{s:5:\"label\";s:8:\"Vollkorn\";s:8:\"variants\";a:12:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Vollkorn SC\";a:3:{s:5:\"label\";s:11:\"Vollkorn SC\";s:8:\"variants\";a:4:{i:0;s:3:\"600\";i:1;s:3:\"700\";i:2;s:3:\"900\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Voltaire\";a:3:{s:5:\"label\";s:8:\"Voltaire\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:23:\"Waiting for the Sunrise\";a:3:{s:5:\"label\";s:23:\"Waiting for the Sunrise\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Wallpoet\";a:3:{s:5:\"label\";s:8:\"Wallpoet\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Walter Turncoat\";a:3:{s:5:\"label\";s:15:\"Walter Turncoat\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Warnes\";a:3:{s:5:\"label\";s:6:\"Warnes\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Wellfleet\";a:3:{s:5:\"label\";s:9:\"Wellfleet\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Wendy One\";a:3:{s:5:\"label\";s:9:\"Wendy One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Wire One\";a:3:{s:5:\"label\";s:8:\"Wire One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Work Sans\";a:3:{s:5:\"label\";s:9:\"Work Sans\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Xanh Mono\";a:3:{s:5:\"label\";s:9:\"Xanh Mono\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:17:\"Yanone Kaffeesatz\";a:3:{s:5:\"label\";s:17:\"Yanone Kaffeesatz\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Yantramanav\";a:3:{s:5:\"label\";s:11:\"Yantramanav\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Yatra One\";a:3:{s:5:\"label\";s:9:\"Yatra One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Yellowtail\";a:3:{s:5:\"label\";s:10:\"Yellowtail\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Yeon Sung\";a:3:{s:5:\"label\";s:9:\"Yeon Sung\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Yeseva One\";a:3:{s:5:\"label\";s:10:\"Yeseva One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Yesteryear\";a:3:{s:5:\"label\";s:10:\"Yesteryear\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Yomogi\";a:3:{s:5:\"label\";s:6:\"Yomogi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:4:\"Yrsa\";a:3:{s:5:\"label\";s:4:\"Yrsa\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Yusei Magic\";a:3:{s:5:\"label\";s:11:\"Yusei Magic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"ZCOOL KuaiLe\";a:3:{s:5:\"label\";s:12:\"ZCOOL KuaiLe\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:21:\"ZCOOL QingKe HuangYou\";a:3:{s:5:\"label\";s:21:\"ZCOOL QingKe HuangYou\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"ZCOOL XiaoWei\";a:3:{s:5:\"label\";s:13:\"ZCOOL XiaoWei\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Zen Dots\";a:3:{s:5:\"label\";s:8:\"Zen Dots\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Zen Loop\";a:3:{s:5:\"label\";s:8:\"Zen Loop\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Zen Tokyo Zoo\";a:3:{s:5:\"label\";s:13:\"Zen Tokyo Zoo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Zeyada\";a:3:{s:5:\"label\";s:6:\"Zeyada\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Zhi Mang Xing\";a:3:{s:5:\"label\";s:13:\"Zhi Mang Xing\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Zilla Slab\";a:3:{s:5:\"label\";s:10:\"Zilla Slab\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:20:\"Zilla Slab Highlight\";a:3:{s:5:\"label\";s:20:\"Zilla Slab Highlight\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}}", "no");
INSERT INTO `wp_options` VALUES("68094", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("77231", "_site_transient_timeout_browser_a995eec83d67ec764a595cebef703233", "1679731711", "no");
INSERT INTO `wp_options` VALUES("77232", "_site_transient_browser_a995eec83d67ec764a595cebef703233", "a:10:{s:4:\"name\";s:7:\"unknown\";s:7:\"version\";s:0:\"\";s:8:\"platform\";s:0:\"\";s:10:\"update_url\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:11:\"img_src_ssl\";s:0:\"\";s:15:\"current_version\";s:0:\"\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("77024", "_site_transient_timeout_php_check_990bfacb848fa087bcfc06850f5e4447", "1679645213", "no");
INSERT INTO `wp_options` VALUES("76977", "_transient_rank_math_first_submenu_id", "rank-math", "yes");
INSERT INTO `wp_options` VALUES("76978", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:62:\"https://downloads.wordpress.org/release/vi/wordpress-6.1.1.zip\";s:6:\"locale\";s:2:\"vi\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:62:\"https://downloads.wordpress.org/release/vi/wordpress-6.1.1.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.1.1\";s:7:\"version\";s:5:\"6.1.1\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1679127768;s:15:\"version_checked\";s:5:\"6.1.1\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("76980", "_transient_timeout_acf_plugin_updates", "1679211010", "no");
INSERT INTO `wp_options` VALUES("76981", "_transient_acf_plugin_updates", "a:4:{s:7:\"plugins\";a:1:{s:34:\"advanced-custom-fields-pro/acf.php\";a:8:{s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:6:\"plugin\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"new_version\";s:5:\"6.0.7\";s:3:\"url\";s:36:\"https://www.advancedcustomfields.com\";s:6:\"tested\";s:5:\"6.1.1\";s:7:\"package\";s:0:\"\";s:5:\"icons\";a:1:{s:7:\"default\";s:63:\"https://ps.w.org/advanced-custom-fields/assets/icon-256x256.png\";}s:7:\"banners\";a:2:{s:3:\"low\";s:77:\"https://ps.w.org/advanced-custom-fields/assets/banner-772x250.jpg?rev=1729102\";s:4:\"high\";s:78:\"https://ps.w.org/advanced-custom-fields/assets/banner-1544x500.jpg?rev=1729099\";}}}s:10:\"expiration\";i:172800;s:6:\"status\";i:1;s:7:\"checked\";a:1:{s:34:\"advanced-custom-fields-pro/acf.php\";s:5:\"5.9.6\";}}", "no");
INSERT INTO `wp_options` VALUES("77198", "rank_math_sitemap_cache_files", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("77246", "_site_transient_timeout_browser_09872863eb9f2810e6cba485fb238284", "1679731715", "no");
INSERT INTO `wp_options` VALUES("77247", "_site_transient_browser_09872863eb9f2810e6cba485fb238284", "a:10:{s:4:\"name\";s:7:\"unknown\";s:7:\"version\";s:0:\"\";s:8:\"platform\";s:0:\"\";s:10:\"update_url\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:11:\"img_src_ssl\";s:0:\"\";s:15:\"current_version\";s:0:\"\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("77248", "_transient_timeout_rocket_mod_pagespeed_enabled", "1679213325", "no");
INSERT INTO `wp_options` VALUES("77249", "_transient_rocket_mod_pagespeed_enabled", "0", "no");
INSERT INTO `wp_options` VALUES("77250", "_transient_timeout_rocketcdn_pricing", "1679148526", "no");
INSERT INTO `wp_options` VALUES("77251", "_transient_rocketcdn_pricing", "a:7:{s:18:\"is_discount_active\";b:1;s:24:\"discounted_price_monthly\";d:6.99;s:23:\"discounted_price_yearly\";d:78.99;s:22:\"discount_campaign_name\";s:16:\"Anniversary 2022\";s:8:\"end_date\";s:10:\"2022-07-19\";s:13:\"monthly_price\";d:7.99;s:12:\"annual_price\";d:79.99;}", "no");
INSERT INTO `wp_options` VALUES("77329", "duplicator_version_plugin", "1.5.3", "yes");
INSERT INTO `wp_options` VALUES("77330", "duplicator_uninstall_package", "1", "yes");
INSERT INTO `wp_options` VALUES("77331", "duplicator_uninstall_settings", "1", "yes");
INSERT INTO `wp_options` VALUES("77332", "duplicator_settings", "a:17:{s:7:\"version\";s:5:\"1.5.3\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:1;i:0;b:0;}", "yes");
INSERT INTO `wp_options` VALUES("77334", "duplicator_activated", "a:1:{s:4:\"lite\";i:1679127782;}", "yes");
INSERT INTO `wp_options` VALUES("77336", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-03-18 08:24:00\";s:7:\"Version\";s:5:\"1.5.3\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:7:\"10.3.38\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:13:\"20230318_123b\";s:4:\"Hash\";s:35:\"1ab0596fcea4bf2c1522_20230318082400\";s:8:\"NameHash\";s:49:\"20230318_123b_1ab0596fcea4bf2c1522_20230318082400\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:59:\"20230318_123b_1ab0596fcea4bf2c1522_20230318082400_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:30:\"/home/ysscptnb/mami.gameh5.xyz\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1793;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11676;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-03-18 08:24:00\";s:7:\"Version\";s:5:\"1.5.3\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:7:\"10.3.38\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:13:\"20230318_123b\";s:4:\"Hash\";s:35:\"1ab0596fcea4bf2c1522_20230318082400\";s:8:\"NameHash\";s:49:\"20230318_123b_1ab0596fcea4bf2c1522_20230318082400\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:44:\"/home/ysscptnb/mami.gameh5.xyz/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":14:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:18:\"varLowerCaseTables\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:39:\"/home/ysscptnb/mami.gameh5.xyz/wp-admin\";i:1;s:42:\"/home/ysscptnb/mami.gameh5.xyz/wp-includes\";i:2;s:51:\"/home/ysscptnb/mami.gameh5.xyz/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:30:\"/home/ysscptnb/mami.gameh5.xyz\";i:1;s:30:\"/home/ysscptnb/mami.gameh5.xyz\";i:2;s:41:\"/home/ysscptnb/mami.gameh5.xyz/wp-content\";i:3;s:49:\"/home/ysscptnb/mami.gameh5.xyz/wp-content/uploads\";i:4;s:49:\"/home/ysscptnb/mami.gameh5.xyz/wp-content/plugins\";i:5;s:52:\"/home/ysscptnb/mami.gameh5.xyz/wp-content/mu-plugins\";i:6;s:48:\"/home/ysscptnb/mami.gameh5.xyz/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:62:\"/home/ysscptnb/mami.gameh5.xyz/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:143;}", "yes");
INSERT INTO `wp_options` VALUES("77277", "_site_transient_timeout_browser_5f931a301e8b860d486f5b75fc2f5b65", "1679731918", "no");
INSERT INTO `wp_options` VALUES("77278", "_site_transient_browser_5f931a301e8b860d486f5b75fc2f5b65", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"44.0.2403.157\";s:8:\"platform\";s:5:\"Linux\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("77281", "_transient_timeout_tablepress_85f8809bab379df2ef6147a5cd515642", "1679213519", "no");
INSERT INTO `wp_options` VALUES("77282", "_transient_tablepress_85f8809bab379df2ef6147a5cd515642", "\n<table id=\"tablepress-24\" class=\"tablepress tablepress-id-24\">\n<thead>\n<tr class=\"row-1 odd\">\n	<th class=\"column-1\"><br />\n✅ Tốc độ nạp tiền</th><th class=\"column-2\">⭐Siêu nhanh</th>\n</tr>\n</thead>\n<tbody class=\"row-hover\">\n<tr class=\"row-2 even\">\n	<td class=\"column-1\"><br />\n✅ Phương thức nạp tiền</td><td class=\"column-2\">⭐Đa nền tảng</td>\n</tr>\n<tr class=\"row-3 odd\">\n	<td class=\"column-1\"><br />\n✅ Hạn mức nạp tiền</td><td class=\"column-2\">⭐300.00.000 vnđ</td>\n</tr>\n<tr class=\"row-4 even\">\n	<td class=\"column-1\"><br />\n✅ Khuyến mãi nạp tiền</td><td class=\"column-2\">⭐Siêu khủng</td>\n</tr>\n<tr class=\"row-5 odd\">\n	<td class=\"column-1\"><br />\n✅ Thời gian hỗ trợ nạp tiền</td><td class=\"column-2\">⭐24/7</td>\n</tr>\n</tbody>\n</table>\n", "no");
INSERT INTO `wp_options` VALUES("77283", "_transient_timeout_tablepress_c_1ff1de774005f8da13f42943881c655f", "1679299919", "no");
INSERT INTO `wp_options` VALUES("77284", "_transient_tablepress_c_1ff1de774005f8da13f42943881c655f", "[\"tablepress_85f8809bab379df2ef6147a5cd515642\",\"tablepress_b8164f19a3424338bf9df67e366ef43d\"]", "no");
INSERT INTO `wp_options` VALUES("77285", "_transient_timeout_tablepress_b8164f19a3424338bf9df67e366ef43d", "1679213519", "no");
INSERT INTO `wp_options` VALUES("77286", "_transient_tablepress_b8164f19a3424338bf9df67e366ef43d", "\n<table id=\"tablepress-24-no-2\" class=\"tablepress tablepress-id-24\">\n<thead>\n<tr class=\"row-1 odd\">\n	<th class=\"column-1\"><br />\n✅ Tốc độ nạp tiền</th><th class=\"column-2\">⭐Siêu nhanh</th>\n</tr>\n</thead>\n<tbody class=\"row-hover\">\n<tr class=\"row-2 even\">\n	<td class=\"column-1\"><br />\n✅ Phương thức nạp tiền</td><td class=\"column-2\">⭐Đa nền tảng</td>\n</tr>\n<tr class=\"row-3 odd\">\n	<td class=\"column-1\"><br />\n✅ Hạn mức nạp tiền</td><td class=\"column-2\">⭐300.00.000 vnđ</td>\n</tr>\n<tr class=\"row-4 even\">\n	<td class=\"column-1\"><br />\n✅ Khuyến mãi nạp tiền</td><td class=\"column-2\">⭐Siêu khủng</td>\n</tr>\n<tr class=\"row-5 odd\">\n	<td class=\"column-1\"><br />\n✅ Thời gian hỗ trợ nạp tiền</td><td class=\"column-2\">⭐24/7</td>\n</tr>\n</tbody>\n</table>\n", "no");
INSERT INTO `wp_options` VALUES("77228", "_site_transient_timeout_theme_roots", "1679128705", "no");
INSERT INTO `wp_options` VALUES("77229", "_site_transient_theme_roots", "a:2:{s:14:\"flatsome-child\";s:7:\"/themes\";s:8:\"flatsome\";s:7:\"/themes\";}", "no");
INSERT INTO `wp_options` VALUES("76984", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1679127771;s:7:\"checked\";a:2:{s:14:\"flatsome-child\";s:3:\"dev\";s:8:\"flatsome\";s:6:\"3.14.3\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:1:{s:8:\"flatsome\";a:4:{s:5:\"theme\";s:8:\"flatsome\";s:11:\"new_version\";s:6:\"3.14.3\";s:3:\"url\";s:84:\"https://mami.gameh5.xyz/wp-admin/admin.php?page=flatsome-version-info&version=3.14.3\";s:7:\"package\";s:106:\"https://mami.gameh5.xyz/wp-admin/admin.php?page=flatsome-panel&flatsome_version=3.14.3&flatsome_download=1\";}}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("77081", "_site_transient_timeout_browser_98bc39f193b76f394116d8548f0e35a4", "1679660552", "no");
INSERT INTO `wp_options` VALUES("77082", "_site_transient_browser_98bc39f193b76f394116d8548f0e35a4", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"56.0\";s:8:\"platform\";s:7:\"Android\";s:10:\"update_url\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:11:\"img_src_ssl\";s:0:\"\";s:15:\"current_version\";s:0:\"\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:1;}", "no");
INSERT INTO `wp_options` VALUES("77088", "_site_transient_timeout_browser_b2829163bce91b35e8bc33b4fd707463", "1679669794", "no");
INSERT INTO `wp_options` VALUES("77089", "_site_transient_browser_b2829163bce91b35e8bc33b4fd707463", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"41.0.2272.96\";s:8:\"platform\";s:0:\"\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("77091", "_site_transient_timeout_browser_b89363e911ff1fa8a8b47c5dcd2c09bd", "1679727025", "no");
INSERT INTO `wp_options` VALUES("77092", "_site_transient_browser_b89363e911ff1fa8a8b47c5dcd2c09bd", "a:10:{s:4:\"name\";s:7:\"unknown\";s:7:\"version\";s:0:\"\";s:8:\"platform\";s:6:\"iPhone\";s:10:\"update_url\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:11:\"img_src_ssl\";s:0:\"\";s:15:\"current_version\";s:0:\"\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:1;}", "no");
INSERT INTO `wp_options` VALUES("77107", "_site_transient_timeout_available_translations", "1679133174", "no");
INSERT INTO `wp_options` VALUES("77108", "_site_transient_available_translations", "a:130:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1.1/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-07 13:09:35\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.21\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.21/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-04 12:54:13\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-12 20:34:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2019-10-29 07:54:22\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.22/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-17 10:40:57\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-10-31 08:48:37\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.12/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-17 22:04:18\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-21 08:26:37\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-06 11:56:19\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-10 08:19:28\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-16 12:27:34\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.1.1/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-16 12:27:22\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-04 22:06:32\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.1.1/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-04 21:36:27\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-03-17 12:58:14\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1.1/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-22 14:01:36\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-21 05:55:12\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2021-12-24 12:36:39\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-31 12:11:44\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-14 08:07:38\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-04-01 22:35:34\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-18 21:56:09\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-13 17:54:51\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-16 13:13:32\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-10 19:19:07\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-07-22 14:08:10\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-10-04 20:53:18\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.6/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.6/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-06-14 16:02:22\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.12/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-03 04:18:58\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.17\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.17/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-27 22:40:37\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-01 03:10:20\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-08-12 08:38:59\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-25 16:37:05\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-19 17:10:42\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-25 09:13:10\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-07 05:25:25\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-03 21:31:57\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-22 13:54:46\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-07 20:28:50\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.21\";s:7:\"updated\";s:19:\"2018-01-29 17:32:35\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.21/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-25 12:53:23\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-03 11:38:42\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2018-09-14 12:33:48\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.22/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:31:\"ચાલુ રાખવું\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.29\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.29/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-27 14:23:57\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-11-06 12:34:38\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.12/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-06 12:29:04\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-07-18 19:40:10\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1.1/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-28 13:53:25\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-03 08:44:20\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.22/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-12 20:02:23\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-06 07:11:58\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.22/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-24 08:01:09\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-21 21:13:06\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1.1/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2018-07-10 11:35:44\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.22/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.17\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.17/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-10-20 17:15:28\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-21 23:01:12\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-12-07 16:32:30\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.6/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-24 03:51:58\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-03 00:36:37\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:43:32\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-02 15:24:05\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2019-11-22 15:32:08\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.22/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.11\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.11/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.34\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.34/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-09 10:03:46\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-25 10:09:15\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-26 10:11:03\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-05 12:28:58\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.1.1/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-06 13:27:56\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.21\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.21/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-21 19:04:45\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.30\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.30/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-10-01 12:16:29\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-08-09 12:26:21\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.1.1/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-15 02:13:14\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-08 12:44:25\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-07 12:03:46\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-27 14:35:22\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.12/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-01-20 04:27:59\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-16 15:38:21\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.1.1/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-11-11 12:48:55\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-11 14:39:54\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-08-01 21:21:06\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.6/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-21 12:06:05\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:6:\"5.3.14\";s:7:\"updated\";s:19:\"2019-10-13 15:35:35\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.3.14/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.34\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.34/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.8.6/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:6:\"4.8.21\";s:7:\"updated\";s:19:\"2017-09-30 09:04:29\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.21/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-28 14:43:36\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2021-07-03 18:41:33\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.22/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-04 10:46:30\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.12/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-02-12 07:49:12\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.1/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2022-12-18 06:20:30\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.1.1\";s:7:\"updated\";s:19:\"2023-03-16 04:53:25\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.1.1/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "no");
INSERT INTO `wp_options` VALUES("77244", "wpr_rucss_used_css_version", "20210401", "yes");
INSERT INTO `wp_options` VALUES("77316", "_transient_timeout_global_styles_flatsome-child", "1679127787", "no");
INSERT INTO `wp_options` VALUES("77317", "_transient_global_styles_flatsome-child", "body{--wp--preset--color--black: #000000;--wp--preset--color--cyan-bluish-gray: #abb8c3;--wp--preset--color--white: #ffffff;--wp--preset--color--pale-pink: #f78da7;--wp--preset--color--vivid-red: #cf2e2e;--wp--preset--color--luminous-vivid-orange: #ff6900;--wp--preset--color--luminous-vivid-amber: #fcb900;--wp--preset--color--light-green-cyan: #7bdcb5;--wp--preset--color--vivid-green-cyan: #00d084;--wp--preset--color--pale-cyan-blue: #8ed1fc;--wp--preset--color--vivid-cyan-blue: #0693e3;--wp--preset--color--vivid-purple: #9b51e0;--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple: linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%);--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan: linear-gradient(135deg,rgb(122,220,180) 0%,rgb(0,208,130) 100%);--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange: linear-gradient(135deg,rgba(252,185,0,1) 0%,rgba(255,105,0,1) 100%);--wp--preset--gradient--luminous-vivid-orange-to-vivid-red: linear-gradient(135deg,rgba(255,105,0,1) 0%,rgb(207,46,46) 100%);--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray: linear-gradient(135deg,rgb(238,238,238) 0%,rgb(169,184,195) 100%);--wp--preset--gradient--cool-to-warm-spectrum: linear-gradient(135deg,rgb(74,234,220) 0%,rgb(151,120,209) 20%,rgb(207,42,186) 40%,rgb(238,44,130) 60%,rgb(251,105,98) 80%,rgb(254,248,76) 100%);--wp--preset--gradient--blush-light-purple: linear-gradient(135deg,rgb(255,206,236) 0%,rgb(152,150,240) 100%);--wp--preset--gradient--blush-bordeaux: linear-gradient(135deg,rgb(254,205,165) 0%,rgb(254,45,45) 50%,rgb(107,0,62) 100%);--wp--preset--gradient--luminous-dusk: linear-gradient(135deg,rgb(255,203,112) 0%,rgb(199,81,192) 50%,rgb(65,88,208) 100%);--wp--preset--gradient--pale-ocean: linear-gradient(135deg,rgb(255,245,203) 0%,rgb(182,227,212) 50%,rgb(51,167,181) 100%);--wp--preset--gradient--electric-grass: linear-gradient(135deg,rgb(202,248,128) 0%,rgb(113,206,126) 100%);--wp--preset--gradient--midnight: linear-gradient(135deg,rgb(2,3,129) 0%,rgb(40,116,252) 100%);--wp--preset--duotone--dark-grayscale: url(\'#wp-duotone-dark-grayscale\');--wp--preset--duotone--grayscale: url(\'#wp-duotone-grayscale\');--wp--preset--duotone--purple-yellow: url(\'#wp-duotone-purple-yellow\');--wp--preset--duotone--blue-red: url(\'#wp-duotone-blue-red\');--wp--preset--duotone--midnight: url(\'#wp-duotone-midnight\');--wp--preset--duotone--magenta-yellow: url(\'#wp-duotone-magenta-yellow\');--wp--preset--duotone--purple-green: url(\'#wp-duotone-purple-green\');--wp--preset--duotone--blue-orange: url(\'#wp-duotone-blue-orange\');--wp--preset--font-size--small: 13px;--wp--preset--font-size--medium: 20px;--wp--preset--font-size--large: 36px;--wp--preset--font-size--x-large: 42px;--wp--preset--spacing--20: 0.44rem;--wp--preset--spacing--30: 0.67rem;--wp--preset--spacing--40: 1rem;--wp--preset--spacing--50: 1.5rem;--wp--preset--spacing--60: 2.25rem;--wp--preset--spacing--70: 3.38rem;--wp--preset--spacing--80: 5.06rem;}:where(.is-layout-flex){gap: 0.5em;}body .is-layout-flow > .alignleft{float: left;margin-inline-start: 0;margin-inline-end: 2em;}body .is-layout-flow > .alignright{float: right;margin-inline-start: 2em;margin-inline-end: 0;}body .is-layout-flow > .aligncenter{margin-left: auto !important;margin-right: auto !important;}body .is-layout-constrained > .alignleft{float: left;margin-inline-start: 0;margin-inline-end: 2em;}body .is-layout-constrained > .alignright{float: right;margin-inline-start: 2em;margin-inline-end: 0;}body .is-layout-constrained > .aligncenter{margin-left: auto !important;margin-right: auto !important;}body .is-layout-constrained > :where(:not(.alignleft):not(.alignright):not(.alignfull)){max-width: var(--wp--style--global--content-size);margin-left: auto !important;margin-right: auto !important;}body .is-layout-constrained > .alignwide{max-width: var(--wp--style--global--wide-size);}body .is-layout-flex{display: flex;}body .is-layout-flex{flex-wrap: wrap;align-items: center;}body .is-layout-flex > *{margin: 0;}:where(.wp-block-columns.is-layout-flex){gap: 2em;}.has-black-color{color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-color{color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-color{color: var(--wp--preset--color--white) !important;}.has-pale-pink-color{color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-color{color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-color{color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-color{color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-color{color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-color{color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-color{color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-color{color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-color{color: var(--wp--preset--color--vivid-purple) !important;}.has-black-background-color{background-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-background-color{background-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-background-color{background-color: var(--wp--preset--color--white) !important;}.has-pale-pink-background-color{background-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-background-color{background-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-background-color{background-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-background-color{background-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-background-color{background-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-background-color{background-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-background-color{background-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-background-color{background-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-background-color{background-color: var(--wp--preset--color--vivid-purple) !important;}.has-black-border-color{border-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-border-color{border-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-border-color{border-color: var(--wp--preset--color--white) !important;}.has-pale-pink-border-color{border-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-border-color{border-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-border-color{border-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-border-color{border-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-border-color{border-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-border-color{border-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-border-color{border-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-border-color{border-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-border-color{border-color: var(--wp--preset--color--vivid-purple) !important;}.has-vivid-cyan-blue-to-vivid-purple-gradient-background{background: var(--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple) !important;}.has-light-green-cyan-to-vivid-green-cyan-gradient-background{background: var(--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan) !important;}.has-luminous-vivid-amber-to-luminous-vivid-orange-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange) !important;}.has-luminous-vivid-orange-to-vivid-red-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-orange-to-vivid-red) !important;}.has-very-light-gray-to-cyan-bluish-gray-gradient-background{background: var(--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray) !important;}.has-cool-to-warm-spectrum-gradient-background{background: var(--wp--preset--gradient--cool-to-warm-spectrum) !important;}.has-blush-light-purple-gradient-background{background: var(--wp--preset--gradient--blush-light-purple) !important;}.has-blush-bordeaux-gradient-background{background: var(--wp--preset--gradient--blush-bordeaux) !important;}.has-luminous-dusk-gradient-background{background: var(--wp--preset--gradient--luminous-dusk) !important;}.has-pale-ocean-gradient-background{background: var(--wp--preset--gradient--pale-ocean) !important;}.has-electric-grass-gradient-background{background: var(--wp--preset--gradient--electric-grass) !important;}.has-midnight-gradient-background{background: var(--wp--preset--gradient--midnight) !important;}.has-small-font-size{font-size: var(--wp--preset--font-size--small) !important;}.has-medium-font-size{font-size: var(--wp--preset--font-size--medium) !important;}.has-large-font-size{font-size: var(--wp--preset--font-size--large) !important;}.has-x-large-font-size{font-size: var(--wp--preset--font-size--x-large) !important;}", "no");
INSERT INTO `wp_options` VALUES("76971", "_site_transient_timeout_browser_f22b4283780968eff68d731eb36fd090", "1679642969", "no");
INSERT INTO `wp_options` VALUES("76972", "_site_transient_browser_f22b4283780968eff68d731eb36fd090", "a:10:{s:4:\"name\";s:7:\"unknown\";s:7:\"version\";s:0:\"\";s:8:\"platform\";s:0:\"\";s:10:\"update_url\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:11:\"img_src_ssl\";s:0:\"\";s:15:\"current_version\";s:0:\"\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("77110", "_transient_timeout_rank_math_feed_posts_v2", "1679165621", "no");
INSERT INTO `wp_options` VALUES("77111", "_transient_rank_math_feed_posts_v2", "a:4:{i:0;a:5:{s:5:\"title\";a:1:{s:8:\"rendered\";s:57:\"Learn more about Google\'s upcoming Helpful Content Update\";}s:4:\"date\";s:19:\"2023-03-18 04:53:20\";s:4:\"link\";s:58:\"https://rankmath.com/google-update/helpful-content-update/\";s:12:\"custom_label\";s:0:\"\";s:9:\"condition\";s:0:\"\";}i:1;a:3:{s:5:\"title\";a:1:{s:8:\"rendered\";s:73:\"The 50-Step WordPress SEO Checklist To Boost Your Organic Traffic in 2023\";}s:4:\"date\";s:19:\"2023-02-01 14:53:05\";s:4:\"link\";s:50:\"https://rankmath.com/blog/wordpress-seo-checklist/\";}i:2;a:3:{s:5:\"title\";a:1:{s:8:\"rendered\";s:55:\"Sticky Posts in WordPress: Complete Guide for Beginners\";}s:4:\"date\";s:19:\"2023-01-24 09:39:06\";s:4:\"link\";s:52:\"https://rankmath.com/blog/sticky-posts-in-wordpress/\";}i:3;a:3:{s:5:\"title\";a:1:{s:8:\"rendered\";s:62:\"How to Quickly Remove Widgets from the Dashboard in WordPress?\";}s:4:\"date\";s:19:\"2023-01-23 10:29:15\";s:4:\"link\";s:66:\"https://rankmath.com/blog/remove-widgets-from-wordpress-dashboard/\";}}", "no");
INSERT INTO `wp_options` VALUES("77114", "_transient_timeout_feed_b748b176461a07a256071902477d41d7", "1679165622", "no");
INSERT INTO `wp_options` VALUES("77115", "_transient_timeout_feed_mod_b748b176461a07a256071902477d41d7", "1679165622", "no");
INSERT INTO `wp_options` VALUES("77116", "_transient_feed_mod_b748b176461a07a256071902477d41d7", "1679122422", "no");
INSERT INTO `wp_options` VALUES("77119", "_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1679122424", "no");
INSERT INTO `wp_options` VALUES("77120", "_transient_timeout_dash_v2_a5a61dcab273495c31cd79aafebbdc74", "1679165624", "no");
INSERT INTO `wp_options` VALUES("77121", "_transient_dash_v2_a5a61dcab273495c31cd79aafebbdc74", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://vi.wordpress.org/2022/11/04/wordpress-meetup-nha-trang-thang-11-2022/\'>WordPress Meetup Nha Trang tháng 11/2022</a></li><li><a class=\'rsswidget\' href=\'https://vi.wordpress.org/2022/07/12/sap-dien-ra-meetup-wordpress-ha-noi-15-07-2022/\'>Sắp diễn ra: Meetup WordPress Hà Nội (15/07/2022)</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wptavern.com/wordpress-launches-wapuu-coloring-giveaway-to-celebrate-upcoming-20th-anniversary\'>WPTavern: WordPress Launches Wapuu Coloring Giveaway to Celebrate Upcoming 20th Anniversary</a></li><li><a class=\'rsswidget\' href=\'https://central.wordcamp.org/news/2023/03/wordcamp-buffalo-2023/\'>WordCamp Central: WordCamp Buffalo 2023</a></li><li><a class=\'rsswidget\' href=\'https://central.wordcamp.org/news/2023/03/wordcamp-entebbe-2023-an-amazing-recap/\'>WordCamp Central: WordCamp Entebbe 2023: An Amazing Recap</a></li></ul></div>", "no");
INSERT INTO `wp_options` VALUES("77172", "action_scheduler_migration_status", "complete", "yes");
INSERT INTO `wp_options` VALUES("77323", "_site_transient_timeout_rank_math_pro_updates", "1679131370", "no");
INSERT INTO `wp_options` VALUES("77324", "_site_transient_rank_math_pro_updates", "a:10:{s:11:\"new_version\";s:6:\"3.0.32\";s:12:\"beta_version\";s:11:\"3.0.32-beta\";s:7:\"package\";s:99:\"https://rankmath.com/download/510590/seo-by-rank-math-pro.zip?username=VietCoders&api_key=*********\";s:12:\"beta_package\";s:99:\"https://rankmath.com/download/739367/seo-by-rank-math-pro.zip?username=VietCoders&api_key=*********\";s:7:\"message\";s:0:\"\";s:8:\"requires\";s:3:\"5.2\";s:6:\"tested\";s:5:\"6.1.1\";s:12:\"requires_php\";s:3:\"5.6\";s:21:\"unavailability_reason\";s:0:\"\";s:9:\"g_updates\";s:4617:\"[{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/march-2023-core-algorithm-update\\/\",\"title\":\"March 2023 Core Algorithm Update\",\"content\":\"Google announced rolling out the core algorithm update on March 15, 2023. The rollout will take two weeks to complete.\",\"date\":\"1678838400\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/february-2023-product-reviews-update\\/\",\"title\":\"February 2023 Product Reviews Update\",\"content\":\"Google rolled out a product reviews update on February 22, 2023. The update expands to many languages in addition to just English and was completed on March 7, 2023.\",\"date\":\"1676937600\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/google-search-ranking-algorithm-feb-13th-14th-2023\\/\",\"title\":\"Unconfirmed Google Search Ranking Algorithm Update–February 13th and 14th, 2023\",\"content\":\"Google may have rolled out another unconfirmed Google search ranking algorithm update around February 13th, and tracking tools are showing huge spikes.\",\"date\":\"1676246400\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/google-search-ranking-feb-8th-9th-2023\\/\",\"title\":\"Unconfirmed Google Search Ranking Algorithm Update- February 8th and 9th 2023\",\"content\":\"Google may have rolled out another unconfirmed Google search ranking algorithm update around February 8th and 9th, and tracking tools are showing big spikes.\",\"date\":\"1675814400\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/unconfirmed-search-ranking-feb-3rd-4th\\/\",\"title\":\"Unconfirmed Google Search Ranking Algorithm Update - February 3rd and 4th\",\"content\":\"Google may have rolled out another unconfirmed Google search ranking algorithm update around February 3 and continued till February 4. The tracking tools are showing big spikes.\",\"date\":\"1675382400\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/december-2022-link-spam-update\\/\",\"title\":\"December 2022 Link Spam Update\",\"content\":\"Google is rolling out a link spam update on Dec 14, 2022. This update aims to identify and nullify link spam more broadly across multiple languages. The update took 29 days to roll out and was completed on January 12, 2023. \",\"date\":\"1670976000\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/december-2022-helpful-content-update\\/\",\"title\":\"December 2022 Helpful Content Update\",\"content\":\"Google announced another Helpful Content Update on December 5, 2022, which improves the classifier and works across all content globally in all languages. The update was completed on January 12, 2023.\\r\\n\",\"date\":\"1670198400\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/unconfirmed-search-ranking-nov-4th-5th\\/\",\"title\":\"Unconfirmed Google Search Ranking Algorithm Update - November 4th and 5th\",\"content\":\"Google may have rolled out another unconfirmed Google search ranking update around November 4th and 5th, and the tracking tools are showing big spikes.\",\"date\":\"1667520000\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/search-ranking-algorithm-update-oct-28\\/\",\"title\":\"Google Search Ranking Algorithm Update\\/ Adjustment On October 28\",\"content\":\"Google rolled out another search ranking update around October 28th that may have disrupted the search ranking algorithm. Users are noticing big swings in terms of their Google rankings and traffic.\",\"date\":\"1666915200\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/october-2022-spam-update\\/\",\"title\":\"October 2022 Spam Update\",\"content\":\"Google rolled out a new search ranking algorithm on October 19, 2022. The update targeted the more spammy side of the search results, and the rollout was completed on October 21, 2022.\",\"date\":\"1666137600\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/unconfirmed-search-ranking-oct-2022\\/\",\"title\":\"Unconfirmed Google Search Ranking Algorithm Update (October 2022)\",\"content\":\"Google may have rolled out a search ranking update around October 13th. Users have reported traffic changes from Google’s organic sources and Google Search over the past day or two. \",\"date\":\"1665619200\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/product-reviews-update-sep-2022\\/\",\"title\":\"September 2022 Product Reviews Algorithm Update\",\"content\":\"Google announced its fifth Product Reviews algorithm update on September 20, 2022. This update aims to reward product reviews that are most helpful to searchers. The update finished rolling out on Sep 26, 2022.\",\"date\":\"1663632000\",\"status\":\"confirmed\"}]\";}", "no");
INSERT INTO `wp_options` VALUES("77326", "_site_transient_timeout_wp_rocket_update_data", "1679170980", "no");
INSERT INTO `wp_options` VALUES("77327", "_site_transient_wp_rocket_update_data", "O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:20:\"rocket_update_failed\";a:1:{i:0;s:245:\"An unexpected error occurred. Something may be wrong with WP-Rocket.me or this server&#8217;s configuration. If you continue to have problems, <a href=\"https://wp-rocket.me/support/?utm_source=wp_plugin&utm_medium=wp_rocket\">contact support</a>.\";}}s:10:\"error_data\";a:1:{s:20:\"rocket_update_failed\";a:1:{s:8:\"response\";s:6:\"NULLED\";}}s:18:\"\0*\0additional_data\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("77328", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1679127781;s:8:\"response\";a:6:{s:49:\"easy-table-of-contents/easy-table-of-contents.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:36:\"w.org/plugins/easy-table-of-contents\";s:4:\"slug\";s:22:\"easy-table-of-contents\";s:6:\"plugin\";s:49:\"easy-table-of-contents/easy-table-of-contents.php\";s:11:\"new_version\";s:6:\"2.0.46\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/easy-table-of-contents/\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/plugin/easy-table-of-contents.2.0.46.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:75:\"https://ps.w.org/easy-table-of-contents/assets/icon-256x256.png?rev=2847895\";s:2:\"1x\";s:75:\"https://ps.w.org/easy-table-of-contents/assets/icon-128x128.png?rev=2847895\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:78:\"https://ps.w.org/easy-table-of-contents/assets/banner-1544x500.png?rev=2704774\";s:2:\"1x\";s:77:\"https://ps.w.org/easy-table-of-contents/assets/banner-772x250.png?rev=2704774\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.1.1\";s:12:\"requires_php\";s:6:\"5.6.20\";}s:31:\"intelly-related-posts/index.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:35:\"w.org/plugins/intelly-related-posts\";s:4:\"slug\";s:21:\"intelly-related-posts\";s:6:\"plugin\";s:31:\"intelly-related-posts/index.php\";s:11:\"new_version\";s:6:\"3.0.13\";s:3:\"url\";s:52:\"https://wordpress.org/plugins/intelly-related-posts/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/intelly-related-posts.3.0.13.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/intelly-related-posts/assets/icon-256x256.png?rev=2672481\";s:2:\"1x\";s:74:\"https://ps.w.org/intelly-related-posts/assets/icon-128x128.png?rev=2672481\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:77:\"https://ps.w.org/intelly-related-posts/assets/banner-1544x500.png?rev=2672481\";s:2:\"1x\";s:76:\"https://ps.w.org/intelly-related-posts/assets/banner-772x250.png?rev=2672481\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"3.6.0\";s:6:\"tested\";s:5:\"6.1.1\";s:12:\"requires_php\";s:3:\"7.3\";}s:30:\"seo-by-rank-math/rank-math.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:30:\"w.org/plugins/seo-by-rank-math\";s:4:\"slug\";s:16:\"seo-by-rank-math\";s:6:\"plugin\";s:30:\"seo-by-rank-math/rank-math.php\";s:11:\"new_version\";s:9:\"1.0.110.1\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/seo-by-rank-math/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/seo-by-rank-math.1.0.110.1.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:69:\"https://ps.w.org/seo-by-rank-math/assets/icon-256x256.png?rev=2848340\";s:2:\"1x\";s:61:\"https://ps.w.org/seo-by-rank-math/assets/icon.svg?rev=2848340\";s:3:\"svg\";s:61:\"https://ps.w.org/seo-by-rank-math/assets/icon.svg?rev=2848340\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/seo-by-rank-math/assets/banner-1544x500.png?rev=2639678\";s:2:\"1x\";s:71:\"https://ps.w.org/seo-by-rank-math/assets/banner-772x250.png?rev=2639678\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.6\";s:6:\"tested\";s:5:\"6.1.1\";s:12:\"requires_php\";s:3:\"7.4\";}s:29:\"rate-my-post/rate-my-post.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:26:\"w.org/plugins/rate-my-post\";s:4:\"slug\";s:12:\"rate-my-post\";s:6:\"plugin\";s:29:\"rate-my-post/rate-my-post.php\";s:11:\"new_version\";s:5:\"3.4.1\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/rate-my-post/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/rate-my-post.3.4.1.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/rate-my-post/assets/icon-128x128.png?rev=2045796\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:67:\"https://ps.w.org/rate-my-post/assets/banner-772x250.png?rev=2045796\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"4.7.0\";s:6:\"tested\";s:5:\"6.1.1\";s:12:\"requires_php\";s:3:\"5.3\";}s:34:\"advanced-custom-fields-pro/acf.php\";O:8:\"stdClass\":8:{s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:6:\"plugin\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"new_version\";s:5:\"6.0.7\";s:3:\"url\";s:36:\"https://www.advancedcustomfields.com\";s:6:\"tested\";s:5:\"6.1.1\";s:7:\"package\";s:0:\"\";s:5:\"icons\";a:1:{s:7:\"default\";s:63:\"https://ps.w.org/advanced-custom-fields/assets/icon-256x256.png\";}s:7:\"banners\";a:2:{s:3:\"low\";s:77:\"https://ps.w.org/advanced-custom-fields/assets/banner-772x250.jpg?rev=1729102\";s:4:\"high\";s:78:\"https://ps.w.org/advanced-custom-fields/assets/banner-1544x500.jpg?rev=1729099\";}}s:38:\"seo-by-rank-math-pro/rank-math-pro.php\";O:8:\"stdClass\":14:{s:4:\"slug\";s:20:\"seo-by-rank-math-pro\";s:6:\"plugin\";s:38:\"seo-by-rank-math-pro/rank-math-pro.php\";s:3:\"url\";s:21:\"https://rankmath.com/\";s:5:\"icons\";a:3:{s:3:\"svg\";s:61:\"https://ps.w.org/seo-by-rank-math/assets/icon.svg?rev=2348086\";s:2:\"1x\";s:57:\"https://ps.w.org/seo-by-rank-math/assets/icon-128x128.png\";s:2:\"2x\";s:57:\"https://ps.w.org/seo-by-rank-math/assets/icon-256x256.png\";}s:11:\"new_version\";s:6:\"3.0.32\";s:7:\"package\";s:99:\"https://rankmath.com/download/510590/seo-by-rank-math-pro.zip?username=VietCoders&api_key=*********\";s:12:\"beta_version\";s:11:\"3.0.32-beta\";s:12:\"beta_package\";s:99:\"https://rankmath.com/download/739367/seo-by-rank-math-pro.zip?username=VietCoders&api_key=*********\";s:7:\"message\";s:0:\"\";s:8:\"requires\";s:3:\"5.2\";s:6:\"tested\";s:5:\"6.1.1\";s:12:\"requires_php\";s:3:\"5.6\";s:21:\"unavailability_reason\";s:0:\"\";s:9:\"g_updates\";s:4617:\"[{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/march-2023-core-algorithm-update\\/\",\"title\":\"March 2023 Core Algorithm Update\",\"content\":\"Google announced rolling out the core algorithm update on March 15, 2023. The rollout will take two weeks to complete.\",\"date\":\"1678838400\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/february-2023-product-reviews-update\\/\",\"title\":\"February 2023 Product Reviews Update\",\"content\":\"Google rolled out a product reviews update on February 22, 2023. The update expands to many languages in addition to just English and was completed on March 7, 2023.\",\"date\":\"1676937600\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/google-search-ranking-algorithm-feb-13th-14th-2023\\/\",\"title\":\"Unconfirmed Google Search Ranking Algorithm Update–February 13th and 14th, 2023\",\"content\":\"Google may have rolled out another unconfirmed Google search ranking algorithm update around February 13th, and tracking tools are showing huge spikes.\",\"date\":\"1676246400\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/google-search-ranking-feb-8th-9th-2023\\/\",\"title\":\"Unconfirmed Google Search Ranking Algorithm Update- February 8th and 9th 2023\",\"content\":\"Google may have rolled out another unconfirmed Google search ranking algorithm update around February 8th and 9th, and tracking tools are showing big spikes.\",\"date\":\"1675814400\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/unconfirmed-search-ranking-feb-3rd-4th\\/\",\"title\":\"Unconfirmed Google Search Ranking Algorithm Update - February 3rd and 4th\",\"content\":\"Google may have rolled out another unconfirmed Google search ranking algorithm update around February 3 and continued till February 4. The tracking tools are showing big spikes.\",\"date\":\"1675382400\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/december-2022-link-spam-update\\/\",\"title\":\"December 2022 Link Spam Update\",\"content\":\"Google is rolling out a link spam update on Dec 14, 2022. This update aims to identify and nullify link spam more broadly across multiple languages. The update took 29 days to roll out and was completed on January 12, 2023. \",\"date\":\"1670976000\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/december-2022-helpful-content-update\\/\",\"title\":\"December 2022 Helpful Content Update\",\"content\":\"Google announced another Helpful Content Update on December 5, 2022, which improves the classifier and works across all content globally in all languages. The update was completed on January 12, 2023.\\r\\n\",\"date\":\"1670198400\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/unconfirmed-search-ranking-nov-4th-5th\\/\",\"title\":\"Unconfirmed Google Search Ranking Algorithm Update - November 4th and 5th\",\"content\":\"Google may have rolled out another unconfirmed Google search ranking update around November 4th and 5th, and the tracking tools are showing big spikes.\",\"date\":\"1667520000\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/search-ranking-algorithm-update-oct-28\\/\",\"title\":\"Google Search Ranking Algorithm Update\\/ Adjustment On October 28\",\"content\":\"Google rolled out another search ranking update around October 28th that may have disrupted the search ranking algorithm. Users are noticing big swings in terms of their Google rankings and traffic.\",\"date\":\"1666915200\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/october-2022-spam-update\\/\",\"title\":\"October 2022 Spam Update\",\"content\":\"Google rolled out a new search ranking algorithm on October 19, 2022. The update targeted the more spammy side of the search results, and the rollout was completed on October 21, 2022.\",\"date\":\"1666137600\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/unconfirmed-search-ranking-oct-2022\\/\",\"title\":\"Unconfirmed Google Search Ranking Algorithm Update (October 2022)\",\"content\":\"Google may have rolled out a search ranking update around October 13th. Users have reported traffic changes from Google’s organic sources and Google Search over the past day or two. \",\"date\":\"1665619200\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/product-reviews-update-sep-2022\\/\",\"title\":\"September 2022 Product Reviews Algorithm Update\",\"content\":\"Google announced its fifth Product Reviews algorithm update on September 20, 2022. This update aims to reward product reviews that are most helpful to searchers. The update finished rolling out on Sep 26, 2022.\",\"date\":\"1663632000\",\"status\":\"confirmed\"}]\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:9:{s:33:\"classic-editor/classic-editor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/classic-editor\";s:4:\"slug\";s:14:\"classic-editor\";s:6:\"plugin\";s:33:\"classic-editor/classic-editor.php\";s:11:\"new_version\";s:5:\"1.6.2\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/classic-editor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/classic-editor.1.6.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-256x256.png?rev=1998671\";s:2:\"1x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-128x128.png?rev=1998671\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/classic-editor/assets/banner-1544x500.png?rev=1998671\";s:2:\"1x\";s:69:\"https://ps.w.org/classic-editor/assets/banner-772x250.png?rev=1998676\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:35:\"classic-widgets/classic-widgets.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:29:\"w.org/plugins/classic-widgets\";s:4:\"slug\";s:15:\"classic-widgets\";s:6:\"plugin\";s:35:\"classic-widgets/classic-widgets.php\";s:11:\"new_version\";s:3:\"0.3\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/classic-widgets/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/classic-widgets.0.3.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:59:\"https://s.w.org/plugins/geopattern-icon/classic-widgets.svg\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"5.7.4\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.7.4.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:67:\"https://ps.w.org/contact-form-7/assets/icon-256x256.png?rev=2279696\";s:2:\"1x\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";s:3:\"svg\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.0\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:5:\"1.5.3\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/duplicator.1.5.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2605836\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2605835\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2085472\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";}s:33:\"easy-watermark/easy-watermark.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/easy-watermark\";s:4:\"slug\";s:14:\"easy-watermark\";s:6:\"plugin\";s:33:\"easy-watermark/easy-watermark.php\";s:11:\"new_version\";s:6:\"1.0.11\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/easy-watermark/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/easy-watermark.1.0.11.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:59:\"https://ps.w.org/easy-watermark/assets/icon.svg?rev=2153955\";s:3:\"svg\";s:59:\"https://ps.w.org/easy-watermark/assets/icon.svg?rev=2153955\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/easy-watermark/assets/banner-1544x500.png?rev=2153955\";s:2:\"1x\";s:69:\"https://ps.w.org/easy-watermark/assets/banner-772x250.png?rev=2153955\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";}s:37:\"mihdan-index-now/mihdan-index-now.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:30:\"w.org/plugins/mihdan-index-now\";s:4:\"slug\";s:16:\"mihdan-index-now\";s:6:\"plugin\";s:37:\"mihdan-index-now/mihdan-index-now.php\";s:11:\"new_version\";s:5:\"2.4.1\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/mihdan-index-now/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/mihdan-index-now.2.4.1.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:61:\"https://ps.w.org/mihdan-index-now/assets/icon.svg?rev=2665043\";s:3:\"svg\";s:61:\"https://ps.w.org/mihdan-index-now/assets/icon.svg?rev=2665043\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:71:\"https://ps.w.org/mihdan-index-now/assets/banner-772x250.jpg?rev=2657423\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";}s:45:\"phoenix-media-rename/phoenix-media-rename.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:34:\"w.org/plugins/phoenix-media-rename\";s:4:\"slug\";s:20:\"phoenix-media-rename\";s:6:\"plugin\";s:45:\"phoenix-media-rename/phoenix-media-rename.php\";s:11:\"new_version\";s:5:\"3.9.0\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/phoenix-media-rename/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/phoenix-media-rename.3.9.0.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:65:\"https://ps.w.org/phoenix-media-rename/assets/icon.svg?rev=1485775\";s:3:\"svg\";s:65:\"https://ps.w.org/phoenix-media-rename/assets/icon.svg?rev=1485775\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:75:\"https://ps.w.org/phoenix-media-rename/assets/banner-772x250.png?rev=1490792\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";}s:25:\"tablepress/tablepress.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/tablepress\";s:4:\"slug\";s:10:\"tablepress\";s:6:\"plugin\";s:25:\"tablepress/tablepress.php\";s:11:\"new_version\";s:5:\"2.0.4\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/tablepress/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/tablepress.2.0.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/tablepress/assets/icon-256x256.png?rev=1064192\";s:2:\"1x\";s:63:\"https://ps.w.org/tablepress/assets/icon-128x128.png?rev=1064192\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/tablepress/assets/banner-1544x500.png?rev=1275767\";s:2:\"1x\";s:65:\"https://ps.w.org/tablepress/assets/banner-772x250.png?rev=1275767\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/tablepress/assets/banner-1544x500-rtl.png?rev=2837971\";s:2:\"1x\";s:69:\"https://ps.w.org/tablepress/assets/banner-772x250-rtl.png?rev=2837971\";}s:8:\"requires\";s:3:\"5.8\";}s:39:\"wp-file-manager/file_folder_manager.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:29:\"w.org/plugins/wp-file-manager\";s:4:\"slug\";s:15:\"wp-file-manager\";s:6:\"plugin\";s:39:\"wp-file-manager/file_folder_manager.php\";s:11:\"new_version\";s:5:\"7.1.8\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/wp-file-manager/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/wp-file-manager.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:68:\"https://ps.w.org/wp-file-manager/assets/icon-128x128.png?rev=2491299\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:70:\"https://ps.w.org/wp-file-manager/assets/banner-772x250.jpg?rev=2491299\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";}}s:7:\"checked\";a:16:{s:34:\"advanced-custom-fields-pro/acf.php\";s:5:\"5.9.6\";s:33:\"classic-editor/classic-editor.php\";s:5:\"1.6.2\";s:35:\"classic-widgets/classic-widgets.php\";s:3:\"0.3\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"5.7.4\";s:25:\"duplicator/duplicator.php\";s:5:\"1.5.3\";s:49:\"easy-table-of-contents/easy-table-of-contents.php\";s:8:\"2.0.45.2\";s:33:\"easy-watermark/easy-watermark.php\";s:6:\"1.0.11\";s:37:\"mihdan-index-now/mihdan-index-now.php\";s:5:\"2.4.1\";s:31:\"intelly-related-posts/index.php\";s:6:\"3.0.12\";s:45:\"phoenix-media-rename/phoenix-media-rename.php\";s:5:\"3.9.0\";s:30:\"seo-by-rank-math/rank-math.php\";s:7:\"1.0.109\";s:38:\"seo-by-rank-math-pro/rank-math-pro.php\";s:5:\"3.0.0\";s:29:\"rate-my-post/rate-my-post.php\";s:5:\"3.4.0\";s:25:\"tablepress/tablepress.php\";s:5:\"2.0.4\";s:39:\"wp-file-manager/file_folder_manager.php\";s:5:\"7.1.8\";s:23:\"wp-rocket/wp-rocket.php\";s:7:\"3.9.1.1\";}}", "no");
INSERT INTO `wp_options` VALUES("77184", "rank_math_connect_data", "a:5:{s:8:\"username\";s:10:\"VietCoders\";s:5:\"email\";s:22:\"plugins@vietcoders.org\";s:7:\"api_key\";s:9:\"*********\";s:4:\"plan\";s:8:\"business\";s:9:\"connected\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("76964", "_site_transient_timeout_browser_c3fcd9e52fd775c43c9553a961bfc52c", "1679642968", "no");
INSERT INTO `wp_options` VALUES("76965", "_site_transient_browser_c3fcd9e52fd775c43c9553a961bfc52c", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"111.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("76654", "secret_key", "h{<j$12{^*thQs`E2u|9G_5mTm:I@{CpLj.7LxRoX]2A+Y3A+s,pv`8GsE^}i5~4", "no");
INSERT INTO `wp_options` VALUES("76960", "duplicator_pro_exe_safe_mode", "0", "yes");
INSERT INTO `wp_options` VALUES("77168", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1679134196", "no");
INSERT INTO `wp_options` VALUES("76988", "_transient_timeout_as-post-store-dependencies-met", "1679124658", "no");
INSERT INTO `wp_options` VALUES("76989", "_transient_as-post-store-dependencies-met", "yes", "no");
INSERT INTO `wp_options` VALUES("77043", "_site_transient_timeout_browser_902fc656780d86347024b6379547f0ef", "1679650579", "no");
INSERT INTO `wp_options` VALUES("77044", "_site_transient_browser_902fc656780d86347024b6379547f0ef", "a:10:{s:4:\"name\";s:7:\"unknown\";s:7:\"version\";s:0:\"\";s:8:\"platform\";s:0:\"\";s:10:\"update_url\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:11:\"img_src_ssl\";s:0:\"\";s:15:\"current_version\";s:0:\"\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("77050", "_site_transient_timeout_browser_33a3621f0a8a9e404f55e2c06b892195", "1679652781", "no");
INSERT INTO `wp_options` VALUES("77051", "_site_transient_browser_33a3621f0a8a9e404f55e2c06b892195", "a:10:{s:4:\"name\";s:6:\"Safari\";s:7:\"version\";s:13:\"8614.2.9.0.10\";s:8:\"platform\";s:0:\"\";s:10:\"update_url\";s:29:\"https://www.apple.com/safari/\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/safari.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/safari.png?1\";s:15:\"current_version\";s:2:\"11\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("77062", "_site_transient_timeout_browser_20570d589bf2d48992926c8992376721", "1679660132", "no");
INSERT INTO `wp_options` VALUES("77063", "_site_transient_browser_20570d589bf2d48992926c8992376721", "a:10:{s:4:\"name\";s:7:\"unknown\";s:7:\"version\";s:0:\"\";s:8:\"platform\";s:0:\"\";s:10:\"update_url\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:11:\"img_src_ssl\";s:0:\"\";s:15:\"current_version\";s:0:\"\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("77065", "_site_transient_timeout_browser_b4088f046bf9a570f2964ffc86d258ff", "1679660140", "no");
INSERT INTO `wp_options` VALUES("77066", "_site_transient_browser_b4088f046bf9a570f2964ffc86d258ff", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"96.0.4664.45\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("77072", "_site_transient_timeout_browser_67a6b9406868780014c1ae323149aca9", "1679660207", "no");
INSERT INTO `wp_options` VALUES("77073", "_site_transient_browser_67a6b9406868780014c1ae323149aca9", "a:10:{s:4:\"name\";s:7:\"unknown\";s:7:\"version\";s:0:\"\";s:8:\"platform\";s:0:\"\";s:10:\"update_url\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:11:\"img_src_ssl\";s:0:\"\";s:15:\"current_version\";s:0:\"\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("77074", "_site_transient_timeout_browser_4b3bc921ee14f2d8a468ab1be7e7796d", "1679660417", "no");
INSERT INTO `wp_options` VALUES("77075", "_site_transient_browser_4b3bc921ee14f2d8a468ab1be7e7796d", "a:10:{s:4:\"name\";s:7:\"unknown\";s:7:\"version\";s:0:\"\";s:8:\"platform\";s:0:\"\";s:10:\"update_url\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:11:\"img_src_ssl\";s:0:\"\";s:15:\"current_version\";s:0:\"\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("75620", "updraftplus_version", "1.23.1", "yes");
INSERT INTO `wp_options` VALUES("75621", "updraftplus_tour_cancelled_on", "intro", "yes");
INSERT INTO `wp_options` VALUES("75622", "updraft_updraftvault", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-72f07a6323980e7422f202c9f7381ad5\";a:3:{s:5:\"token\";s:0:\"\";s:5:\"email\";s:0:\"\";s:5:\"quota\";i:-1;}}}", "yes");
INSERT INTO `wp_options` VALUES("75623", "updraft_dropbox", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-56dd7e738aff50ac9cde13eef68439bf\";a:4:{s:6:\"appkey\";s:0:\"\";s:6:\"secret\";s:0:\"\";s:6:\"folder\";s:0:\"\";s:15:\"tk_access_token\";s:0:\"\";}}}", "yes");
INSERT INTO `wp_options` VALUES("75624", "updraft_s3", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-7f758f00f222965f1948cc5811d01ab7\";a:5:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";s:3:\"rrs\";s:0:\"\";s:22:\"server_side_encryption\";s:0:\"\";}}}", "yes");
INSERT INTO `wp_options` VALUES("75625", "updraft_cloudfiles", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-bfc9d8b726e346b5bf1557a99f01a5be\";a:5:{s:4:\"user\";s:0:\"\";s:7:\"authurl\";s:35:\"https://auth.api.rackspacecloud.com\";s:6:\"apikey\";s:0:\"\";s:4:\"path\";s:0:\"\";s:6:\"region\";N;}}}", "yes");
INSERT INTO `wp_options` VALUES("75626", "updraft_googledrive", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-1b354132326d377dbc5d2f9e62afc8b4\";a:3:{s:8:\"clientid\";s:0:\"\";s:6:\"secret\";s:0:\"\";s:5:\"token\";s:0:\"\";}}}", "yes");
INSERT INTO `wp_options` VALUES("75627", "updraft_onedrive", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-32bc4702d2b5784a1bb1b1aa03d3eae3\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("75628", "updraft_ftp", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-39a57454aee61387e52b338078538f9c\";a:5:{s:4:\"host\";s:0:\"\";s:4:\"user\";s:0:\"\";s:4:\"pass\";s:0:\"\";s:4:\"path\";s:0:\"\";s:7:\"passive\";i:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("75629", "updraft_azure", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-7ec0d9d168f27124de53f6d2b99f051d\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("75630", "updraft_sftp", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-ff86b8a3358dd45a5a05da84b19f79f0\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("75631", "updraft_googlecloud", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-9d95bbadf1403ecbe9586ecdd8aca42f\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("75632", "updraft_backblaze", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-44597cb478ebd15da604caa7d44ac933\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("75633", "updraft_webdav", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-a54fd7cff3886c33804ce0ae346ad677\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("75634", "updraft_s3generic", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-ca2ec9c26c01dd3abdbe9fedc3b98e12\";a:4:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";s:8:\"endpoint\";s:0:\"\";}}}", "yes");
INSERT INTO `wp_options` VALUES("75635", "updraft_pcloud", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-fe2b63fabc2b0d14c89fe25a42fd3918\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("75636", "updraft_openstack", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-0103806dc69352f95535014a388a4ebd\";a:6:{s:4:\"user\";s:0:\"\";s:7:\"authurl\";s:0:\"\";s:8:\"password\";s:0:\"\";s:6:\"tenant\";s:0:\"\";s:4:\"path\";s:0:\"\";s:6:\"region\";s:0:\"\";}}}", "yes");
INSERT INTO `wp_options` VALUES("75637", "updraft_dreamobjects", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-30ab0574a5f9bed9dd0a7f35c704ef02\";a:3:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}}}", "yes");
INSERT INTO `wp_options` VALUES("75638", "updraftplus-addons_siteid", "75b5a143baafa3f963ad25a0db705f0e", "no");
INSERT INTO `wp_options` VALUES("75639", "updraft_lastmessage", "This backup task (2ea2241085eb) is either complete or began over 2 days ago: ending (1678881226.159, ) (existing jobdata keys: ) (Th3 15 18:53:46)", "yes");
INSERT INTO `wp_options` VALUES("75640", "updraftplus_locked_fd", "1", "no");
INSERT INTO `wp_options` VALUES("75641", "updraftplus_last_lock_time_fd", "2023-03-15 11:18:43", "no");
INSERT INTO `wp_options` VALUES("75642", "updraftplus_semaphore_fd", "1", "no");
INSERT INTO `wp_options` VALUES("75643", "updraft_last_scheduled_fd", "1678879123", "yes");
INSERT INTO `wp_options` VALUES("75645", "updraft_backup_history", "a:1:{i:1678879123;a:18:{s:7:\"plugins\";a:1:{i:0;s:52:\"backup_2023-03-15-1818_123B_2ea2241085eb-plugins.zip\";}s:12:\"plugins-size\";i:37462199;s:6:\"themes\";a:1:{i:0;s:51:\"backup_2023-03-15-1818_123B_2ea2241085eb-themes.zip\";}s:11:\"themes-size\";i:7753943;s:7:\"uploads\";a:1:{i:0;s:52:\"backup_2023-03-15-1818_123B_2ea2241085eb-uploads.zip\";}s:12:\"uploads-size\";i:65191872;s:6:\"others\";a:1:{i:0;s:51:\"backup_2023-03-15-1818_123B_2ea2241085eb-others.zip\";}s:11:\"others-size\";i:70148492;s:5:\"nonce\";s:12:\"2ea2241085eb\";s:7:\"service\";a:0:{}s:20:\"service_instance_ids\";a:0:{}s:11:\"always_keep\";b:0;s:19:\"files_enumerated_at\";a:4:{s:7:\"plugins\";i:1678879123;s:6:\"themes\";i:1678879129;s:7:\"uploads\";i:1678879130;s:6:\"others\";i:1678879131;}s:18:\"created_by_version\";s:6:\"1.23.1\";s:21:\"last_saved_by_version\";s:6:\"1.23.1\";s:12:\"is_multisite\";b:0;s:2:\"db\";s:46:\"backup_2023-03-15-1818_123B_2ea2241085eb-db.gz\";s:7:\"db-size\";i:3529664;}}", "no");
INSERT INTO `wp_options` VALUES("75646", "updraft_remotesites", "", "yes");
INSERT INTO `wp_options` VALUES("75647", "updraft_migrator_localkeys", "", "yes");
INSERT INTO `wp_options` VALUES("75648", "updraft_central_localkeys", "", "yes");
INSERT INTO `wp_options` VALUES("75650", "updraft_jobdata_39b11b64296d", "a:15:{s:8:\"job_type\";s:7:\"restore\";s:11:\"job_time_ms\";d:1678881219.333042;s:16:\"backup_timestamp\";s:10:\"1678904280\";s:12:\"meta_foreign\";s:1:\"0\";s:28:\"updraft_restorer_backup_info\";s:158:\"{\\\"timestamp\\\":1678904280,\\\"created_by_version\\\":\\\"1.23.1\\\",\\\"same_url\\\":true,\\\"url_scheme_change\\\":false,\\\"multisite\\\":false,\\\"php_max_input_vars\\\":\\\"1000\\\"}\";s:32:\"updraft_restorer_restore_options\";a:3:{s:26:\"include_unspecified_tables\";b:0;s:17:\"tables_to_restore\";a:75:{i:0;s:12:\"wpy6_options\";i:1;s:10:\"wpy6_users\";i:2;s:13:\"wpy6_usermeta\";i:3;s:28:\"wpy6_actionscheduler_actions\";i:4;s:27:\"wpy6_actionscheduler_claims\";i:5;s:27:\"wpy6_actionscheduler_groups\";i:6;s:25:\"wpy6_actionscheduler_logs\";i:7;s:16:\"wpy6_commentmeta\";i:8;s:13:\"wpy6_comments\";i:9;s:10:\"wpy6_links\";i:10;s:13:\"wpy6_postmeta\";i:11;s:10:\"wpy6_posts\";i:12;s:23:\"wpy6_term_relationships\";i:13;s:18:\"wpy6_term_taxonomy\";i:14;s:13:\"wpy6_termmeta\";i:15;s:10:\"wpy6_terms\";i:16;s:24:\"wpy6_wpr_rucss_resources\";i:17;s:23:\"wpy6_wpr_rucss_used_css\";i:18;s:27:\"wpy6_automatic_amazon_links\";i:19;s:28:\"wpy6_automatic_articles_keys\";i:20;s:29:\"wpy6_automatic_articles_links\";i:21;s:21:\"wpy6_automatic_cached\";i:22;s:20:\"wpy6_automatic_camps\";i:23;s:25:\"wpy6_automatic_categories\";i:24;s:30:\"wpy6_automatic_clickbank_links\";i:25;s:22:\"wpy6_automatic_general\";i:26;s:23:\"wpy6_automatic_keywords\";i:27;s:20:\"wpy6_automatic_links\";i:28;s:18:\"wpy6_automatic_log\";i:29;s:28:\"wpy6_automatic_youtube_links\";i:30;s:18:\"wpy6_index_now_log\";i:31;s:17:\"wpy6_pmxe_exports\";i:32;s:21:\"wpy6_pmxe_google_cats\";i:33;s:15:\"wpy6_pmxe_posts\";i:34;s:19:\"wpy6_pmxe_templates\";i:35;s:15:\"wpy6_pmxi_files\";i:36;s:14:\"wpy6_pmxi_hash\";i:37;s:17:\"wpy6_pmxi_history\";i:38;s:16:\"wpy6_pmxi_images\";i:39;s:17:\"wpy6_pmxi_imports\";i:40;s:15:\"wpy6_pmxi_posts\";i:41;s:19:\"wpy6_pmxi_templates\";i:42;s:23:\"wpy6_rank_math_404_logs\";i:43;s:28:\"wpy6_rank_math_analytics_gsc\";i:44;s:36:\"wpy6_rank_math_analytics_inspections\";i:45;s:40:\"wpy6_rank_math_analytics_keyword_manager\";i:46;s:32:\"wpy6_rank_math_analytics_objects\";i:47;s:29:\"wpy6_rank_math_internal_links\";i:48;s:28:\"wpy6_rank_math_internal_meta\";i:49;s:27:\"wpy6_rank_math_redirections\";i:50;s:33:\"wpy6_rank_math_redirections_cache\";i:51;s:18:\"wpy6_rmp_analytics\";i:52;s:19:\"wpy6_wfblockediplog\";i:53;s:14:\"wpy6_wfblocks7\";i:54;s:13:\"wpy6_wfconfig\";i:55;s:15:\"wpy6_wfcrawlers\";i:56;s:18:\"wpy6_wffilechanges\";i:57;s:15:\"wpy6_wffilemods\";i:58;s:11:\"wpy6_wfhits\";i:59;s:13:\"wpy6_wfhoover\";i:60;s:13:\"wpy6_wfissues\";i:61;s:20:\"wpy6_wfknownfilelist\";i:62;s:23:\"wpy6_wflivetraffichuman\";i:63;s:11:\"wpy6_wflocs\";i:64;s:13:\"wpy6_wflogins\";i:65;s:21:\"wpy6_wfls_2fa_secrets\";i:66;s:21:\"wpy6_wfls_role_counts\";i:67;s:18:\"wpy6_wfls_settings\";i:68;s:20:\"wpy6_wfnotifications\";i:69;s:20:\"wpy6_wfpendingissues\";i:70;s:19:\"wpy6_wfreversecache\";i:71;s:16:\"wpy6_wfsnipcache\";i:72;s:13:\"wpy6_wfstatus\";i:73;s:19:\"wpy6_wftrafficrates\";i:74;s:16:\"wpy6_wpfm_backup\";}s:14:\"tables_to_skip\";a:0:{}}s:15:\"updraft_restore\";a:5:{i:0;s:7:\"plugins\";i:1;s:6:\"themes\";i:2;s:7:\"uploads\";i:3;s:6:\"others\";i:4;s:2:\"db\";}s:15:\"restore_options\";a:6:{s:26:\"include_unspecified_tables\";b:0;s:17:\"tables_to_restore\";a:75:{i:0;s:12:\"wpy6_options\";i:1;s:10:\"wpy6_users\";i:2;s:13:\"wpy6_usermeta\";i:3;s:28:\"wpy6_actionscheduler_actions\";i:4;s:27:\"wpy6_actionscheduler_claims\";i:5;s:27:\"wpy6_actionscheduler_groups\";i:6;s:25:\"wpy6_actionscheduler_logs\";i:7;s:16:\"wpy6_commentmeta\";i:8;s:13:\"wpy6_comments\";i:9;s:10:\"wpy6_links\";i:10;s:13:\"wpy6_postmeta\";i:11;s:10:\"wpy6_posts\";i:12;s:23:\"wpy6_term_relationships\";i:13;s:18:\"wpy6_term_taxonomy\";i:14;s:13:\"wpy6_termmeta\";i:15;s:10:\"wpy6_terms\";i:16;s:24:\"wpy6_wpr_rucss_resources\";i:17;s:23:\"wpy6_wpr_rucss_used_css\";i:18;s:27:\"wpy6_automatic_amazon_links\";i:19;s:28:\"wpy6_automatic_articles_keys\";i:20;s:29:\"wpy6_automatic_articles_links\";i:21;s:21:\"wpy6_automatic_cached\";i:22;s:20:\"wpy6_automatic_camps\";i:23;s:25:\"wpy6_automatic_categories\";i:24;s:30:\"wpy6_automatic_clickbank_links\";i:25;s:22:\"wpy6_automatic_general\";i:26;s:23:\"wpy6_automatic_keywords\";i:27;s:20:\"wpy6_automatic_links\";i:28;s:18:\"wpy6_automatic_log\";i:29;s:28:\"wpy6_automatic_youtube_links\";i:30;s:18:\"wpy6_index_now_log\";i:31;s:17:\"wpy6_pmxe_exports\";i:32;s:21:\"wpy6_pmxe_google_cats\";i:33;s:15:\"wpy6_pmxe_posts\";i:34;s:19:\"wpy6_pmxe_templates\";i:35;s:15:\"wpy6_pmxi_files\";i:36;s:14:\"wpy6_pmxi_hash\";i:37;s:17:\"wpy6_pmxi_history\";i:38;s:16:\"wpy6_pmxi_images\";i:39;s:17:\"wpy6_pmxi_imports\";i:40;s:15:\"wpy6_pmxi_posts\";i:41;s:19:\"wpy6_pmxi_templates\";i:42;s:23:\"wpy6_rank_math_404_logs\";i:43;s:28:\"wpy6_rank_math_analytics_gsc\";i:44;s:36:\"wpy6_rank_math_analytics_inspections\";i:45;s:40:\"wpy6_rank_math_analytics_keyword_manager\";i:46;s:32:\"wpy6_rank_math_analytics_objects\";i:47;s:29:\"wpy6_rank_math_internal_links\";i:48;s:28:\"wpy6_rank_math_internal_meta\";i:49;s:27:\"wpy6_rank_math_redirections\";i:50;s:33:\"wpy6_rank_math_redirections_cache\";i:51;s:18:\"wpy6_rmp_analytics\";i:52;s:19:\"wpy6_wfblockediplog\";i:53;s:14:\"wpy6_wfblocks7\";i:54;s:13:\"wpy6_wfconfig\";i:55;s:15:\"wpy6_wfcrawlers\";i:56;s:18:\"wpy6_wffilechanges\";i:57;s:15:\"wpy6_wffilemods\";i:58;s:11:\"wpy6_wfhits\";i:59;s:13:\"wpy6_wfhoover\";i:60;s:13:\"wpy6_wfissues\";i:61;s:20:\"wpy6_wfknownfilelist\";i:62;s:23:\"wpy6_wflivetraffichuman\";i:63;s:11:\"wpy6_wflocs\";i:64;s:13:\"wpy6_wflogins\";i:65;s:21:\"wpy6_wfls_2fa_secrets\";i:66;s:21:\"wpy6_wfls_role_counts\";i:67;s:18:\"wpy6_wfls_settings\";i:68;s:20:\"wpy6_wfnotifications\";i:69;s:20:\"wpy6_wfpendingissues\";i:70;s:19:\"wpy6_wfreversecache\";i:71;s:16:\"wpy6_wfsnipcache\";i:72;s:13:\"wpy6_wfstatus\";i:73;s:19:\"wpy6_wftrafficrates\";i:74;s:16:\"wpy6_wpfm_backup\";}s:14:\"tables_to_skip\";a:0:{}s:24:\"updraft_encryptionphrase\";s:0:\"\";s:39:\"updraft_restorer_wpcore_includewpconfig\";b:0;s:33:\"updraft_incremental_restore_point\";i:-1;}s:20:\"second_loop_entities\";a:0:{}s:24:\"temp_import_table_prefix\";s:3:\"6h_\";s:23:\"last_processed_db_table\";s:16:\"wpy6_wpfm_backup\";s:43:\"last_index_d40695e6d36d2317f6d8c8ad7954e018\";a:3:{s:5:\"index\";i:7865;s:4:\"info\";a:8:{s:4:\"name\";s:58:\"plugins/updraftplus/vendor/components/jquery/jquery.min.js\";s:5:\"index\";i:7865;s:3:\"crc\";i:1563608590;s:4:\"size\";i:89501;s:5:\"mtime\";i:1678879092;s:9:\"comp_size\";i:30803;s:11:\"comp_method\";i:8;s:17:\"encryption_method\";i:0;}s:12:\"size_written\";i:105569500;}s:43:\"last_index_ff479c5fb81976bd652f610db9201100\";a:3:{s:5:\"index\";i:2061;s:4:\"info\";a:8:{s:4:\"name\";s:68:\"themes/flatsome/inc/builder/shortcodes/templates/accordion_item.html\";s:5:\"index\";i:2061;s:3:\"crc\";i:434142844;s:4:\"size\";i:295;s:5:\"mtime\";i:1676963150;s:9:\"comp_size\";i:167;s:11:\"comp_method\";i:8;s:17:\"encryption_method\";i:0;}s:12:\"size_written\";i:17361530;}s:43:\"last_index_441db88433bfb2bcc58f4bebd30ff031\";a:3:{s:5:\"index\";i:838;s:4:\"info\";a:8:{s:4:\"name\";s:33:\"uploads/2023/02/1659023397176.jpg\";s:5:\"index\";i:838;s:3:\"crc\";i:1651225669;s:4:\"size\";i:961786;s:5:\"mtime\";i:1676963150;s:9:\"comp_size\";i:961786;s:11:\"comp_method\";i:0;s:17:\"encryption_method\";i:0;}s:12:\"size_written\";i:65018092;}s:43:\"last_index_9eacd5c65a16c195ece5512ae4992783\";a:3:{s:5:\"index\";i:584;s:4:\"info\";a:8:{s:4:\"name\";s:37:\"languages/themes/twentynineteen-vi.mo\";s:5:\"index\";i:584;s:3:\"crc\";i:2562211281;s:4:\"size\";i:7559;s:5:\"mtime\";i:1676963150;s:9:\"comp_size\";i:3497;s:11:\"comp_method\";i:8;s:17:\"encryption_method\";i:0;}s:12:\"size_written\";i:76418664;}}", "no");
INSERT INTO `wp_options` VALUES("77314", "_transient_timeout_global_styles_svg_filters_flatsome-child", "1679127787", "no");
INSERT INTO `wp_options` VALUES("77315", "_transient_global_styles_svg_filters_flatsome-child", "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-dark-grayscale\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncG type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncB type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-grayscale\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 1\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0 1\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-purple-yellow\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.54901960784314 0.98823529411765\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0.71764705882353 0.25490196078431\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-blue-red\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 1\" /><feFuncG type=\"table\" tableValues=\"0 0.27843137254902\" /><feFuncB type=\"table\" tableValues=\"0.5921568627451 0.27843137254902\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-midnight\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 0\" /><feFuncG type=\"table\" tableValues=\"0 0.64705882352941\" /><feFuncB type=\"table\" tableValues=\"0 1\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-magenta-yellow\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.78039215686275 1\" /><feFuncG type=\"table\" tableValues=\"0 0.94901960784314\" /><feFuncB type=\"table\" tableValues=\"0.35294117647059 0.47058823529412\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-purple-green\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.65098039215686 0.40392156862745\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0.44705882352941 0.4\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-blue-orange\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.098039215686275 1\" /><feFuncG type=\"table\" tableValues=\"0 0.66274509803922\" /><feFuncB type=\"table\" tableValues=\"0.84705882352941 0.41960784313725\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg>", "no");
INSERT INTO `wp_options` VALUES("77245", "wp_rocket_settings", "a:80:{s:12:\"cache_mobile\";i:1;s:19:\"purge_cron_interval\";i:10;s:15:\"purge_cron_unit\";s:15:\"HOUR_IN_SECONDS\";s:10:\"minify_css\";i:1;s:22:\"minify_concatenate_css\";i:1;s:11:\"exclude_css\";a:0:{}s:9:\"async_css\";i:1;s:12:\"critical_css\";s:0:\"\";s:26:\"remove_unused_css_safelist\";a:0:{}s:9:\"minify_js\";i:1;s:21:\"minify_concatenate_js\";i:1;s:17:\"exclude_inline_js\";a:0:{}s:10:\"exclude_js\";a:0:{}s:12:\"defer_all_js\";i:1;s:16:\"exclude_defer_js\";a:0:{}s:19:\"delay_js_exclusions\";a:0:{}s:8:\"lazyload\";i:1;s:16:\"exclude_lazyload\";a:0:{}s:16:\"image_dimensions\";i:1;s:14:\"manual_preload\";i:1;s:15:\"sitemap_preload\";i:1;s:21:\"rank_math_xml_sitemap\";s:1:\"1\";s:8:\"sitemaps\";a:0:{}s:13:\"preload_links\";s:1:\"1\";s:12:\"dns_prefetch\";a:0:{}s:13:\"preload_fonts\";a:0:{}s:16:\"cache_reject_uri\";a:0:{}s:20:\"cache_reject_cookies\";a:0:{}s:15:\"cache_reject_ua\";a:0:{}s:17:\"cache_purge_pages\";a:0:{}s:19:\"cache_query_strings\";a:0:{}s:18:\"database_revisions\";i:1;s:20:\"database_auto_drafts\";i:1;s:22:\"database_trashed_posts\";i:1;s:22:\"database_spam_comments\";i:1;s:25:\"database_trashed_comments\";i:1;s:26:\"schedule_automatic_cleanup\";i:1;s:27:\"automatic_cleanup_frequency\";s:6:\"weekly\";s:10:\"cdn_cnames\";a:0:{}s:8:\"cdn_zone\";a:0:{}s:16:\"cdn_reject_files\";a:0:{}s:17:\"control_heartbeat\";i:1;s:24:\"heartbeat_admin_behavior\";s:18:\"reduce_periodicity\";s:25:\"heartbeat_editor_behavior\";s:18:\"reduce_periodicity\";s:23:\"heartbeat_site_behavior\";s:18:\"reduce_periodicity\";s:18:\"cloudflare_api_key\";s:0:\"\";s:16:\"cloudflare_email\";s:0:\"\";s:18:\"cloudflare_zone_id\";s:0:\"\";s:18:\"sucury_waf_api_key\";s:0:\"\";s:12:\"consumer_key\";s:0:\"\";s:14:\"consumer_email\";s:0:\"\";s:10:\"secret_key\";s:0:\"\";s:7:\"license\";s:0:\"\";s:16:\"secret_cache_key\";s:22:\"64157182260ff255815610\";s:14:\"minify_css_key\";s:22:\"64157248d3f01349060036\";s:13:\"minify_js_key\";s:22:\"64157249d5ce4074935513\";s:7:\"version\";s:7:\"3.9.1.1\";s:23:\"cloudflare_old_settings\";s:0:\"\";s:25:\"sitemap_preload_url_crawl\";s:6:\"500000\";s:9:\"cache_ssl\";i:1;s:19:\"minify_google_fonts\";i:1;s:5:\"emoji\";i:1;s:16:\"async_css_mobile\";s:1:\"1\";s:17:\"cache_logged_user\";i:0;s:23:\"do_caching_mobile_files\";i:0;s:6:\"embeds\";i:0;s:16:\"lazyload_iframes\";i:0;s:16:\"lazyload_youtube\";i:0;s:27:\"database_expired_transients\";i:0;s:23:\"database_all_transients\";i:0;s:24:\"database_optimize_tables\";i:0;s:13:\"do_cloudflare\";i:0;s:18:\"cloudflare_devmode\";i:0;s:24:\"cloudflare_auto_settings\";i:0;s:27:\"cloudflare_protocol_rewrite\";i:0;s:21:\"sucury_waf_cache_sync\";i:0;s:3:\"cdn\";i:0;s:18:\"varnish_auto_purge\";i:0;s:8:\"delay_js\";i:0;s:17:\"remove_unused_css\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("77237", "_transient_timeout_wp_rocket_pricing", "1679170112", "no");
INSERT INTO `wp_options` VALUES("77238", "_transient_wp_rocket_pricing", "O:8:\"stdClass\":3:{s:8:\"licenses\";O:8:\"stdClass\":3:{s:6:\"single\";O:8:\"stdClass\":2:{s:6:\"prices\";O:8:\"stdClass\":3:{s:7:\"regular\";i:59;s:4:\"sale\";d:47.2;s:7:\"renewal\";O:8:\"stdClass\":3:{s:14:\"is_grandfather\";d:39.2;s:15:\"not_grandfather\";i:49;s:10:\"is_expired\";i:59;}}s:8:\"websites\";i:1;}s:4:\"plus\";O:8:\"stdClass\":2:{s:6:\"prices\";O:8:\"stdClass\":4:{s:7:\"regular\";i:119;s:4:\"sale\";d:95.2;s:11:\"from_single\";O:8:\"stdClass\":2:{s:7:\"regular\";i:60;s:4:\"sale\";i:48;}s:7:\"renewal\";O:8:\"stdClass\":3:{s:14:\"is_grandfather\";d:79.2;s:15:\"not_grandfather\";i:99;s:10:\"is_expired\";i:119;}}s:8:\"websites\";i:3;}s:8:\"infinite\";O:8:\"stdClass\":2:{s:6:\"prices\";O:8:\"stdClass\":5:{s:7:\"regular\";i:299;s:4:\"sale\";d:239.2;s:11:\"from_single\";O:8:\"stdClass\":2:{s:7:\"regular\";i:240;s:4:\"sale\";i:192;}s:9:\"from_plus\";O:8:\"stdClass\":2:{s:7:\"regular\";i:180;s:4:\"sale\";i:144;}s:7:\"renewal\";O:8:\"stdClass\":3:{s:14:\"is_grandfather\";d:199.2;s:15:\"not_grandfather\";i:249;s:10:\"is_expired\";i:299;}}s:8:\"websites\";s:9:\"unlimited\";}}s:8:\"renewals\";O:8:\"stdClass\":3:{s:10:\"extra_days\";i:15;s:16:\"grandfather_date\";i:1640995200;s:16:\"discount_percent\";O:8:\"stdClass\":3:{s:14:\"is_grandfather\";i:20;s:15:\"not_grandfather\";i:0;s:10:\"is_expired\";i:0;}}s:5:\"promo\";O:8:\"stdClass\":4:{s:4:\"name\";s:6:\"Spring\";s:16:\"discount_percent\";i:20;s:10:\"start_date\";i:1678147200;s:8:\"end_date\";i:1679443199;}}", "no");
INSERT INTO `wp_options` VALUES("76395", "rank_math_notifications", "a:2:{i:0;a:2:{s:7:\"message\";s:277:\"<strong>SEO Notice:</strong> A previously published post has been moved to trash. You may redirect <code>https://mami.gameh5.xyz/chinh-sach-bao-mat/</code> to <a href=\"https://mami.gameh5.xyz/wp-admin/admin.php?page=rank-math-redirections&url=chinh-sach-bao-mat\">a new url</a>.\";s:7:\"options\";a:5:{s:2:\"id\";s:21:\"auto_post_redirection\";s:7:\"classes\";s:31:\"is-dismissible rank-math-notice\";s:4:\"type\";s:7:\"warning\";s:6:\"screen\";s:3:\"any\";s:10:\"capability\";s:0:\"\";}}i:1;a:2:{s:7:\"message\";s:218:\"<strong>SEO Notice</strong>: Your site is set to No Index and will not appear in search engines. You can change the Search engine visibility <a href=\"https://mami.gameh5.xyz/wp-admin/options-reading.php\">from here</a>.\";s:7:\"options\";a:5:{s:2:\"id\";s:24:\"search_engine_visibility\";s:7:\"classes\";s:31:\"is-dismissible rank-math-notice\";s:4:\"type\";s:7:\"warning\";s:6:\"screen\";s:3:\"any\";s:10:\"capability\";s:0:\"\";}}}", "yes");

/* INSERT TABLE DATA: wp_pmxe_google_cats */
INSERT INTO `wp_pmxe_google_cats` VALUES("1", "Animals & Pet Supplies", "0", "", "0");
INSERT INTO `wp_pmxe_google_cats` VALUES("2", "Pet Supplies", "1", "Animals & Pet Supplies", "1");
INSERT INTO `wp_pmxe_google_cats` VALUES("3", "Bird Supplies", "2", "Pet Supplies", "2");
INSERT INTO `wp_pmxe_google_cats` VALUES("4", "Cat Supplies", "2", "Pet Supplies", "2");
INSERT INTO `wp_pmxe_google_cats` VALUES("5", "Dog Supplies", "2", "Pet Supplies", "2");
INSERT INTO `wp_pmxe_google_cats` VALUES("6", "Fish Supplies", "2", "Pet Supplies", "2");
INSERT INTO `wp_pmxe_google_cats` VALUES("7", "Reptile & Amphibian Supplies", "2", "Pet Supplies", "2");
INSERT INTO `wp_pmxe_google_cats` VALUES("8", "Arts & Entertainment", "0", "", "0");
INSERT INTO `wp_pmxe_google_cats` VALUES("9", "Artwork", "696", "Decor", "2");
INSERT INTO `wp_pmxe_google_cats` VALUES("11", "Sculptures & Statues", "9", "Artwork", "3");
INSERT INTO `wp_pmxe_google_cats` VALUES("16", "Arts & Crafts", "5710", "Hobbies & Creative Arts", "2");
INSERT INTO `wp_pmxe_google_cats` VALUES("18", "Art Brushes", "505392", "Craft Measuring & Marking Tools", "5");
INSERT INTO `wp_pmxe_google_cats` VALUES("24", "Art & Craft Paper", "505372", "Art & Crafting Materials", "4");
INSERT INTO `wp_pmxe_google_cats` VALUES("32", "Beads", "505379", "Embellishments & Trims", "5");
INSERT INTO `wp_pmxe_google_cats` VALUES("33", "Juggling", "5710", "Hobbies & Creative Arts", "2");
INSERT INTO `wp_pmxe_google_cats` VALUES("35", "Magic & Novelties", "5710", "Hobbies & Creative Arts", "2");
INSERT INTO `wp_pmxe_google_cats` VALUES("36", "Craft Magnets", "505376", "Crafting Adhesives & Magnets", "5");
INSERT INTO `wp_pmxe_google_cats` VALUES("37", "Scale Models", "216", "Collectibles", "3");
INSERT INTO `wp_pmxe_google_cats` VALUES("39", "Photography", "141", "Cameras & Optics", "1");
INSERT INTO `wp_pmxe_google_cats` VALUES("40", "Photo Albums", "4360", "Photo Storage", "4");
INSERT INTO `wp_pmxe_google_cats` VALUES("41", "Darkroom", "39", "Photography", "2");
INSERT INTO `wp_pmxe_google_cats` VALUES("42", "Lighting & Studio", "39", "Photography", "2");
INSERT INTO `wp_pmxe_google_cats` VALUES("44", "Pottery & Sculpting Materials", "505372", "Art & Crafting Materials", "4");
INSERT INTO `wp_pmxe_google_cats` VALUES("47", "Fabric", "505384", "Textiles", "5");
INSERT INTO `wp_pmxe_google_cats` VALUES("49", "Thread & Floss", "505382", "Crafting Fibers", "5");
INSERT INTO `wp_pmxe_google_cats` VALUES("53", "Gift Cards & Certificates", "2559", "Gift Giving", "3");
INSERT INTO `wp_pmxe_google_cats` VALUES("54", "Musical Instruments", "5710", "Hobbies & Creative Arts", "2");
INSERT INTO `wp_pmxe_google_cats` VALUES("55", "Musical Instrument & Orchestra Accessories", "5710", "Hobbies & Creative Arts", "2");
INSERT INTO `wp_pmxe_google_cats` VALUES("56", "Musical Instrument Amplifiers", "55", "Musical Instrument & Orchestra Accessories", "3");
INSERT INTO `wp_pmxe_google_cats` VALUES("57", "Brass Instrument Accessories", "55", "Musical Instrument & Orchestra Accessories", "3");
INSERT INTO `wp_pmxe_google_cats` VALUES("59", "Drum Sticks & Brushes", "3465", "Percussion Accessories", "4");
INSERT INTO `wp_pmxe_google_cats` VALUES("60", "Musical Keyboard Accessories", "55", "Musical Instrument & Orchestra Accessories", "3");
INSERT INTO `wp_pmxe_google_cats` VALUES("61", "String Instrument Accessories", "55", "Musical Instrument & Orchestra Accessories", "3");
INSERT INTO `wp_pmxe_google_cats` VALUES("62", "Woodwind Instrument Accessories", "55", "Musical Instrument & Orchestra Accessories", "3");
INSERT INTO `wp_pmxe_google_cats` VALUES("63", "Brass Instruments", "54", "Musical Instruments", "3");
INSERT INTO `wp_pmxe_google_cats` VALUES("65", "Euphoniums", "63", "Brass Instruments", "4");
INSERT INTO `wp_pmxe_google_cats` VALUES("67", "French Horns", "63", "Brass Instruments", "4");
INSERT INTO `wp_pmxe_google_cats` VALUES("70", "Trombones", "63", "Brass Instruments", "4");
INSERT INTO `wp_pmxe_google_cats` VALUES("72", "Tubas", "63", "Brass Instruments", "4");
INSERT INTO `wp_pmxe_google_cats` VALUES("74", "Musical Keyboards", "6001", "Electronic Musical Instruments", "4");
INSER