<?php

namespace TablePress\PhpOffice\PhpSpreadsheet\Calculation\MathTrig;

use TablePress\PhpOffice\PhpSpreadsheet\Calculation\ArrayEnabled;
use TablePress\PhpOffice\PhpSpreadsheet\Calculation\Exception;

class IntClass
{
	use ArrayEnabled;

	/**
	 * INT.
	 *
	 * Casts a floating point value to an integer
	 *
	 * Excel Function:
	 *        INT(number)
	 *
	 * @param array|float $number Number to cast to an integer, or can be an array of numbers
	 *
	 * @return array|string Integer value, or a string containing an error
	 *         If an array of numbers is passed as the argument, then the returned result will also be an array
	 *            with the same dimensions
	 */
	public static function evaluate($number)
	{
		if (is_array($number)) {
			return self::evaluateSingleArgumentArray([self::class, __FUNCTION__], $number);
		}

		try {
			$number = Helpers::validateNumericNullBool($number);
		} catch (Exception $e) {
			return $e->getMessage();
		}

		return (int) floor($number);
	}
}
