<?php
/**
 * The template for displaying the footer.
 *
 * @package flatsome
 */

global $flatsome_opt;
$frontpage_id = get_option('page_on_front');
?>

</main>
<footer class="footer">
    <div class="footer-top">
        <div class="container">
            <div class="bank">
                <img src="<?php echo get_field('logo_bank','option')['url']; ?>" alt="<?php echo get_field('logo_bank','option')['alt']; ?>">
            </div>
            
            <div class="pay">
                <img src="<?php echo get_field('logo_game','option'); ?>" alt="<?php echo get_field('logo_game','option')['alt']; ?>">
            </div>
        </div>
    </div>
    <div class="footer-bottom">
        <div class="container">
            <div class="row">
                <div class="col-md-3 ft-1"><?php dynamic_sidebar( 'sidebar-footer-1' ); ?></div>
                <div class="col-md-3 ft-2"><?php dynamic_sidebar( 'footer_2' ); ?></div>
                <div class="col-md-3 ft-3"><?php dynamic_sidebar( 'footer_3' ); ?></div>
                <div class="col-md-3 ft-4"><?php dynamic_sidebar( 'footer_4' ); ?></div>
            </div>
            <div class="copyright text-center">
                <?php echo get_field('copyright','option'); ?>
            </div>
        </div>
    </div>
</footer>

<div class="footer-contact">
    <div class="text-center">
        <a class="btn btn-danger" href="<?php echo get_field('signup',$frontpage_id); ?>" target="_blank" rel="nofollow noopener">
            <span class="pdmb">Đăng ký</span>
        </a>
        <a class="btn btn-success" href="<?php echo get_field('singin',$frontpage_id); ?>" target="_blank" rel="nofollow noopener">
            <span class="pdmb">Đăng nhập</span>
        </a>
    </div>
</div>
<div class="float_box-right">
    <div class="float_shortcut-box">
        <?php
        if( have_rows('list_contact','option') ):
            echo '<ul class="float_shortcut-box_list">';
            while( have_rows('list_contact','option') ) : the_row();
                $icon_contact = get_sub_field('icon_contact');
                $link_contact = get_sub_field('link_contact');
                $title_contact = get_sub_field('title_contact');
            ?>
            <li class="float_shortcut-box_item line_bottom">
                <a href="<?php echo $link_contact; ?>">
                    <span class="icon">
                        <img src="<?php echo $icon_contact['url']; ?>" alt="<?php echo $icon_contact['alt']; ?>">
                    </span>
                    <span class="text"><?php echo $title_contact; ?></span>
                </a>
            </li>
            <?php endwhile;
            echo '</ul>';
        endif;?>
    </div>
</div>

<div class="overlay"></div>
<div id="menu-mb">
    <div class="logo-menu-mb">     
        <img src="<?php echo get_field('logo_image','option')['url']; ?>" alt="<?php echo get_field('logo_image','option')['alt']; ?>">
    </div>
    <?php
        if( have_rows('list_menu',$frontpage_id) ):
            echo '<ul class="parent-menu">';
            while( have_rows('list_menu',$frontpage_id) ) : the_row();
                $menu_parent = get_sub_field('menu_parent',$frontpage_id);
                $link_parent = get_sub_field('link_parent',$frontpage_id);
            ?>
            <li>
                <a href="<?php echo $link_parent; ?>"><?php echo $menu_parent; ?></a>
                <?php
                if( have_rows('list_menu_children',$frontpage_id) ):
                    echo '<ul class="sub-menu">';
                    while( have_rows('list_menu_children',$frontpage_id) ) : the_row();
                        $link_child = get_sub_field('link_child',$frontpage_id);
                        $image_child = get_sub_field('image_child',$frontpage_id);
                        $title_child = get_sub_field('title_child',$frontpage_id);
                    ?>
                    <li>
                        <a href="<?php echo $link_child; ?>"><img src="<?php echo $image_child['url']; ?>" alt="<?php echo $image_child['alt']; ?>"><span><?php echo $title_child; ?></span></a>
                    </li>                               
                    <?php 
                    endwhile;
                    echo '</ul>';
                endif;
                ?>
            </li>                           
            <?php 
            endwhile;
            echo '</ul>';
        endif;
        ?>
</div>
<?php wp_footer(); ?>

</body>
</html>
