<?php
if ( ! function_exists( 'kakael_setup' ) ){
    function kakael_setup() {
        add_theme_support( 'automatic-feed-links' );
        add_theme_support( 'title-tag' );
        add_theme_support( 'post-thumbnails' );
        register_nav_menus( array(
            'primary' => esc_html__( 'Primary menu', 'kakael' ),
        ) );
        register_nav_menus( array(
            'menu_mobile' => esc_html__( 'Menu mobile', 'kakael' ),
        ) );
    }
}
add_action( 'after_setup_theme', 'kakael_setup' );
add_action( 'wp_enqueue_scripts', 'inc_scripts' );
function inc_scripts() {
    wp_enqueue_style( 'kael-bootstrap.min.css', get_stylesheet_directory_uri() .'/assets/styles/bootstrap.min.css', false, 'dev', 'all' );
    wp_enqueue_style( 'kael-all.min.css', get_stylesheet_directory_uri() .'/assets/styles/all.min.css', false, 'dev', 'all' );
    wp_enqueue_style( 'owl.carousel.min.css', get_stylesheet_directory_uri() .'/assets/styles/owl.carousel.min.css', false, 'dev', 'all' );
    wp_enqueue_style( 'swiper-bundle.min.css', get_stylesheet_directory_uri() .'/assets/styles/swiper-bundle.min.css', false, 'dev', 'all' );
    wp_enqueue_style( 'kael-plus', get_stylesheet_directory_uri() .'/assets/styles/plus.css', false, time(), 'all' );
    wp_enqueue_style( 'kael-main', get_stylesheet_directory_uri() .'/assets/styles/main.css', false, time(), 'all' );
    wp_enqueue_style( 'kael-responsive', get_stylesheet_directory_uri() .'/assets/styles/responsive.css', false, time(), 'all' );
  

    wp_enqueue_script( 'owl.carousel.min.js', get_stylesheet_directory_uri() . '/assets/javascripts/owl.carousel.min.js', array('jquery'), '', true );
    wp_enqueue_script( 'swiper-bundle.min.js', get_stylesheet_directory_uri() . '/assets/javascripts/swiper-bundle.min.js', array('jquery'), '', true );
    wp_enqueue_script( 'main.js', get_stylesheet_directory_uri() . '/assets/javascripts/main.js', array('jquery'), time(), true );
}
if( function_exists('acf_add_options_page') ) {
    acf_add_options_page(array(
        'page_title' 	=> 'Theme Settings',
        'menu_title'	=> 'Theme Settings',
        'menu_slug' 	=> 'theme-general-settings',
        'capability'	=> 'edit_posts',
        'redirect'		=> false
    ));
}
if ( ! function_exists( 'kakael_widgets_init' ) ){
    function kakael_widgets_init() {
        register_sidebar( array(
            'name'          => esc_html__( 'Footer 1', 'kakael' ),
            'id'            => 'footer_1',
            'description'   => esc_html__( 'Add widgets here.', 'kakael' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<div class="nav__title-item">',
            'after_title'   => '</div>',
        ) );
        register_sidebar( array(
            'name'          => esc_html__( 'Footer 2', 'kakael' ),
            'id'            => 'footer_2',
            'description'   => esc_html__( 'Add widgets here.', 'kakael' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<div class="nav__title-item">',
            'after_title'   => '</div>',
        ) );
        register_sidebar( array(
            'name'          => esc_html__( 'Footer 3', 'kakael' ),
            'id'            => 'footer_3',
            'description'   => esc_html__( 'Add widgets here.', 'kakael' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<div class="nav__title-item">',
            'after_title'   => '</div>',
        ) );
        register_sidebar( array(
            'name'          => esc_html__( 'Footer 4', 'kakael' ),
            'id'            => 'footer_4',
            'description'   => esc_html__( 'Add widgets here.', 'kakael' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<div class="nav__title-item">',
            'after_title'   => '</div>',
        ) );
    }
}
add_action( 'widgets_init', 'kakael_widgets_init' );

//count terms
function countDescendentTerms($term) {
    $query_s = new WP_Query(array(
        'post_type' => 'post',
        'orderby' => 'date',
        'order' => 'DESC', 
        'post_status'    => 'publish',
        'posts_per_page' => -1,
        'tax_query' => array(array(
            'taxonomy' => 'category',
            'field' => 'term_id',
            'terms' => array($term->term_id),
            'include_children' => true
        ))
    ));
    return $query_s->post_count;
}
add_filter( 'widget_text', 'do_shortcode' );
function kael_time() {
    ob_start();
    echo 'Ngày '.date('d').' Tháng '.date('m').' Năm '.date('Y').' | '.date('H:i');
    $list_post = ob_get_contents();
    ob_end_clean();
    return $list_post;
}
add_shortcode( "kael_time", "kael_time" );

//show socials
add_shortcode('show_socials_icon','show_socials_icon');
function show_socials_icon(){
    global $arrow_option; 
    ob_start();
    ?>
    <ul class="list-socials d-flex">
        <?php
        if( have_rows('list_social','option') ): ;
            while( have_rows('list_social','option') ) : the_row();
                $icon = get_sub_field('icon');
                $name = get_sub_field('name');
                $link = get_sub_field('link');
            ?>
            <li class="<?php echo $name; ?>"><a href="<?php echo $link; ?>" class="item"><?php echo $icon; ?></a></li>
            <?php endwhile;
        endif;?>
    </ul>
    <?php
    $list_icon = ob_get_contents();
    ob_end_clean();
    return $list_icon;
}
//add vote
add_action('publish_post', 'check_for_meta_in_database');
add_action('publish_page', 'check_for_meta_in_database');
function check_for_meta_in_database($post_id) {
    global $wpdb;
    $rmp_avg_rating = get_post_meta($post_id, 'rmp_avg_rating', true);
    if( $rmp_avg_rating == "" ) {
        update_post_meta($post_id, 'rmp_avg_rating', '5');
        update_post_meta($post_id, 'rmp_rating_val_sum', '10');
        update_post_meta($post_id, 'rmp_vote_count', '2');
    }
}