<!DOCTYPE html>
<!--[if IE 9 ]> <html <?php language_attributes(); ?> class="ie9 <?php flatsome_html_classes(); ?>"> <![endif]-->
<!--[if IE 8 ]> <html <?php language_attributes(); ?> class="ie8 <?php flatsome_html_classes(); ?>"> <![endif]-->
<!--[if (gte IE 9)|!(IE)]><!--><html <?php language_attributes(); ?> class="<?php flatsome_html_classes(); ?>"> <!--<![endif]-->
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php do_action( 'flatsome_after_body_open' ); ?>
<?php wp_body_open(); ?>
<?php $frontpage_id = get_option('page_on_front'); ?>
<div id="wrapper">
	<?php do_action( 'flatsome_before_header' ); ?>
	<header>	    
    	<div class="top-header">
    		<div class="container d-flex justify-content-between align-items-center">
    			<div class="btn-menu"><i class="fas fa-bars"></i></div>
    			<a href="<?php echo home_url(); ?>" id="logo" class="logo-mb">
	            	<img src="<?php echo get_field('logo_image','option')['url']; ?>" alt="<?php echo get_field('logo_image','option')['alt']; ?>" title="<?php _e('Logo') ?>"/>
	            </a>
    			<div class="user-action">
    				<ul class="d-flex align-items-center">
	                  <li class="reg-button" style="background: linear-gradient(to top,#1671c4 0,#76f6fe 100%)"><a href="<?php echo get_field('signup',$frontpage_id); ?>" rel="nofollow"><?php _e("Đăng ký"); ?></a></li>
	                  <li class="login-button" style="background-color:#33c85d"><a href="<?php echo get_field('singin',$frontpage_id); ?>" rel="nofollow"><?php _e("Đăng nhập"); ?></a></li>
	                </ul>
    			</div>
	    	</div>
    	</div>
        <div class="bot-header">
        	<div class="container" style="height: 100%;">
        		<div class="d-flex align-items-center" style="height: 100%;">
        			<a href="<?php echo home_url(); ?>" id="logo">
		            	<img src="<?php echo get_field('logo_image','option')['url']; ?>" alt="<?php echo get_field('logo_image','option')['alt']; ?>" title="<?php _e('Logo') ?>"/>
		            </a>
	            	<?php
					if( have_rows('list_menu',$frontpage_id) ):
						echo '<ul class="parent-menu d-flex align-items-center">';
					    while( have_rows('list_menu',$frontpage_id) ) : the_row();
					        $menu_parent = get_sub_field('menu_parent');
					        $link_parent = get_sub_field('link_parent');
					    ?>
					    <li>
					    	<a href="<?php echo $link_parent; ?>"><?php echo $menu_parent; ?></a>
					    	<?php
							if( have_rows('list_menu_children',$frontpage_id) ):
								echo '<ul class="sub-menu">';
							    while( have_rows('list_menu_children',$frontpage_id) ) : the_row();
							        $link_child = get_sub_field('link_child');
							        $image_child = get_sub_field('image_child');
							        $title_child = get_sub_field('title_child');
							    ?>
							    <li>
							    	<a href="<?php echo $link_child; ?>"><img src="<?php echo $image_child['url']; ?>" alt="<?php echo $image_child['alt'] ?>"><span><?php echo $title_child; ?></span></a>
							    </li>							    
							    <?php 
								endwhile;
							    echo '</ul>';
							endif;
							?>
					    </li>						    
						<?php 
						endwhile;
					    echo '</ul>';
					endif;
					?>
				</div>
		    </div>   
        </div>
	</header>
	<?php do_action( 'flatsome_after_header' ); ?>
	<main id="main" class="<?php flatsome_main_classes(); ?>">
