<?php if ( have_posts() ) :
	if(is_category() || is_tag()):
		$object = get_queried_object(); ?>
		<h1 class="cat-title"><?php echo $object->name; ?></h1>
	    <div class="cat-meta">
	    	<div class="meta-item"><img src="<?php echo get_stylesheet_directory_uri() . '/assets/images/edit.png'; ?>" alt="Edit" title="Edit"/> <?php echo countDescendentTerms($object); ?> bài viết</div>
	    </div>
	    <?php if($object->description): ?>
	        <div class="cat-excerpt">
	            <?php echo $object->description; ?>
	        </div>
	    <?php endif;?>
	    <?php $terms = get_terms( array(
		    'taxonomy' => $object->taxonomy,
		    'hide_empty' => false,
		    'parent' => $object->term_id,
		    'number' => 0,
		) );
		if($terms): ?>
	    	<div class="term-child-data">
	            <div class="term-child">
	                <?php foreach ($terms as $key => $term) {
	                	$term_count = countDescendentTerms($term);
	                	$icon = get_field('icon',$term); ?>
	                	<div class="item">
	                		<a href="<?php echo get_term_link($term); ?>" title="<?php echo $term->name; ?>" class="item-wrap">
	                			<?php if($icon): ?>
	                				<div class="icon"><img src="<?php echo $icon; ?>" alt="Icon" title="Icon"/></div>
	                			<?php endif; ?>
	                			<div class="child-title"><?php echo $term->name; ?></div>
	                			<div class="child-meta">
	                				<div class="child-meta-item"><img src="<?php echo get_stylesheet_directory_uri() . '/assets/images/edit.png'; ?>"  alt="Edit" title="Edit"/> <?php echo $term_count; ?> bài viết</div>
	                			</div>
	                		</a>
	                	</div>
	                <?php } ?>
	            </div>
	        </div>
	    <?php endif;?>
	    <h2 class="aw-title"><?php _e("Bài viết mới nhất","default"); ?></h2>
	<?php endif;?>
<?php
	// Create IDS
	$ids = array();
	while ( have_posts() ) : the_post();
		array_push($ids, get_the_ID());
	endwhile; // end of the loop.
	$ids = implode(',', $ids);
?>

	<?php
	echo flatsome_apply_shortcode( 'blog_posts', array(
		'type'        => get_theme_mod( 'blog_style_type', 'masonry' ),
		'depth'       => get_theme_mod( 'blog_posts_depth', 0 ),
		'depth_hover' => get_theme_mod( 'blog_posts_depth_hover', 0 ),
		'text_align'  => get_theme_mod( 'blog_posts_title_align', 'center' ),
		'columns'     => '3',
		'show_date'   => get_theme_mod( 'blog_badge', 1 ) ? 'true' : 'false',
		'ids'         => $ids,
		'show_category' => true
	) );
	?>

<?php flatsome_posts_pagination(); ?>

<?php else : ?>

	<?php get_template_part( 'template-parts/posts/content','none'); ?>

<?php endif; ?>
